/*
 * Decompiled with CFR 0.152.
 */
package org.springsource.loaded.ri;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import org.springsource.loaded.CurrentLiveVersion;
import org.springsource.loaded.GlobalConfiguration;
import org.springsource.loaded.MethodMember;
import org.springsource.loaded.ReloadableType;
import org.springsource.loaded.Utils;
import org.springsource.loaded.jvm.JVM;
import org.springsource.loaded.ri.Invoker;
import org.springsource.loaded.ri.ReloadableTypeMethodProvider;
import sl.org.objectweb.asm.Type;

public abstract class ReloadedTypeInvoker
extends Invoker {
    ReloadableType rtype;
    private MethodMember methodMember;

    private ReloadedTypeInvoker(ReloadableTypeMethodProvider declaringType, MethodMember methodMember) {
        this.methodMember = methodMember;
        this.rtype = declaringType.getRType();
        if (GlobalConfiguration.assertsMode) {
            Utils.assertTrue(this.rtype.hasBeenReloaded(), "This class is only equiped to provide invocation/method services for reloaded types");
        }
    }

    @Override
    public abstract Object invoke(Object var1, Object ... var2) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException;

    @Override
    public Method createJavaMethod() {
        Class<?> clazz = this.rtype.getClazz();
        String name = this.methodMember.getName();
        String methodDescriptor = this.methodMember.getDescriptor();
        ClassLoader classLoader = this.rtype.getTypeRegistry().getClassLoader();
        try {
            Class<?>[] params = Utils.toParamClasses(methodDescriptor, classLoader);
            Class<?> returnType = Utils.toClass(Type.getReturnType(methodDescriptor), classLoader);
            Class<?>[] exceptions = Utils.slashedNamesToClasses(this.methodMember.getExceptions(), classLoader);
            return JVM.newMethod(clazz, name, params, returnType, exceptions, this.methodMember.getModifiers(), this.methodMember.getGenericSignature());
        }
        catch (ClassNotFoundException e) {
            throw new IllegalStateException("Couldn't create j.l.r.Method for " + clazz.getName() + "." + methodDescriptor, e);
        }
    }

    @Override
    public int getModifiers() {
        return this.methodMember.getModifiers();
    }

    @Override
    public String getName() {
        return this.methodMember.getName();
    }

    @Override
    public String getMethodDescriptor() {
        return this.methodMember.getDescriptor();
    }

    @Override
    public String getClassName() {
        return this.rtype.getName();
    }

    public static Invoker create(ReloadableTypeMethodProvider declaringType, final MethodMember methodMember) {
        if (Modifier.isStatic(methodMember.getModifiers())) {
            return new ReloadedTypeInvoker(declaringType, methodMember){

                @Override
                public Object invoke(Object target, Object ... params) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
                    CurrentLiveVersion clv = this.rtype.getLiveVersion();
                    Method executor = clv.getExecutorMethod(methodMember);
                    return executor.invoke(target, params);
                }
            };
        }
        return new ReloadedTypeInvoker(declaringType, methodMember){

            @Override
            public Object invoke(Object target, Object ... params) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
                CurrentLiveVersion clv = this.rtype.getLiveVersion();
                Method executor = clv.getExecutorMethod(methodMember);
                if (params == null) {
                    return executor.invoke(null, target);
                }
                Object[] ps = new Object[params.length + 1];
                System.arraycopy(params, 0, ps, 1, params.length);
                ps[0] = target;
                return executor.invoke(null, ps);
            }
        };
    }
}

