/*
 * Decompiled with CFR 0.152.
 */
package org.springsource.loaded.test.infra;

import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;
import org.springsource.loaded.Utils;
import sl.org.objectweb.asm.AnnotationVisitor;
import sl.org.objectweb.asm.Attribute;
import sl.org.objectweb.asm.Label;
import sl.org.objectweb.asm.MethodVisitor;
import sl.org.objectweb.asm.Opcodes;

public class MethodPrinter
implements MethodVisitor,
Opcodes {
    PrintStream to;
    List<Label> labels = new ArrayList<Label>();

    private String toString(Label label) {
        int idx = this.labels.indexOf(label);
        if (idx != -1) {
            return "L" + idx;
        }
        this.labels.add(label);
        return "L" + this.labels.indexOf(label);
    }

    public MethodPrinter(PrintStream destination) {
        this.to = destination;
    }

    @Override
    public void visitCode() {
        this.to.print("    CODE\n");
    }

    @Override
    public void visitMethodInsn(int opcode, String owner, String name, String desc) {
        if (opcode == 184) {
            this.to.println("    INVOKESTATIC " + owner + "." + name + desc);
        } else if (opcode == 183) {
            this.to.println("    INVOKESPECIAL " + owner + "." + name + desc);
        } else if (opcode == 182) {
            this.to.println("    INVOKEVIRTUAL " + owner + "." + name + desc);
        } else if (opcode == 185) {
            this.to.println("    INVOKEINTERFACE " + owner + "." + name + desc);
        } else {
            throw new IllegalStateException(":" + opcode);
        }
    }

    @Override
    public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
        this.to.print("ANNOTATION " + desc + " vis?" + visible + " VALUE ");
        return new AnnotationVisitorPrinter();
    }

    @Override
    public AnnotationVisitor visitAnnotationDefault() {
        return null;
    }

    @Override
    public void visitAttribute(Attribute attr) {
    }

    @Override
    public void visitEnd() {
    }

    @Override
    public void visitFieldInsn(int opcode, String owner, String name, String desc) {
        if (opcode == 178) {
            this.to.println("    GETSTATIC " + owner + "." + name + " " + desc);
        } else if (opcode == 179) {
            this.to.println("    PUTSTATIC " + owner + "." + name + " " + desc);
        } else if (opcode == 180) {
            this.to.println("    GETFIELD " + owner + "." + name + " " + desc);
        } else if (opcode == 181) {
            this.to.println("    PUTFIELD " + owner + "." + name + " " + desc);
        } else {
            throw new IllegalStateException(":" + opcode);
        }
    }

    @Override
    public void visitFrame(int type, int nLocal, Object[] local, int nStack, Object[] stack) {
    }

    @Override
    public void visitIincInsn(int var, int increment) {
    }

    @Override
    public void visitInsn(int opcode) {
        this.to.println("    " + Utils.toOpcodeString(opcode));
    }

    @Override
    public void visitIntInsn(int opcode, int operand) {
        this.to.println("    " + Utils.toOpcodeString(opcode) + " " + operand);
    }

    @Override
    public void visitJumpInsn(int opcode, Label label) {
        this.to.println("    " + Utils.toOpcodeString(opcode) + " " + this.toString(label));
    }

    @Override
    public void visitLabel(Label label) {
        this.to.println(" " + this.toString(label));
    }

    @Override
    public void visitLdcInsn(Object cst) {
        this.to.println("    LDC " + cst);
    }

    @Override
    public void visitLineNumber(int line, Label start) {
    }

    @Override
    public void visitLocalVariable(String name, String desc, String signature, Label start, Label end, int index) {
    }

    @Override
    public void visitLookupSwitchInsn(Label dflt, int[] keys, Label[] labels) {
    }

    @Override
    public void visitMaxs(int maxStack, int maxLocals) {
    }

    @Override
    public void visitMultiANewArrayInsn(String desc, int dims) {
    }

    @Override
    public AnnotationVisitor visitParameterAnnotation(int parameter, String desc, boolean visible) {
        return null;
    }

    @Override
    public void visitTableSwitchInsn(int min, int max, Label dflt, Label[] labels) {
    }

    @Override
    public void visitTryCatchBlock(Label start, Label end, Label handler, String type) {
    }

    @Override
    public void visitTypeInsn(int opcode, String type) {
        if (opcode == 187) {
            this.to.println("    NEW " + type);
        } else if (opcode == 189) {
            this.to.println("    ANEWARRAY " + type);
        } else if (opcode == 192) {
            this.to.println("    CHECKCAST " + type);
        } else if (opcode == 193) {
            this.to.println("    INSTANCEOF " + type);
        } else {
            throw new IllegalStateException(":" + opcode);
        }
    }

    @Override
    public void visitVarInsn(int opcode, int var) {
        if (opcode == 25) {
            this.to.println("    ALOAD " + var);
        } else if (opcode == 58) {
            this.to.println("    ASTORE " + var);
        } else if (opcode == 21) {
            this.to.println("    ILOAD " + var);
        } else if (opcode == 23) {
            this.to.println("    FLOAD " + var);
        } else if (opcode == 22) {
            this.to.println("    LLOAD " + var);
        } else if (opcode == 24) {
            this.to.println("    DLOAD " + var);
        } else if (opcode == 54) {
            this.to.println("    ISTORE " + var);
        } else if (opcode == 55) {
            this.to.println("    LSTORE " + var);
        } else {
            throw new IllegalStateException(":" + opcode);
        }
    }

    class AnnotationVisitorPrinter
    implements AnnotationVisitor {
        AnnotationVisitorPrinter() {
        }

        @Override
        public void visit(String name, Object value) {
            MethodPrinter.this.to.print(name + "=" + value + " ");
        }

        @Override
        public void visitEnum(String name, String desc, String value) {
            MethodPrinter.this.to.print(name + "=" + desc + "." + value + " ");
        }

        @Override
        public AnnotationVisitor visitAnnotation(String name, String desc) {
            MethodPrinter.this.to.print(name + "=" + desc + " ");
            return new AnnotationVisitorPrinter();
        }

        @Override
        public AnnotationVisitor visitArray(String name) {
            MethodPrinter.this.to.print(name + " ");
            return new AnnotationVisitorPrinter();
        }

        @Override
        public void visitEnd() {
            MethodPrinter.this.to.println();
        }
    }
}

