/*
 * Decompiled with CFR 0.152.
 */
package org.springsource.loaded.agent;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.security.ProtectionDomain;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.springsource.loaded.GlobalConfiguration;
import org.springsource.loaded.LoadtimeInstrumentationPlugin;
import org.springsource.loaded.ReloadEventProcessorPlugin;
import org.springsource.loaded.agent.ClassVisitingConstructorAppender;
import sl.org.objectweb.asm.ClassReader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SpringPlugin
implements LoadtimeInstrumentationPlugin,
ReloadEventProcessorPlugin {
    private static final String THIS_CLASS = "org/springsource/loaded/agent/SpringPlugin";
    private static Logger log = Logger.getLogger(SpringPlugin.class.getName());
    private static boolean debug = true;
    public static List<Object> annotationMethodHandlerAdapterInstances = new ArrayList<Object>();
    public static List<Object> defaultAnnotationHandlerMappingInstances = new ArrayList<Object>();
    public static List<Object> requestMappingHandlerMappingInstances = new ArrayList<Object>();
    public static List<Object> localVariableTableParameterNameDiscovererInstances = null;
    public static boolean support305 = true;
    private Field classCacheField;
    private Field strongClassCacheField;
    private Field softClassCacheField;
    private Field declaredMethodsCacheField;
    private Field parameterNamesCacheField;
    private boolean cachedIntrospectionResultsClassLoaded = false;
    private boolean reflectionUtilsClassLoaded = false;
    private Class<?> cachedIntrospectionResultsClass = null;
    private Class<?> reflectionUtilsClass = null;

    @Override
    public boolean accept(String slashedTypeName, ClassLoader classLoader, ProtectionDomain protectionDomain, byte[] bytes) {
        if (slashedTypeName == null) {
            return false;
        }
        if (slashedTypeName.equals("org/springframework/core/LocalVariableTableParameterNameDiscoverer")) {
            return true;
        }
        if (slashedTypeName.equals("org/springframework/beans/CachedIntrospectionResults")) {
            this.cachedIntrospectionResultsClassLoaded = true;
        }
        if (slashedTypeName.equals("org/springframework/util/ReflectionUtils")) {
            this.reflectionUtilsClassLoaded = true;
        }
        return slashedTypeName.equals("org/springframework/web/servlet/mvc/annotation/AnnotationMethodHandlerAdapter") || slashedTypeName.equals("org/springframework/web/servlet/mvc/method/annotation/RequestMappingHandlerMapping") || support305 && slashedTypeName.equals("org/springframework/web/servlet/mvc/annotation/DefaultAnnotationHandlerMapping");
    }

    @Override
    public byte[] modify(String slashedClassName, ClassLoader classLoader, byte[] bytes) {
        if (GlobalConfiguration.isRuntimeLogging && log.isLoggable(Level.INFO)) {
            log.info("loadtime modifying " + slashedClassName);
        }
        if (slashedClassName.equals("org/springframework/web/servlet/mvc/annotation/AnnotationMethodHandlerAdapter")) {
            return this.bytesWithInstanceCreationCaptured(bytes, THIS_CLASS, "recordAnnotationMethodHandlerAdapterInstance");
        }
        if (slashedClassName.equals("org/springframework/web/servlet/mvc/method/annotation/RequestMappingHandlerMapping")) {
            return this.bytesWithInstanceCreationCaptured(bytes, THIS_CLASS, "recordRequestMappingHandlerMappingInstance");
        }
        if (slashedClassName.equals("org/springframework/core/LocalVariableTableParameterNameDiscoverer")) {
            return this.bytesWithInstanceCreationCaptured(bytes, THIS_CLASS, "recordLocalVariableTableParameterNameDiscoverer");
        }
        return this.bytesWithInstanceCreationCaptured(bytes, THIS_CLASS, "recordDefaultAnnotationHandlerMappingInstance");
    }

    public static void recordAnnotationMethodHandlerAdapterInstance(Object obj) {
        annotationMethodHandlerAdapterInstances.add(obj);
    }

    public static void recordRequestMappingHandlerMappingInstance(Object obj) {
        requestMappingHandlerMappingInstances.add(obj);
    }

    public static void recordLocalVariableTableParameterNameDiscoverer(Object obj) {
        if (localVariableTableParameterNameDiscovererInstances == null) {
            localVariableTableParameterNameDiscovererInstances = new ArrayList<Object>();
        }
        localVariableTableParameterNameDiscovererInstances.add(obj);
    }

    public static void recordDefaultAnnotationHandlerMappingInstance(Object obj) {
        if (debug) {
            System.out.println("Recording new instance of DefaultAnnotationHandlerMappingInstance");
        }
        defaultAnnotationHandlerMappingInstances.add(obj);
    }

    @Override
    public void reloadEvent(String typename, Class<?> clazz, String versionsuffix) {
        this.removeClazzFromMethodResolverCache(clazz);
        this.removeClazzFromDeclaredMethodsCache(clazz);
        this.clearCachedIntrospectionResults(clazz);
        this.reinvokeDetectHandlers();
        this.reinvokeInitHandlerMethods();
        this.clearLocalVariableTableParameterNameDiscovererCache(clazz);
    }

    private void clearLocalVariableTableParameterNameDiscovererCache(Class<?> clazz) {
        if (localVariableTableParameterNameDiscovererInstances == null) {
            return;
        }
        if (debug) {
            System.out.println("ParameterNamesCache: Clearing parameter name discoverer caches");
        }
        if (this.parameterNamesCacheField == null) {
            try {
                this.parameterNamesCacheField = localVariableTableParameterNameDiscovererInstances.get(0).getClass().getDeclaredField("parameterNamesCache");
            }
            catch (NoSuchFieldException nsfe) {
                log.log(Level.SEVERE, "Unexpectedly cannot find parameterNamesCache field on LocalVariableTableParameterNameDiscoverer class");
            }
        }
        for (Object instance : localVariableTableParameterNameDiscovererInstances) {
            this.parameterNamesCacheField.setAccessible(true);
            try {
                Map parameterNamesCache = (Map)this.parameterNamesCacheField.get(instance);
                Object o = parameterNamesCache.remove(clazz);
                if (!debug) continue;
                System.out.println("ParameterNamesCache: Removed " + clazz.getName() + " from cache?" + (o != null));
            }
            catch (IllegalAccessException e) {
                log.log(Level.SEVERE, "Unexpected IllegalAccessException trying to access parameterNamesCache field on LocalVariableTableParameterNameDiscoverer class");
            }
        }
    }

    private void removeClazzFromMethodResolverCache(Class<?> clazz) {
        for (Object o : annotationMethodHandlerAdapterInstances) {
            try {
                Field f = o.getClass().getDeclaredField("methodResolverCache");
                f.setAccessible(true);
                Map map = (Map)f.get(o);
                Method removeMethod = Map.class.getDeclaredMethod("remove", Object.class);
                Object ret = removeMethod.invoke((Object)map, clazz);
                if (GlobalConfiguration.debugplugins) {
                    System.err.println("SpringPlugin: clearing methodResolverCache for " + clazz.getName());
                }
                if (!GlobalConfiguration.isRuntimeLogging || !log.isLoggable(Level.INFO)) continue;
                log.info("cleared a cache entry? " + (ret != null));
            }
            catch (Exception e) {
                log.log(Level.SEVERE, "Unexpected problem accessing methodResolverCache on " + o, e);
            }
        }
    }

    private void removeClazzFromDeclaredMethodsCache(Class<?> clazz) {
        block9: {
            if (this.reflectionUtilsClassLoaded) {
                try {
                    if (this.reflectionUtilsClass == null) {
                        this.reflectionUtilsClass = clazz.getClassLoader().loadClass("org.springframework.util.ReflectionUtils");
                    }
                    if (this.declaredMethodsCacheField == null) {
                        try {
                            this.declaredMethodsCacheField = this.reflectionUtilsClass.getDeclaredField("declaredMethodsCache");
                        }
                        catch (NoSuchFieldException e) {
                            // empty catch block
                        }
                    }
                    if (this.declaredMethodsCacheField != null) {
                        this.declaredMethodsCacheField.setAccessible(true);
                        Map m = (Map)this.declaredMethodsCacheField.get(null);
                        Object o = m.remove(clazz);
                        if (GlobalConfiguration.debugplugins) {
                            System.err.println("SpringPlugin: clearing ReflectionUtils.declaredMethodsCache for " + clazz.getName() + " removed=" + o);
                        }
                    }
                }
                catch (Exception e) {
                    if (!GlobalConfiguration.debugplugins) break block9;
                    e.printStackTrace();
                }
            }
        }
    }

    private void clearCachedIntrospectionResults(Class<?> clazz) {
        block13: {
            if (this.cachedIntrospectionResultsClassLoaded) {
                try {
                    Object o;
                    Map m;
                    if (this.cachedIntrospectionResultsClass == null) {
                        this.cachedIntrospectionResultsClass = clazz.getClassLoader().loadClass("org.springframework.beans.CachedIntrospectionResults");
                    }
                    if (this.classCacheField == null && this.strongClassCacheField == null) {
                        try {
                            this.classCacheField = this.cachedIntrospectionResultsClass.getDeclaredField("classCache");
                        }
                        catch (NoSuchFieldException e) {
                            this.strongClassCacheField = this.cachedIntrospectionResultsClass.getDeclaredField("strongClassCache");
                            this.softClassCacheField = this.cachedIntrospectionResultsClass.getDeclaredField("softClassCache");
                        }
                    }
                    if (this.classCacheField != null) {
                        this.classCacheField.setAccessible(true);
                        m = (Map)this.classCacheField.get(null);
                        o = m.remove(clazz);
                        if (GlobalConfiguration.debugplugins) {
                            System.err.println("SpringPlugin: clearing CachedIntrospectionResults.classCache for " + clazz.getName() + " removed=" + o);
                        }
                    }
                    if (this.strongClassCacheField != null) {
                        this.strongClassCacheField.setAccessible(true);
                        m = (Map)this.strongClassCacheField.get(null);
                        o = m.remove(clazz);
                        if (GlobalConfiguration.debugplugins) {
                            System.err.println("SpringPlugin: clearing CachedIntrospectionResults.strongClassCache for " + clazz.getName() + " removed=" + o);
                        }
                    }
                    if (this.softClassCacheField != null) {
                        this.softClassCacheField.setAccessible(true);
                        m = (Map)this.softClassCacheField.get(null);
                        o = m.remove(clazz);
                        if (GlobalConfiguration.debugplugins) {
                            System.err.println("SpringPlugin: clearing CachedIntrospectionResults.softClassCache for " + clazz.getName() + " removed=" + o);
                        }
                    }
                }
                catch (Exception e) {
                    if (!GlobalConfiguration.debugplugins) break block13;
                    e.printStackTrace();
                }
            }
        }
    }

    private void reinvokeDetectHandlers() {
        for (Object o : defaultAnnotationHandlerMappingInstances) {
            if (debug) {
                System.out.println("Invoking detectHandlers on instance of DefaultAnnotationHandlerMappingInstance");
            }
            try {
                Class<?> clazz_AbstractDetectingUrlHandlerMapping = o.getClass().getSuperclass();
                Method method_detectHandlers = clazz_AbstractDetectingUrlHandlerMapping.getDeclaredMethod("detectHandlers", new Class[0]);
                method_detectHandlers.setAccessible(true);
                method_detectHandlers.invoke(o, new Object[0]);
            }
            catch (Exception e) {
                if (!GlobalConfiguration.debugplugins) continue;
                e.printStackTrace();
            }
        }
    }

    private void reinvokeInitHandlerMethods() {
        for (Object o : requestMappingHandlerMappingInstances) {
            if (debug) {
                System.out.println("Invoking initHandlerMethods on instance of RequestMappingHandlerMapping");
            }
            try {
                Class<?> clazz_AbstractHandlerMethodMapping = o.getClass().getSuperclass().getSuperclass();
                Field field_handlerMethods = clazz_AbstractHandlerMethodMapping.getDeclaredField("handlerMethods");
                field_handlerMethods.setAccessible(true);
                Map m = (Map)field_handlerMethods.get(o);
                m.clear();
                Field field_urlMap = clazz_AbstractHandlerMethodMapping.getDeclaredField("urlMap");
                field_urlMap.setAccessible(true);
                m = (Map)field_urlMap.get(o);
                m.clear();
                Method method_initHandlerMethods = clazz_AbstractHandlerMethodMapping.getDeclaredMethod("initHandlerMethods", new Class[0]);
                method_initHandlerMethods.setAccessible(true);
                method_initHandlerMethods.invoke(o, new Object[0]);
            }
            catch (NoSuchFieldException nsfe) {
                if (!debug) continue;
                if (nsfe.getMessage().equals("handlerMethods")) {
                    System.out.println("problem resetting request mapping handlers - unable to find field 'handlerMethods' on type 'AbstractHandlerMethodMapping' - you probably are not on Spring 3.1");
                    continue;
                }
                System.out.println("problem resetting request mapping handlers - NoSuchFieldException: " + nsfe.getMessage());
            }
            catch (Exception e) {
                if (!GlobalConfiguration.debugplugins) continue;
                e.printStackTrace();
            }
        }
    }

    @Override
    public boolean shouldRerunStaticInitializer(String typename, Class<?> clazz, String encodedTimestamp) {
        return false;
    }

    private byte[] bytesWithInstanceCreationCaptured(byte[] bytes, String classToCall, String methodToCall) {
        ClassReader cr = new ClassReader(bytes);
        ClassVisitingConstructorAppender ca = new ClassVisitingConstructorAppender(classToCall, methodToCall);
        cr.accept(ca, 0);
        byte[] newbytes = ca.getBytes();
        return newbytes;
    }

    static {
        try {
            String debugString = System.getProperty("springloaded.plugins.spring.debug", "false");
            debug = Boolean.valueOf(debugString);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

