/*
 * Decompiled with CFR 0.152.
 */
package org.springsource.loaded.ri;

import java.lang.annotation.Annotation;
import java.lang.annotation.Inherited;
import java.lang.ref.WeakReference;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import org.springsource.loaded.C;
import org.springsource.loaded.Constants;
import org.springsource.loaded.CurrentLiveVersion;
import org.springsource.loaded.FieldMember;
import org.springsource.loaded.GlobalConfiguration;
import org.springsource.loaded.MethodMember;
import org.springsource.loaded.ReloadableType;
import org.springsource.loaded.TypeDescriptor;
import org.springsource.loaded.TypeRegistry;
import org.springsource.loaded.Utils;
import org.springsource.loaded.infra.UsedByGeneratedCode;
import org.springsource.loaded.jvm.JVM;
import org.springsource.loaded.ri.Exceptions;
import org.springsource.loaded.ri.GetDeclaredFieldLookup;
import org.springsource.loaded.ri.GetFieldLookup;
import org.springsource.loaded.ri.Invoker;
import org.springsource.loaded.ri.MethodProvider;
import sl.org.objectweb.asm.Type;
import sun.reflect.Reflection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReflectiveInterceptor {
    public static Logger log = Logger.getLogger(ReflectiveInterceptor.class.getName());
    private static Map<Class<?>, WeakReference<ReloadableType>> classToRType = null;
    private static int depth;
    private static final boolean theOldWay = false;

    @UsedByGeneratedCode
    public static boolean jlosHasStaticInitializer(Class<?> clazz) {
        ReloadableType rtype = ReflectiveInterceptor.getRType(clazz);
        if (rtype == null) {
            throw new IllegalStateException();
        }
        return rtype.hasStaticInitializer();
    }

    @UsedByGeneratedCode
    public static Method jlClassGetDeclaredMethod(Class<?> clazz, String name, Class<?> ... params) throws SecurityException, NoSuchMethodException {
        ReloadableType rtype = ReflectiveInterceptor.getRType(clazz);
        if (rtype == null) {
            return clazz.getDeclaredMethod(name, params);
        }
        MethodProvider methods = MethodProvider.create(rtype);
        Invoker method = methods.getDeclaredMethod(name, params);
        if (method == null) {
            throw Exceptions.noSuchMethodException(clazz, name, params);
        }
        return method.createJavaMethod();
    }

    @UsedByGeneratedCode
    public static Method jlClassGetMethod(Class<?> clazz, String name, Class<?> ... params) throws SecurityException, NoSuchMethodException {
        ReloadableType rtype = ReflectiveInterceptor.getRType(clazz);
        if (rtype == null) {
            return clazz.getMethod(name, params);
        }
        MethodProvider methods = MethodProvider.create(rtype);
        Invoker method = methods.getMethod(name, params);
        if (method == null) {
            throw Exceptions.noSuchMethodException(clazz, name, params);
        }
        return method.createJavaMethod();
    }

    public static Method[] jlClassGetDeclaredMethods(Class<?> clazz) {
        ReloadableType rtype = ReflectiveInterceptor.getRType(clazz);
        if (rtype == null) {
            return clazz.getDeclaredMethods();
        }
        MethodProvider methods = MethodProvider.create(rtype);
        List<Invoker> invokers = methods.getDeclaredMethods();
        Method[] javaMethods = new Method[invokers.size()];
        for (int i = 0; i < javaMethods.length; ++i) {
            javaMethods[i] = invokers.get(i).createJavaMethod();
        }
        return javaMethods;
    }

    public static Method[] jlClassGetMethods(Class<?> clazz) {
        ReloadableType rtype = ReflectiveInterceptor.getRType(clazz);
        if (rtype == null) {
            return clazz.getMethods();
        }
        MethodProvider methods = MethodProvider.create(rtype);
        Collection<Invoker> invokers = methods.getMethods();
        Method[] javaMethods = new Method[invokers.size()];
        int i = 0;
        for (Invoker invoker : invokers) {
            javaMethods[i++] = invoker.createJavaMethod();
        }
        return javaMethods;
    }

    static String toParamString(Class<?>[] params) {
        if (params == null || params.length == 0) {
            return "()";
        }
        StringBuilder s = new StringBuilder();
        s.append('(');
        int max = params.length;
        for (int i = 0; i < max; ++i) {
            if (i > 0) {
                s.append(", ");
            }
            if (params[i] == null) {
                s.append("null");
                continue;
            }
            s.append(params[i].getName());
        }
        s.append(')');
        return s.toString();
    }

    public static Class<?> getCallerClass() {
        String callerClassName;
        Matcher matcher;
        Class caller = Reflection.getCallerClass((int)depth);
        if (caller == ReflectiveInterceptor.class) {
            depth = 5;
            caller = Reflection.getCallerClass((int)depth);
        }
        if ((matcher = Constants.executorClassNamePattern.matcher(callerClassName = caller.getName())).find()) {
            ClassLoader loader = caller.getClassLoader();
            try {
                return Class.forName(callerClassName.substring(0, matcher.start()), false, loader);
            }
            catch (ClassNotFoundException e) {
                log.log(Level.INFO, "Potential trouble determining caller of reflective method", e);
            }
        }
        return caller;
    }

    public static Annotation[] jlClassGetDeclaredAnnotations(Class<?> clazz) {
        if (TypeRegistry.nothingReloaded) {
            return clazz.getDeclaredAnnotations();
        }
        ReloadableType rtype = ReflectiveInterceptor.getReloadableTypeIfHasBeenReloaded(clazz);
        if (rtype == null) {
            return clazz.getDeclaredAnnotations();
        }
        CurrentLiveVersion clv = rtype.getLiveVersion();
        return clv.getExecutorClass().getDeclaredAnnotations();
    }

    public static Annotation[] jlClassGetAnnotations(Class<?> clazz) {
        Annotation[] annotationsToAdd;
        if (TypeRegistry.nothingReloaded) {
            return clazz.getAnnotations();
        }
        ReloadableType rtype = ReflectiveInterceptor.getRType(clazz);
        if (rtype == null) {
            return clazz.getAnnotations();
        }
        Class<?> superClass = clazz.getSuperclass();
        if (superClass == null) {
            return ReflectiveInterceptor.jlClassGetDeclaredAnnotations(clazz);
        }
        HashMap<Class<? extends Annotation>, Annotation> combinedAnnotations = new HashMap<Class<? extends Annotation>, Annotation>();
        for (Annotation annotation : annotationsToAdd = ReflectiveInterceptor.jlClassGetAnnotations(superClass)) {
            if (!ReflectiveInterceptor.isInheritable(annotation)) continue;
            combinedAnnotations.put(annotation.annotationType(), annotation);
        }
        for (Annotation annotation : annotationsToAdd = ReflectiveInterceptor.jlClassGetDeclaredAnnotations(clazz)) {
            combinedAnnotations.put(annotation.annotationType(), annotation);
        }
        return combinedAnnotations.values().toArray(new Annotation[combinedAnnotations.size()]);
    }

    public static Annotation jlClassGetAnnotation(Class<?> clazz, Class<? extends Annotation> annoType) {
        Class<?> superClass;
        ReloadableType rtype = ReflectiveInterceptor.getRType(clazz);
        if (rtype == null) {
            return clazz.getAnnotation(annoType);
        }
        if (annoType == null) {
            throw new NullPointerException();
        }
        for (Annotation localAnnot : ReflectiveInterceptor.jlClassGetDeclaredAnnotations(clazz)) {
            if (localAnnot.annotationType() != annoType) continue;
            return localAnnot;
        }
        if (annoType.isAnnotationPresent(Inherited.class) && (superClass = clazz.getSuperclass()) != null) {
            return ReflectiveInterceptor.jlClassGetAnnotation(superClass, annoType);
        }
        return null;
    }

    public static boolean jlClassIsAnnotationPresent(Class<?> clazz, Class<? extends Annotation> annoType) {
        ReloadableType rtype = ReflectiveInterceptor.getRType(clazz);
        if (rtype == null) {
            return clazz.isAnnotationPresent(annoType);
        }
        return ReflectiveInterceptor.jlClassGetAnnotation(clazz, annoType) != null;
    }

    public static Constructor<?>[] jlClassGetDeclaredConstructors(Class<?> clazz) {
        ReloadableType rtype = ReflectiveInterceptor.getRType(clazz);
        if (rtype == null) {
            Constructor<?>[] cs = clazz.getDeclaredConstructors();
            return cs;
        }
        if (!rtype.hasBeenReloaded()) {
            Constructor<?>[] cs = clazz.getDeclaredConstructors();
            int i = 0;
            for (Constructor<?> c : cs) {
                if (ReflectiveInterceptor.isMetaConstructor(clazz, c)) continue;
                ReflectiveInterceptor.fixModifier(rtype, c);
                cs[i++] = c;
            }
            return Utils.arrayCopyOf(cs, i);
        }
        CurrentLiveVersion liveVersion = rtype.getLiveVersion();
        Constructor<?>[] clazzCs = null;
        TypeDescriptor desc = rtype.getLatestTypeDescriptor();
        MethodMember[] members = desc.getConstructors();
        Constructor[] cs = new Constructor[members.length];
        for (int i = 0; i < cs.length; ++i) {
            MethodMember m = members[i];
            if (!liveVersion.hasConstructorChanged(m)) {
                if (clazzCs == null) {
                    clazzCs = clazz.getDeclaredConstructors();
                }
                cs[i] = ReflectiveInterceptor.findConstructor(clazzCs, m);
                ReflectiveInterceptor.fixModifier(rtype, cs[i]);
                continue;
            }
            cs[i] = ReflectiveInterceptor.newConstructor(rtype, m);
        }
        return cs;
    }

    private static Constructor<?> findConstructor(Constructor<?>[] constructors, MethodMember searchFor) {
        String paramDescriptor = searchFor.getDescriptor();
        int max = constructors.length;
        for (int i = 0; i < max; ++i) {
            String candidateDescriptor = Utils.toConstructorDescriptor(constructors[i].getParameterTypes());
            if (!candidateDescriptor.equals(paramDescriptor)) continue;
            return constructors[i];
        }
        return null;
    }

    private static boolean isMetaConstructor(Class<?> clazz, Constructor<?> c) {
        Class<?>[] params = c.getParameterTypes();
        if (clazz.isEnum()) {
            return params.length > 2 && params[2].getName().equals("org.springsource.loaded.C");
        }
        if (clazz.getSuperclass() != null && clazz.getSuperclass().getName().equals("groovy.lang.Closure")) {
            return params.length > 2 && params[2].getName().equals("org.springsource.loaded.C");
        }
        return params.length > 0 && params[0].getName().equals("org.springsource.loaded.C");
    }

    private static Constructor<?> newConstructor(ReloadableType rtype, MethodMember m) {
        ClassLoader classLoader = rtype.getTypeRegistry().getClassLoader();
        try {
            return JVM.newConstructor(Utils.toClass(rtype), Utils.toParamClasses(m.getDescriptor(), classLoader), Utils.slashedNamesToClasses(m.getExceptions(), classLoader), m.getModifiers(), m.getGenericSignature());
        }
        catch (ClassNotFoundException e) {
            throw new IllegalStateException("Couldn't create j.l.Constructor for " + m, e);
        }
    }

    private static void fixModifiers(ReloadableType rtype, Field[] fields) {
        TypeDescriptor typeDesc = rtype.getLatestTypeDescriptor();
        for (Field field : fields) {
            ReflectiveInterceptor.fixModifier(typeDesc, field);
        }
    }

    static void fixModifier(TypeDescriptor typeDesc, Field field) {
        int mods = typeDesc.getField(field.getName()).getModifiers();
        if (mods != field.getModifiers()) {
            JVM.setFieldModifiers(field, mods);
        }
    }

    protected static void fixModifier(ReloadableType rtype, Constructor<?> constructor) {
        String desc = Type.getConstructorDescriptor(constructor);
        MethodMember rCons = rtype.getCurrentConstructor(desc);
        if (constructor.getModifiers() != rCons.getModifiers()) {
            JVM.setConstructorModifiers(constructor, rCons.getModifiers());
        }
    }

    public static Constructor<?>[] jlClassGetConstructors(Class<?> clazz) {
        ReloadableType rtype = ReflectiveInterceptor.getRType(clazz);
        if (rtype == null) {
            return clazz.getConstructors();
        }
        Constructor<?>[] candidates = ReflectiveInterceptor.jlClassGetDeclaredConstructors(clazz);
        ArrayList keep = new ArrayList(candidates.length);
        for (Constructor<?> candidate : candidates) {
            if (!Modifier.isPublic(candidate.getModifiers())) continue;
            keep.add(candidate);
        }
        return keep.toArray(new Constructor[keep.size()]);
    }

    public static Constructor<?> jlClassGetDeclaredConstructor(Class<?> clazz, Class<?> ... params) throws SecurityException, NoSuchMethodException {
        ReloadableType rtype = ReflectiveInterceptor.getRType(clazz);
        if (rtype == null) {
            Constructor<?> c = clazz.getDeclaredConstructor(params);
            return c;
        }
        if (!rtype.hasBeenReloaded()) {
            Constructor<?> c = clazz.getDeclaredConstructor(params);
            if (ReflectiveInterceptor.isMetaConstructor(clazz, c)) {
                throw Exceptions.noSuchConstructorException(clazz, params);
            }
            ReflectiveInterceptor.fixModifier(rtype, c);
            return c;
        }
        CurrentLiveVersion clv = rtype.getLiveVersion();
        boolean b = clv.hasConstructorChanged(Utils.toConstructorDescriptor(params));
        if (!b) {
            Constructor<?> c = clazz.getDeclaredConstructor(params);
            if (ReflectiveInterceptor.isMetaConstructor(clazz, c)) {
                throw Exceptions.noSuchConstructorException(clazz, params);
            }
            ReflectiveInterceptor.fixModifier(rtype, c);
            return c;
        }
        TypeDescriptor desc = rtype.getLatestTypeDescriptor();
        MethodMember[] members = desc.getConstructors();
        String searchFor = Utils.toConstructorDescriptor(params);
        for (MethodMember m : members) {
            if (!m.getDescriptor().equals(searchFor)) continue;
            return ReflectiveInterceptor.newConstructor(rtype, m);
        }
        throw Exceptions.noSuchConstructorException(clazz, params);
    }

    public static Constructor<?> jlClassGetConstructor(Class<?> clazz, Class<?> ... params) throws SecurityException, NoSuchMethodException {
        ReloadableType rtype = ReflectiveInterceptor.getRType(clazz);
        if (rtype == null) {
            return clazz.getConstructor(params);
        }
        Constructor<?> c = ReflectiveInterceptor.jlClassGetDeclaredConstructor(clazz, params);
        if (Modifier.isPublic(c.getModifiers())) {
            return c;
        }
        throw Exceptions.noSuchMethodException(clazz, "<init>", params);
    }

    private static boolean isInheritable(Annotation annotation) {
        return annotation.annotationType().isAnnotationPresent(Inherited.class);
    }

    private static Method asAccessibleMethod(ReloadableType methodDeclaringTypeReloadableType, Method method, Object target, boolean makeAccessibleCopy) throws IllegalAccessException {
        if (methodDeclaringTypeReloadableType != null && ReflectiveInterceptor.isDeleted(methodDeclaringTypeReloadableType, method)) {
            throw Exceptions.noSuchMethodError(method);
        }
        if (!method.isAccessible()) {
            int classmods;
            Class<?> clazz = method.getDeclaringClass();
            int mods = method.getModifiers();
            if (!Modifier.isPublic(mods & (classmods = methodDeclaringTypeReloadableType == null || !methodDeclaringTypeReloadableType.hasBeenReloaded() ? clazz.getModifiers() : methodDeclaringTypeReloadableType.getLatestTypeDescriptor().getModifiers() & 0xFFFFFFDF))) {
                Class<?> callerClass = ReflectiveInterceptor.getCallerClass();
                JVM.ensureMemberAccess(callerClass, clazz, target, mods);
                if (makeAccessibleCopy) {
                    method = JVM.copyMethod(method);
                    method.setAccessible(true);
                }
            }
        }
        return makeAccessibleCopy ? method : null;
    }

    private static Constructor<?> asAccessibleConstructor(Constructor<?> c, boolean makeAccessibleCopy) throws NoSuchMethodException, IllegalAccessException {
        if (ReflectiveInterceptor.isDeleted(c)) {
            throw Exceptions.noSuchConstructorError(c);
        }
        Class<?> clazz = c.getDeclaringClass();
        int mods = c.getModifiers();
        if (!c.isAccessible() && !Modifier.isPublic(mods & ReflectiveInterceptor.jlClassGetModifiers(clazz))) {
            Class<?> callerClass = ReflectiveInterceptor.getCallerClass();
            JVM.ensureMemberAccess(callerClass, clazz, null, mods);
            if (makeAccessibleCopy) {
                c = JVM.copyConstructor(c);
                c.setAccessible(true);
            }
        }
        return makeAccessibleCopy ? c : null;
    }

    private static Field asAccessibleField(Field field, Object target, boolean makeAccessibleCopy) throws IllegalAccessException {
        if (ReflectiveInterceptor.isDeleted(field)) {
            throw Exceptions.noSuchFieldError(field);
        }
        Class<?> clazz = field.getDeclaringClass();
        int mods = field.getModifiers();
        if (!field.isAccessible() && !Modifier.isPublic(mods & ReflectiveInterceptor.jlClassGetModifiers(clazz))) {
            Class<?> callerClass = ReflectiveInterceptor.getCallerClass();
            JVM.ensureMemberAccess(callerClass, clazz, target, mods);
            if (makeAccessibleCopy) {
                field = JVM.copyField(field);
                field.setAccessible(true);
            }
        }
        return makeAccessibleCopy ? field : null;
    }

    private static Field asSetableField(Field field, Object target, Class<?> valueType, Object value, boolean makeAccessibleCopy) throws IllegalAccessException {
        if (ReflectiveInterceptor.isDeleted(field)) {
            throw Exceptions.noSuchFieldError(field);
        }
        Class<?> clazz = field.getDeclaringClass();
        int mods = field.getModifiers();
        if (!field.isAccessible() && !Modifier.isPublic(mods & ReflectiveInterceptor.jlClassGetModifiers(clazz))) {
            Class<?> callerClass = ReflectiveInterceptor.getCallerClass();
            JVM.ensureMemberAccess(callerClass, clazz, target, mods);
            if (makeAccessibleCopy) {
                field = JVM.copyField(field);
                field.setAccessible(true);
            }
        }
        if (ReflectiveInterceptor.isPrimitive(valueType)) {
            ReflectiveInterceptor.typeCheckFieldSet(field, valueType, value);
            if (!field.isAccessible() && Modifier.isFinal(mods)) {
                throw Exceptions.illegalSetFinalFieldException(field, field.getType(), ReflectiveInterceptor.coerce(value, field.getType()));
            }
        } else {
            if (!field.isAccessible() && Modifier.isFinal(mods)) {
                throw Exceptions.illegalSetFinalFieldException(field, valueType, value);
            }
            ReflectiveInterceptor.typeCheckFieldSet(field, valueType, value);
        }
        return makeAccessibleCopy ? field : null;
    }

    private static Object coerce(Object value, Class<?> toType) {
        Class<?> fromType = value.getClass();
        if (Integer.class.equals(fromType)) {
            if (Float.TYPE.equals(toType)) {
                return Float.valueOf(((Integer)value).intValue());
            }
            if (Double.TYPE.equals(toType)) {
                return (double)((Integer)value).intValue();
            }
        } else if (Byte.class.equals(fromType)) {
            if (Float.TYPE.equals(toType)) {
                return Float.valueOf(((Byte)value).byteValue());
            }
            if (Double.TYPE.equals(toType)) {
                return (double)((Byte)value).byteValue();
            }
        } else if (Character.class.equals(fromType)) {
            if (Integer.TYPE.equals(toType)) {
                return (int)((Character)value).charValue();
            }
            if (Long.TYPE.equals(toType)) {
                return (long)((Character)value).charValue();
            }
            if (Float.TYPE.equals(toType)) {
                return Float.valueOf(((Character)value).charValue());
            }
            if (Double.TYPE.equals(toType)) {
                return (double)((Character)value).charValue();
            }
        } else if (Short.class.equals(fromType)) {
            if (Float.TYPE.equals(toType)) {
                return Float.valueOf(((Short)value).shortValue());
            }
            if (Double.TYPE.equals(toType)) {
                return (double)((Short)value).shortValue();
            }
        } else if (Long.class.equals(fromType)) {
            if (Float.TYPE.equals(toType)) {
                return Float.valueOf(((Long)value).longValue());
            }
            if (Double.TYPE.equals(toType)) {
                return (double)((Long)value).longValue();
            }
        } else if (Float.class.equals(fromType) && Double.TYPE.equals(toType)) {
            return (double)((Float)value).floatValue();
        }
        return value;
    }

    private static void typeCheckFieldSet(Field field, Object value) throws IllegalAccessException {
        Class<?> fieldType = field.getType();
        if (value == null) {
            if (fieldType.isPrimitive()) {
                throw Exceptions.illegalSetFieldTypeException(field, null, value);
            }
        } else {
            Class<?> valueType;
            if (fieldType.isPrimitive()) {
                fieldType = ReflectiveInterceptor.boxTypeFor(fieldType);
            }
            if (!Utils.isConvertableFrom(fieldType, valueType = value.getClass())) {
                throw Exceptions.illegalSetFieldTypeException(field, valueType, value);
            }
        }
    }

    private static void typeCheckFieldSet(Field field, Class<?> valueType, Object value) throws IllegalAccessException {
        if (!ReflectiveInterceptor.isPrimitive(valueType)) {
            ReflectiveInterceptor.typeCheckFieldSet(field, value);
        } else {
            Class<?> fieldType = field.getType();
            if (!Utils.isConvertableFrom(fieldType, valueType)) {
                throw Exceptions.illegalSetFieldTypeException(field, valueType, value);
            }
        }
    }

    private static boolean isPrimitive(Class<?> valueType) {
        return valueType != null && valueType.isPrimitive();
    }

    private static Class<?> valueType(Object value) {
        if (value == null) {
            return null;
        }
        return value.getClass();
    }

    public static int jlClassGetModifiers(Class<?> clazz) {
        ReloadableType rtype = ReflectiveInterceptor.getRType(clazz);
        if (rtype == null) {
            return clazz.getModifiers();
        }
        return rtype.getLatestTypeDescriptor().getModifiers() & 0xFFFFFFDF;
    }

    private static boolean isDeleted(ReloadableType rtype, Method method) {
        if (rtype == null || !rtype.hasBeenReloaded()) {
            return false;
        }
        MethodMember currentMethod = rtype.getCurrentMethod(method.getName(), Type.getMethodDescriptor(method));
        if (currentMethod == null) {
            return true;
        }
        return MethodMember.isDeleted(currentMethod);
    }

    private static boolean isDeleted(Constructor<?> c) {
        ReloadableType rtype = ReflectiveInterceptor.getReloadableTypeIfHasBeenReloaded(c.getDeclaringClass());
        if (rtype == null) {
            return false;
        }
        TypeDescriptor desc = rtype.getLatestTypeDescriptor();
        MethodMember currentConstructor = desc.getConstructor(Type.getConstructorDescriptor(c));
        return currentConstructor == null;
    }

    private static boolean isDeleted(Field field) {
        ReloadableType rtype = ReflectiveInterceptor.getReloadableTypeIfHasBeenReloaded(field.getDeclaringClass());
        if (rtype == null) {
            return false;
        }
        TypeDescriptor desc = rtype.getLatestTypeDescriptor();
        FieldMember currentField = desc.getField(field.getName());
        return currentField == null;
    }

    private static ReloadableType getReloadableTypeIfHasBeenReloaded(Class<?> clazz) {
        if (TypeRegistry.nothingReloaded) {
            return null;
        }
        ReloadableType rtype = ReflectiveInterceptor.getRType(clazz);
        if (rtype != null && rtype.hasBeenReloaded()) {
            return rtype;
        }
        return null;
    }

    public static ReloadableType getRType(Class<?> clazz) {
        WeakReference<ReloadableType> ref = classToRType.get(clazz);
        ReloadableType rtype = null;
        if (ref != null) {
            rtype = (ReloadableType)ref.get();
        }
        if (rtype == null) {
            ClassLoader cl = clazz.getClassLoader();
            TypeRegistry tr = TypeRegistry.getTypeRegistryFor(cl);
            if (tr == null) {
                classToRType.put(clazz, ReloadableType.NOT_RELOADABLE_TYPE_REF);
            } else {
                rtype = tr.getReloadableType(clazz.getName().replace('.', '/'));
                if (rtype == null) {
                    classToRType.put(clazz, ReloadableType.NOT_RELOADABLE_TYPE_REF);
                } else {
                    classToRType.put(clazz, new WeakReference<ReloadableType>(rtype));
                }
            }
        } else if (rtype == ReloadableType.NOT_RELOADABLE_TYPE) {
            return null;
        }
        return rtype;
    }

    public static Annotation[] jlrMethodGetDeclaredAnnotations(Method method) {
        ReloadableType rtype = ReflectiveInterceptor.getReloadableTypeIfHasBeenReloaded(method.getDeclaringClass());
        if (rtype == null) {
            return method.getDeclaredAnnotations();
        }
        CurrentLiveVersion clv = rtype.getLiveVersion();
        MethodMember methodMember = rtype.getCurrentMethod(method.getName(), Type.getMethodDescriptor(method));
        if (MethodMember.isCatcher(methodMember)) {
            if (clv.getExecutorMethod(methodMember) != null) {
                throw new IllegalStateException();
            }
            return method.getDeclaredAnnotations();
        }
        Method executor = clv.getExecutorMethod(methodMember);
        return executor.getAnnotations();
    }

    public static Annotation[][] jlrMethodGetParameterAnnotations(Method method) {
        ReloadableType rtype = ReflectiveInterceptor.getReloadableTypeIfHasBeenReloaded(method.getDeclaringClass());
        if (rtype == null) {
            return method.getParameterAnnotations();
        }
        CurrentLiveVersion clv = rtype.getLiveVersion();
        MethodMember currentMethod = rtype.getCurrentMethod(method.getName(), Type.getMethodDescriptor(method));
        Method executor = clv.getExecutorMethod(currentMethod);
        Annotation[][] result = executor.getParameterAnnotations();
        if (!currentMethod.isStatic()) {
            result = (Annotation[][])Utils.arrayCopyOf(result, result.length - 1);
        }
        return result;
    }

    public static Object jlClassNewInstance(Class<?> clazz) throws SecurityException, NoSuchMethodException, IllegalArgumentException, InstantiationException, IllegalAccessException, InvocationTargetException {
        Constructor<?> c;
        try {
            c = ReflectiveInterceptor.jlClassGetDeclaredConstructor(clazz, new Class[0]);
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
            throw Exceptions.instantiation(clazz);
        }
        c = ReflectiveInterceptor.asAccessibleConstructor(c, true);
        return ReflectiveInterceptor.jlrConstructorNewInstance(c, new Object[0]);
    }

    public static Object jlrConstructorNewInstance(Constructor<?> c, Object ... params) throws InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException, SecurityException, NoSuchMethodException {
        Object[] instanceAndParams;
        Class<?> clazz = c.getDeclaringClass();
        ReloadableType rtype = ReflectiveInterceptor.getReloadableTypeIfHasBeenReloaded(clazz);
        if (rtype == null) {
            c = ReflectiveInterceptor.asAccessibleConstructor(c, true);
            return c.newInstance(params);
        }
        boolean ctorChanged = rtype.getLiveVersion().hasConstructorChanged(Utils.toConstructorDescriptor(c.getParameterTypes()));
        if (!ctorChanged) {
            c = ReflectiveInterceptor.asAccessibleConstructor(c, true);
            return c.newInstance(params);
        }
        ReflectiveInterceptor.asAccessibleConstructor(c, false);
        CurrentLiveVersion clv = rtype.getLiveVersion();
        Method executor = clv.getExecutorMethod(rtype.getCurrentConstructor(Type.getConstructorDescriptor(c)));
        Constructor<?> magicConstructor = clazz.getConstructor(C.class);
        Object instance = magicConstructor.newInstance(new Object[]{null});
        if (params == null || params.length == 0) {
            instanceAndParams = new Object[]{instance};
        } else {
            instanceAndParams = new Object[params.length + 1];
            instanceAndParams[0] = instance;
            System.arraycopy(params, 0, instanceAndParams, 1, params.length);
        }
        executor.invoke(null, instanceAndParams);
        return instance;
    }

    public static Object jlrMethodInvoke(Method method, Object target, Object ... params) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        Invoker invoker;
        Class<?> declaringClass;
        block112: {
            String mname;
            declaringClass = method.getDeclaringClass();
            if (declaringClass == Class.class) {
                mname = method.getName();
                try {
                    if (mname.equals("getFields")) {
                        return ReflectiveInterceptor.jlClassGetFields((Class)target);
                    }
                    if (mname.equals("getDeclaredFields")) {
                        return ReflectiveInterceptor.jlClassGetDeclaredFields((Class)target);
                    }
                    if (mname.equals("getDeclaredField")) {
                        return ReflectiveInterceptor.jlClassGetDeclaredField((Class)target, (String)params[0]);
                    }
                    if (mname.equals("getField")) {
                        return ReflectiveInterceptor.jlClassGetField((Class)target, (String)params[0]);
                    }
                    if (mname.equals("getConstructors")) {
                        return ReflectiveInterceptor.jlClassGetConstructors((Class)target);
                    }
                    if (mname.equals("getDeclaredConstructors")) {
                        return ReflectiveInterceptor.jlClassGetDeclaredConstructors((Class)target);
                    }
                    if (mname.equals("getDeclaredMethod")) {
                        return ReflectiveInterceptor.jlClassGetDeclaredMethod((Class)target, (String)params[0], (Class[])params[1]);
                    }
                    if (mname.equals("getDeclaredMethods")) {
                        return ReflectiveInterceptor.jlClassGetDeclaredMethods((Class)target);
                    }
                    if (mname.equals("getMethod")) {
                        return ReflectiveInterceptor.jlClassGetMethod((Class)target, (String)params[0], (Class[])params[1]);
                    }
                    if (mname.equals("getMethods")) {
                        return ReflectiveInterceptor.jlClassGetMethods((Class)target);
                    }
                    if (mname.equals("getConstructor")) {
                        return ReflectiveInterceptor.jlClassGetConstructor((Class)target, (Class[])params[0]);
                    }
                    if (mname.equals("getDeclaredConstructor")) {
                        return ReflectiveInterceptor.jlClassGetDeclaredConstructor((Class)target, (Class[])params[0]);
                    }
                    if (mname.equals("getModifiers")) {
                        return ReflectiveInterceptor.jlClassGetModifiers((Class)target);
                    }
                    if (mname.equals("isAnnotationPresent")) {
                        return ReflectiveInterceptor.jlClassIsAnnotationPresent((Class)target, (Class)params[0]);
                    }
                    if (mname.equals("newInstance")) {
                        return ReflectiveInterceptor.jlClassNewInstance((Class)target);
                    }
                    if (mname.equals("getDeclaredAnnotations")) {
                        return ReflectiveInterceptor.jlClassGetDeclaredAnnotations((Class)target);
                    }
                    if (mname.equals("getAnnotation")) {
                        return ReflectiveInterceptor.jlClassGetAnnotation((Class)target, (Class)params[0]);
                    }
                    if (mname.equals("getAnnotations")) {
                        return ReflectiveInterceptor.jlClassGetAnnotations((Class)target);
                    }
                    break block112;
                }
                catch (NoSuchMethodException nsme) {
                    throw new InvocationTargetException(nsme);
                }
                catch (NoSuchFieldException nsfe) {
                    throw new InvocationTargetException(nsfe);
                }
                catch (InstantiationException ie) {
                    throw new InvocationTargetException(ie);
                }
            }
            if (declaringClass == Method.class) {
                mname = method.getName();
                if (mname.equals("invoke")) {
                    return ReflectiveInterceptor.jlrMethodInvoke((Method)target, params[0], (Object[])params[1]);
                }
                if (mname.equals("getAnnotation")) {
                    return ReflectiveInterceptor.jlrMethodGetAnnotation((Method)target, (Class)params[0]);
                }
                if (mname.equals("getAnnotations")) {
                    return ReflectiveInterceptor.jlrMethodGetAnnotations((Method)target);
                }
                if (mname.equals("getDeclaredAnnotations")) {
                    return ReflectiveInterceptor.jlrMethodGetDeclaredAnnotations((Method)target);
                }
                if (mname.equals("getParameterAnnotations")) {
                    return ReflectiveInterceptor.jlrMethodGetParameterAnnotations((Method)target);
                }
                if (mname.equals("isAnnotationPresent")) {
                    return ReflectiveInterceptor.jlrMethodIsAnnotationPresent((Method)target, (Class)params[0]);
                }
            } else {
                if (declaringClass == Constructor.class) {
                    mname = method.getName();
                    try {
                        if (mname.equals("getAnnotation")) {
                            return ReflectiveInterceptor.jlrConstructorGetAnnotation((Constructor)target, (Class)params[0]);
                        }
                        if (mname.equals("newInstance")) {
                            return ReflectiveInterceptor.jlrConstructorNewInstance((Constructor)target, (Object[])params[0]);
                        }
                        if (mname.equals("getAnnotations")) {
                            return ReflectiveInterceptor.jlrConstructorGetAnnotations((Constructor)target);
                        }
                        if (mname.equals("getDeclaredAnnotations")) {
                            return ReflectiveInterceptor.jlrConstructorGetDeclaredAnnotations((Constructor)target);
                        }
                        if (mname.equals("isAnnotationPresent")) {
                            return ReflectiveInterceptor.jlrConstructorIsAnnotationPresent((Constructor)target, (Class)params[0]);
                        }
                        if (mname.equals("getParameterAnnotations")) {
                            return ReflectiveInterceptor.jlrConstructorGetParameterAnnotations((Constructor)target);
                        }
                        break block112;
                    }
                    catch (InstantiationException ie) {
                        throw new InvocationTargetException(ie);
                    }
                    catch (NoSuchMethodException nsme) {
                        throw new InvocationTargetException(nsme);
                    }
                }
                if (declaringClass == Field.class) {
                    mname = method.getName();
                    if (mname.equals("set")) {
                        ReflectiveInterceptor.jlrFieldSet((Field)target, params[0], params[1]);
                        return null;
                    }
                    if (mname.equals("setBoolean")) {
                        ReflectiveInterceptor.jlrFieldSetBoolean((Field)target, params[0], (Boolean)params[1]);
                        return null;
                    }
                    if (mname.equals("setByte")) {
                        ReflectiveInterceptor.jlrFieldSetByte((Field)target, params[0], (Byte)params[1]);
                        return null;
                    }
                    if (mname.equals("setChar")) {
                        ReflectiveInterceptor.jlrFieldSetChar((Field)target, params[0], ((Character)params[1]).charValue());
                        return null;
                    }
                    if (mname.equals("setFloat")) {
                        ReflectiveInterceptor.jlrFieldSetFloat((Field)target, params[0], ((Float)params[1]).floatValue());
                        return null;
                    }
                    if (mname.equals("setShort")) {
                        ReflectiveInterceptor.jlrFieldSetShort((Field)target, params[0], (Short)params[1]);
                        return null;
                    }
                    if (mname.equals("setLong")) {
                        ReflectiveInterceptor.jlrFieldSetLong((Field)target, params[0], (Long)params[1]);
                        return null;
                    }
                    if (mname.equals("setDouble")) {
                        ReflectiveInterceptor.jlrFieldSetDouble((Field)target, params[0], (Double)params[1]);
                        return null;
                    }
                    if (mname.equals("setInt")) {
                        ReflectiveInterceptor.jlrFieldSetInt((Field)target, params[0], (Integer)params[1]);
                        return null;
                    }
                    if (mname.equals("get")) {
                        return ReflectiveInterceptor.jlrFieldGet((Field)target, params[0]);
                    }
                    if (mname.equals("getByte")) {
                        return ReflectiveInterceptor.jlrFieldGetByte((Field)target, params[0]);
                    }
                    if (mname.equals("getChar")) {
                        return Character.valueOf(ReflectiveInterceptor.jlrFieldGetChar((Field)target, params[0]));
                    }
                    if (mname.equals("getDouble")) {
                        return ReflectiveInterceptor.jlrFieldGetDouble((Field)target, params[0]);
                    }
                    if (mname.equals("getBoolean")) {
                        return ReflectiveInterceptor.jlrFieldGetBoolean((Field)target, params[0]);
                    }
                    if (mname.equals("getLong")) {
                        return ReflectiveInterceptor.jlrFieldGetLong((Field)target, params[0]);
                    }
                    if (mname.equals("getFloat")) {
                        return Float.valueOf(ReflectiveInterceptor.jlrFieldGetFloat((Field)target, params[0]));
                    }
                    if (mname.equals("getInt")) {
                        return ReflectiveInterceptor.jlrFieldGetInt((Field)target, params[0]);
                    }
                    if (mname.equals("getShort")) {
                        return ReflectiveInterceptor.jlrFieldGetShort((Field)target, params[0]);
                    }
                    if (mname.equals("getAnnotations")) {
                        return ReflectiveInterceptor.jlrFieldGetAnnotations((Field)target);
                    }
                    if (mname.equals("getDeclaredAnnotations")) {
                        return ReflectiveInterceptor.jlrFieldGetDeclaredAnnotations((Field)target);
                    }
                    if (mname.equals("isAnnotationPresent")) {
                        return ReflectiveInterceptor.jlrFieldIsAnnotationPresent((Field)target, (Class)params[0]);
                    }
                    if (mname.equals("getAnnotation")) {
                        return ReflectiveInterceptor.jlrFieldGetAnnotation((Field)target, (Class)params[0]);
                    }
                } else if (declaringClass == AccessibleObject.class) {
                    mname = method.getName();
                    if (mname.equals("isAnnotationPresent")) {
                        if (target instanceof Constructor) {
                            return ReflectiveInterceptor.jlrConstructorIsAnnotationPresent((Constructor)target, (Class)params[0]);
                        }
                        if (target instanceof Method) {
                            return ReflectiveInterceptor.jlrMethodIsAnnotationPresent((Method)target, (Class)params[0]);
                        }
                        if (target instanceof Field) {
                            return ReflectiveInterceptor.jlrFieldIsAnnotationPresent((Field)target, (Class)params[0]);
                        }
                    } else if (mname.equals("getAnnotations")) {
                        if (target instanceof Constructor) {
                            return ReflectiveInterceptor.jlrConstructorGetAnnotations((Constructor)target);
                        }
                        if (target instanceof Method) {
                            return ReflectiveInterceptor.jlrMethodGetAnnotations((Method)target);
                        }
                        if (target instanceof Field) {
                            return ReflectiveInterceptor.jlrFieldGetAnnotations((Field)target);
                        }
                    } else if (mname.equals("getDeclaredAnnotations")) {
                        if (target instanceof Constructor) {
                            return ReflectiveInterceptor.jlrConstructorGetDeclaredAnnotations((Constructor)target);
                        }
                        if (target instanceof Method) {
                            return ReflectiveInterceptor.jlrMethodGetDeclaredAnnotations((Method)target);
                        }
                        if (target instanceof Field) {
                            return ReflectiveInterceptor.jlrFieldGetDeclaredAnnotations((Field)target);
                        }
                    } else if (mname.equals("getAnnotation")) {
                        if (target instanceof Constructor) {
                            return ReflectiveInterceptor.jlrConstructorGetAnnotation((Constructor)target, (Class)params[0]);
                        }
                        if (target instanceof Method) {
                            return ReflectiveInterceptor.jlrMethodGetAnnotation((Method)target, (Class)params[0]);
                        }
                        if (target instanceof Field) {
                            return ReflectiveInterceptor.jlrFieldGetAnnotation((Field)target, (Class)params[0]);
                        }
                    }
                } else if (declaringClass == AnnotatedElement.class) {
                    mname = method.getName();
                    if (mname.equals("isAnnotationPresent")) {
                        if (target instanceof Constructor) {
                            return ReflectiveInterceptor.jlrConstructorIsAnnotationPresent((Constructor)target, (Class)params[0]);
                        }
                        if (target instanceof Method) {
                            return ReflectiveInterceptor.jlrMethodIsAnnotationPresent((Method)target, (Class)params[0]);
                        }
                        if (target instanceof Field) {
                            return ReflectiveInterceptor.jlrFieldIsAnnotationPresent((Field)target, (Class)params[0]);
                        }
                    } else if (mname.equals("getAnnotations")) {
                        if (target instanceof Constructor) {
                            return ReflectiveInterceptor.jlrConstructorGetAnnotations((Constructor)target);
                        }
                        if (target instanceof Method) {
                            return ReflectiveInterceptor.jlrMethodGetAnnotations((Method)target);
                        }
                        if (target instanceof Field) {
                            return ReflectiveInterceptor.jlrFieldGetAnnotations((Field)target);
                        }
                    } else if (mname.equals("getDeclaredAnnotations")) {
                        if (target instanceof Constructor) {
                            return ReflectiveInterceptor.jlrConstructorGetDeclaredAnnotations((Constructor)target);
                        }
                        if (target instanceof Method) {
                            return ReflectiveInterceptor.jlrMethodGetDeclaredAnnotations((Method)target);
                        }
                        if (target instanceof Field) {
                            return ReflectiveInterceptor.jlrFieldGetDeclaredAnnotations((Field)target);
                        }
                    } else if (mname.equals("getAnnotation")) {
                        if (target instanceof Constructor) {
                            return ReflectiveInterceptor.jlrConstructorGetAnnotation((Constructor)target, (Class)params[0]);
                        }
                        if (target instanceof Method) {
                            return ReflectiveInterceptor.jlrMethodGetAnnotation((Method)target, (Class)params[0]);
                        }
                        if (target instanceof Field) {
                            return ReflectiveInterceptor.jlrFieldGetAnnotation((Field)target, (Class)params[0]);
                        }
                    }
                }
            }
        }
        if (TypeRegistry.nothingReloaded) {
            method = ReflectiveInterceptor.asAccessibleMethod(null, method, target, true);
            return method.invoke(target, params);
        }
        ReloadableType declaringType = ReflectiveInterceptor.getRType(declaringClass);
        if (declaringType == null) {
            method = ReflectiveInterceptor.asAccessibleMethod(declaringType, method, target, true);
            return method.invoke(target, params);
        }
        ReflectiveInterceptor.asAccessibleMethod(declaringType, method, target, false);
        int mods = method.getModifiers();
        if ((mods & 0xA) != 0) {
            MethodProvider methods = MethodProvider.create(declaringType);
            invoker = methods.staticLookup(mods, method.getName(), Type.getMethodDescriptor(method));
        } else {
            ReloadableType targetType = ReflectiveInterceptor.getRType(target.getClass());
            if (targetType == null) {
                if (GlobalConfiguration.verboseMode) {
                    System.out.println("UNEXPECTED: Subtype '" + target.getClass().getName() + "' of reloadable type " + method.getDeclaringClass().getName() + " is not reloadable: may not see changes reloaded in this hierarchy");
                }
                method = ReflectiveInterceptor.asAccessibleMethod(declaringType, method, target, true);
                return method.invoke(target, params);
            }
            MethodProvider methods = MethodProvider.create(targetType);
            invoker = methods.dynamicLookup(mods, method.getName(), Type.getMethodDescriptor(method));
        }
        return invoker.invoke(target, params);
    }

    public static boolean jlrMethodIsAnnotationPresent(Method method, Class<? extends Annotation> annotClass) {
        return ReflectiveInterceptor.jlrMethodGetAnnotation(method, annotClass) != null;
    }

    public static Annotation jlrMethodGetAnnotation(Method method, Class<? extends Annotation> annotClass) {
        Annotation[] annots;
        ReloadableType rtype = ReflectiveInterceptor.getReloadableTypeIfHasBeenReloaded(method.getDeclaringClass());
        if (rtype == null) {
            return method.getAnnotation(annotClass);
        }
        if (annotClass == null) {
            throw new NullPointerException();
        }
        for (Annotation annotation : annots = ReflectiveInterceptor.jlrMethodGetDeclaredAnnotations(method)) {
            if (!annotClass.equals(annotation.annotationType())) continue;
            return annotation;
        }
        return null;
    }

    public static Annotation[] jlrAnnotatedElementGetAnnotations(AnnotatedElement elem) {
        if (elem instanceof Class) {
            return ReflectiveInterceptor.jlClassGetAnnotations((Class)elem);
        }
        if (elem instanceof AccessibleObject) {
            return ReflectiveInterceptor.jlrAccessibleObjectGetAnnotations((AccessibleObject)elem);
        }
        return elem.getAnnotations();
    }

    public static Annotation[] jlrAnnotatedElementGetDeclaredAnnotations(AnnotatedElement elem) {
        if (elem instanceof Class) {
            return ReflectiveInterceptor.jlClassGetDeclaredAnnotations((Class)elem);
        }
        if (elem instanceof AccessibleObject) {
            return ReflectiveInterceptor.jlrAccessibleObjectGetDeclaredAnnotations((AccessibleObject)elem);
        }
        return elem.getDeclaredAnnotations();
    }

    public static Annotation[] jlrAccessibleObjectGetDeclaredAnnotations(AccessibleObject obj) {
        if (obj instanceof Method) {
            return ReflectiveInterceptor.jlrMethodGetDeclaredAnnotations((Method)obj);
        }
        if (obj instanceof Field) {
            return ReflectiveInterceptor.jlrFieldGetDeclaredAnnotations((Field)obj);
        }
        if (obj instanceof Constructor) {
            return ReflectiveInterceptor.jlrConstructorGetDeclaredAnnotations((Constructor)obj);
        }
        return obj.getDeclaredAnnotations();
    }

    public static Annotation[] jlrFieldGetDeclaredAnnotations(Field field) {
        ReloadableType rtype = ReflectiveInterceptor.getReloadableTypeIfHasBeenReloaded(field.getDeclaringClass());
        if (rtype == null) {
            return field.getDeclaredAnnotations();
        }
        CurrentLiveVersion clv = rtype.getLiveVersion();
        try {
            Field executor = clv.getExecutorField(field.getName());
            return executor.getAnnotations();
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    public static boolean jlrFieldIsAnnotationPresent(Field field, Class<? extends Annotation> annotType) {
        if (annotType == null) {
            throw new NullPointerException();
        }
        ReloadableType rtype = ReflectiveInterceptor.getReloadableTypeIfHasBeenReloaded(field.getDeclaringClass());
        if (rtype == null) {
            return field.isAnnotationPresent(annotType);
        }
        CurrentLiveVersion clv = rtype.getLiveVersion();
        try {
            Field executor = clv.getExecutorField(field.getName());
            return executor.isAnnotationPresent(annotType);
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    public static Annotation[] jlrFieldGetAnnotations(Field field) {
        return ReflectiveInterceptor.jlrFieldGetDeclaredAnnotations(field);
    }

    public static Annotation[] jlrAccessibleObjectGetAnnotations(AccessibleObject obj) {
        if (obj instanceof Method) {
            return ReflectiveInterceptor.jlrMethodGetAnnotations((Method)obj);
        }
        if (obj instanceof Field) {
            return ReflectiveInterceptor.jlrFieldGetAnnotations((Field)obj);
        }
        if (obj instanceof Constructor) {
            return ReflectiveInterceptor.jlrConstructorGetAnnotations((Constructor)obj);
        }
        return obj.getAnnotations();
    }

    public static Annotation[] jlrConstructorGetAnnotations(Constructor<?> c) {
        return ReflectiveInterceptor.jlrConstructorGetDeclaredAnnotations(c);
    }

    public static Annotation[] jlrConstructorGetDeclaredAnnotations(Constructor<?> c) {
        ReloadableType rtype = ReflectiveInterceptor.getReloadableTypeIfHasBeenReloaded(c.getDeclaringClass());
        if (rtype == null) {
            return c.getDeclaredAnnotations();
        }
        CurrentLiveVersion clv = rtype.getLiveVersion();
        Method executor = clv.getExecutorMethod(rtype.getCurrentConstructor(Type.getConstructorDescriptor(c)));
        return executor.getAnnotations();
    }

    public static Annotation jlrConstructorGetAnnotation(Constructor<?> c, Class<? extends Annotation> annotType) {
        ReloadableType rtype = ReflectiveInterceptor.getReloadableTypeIfHasBeenReloaded(c.getDeclaringClass());
        if (rtype == null) {
            return c.getAnnotation(annotType);
        }
        CurrentLiveVersion clv = rtype.getLiveVersion();
        Method executor = clv.getExecutorMethod(rtype.getCurrentConstructor(Type.getConstructorDescriptor(c)));
        return executor.getAnnotation(annotType);
    }

    public static Annotation[][] jlrConstructorGetParameterAnnotations(Constructor<?> c) {
        ReloadableType rtype = ReflectiveInterceptor.getReloadableTypeIfHasBeenReloaded(c.getDeclaringClass());
        if (rtype == null) {
            return c.getParameterAnnotations();
        }
        CurrentLiveVersion clv = rtype.getLiveVersion();
        MethodMember currentConstructor = rtype.getCurrentConstructor(Type.getConstructorDescriptor(c));
        Method executor = clv.getExecutorMethod(currentConstructor);
        Annotation[][] result = executor.getParameterAnnotations();
        result = (Annotation[][])Utils.arrayCopyOf(result, result.length - 1);
        return result;
    }

    public static boolean jlrConstructorIsAnnotationPresent(Constructor<?> c, Class<? extends Annotation> annotType) {
        ReloadableType rtype = ReflectiveInterceptor.getReloadableTypeIfHasBeenReloaded(c.getDeclaringClass());
        if (rtype == null) {
            return c.isAnnotationPresent(annotType);
        }
        CurrentLiveVersion clv = rtype.getLiveVersion();
        Method executor = clv.getExecutorMethod(rtype.getCurrentConstructor(Type.getConstructorDescriptor(c)));
        return executor.isAnnotationPresent(annotType);
    }

    public static Annotation jlrFieldGetAnnotation(Field field, Class<? extends Annotation> annotType) {
        if (annotType == null) {
            throw new NullPointerException();
        }
        ReloadableType rtype = ReflectiveInterceptor.getReloadableTypeIfHasBeenReloaded(field.getDeclaringClass());
        if (rtype == null) {
            return field.getAnnotation(annotType);
        }
        CurrentLiveVersion clv = rtype.getLiveVersion();
        try {
            Field executor = clv.getExecutorField(field.getName());
            return executor.getAnnotation(annotType);
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    public static Annotation[] jlrMethodGetAnnotations(Method method) {
        return ReflectiveInterceptor.jlrMethodGetDeclaredAnnotations(method);
    }

    public static boolean jlrAnnotatedElementIsAnnotationPresent(AnnotatedElement elem, Class<? extends Annotation> annotType) {
        if (elem instanceof Class) {
            return ReflectiveInterceptor.jlClassIsAnnotationPresent((Class)elem, annotType);
        }
        if (elem instanceof AccessibleObject) {
            return ReflectiveInterceptor.jlrAccessibleObjectIsAnnotationPresent((AccessibleObject)elem, annotType);
        }
        return elem.isAnnotationPresent(annotType);
    }

    public static boolean jlrAccessibleObjectIsAnnotationPresent(AccessibleObject obj, Class<? extends Annotation> annotType) {
        if (obj instanceof Method) {
            return ReflectiveInterceptor.jlrMethodIsAnnotationPresent((Method)obj, annotType);
        }
        if (obj instanceof Field) {
            return ReflectiveInterceptor.jlrFieldIsAnnotationPresent((Field)obj, annotType);
        }
        if (obj instanceof Constructor) {
            return ReflectiveInterceptor.jlrConstructorIsAnnotationPresent((Constructor)obj, annotType);
        }
        return obj.isAnnotationPresent(annotType);
    }

    public static Annotation jlrAnnotatedElementGetAnnotation(AnnotatedElement elem, Class<? extends Annotation> annotType) {
        if (elem instanceof Class) {
            return ReflectiveInterceptor.jlClassGetAnnotation((Class)elem, annotType);
        }
        if (elem instanceof AccessibleObject) {
            return ReflectiveInterceptor.jlrAccessibleObjectGetAnnotation((AccessibleObject)elem, annotType);
        }
        return elem.getAnnotation(annotType);
    }

    public static Annotation jlrAccessibleObjectGetAnnotation(AccessibleObject obj, Class<? extends Annotation> annotType) {
        if (obj instanceof Method) {
            return ReflectiveInterceptor.jlrMethodGetAnnotation((Method)obj, annotType);
        }
        if (obj instanceof Field) {
            return ReflectiveInterceptor.jlrFieldGetAnnotation((Field)obj, annotType);
        }
        if (obj instanceof Constructor) {
            return ReflectiveInterceptor.jlrConstructorGetAnnotation((Constructor)obj, annotType);
        }
        return obj.getAnnotation(annotType);
    }

    public static Field jlClassGetField(Class<?> clazz, String name) throws SecurityException, NoSuchFieldException {
        ReloadableType rtype = ReflectiveInterceptor.getRType(clazz);
        if (name.startsWith("r$")) {
            throw Exceptions.noSuchFieldException(name);
        }
        if (rtype == null) {
            return clazz.getField(name);
        }
        Field f = GetFieldLookup.lookup(rtype, name);
        if (f != null) {
            return f;
        }
        throw Exceptions.noSuchFieldException(name);
    }

    public static Field jlClassGetDeclaredField(Class<?> clazz, String name) throws SecurityException, NoSuchFieldException {
        ReloadableType rtype = ReflectiveInterceptor.getRType(clazz);
        if (rtype == null) {
            return clazz.getDeclaredField(name);
        }
        if (name.startsWith("r$")) {
            throw Exceptions.noSuchFieldException(name);
        }
        if (!rtype.hasBeenReloaded()) {
            Field f = clazz.getDeclaredField(name);
            ReflectiveInterceptor.fixModifier(rtype.getLatestTypeDescriptor(), f);
            return f;
        }
        Field f = GetDeclaredFieldLookup.lookup(rtype, name);
        if (f == null) {
            throw Exceptions.noSuchFieldException(name);
        }
        return f;
    }

    public static Field[] jlClassGetDeclaredFields(Class<?> clazz) {
        Field[] fields = clazz.getDeclaredFields();
        ReloadableType rtype = ReflectiveInterceptor.getRType(clazz);
        if (rtype == null) {
            return fields;
        }
        if (!rtype.hasBeenReloaded()) {
            fields = ReflectiveInterceptor.removeMetaFields(fields);
            ReflectiveInterceptor.fixModifiers(rtype, fields);
            return fields;
        }
        TypeDescriptor typeDesc = rtype.getLatestTypeDescriptor();
        FieldMember[] members = typeDesc.getFields();
        fields = new Field[members.length];
        int i = 0;
        for (FieldMember f : members) {
            Class<?> type;
            String fieldTypeDescriptor = f.getDescriptor();
            try {
                type = Utils.toClass(Type.getType(fieldTypeDescriptor), rtype.typeRegistry.getClassLoader());
            }
            catch (ClassNotFoundException e) {
                throw new IllegalStateException(e);
            }
            fields[i++] = JVM.newField(clazz, type, f.getModifiers(), f.getName(), f.getGenericSignature());
        }
        if (GlobalConfiguration.assertsMode) {
            Utils.assertTrue(i == fields.length, "Bug: unexpected number of fields");
        }
        return fields;
    }

    private static Field[] removeMetaFields(Field[] fields) {
        Field[] realFields = new Field[fields.length - 1];
        int i = 0;
        for (Field field : fields) {
            if (field.getName().startsWith("r$")) continue;
            realFields[i++] = field;
        }
        if (i < realFields.length) {
            realFields = Utils.arrayCopyOf(realFields, i);
        }
        if (GlobalConfiguration.assertsMode) {
            Utils.assertTrue(i == realFields.length, "Bug in removeMetaFields, created array of wrong length");
        }
        return realFields;
    }

    public static Field[] jlClassGetFields(Class<?> clazz) {
        ReloadableType rtype = ReflectiveInterceptor.getRType(clazz);
        if (rtype == null) {
            return clazz.getFields();
        }
        ArrayList<Field> allFields = new ArrayList<Field>();
        ReflectiveInterceptor.gatherFields(clazz, allFields, new HashSet());
        return allFields.toArray(new Field[allFields.size()]);
    }

    private static void gatherFields(Class<?> clazz, List<Field> collected, HashSet<Class<?>> visited) {
        Class<?> supr;
        if (visited.contains(clazz)) {
            return;
        }
        visited.add(clazz);
        Field[] fields = ReflectiveInterceptor.jlClassGetDeclaredFields(clazz);
        for (Field field : fields) {
            if (!Modifier.isPublic(field.getModifiers())) continue;
            collected.add(field);
        }
        if (!clazz.isInterface() && (supr = clazz.getSuperclass()) != null) {
            ReflectiveInterceptor.gatherFields(supr, collected, visited);
        }
        for (AnnotatedElement annotatedElement : clazz.getInterfaces()) {
            ReflectiveInterceptor.gatherFields(annotatedElement, collected, visited);
        }
    }

    public static Object jlrFieldGet(Field field, Object target) throws IllegalArgumentException, IllegalAccessException {
        Class<?> clazz = field.getDeclaringClass();
        ReloadableType rtype = ReflectiveInterceptor.getRType(clazz);
        if (rtype == null) {
            field = ReflectiveInterceptor.asAccessibleField(field, target, true);
            return field.get(target);
        }
        ReflectiveInterceptor.asAccessibleField(field, target, false);
        return rtype.getField(target, field.getName(), Modifier.isStatic(field.getModifiers()));
    }

    public static int jlrFieldGetInt(Field field, Object target) throws IllegalAccessException {
        Class<?> clazz = field.getDeclaringClass();
        ReloadableType rtype = ReflectiveInterceptor.getRType(clazz);
        if (rtype == null) {
            field = ReflectiveInterceptor.asAccessibleField(field, target, true);
            return field.getInt(target);
        }
        ReflectiveInterceptor.asAccessibleField(field, target, false);
        ReflectiveInterceptor.typeCheckFieldGet(field, Integer.TYPE);
        Object value = rtype.getField(target, field.getName(), Modifier.isStatic(field.getModifiers()));
        if (value instanceof Character) {
            return ((Character)value).charValue();
        }
        return ((Number)value).intValue();
    }

    public static byte jlrFieldGetByte(Field field, Object target) throws IllegalAccessException {
        Class<?> clazz = field.getDeclaringClass();
        ReloadableType rtype = ReflectiveInterceptor.getRType(clazz);
        if (rtype == null) {
            field = ReflectiveInterceptor.asAccessibleField(field, target, true);
            return field.getByte(target);
        }
        ReflectiveInterceptor.asAccessibleField(field, target, false);
        ReflectiveInterceptor.typeCheckFieldGet(field, Byte.TYPE);
        Object value = rtype.getField(target, field.getName(), Modifier.isStatic(field.getModifiers()));
        return ((Number)value).byteValue();
    }

    public static char jlrFieldGetChar(Field field, Object target) throws IllegalAccessException {
        Class<?> clazz = field.getDeclaringClass();
        ReloadableType rtype = ReflectiveInterceptor.getRType(clazz);
        if (rtype == null) {
            field = ReflectiveInterceptor.asAccessibleField(field, target, true);
            return field.getChar(target);
        }
        ReflectiveInterceptor.asAccessibleField(field, target, false);
        ReflectiveInterceptor.typeCheckFieldGet(field, Character.TYPE);
        Object value = rtype.getField(target, field.getName(), Modifier.isStatic(field.getModifiers()));
        return ((Character)value).charValue();
    }

    public static short jlrFieldGetShort(Field field, Object target) throws IllegalAccessException {
        Class<?> clazz = field.getDeclaringClass();
        ReloadableType rtype = ReflectiveInterceptor.getRType(clazz);
        if (rtype == null) {
            field = ReflectiveInterceptor.asAccessibleField(field, target, true);
            return field.getShort(target);
        }
        ReflectiveInterceptor.asAccessibleField(field, target, false);
        ReflectiveInterceptor.typeCheckFieldGet(field, Short.TYPE);
        Object value = rtype.getField(target, field.getName(), Modifier.isStatic(field.getModifiers()));
        if (value instanceof Character) {
            return (short)((Character)value).charValue();
        }
        return ((Number)value).shortValue();
    }

    public static double jlrFieldGetDouble(Field field, Object target) throws IllegalAccessException {
        Class<?> clazz = field.getDeclaringClass();
        ReloadableType rtype = ReflectiveInterceptor.getRType(clazz);
        if (rtype == null) {
            field = ReflectiveInterceptor.asAccessibleField(field, target, true);
            return field.getDouble(target);
        }
        ReflectiveInterceptor.asAccessibleField(field, target, false);
        ReflectiveInterceptor.typeCheckFieldGet(field, Double.TYPE);
        Object value = rtype.getField(target, field.getName(), Modifier.isStatic(field.getModifiers()));
        if (value instanceof Character) {
            return ((Character)value).charValue();
        }
        return ((Number)value).doubleValue();
    }

    public static float jlrFieldGetFloat(Field field, Object target) throws IllegalAccessException {
        Class<?> clazz = field.getDeclaringClass();
        ReloadableType rtype = ReflectiveInterceptor.getRType(clazz);
        if (rtype == null) {
            field = ReflectiveInterceptor.asAccessibleField(field, target, true);
            return field.getFloat(target);
        }
        ReflectiveInterceptor.asAccessibleField(field, target, false);
        ReflectiveInterceptor.typeCheckFieldGet(field, Float.TYPE);
        Object value = rtype.getField(target, field.getName(), Modifier.isStatic(field.getModifiers()));
        if (value instanceof Character) {
            return ((Character)value).charValue();
        }
        return ((Number)value).floatValue();
    }

    public static boolean jlrFieldGetBoolean(Field field, Object target) throws IllegalAccessException {
        Class<?> clazz = field.getDeclaringClass();
        ReloadableType rtype = ReflectiveInterceptor.getRType(clazz);
        if (rtype == null) {
            field = ReflectiveInterceptor.asAccessibleField(field, target, true);
            return field.getBoolean(target);
        }
        ReflectiveInterceptor.asAccessibleField(field, target, false);
        ReflectiveInterceptor.typeCheckFieldGet(field, Boolean.TYPE);
        Object value = rtype.getField(target, field.getName(), Modifier.isStatic(field.getModifiers()));
        return (Boolean)value;
    }

    public static long jlrFieldGetLong(Field field, Object target) throws IllegalAccessException {
        Class<?> clazz = field.getDeclaringClass();
        ReloadableType rtype = ReflectiveInterceptor.getRType(clazz);
        if (rtype == null) {
            field = ReflectiveInterceptor.asAccessibleField(field, target, true);
            return field.getLong(target);
        }
        ReflectiveInterceptor.asAccessibleField(field, target, false);
        ReflectiveInterceptor.typeCheckFieldGet(field, Long.TYPE);
        Object value = rtype.getField(target, field.getName(), Modifier.isStatic(field.getModifiers()));
        if (value instanceof Character) {
            return ((Character)value).charValue();
        }
        return ((Number)value).longValue();
    }

    private static void typeCheckFieldGet(Field field, Class<?> returnType) {
        Class<?> fieldType = field.getType();
        if (!Utils.isConvertableFrom(returnType, fieldType)) {
            throw Exceptions.illegalGetFieldType(field, returnType);
        }
    }

    public static void jlrFieldSet(Field field, Object target, Object value) throws IllegalAccessException {
        Class<?> clazz = field.getDeclaringClass();
        ReloadableType rtype = ReflectiveInterceptor.getRType(clazz);
        if (rtype == null) {
            field = ReflectiveInterceptor.asSetableField(field, target, ReflectiveInterceptor.valueType(value), value, true);
            field.set(target, value);
        } else {
            ReflectiveInterceptor.asSetableField(field, target, ReflectiveInterceptor.valueType(value), value, false);
            rtype.setField(target, field.getName(), Modifier.isStatic(field.getModifiers()), value);
        }
    }

    public static void jlrFieldSetInt(Field field, Object target, int value) throws IllegalAccessException {
        Class<?> clazz = field.getDeclaringClass();
        ReloadableType rtype = ReflectiveInterceptor.getRType(clazz);
        if (rtype == null) {
            field = ReflectiveInterceptor.asSetableField(field, target, Integer.TYPE, value, true);
            field.setInt(target, value);
        } else {
            ReflectiveInterceptor.asSetableField(field, target, Integer.TYPE, value, false);
            rtype.setField(target, field.getName(), Modifier.isStatic(field.getModifiers()), value);
        }
    }

    public static void jlrFieldSetByte(Field field, Object target, byte value) throws IllegalAccessException {
        Class<?> clazz = field.getDeclaringClass();
        ReloadableType rtype = ReflectiveInterceptor.getRType(clazz);
        if (rtype == null) {
            field = ReflectiveInterceptor.asSetableField(field, target, Byte.TYPE, value, true);
            field.setByte(target, value);
        } else {
            ReflectiveInterceptor.asSetableField(field, target, Byte.TYPE, value, false);
            rtype.setField(target, field.getName(), Modifier.isStatic(field.getModifiers()), value);
        }
    }

    public static void jlrFieldSetChar(Field field, Object target, char value) throws IllegalAccessException {
        Class<?> clazz = field.getDeclaringClass();
        ReloadableType rtype = ReflectiveInterceptor.getRType(clazz);
        if (rtype == null) {
            field = ReflectiveInterceptor.asSetableField(field, target, Character.TYPE, Character.valueOf(value), true);
            field.setChar(target, value);
        } else {
            ReflectiveInterceptor.asSetableField(field, target, Character.TYPE, Character.valueOf(value), false);
            rtype.setField(target, field.getName(), Modifier.isStatic(field.getModifiers()), Character.valueOf(value));
        }
    }

    public static void jlrFieldSetShort(Field field, Object target, short value) throws IllegalAccessException {
        Class<?> clazz = field.getDeclaringClass();
        ReloadableType rtype = ReflectiveInterceptor.getRType(clazz);
        if (rtype == null) {
            field = ReflectiveInterceptor.asSetableField(field, target, Short.TYPE, value, true);
            field.setShort(target, value);
        } else {
            ReflectiveInterceptor.asSetableField(field, target, Short.TYPE, value, false);
            rtype.setField(target, field.getName(), Modifier.isStatic(field.getModifiers()), value);
        }
    }

    public static void jlrFieldSetDouble(Field field, Object target, double value) throws IllegalAccessException {
        Class<?> clazz = field.getDeclaringClass();
        ReloadableType rtype = ReflectiveInterceptor.getRType(clazz);
        if (rtype == null) {
            field = ReflectiveInterceptor.asSetableField(field, target, Double.TYPE, value, true);
            field.setDouble(target, value);
        } else {
            ReflectiveInterceptor.asSetableField(field, target, Double.TYPE, value, false);
            rtype.setField(target, field.getName(), Modifier.isStatic(field.getModifiers()), value);
        }
    }

    public static void jlrFieldSetFloat(Field field, Object target, float value) throws IllegalAccessException {
        Class<?> clazz = field.getDeclaringClass();
        ReloadableType rtype = ReflectiveInterceptor.getRType(clazz);
        if (rtype == null) {
            field = ReflectiveInterceptor.asSetableField(field, target, Float.TYPE, Float.valueOf(value), true);
            field.setFloat(target, value);
        } else {
            ReflectiveInterceptor.asSetableField(field, target, Float.TYPE, Float.valueOf(value), false);
            rtype.setField(target, field.getName(), Modifier.isStatic(field.getModifiers()), Float.valueOf(value));
        }
    }

    public static void jlrFieldSetLong(Field field, Object target, long value) throws IllegalAccessException {
        Class<?> clazz = field.getDeclaringClass();
        ReloadableType rtype = ReflectiveInterceptor.getRType(clazz);
        if (rtype == null) {
            field = ReflectiveInterceptor.asSetableField(field, target, Long.TYPE, value, true);
            field.setLong(target, value);
        } else {
            ReflectiveInterceptor.asSetableField(field, target, Long.TYPE, value, false);
            rtype.setField(target, field.getName(), Modifier.isStatic(field.getModifiers()), value);
        }
    }

    public static void jlrFieldSetBoolean(Field field, Object target, boolean value) throws IllegalAccessException {
        Class<?> clazz = field.getDeclaringClass();
        ReloadableType rtype = ReflectiveInterceptor.getRType(clazz);
        if (rtype == null) {
            field = ReflectiveInterceptor.asSetableField(field, target, Boolean.TYPE, value, true);
            field.setBoolean(target, value);
        } else {
            ReflectiveInterceptor.asSetableField(field, target, Boolean.TYPE, value, false);
            rtype.setField(target, field.getName(), Modifier.isStatic(field.getModifiers()), value);
        }
    }

    private static Class<?> boxTypeFor(Class<?> primType) {
        if (primType == Integer.TYPE) {
            return Integer.class;
        }
        if (primType == Boolean.TYPE) {
            return Boolean.class;
        }
        if (primType == Byte.TYPE) {
            return Byte.class;
        }
        if (primType == Character.TYPE) {
            return Character.class;
        }
        if (primType == Double.TYPE) {
            return Double.class;
        }
        if (primType == Float.TYPE) {
            return Float.class;
        }
        if (primType == Long.TYPE) {
            return Long.class;
        }
        if (primType == Short.TYPE) {
            return Short.class;
        }
        throw new IllegalStateException("Forgotten a case in this method?");
    }

    static {
        boolean synchronize = false;
        try {
            String prop = System.getProperty("springloaded.synchronize", "false");
            if (prop.equalsIgnoreCase("true")) {
                synchronize = true;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        classToRType = synchronize ? Collections.synchronizedMap(new WeakHashMap()) : new WeakHashMap();
        depth = 4;
    }
}

