/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.serial;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import org.switchyard.common.io.Buffers;
import org.switchyard.serial.CompressionType;
import org.switchyard.serial.FormatType;
import org.switchyard.serial.Serializer;

public abstract class BaseSerializer
implements Serializer {
    private final FormatType _format;
    private final CompressionType _compression;
    private int _bufferSize = Buffers.DEFAULT_SIZE;
    private boolean _closeEnabled = false;
    private boolean _prettyPrint = false;

    public BaseSerializer(FormatType formatType) {
        this(formatType, null);
    }

    public BaseSerializer(FormatType format, CompressionType compression) {
        this._format = format;
        this._compression = compression;
    }

    @Override
    public <T> byte[] serialize(T obj, Class<T> type) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream(this.getBufferSize());
        int count = this.serialize(obj, type, out);
        byte[] bytes = out.toByteArray();
        assert (count == bytes.length);
        return bytes;
    }

    @Override
    public <T> T deserialize(byte[] bytes, Class<T> type) throws IOException {
        return this.deserialize(new ByteArrayInputStream(bytes), type);
    }

    @Override
    public FormatType getFormat() {
        return this._format;
    }

    @Override
    public CompressionType getCompression() {
        return this._compression;
    }

    @Override
    public int getBufferSize() {
        return this._bufferSize;
    }

    @Override
    public Serializer setBufferSize(int bufferSize) {
        this._bufferSize = bufferSize;
        return this;
    }

    @Override
    public boolean isCloseEnabled() {
        return this._closeEnabled;
    }

    @Override
    public Serializer setCloseEnabled(boolean closeEnabled) {
        this._closeEnabled = closeEnabled;
        return this;
    }

    @Override
    public boolean isPrettyPrint() {
        return this._prettyPrint;
    }

    @Override
    public Serializer setPrettyPrint(boolean prettyPrint) {
        this._prettyPrint = prettyPrint;
        return this;
    }
}

