/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.test;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import javax.xml.namespace.QName;
import org.junit.Assert;
import org.switchyard.Exchange;
import org.switchyard.ExchangeHandler;
import org.switchyard.ExchangePattern;
import org.switchyard.HandlerException;
import org.switchyard.Message;
import org.switchyard.ServiceDomain;
import org.switchyard.ServiceReference;
import org.switchyard.common.xml.XMLHelper;
import org.switchyard.metadata.BaseService;
import org.switchyard.metadata.InOnlyOperation;
import org.switchyard.metadata.InOutOperation;
import org.switchyard.metadata.ServiceInterface;
import org.switchyard.metadata.ServiceOperation;
import org.switchyard.test.InvocationFaultException;

public class Invoker {
    private ServiceDomain _domain;
    private QName _serviceName;
    private String _operationName;
    private ServiceOperation _serviceOperation;
    private ExchangeHandlerProxy _exchangeHandlerProxy;
    private long _timeoutMillis = 10000L;
    private QName _inputType;
    private QName _expectedOutputType;
    private QName _expectedFaultType;

    protected Invoker(ServiceDomain domain, String serviceName) {
        this(domain, XMLHelper.createQName((String)domain.getName().getNamespaceURI(), (String)serviceName));
    }

    public Invoker(ServiceDomain domain, QName serviceName) {
        this._domain = domain;
        String[] serviceNameTokens = serviceName.getLocalPart().split("\\.");
        if (serviceNameTokens.length == 1) {
            this._serviceName = serviceName;
        } else if (serviceNameTokens.length == 2) {
            this._serviceName = XMLHelper.createQName((String)serviceName.getNamespaceURI(), (String)serviceNameTokens[0]);
            this._operationName = serviceNameTokens[1];
        }
    }

    public QName getServiceName() {
        return this._serviceName;
    }

    public String getOperationName() {
        return this._operationName;
    }

    public Invoker operation(String operationName) {
        this._operationName = operationName;
        return this;
    }

    public Invoker operation(ServiceOperation serviceOperation) {
        this._serviceOperation = serviceOperation;
        return this;
    }

    public Invoker responseHandler(ExchangeHandler handler) {
        if (handler != null) {
            this._exchangeHandlerProxy = this.createHandlerProxy(handler);
        }
        return this;
    }

    public Invoker timeout(long timeoutMillis) {
        this._timeoutMillis = timeoutMillis;
        return this;
    }

    public Invoker inputType(QName inputType) {
        this._inputType = inputType;
        return this;
    }

    public Invoker expectedOutputType(QName expectedOutputType) {
        this._expectedOutputType = expectedOutputType;
        return this;
    }

    public Invoker expectedFaultType(QName expectedFaultType) {
        this._expectedFaultType = expectedFaultType;
        return this;
    }

    public void sendInOnly(Object messagePayload) {
        ExchangeHandlerProxy exchangeHandlerProxy = this._exchangeHandlerProxy;
        ResponseCatcher responseCatcher = null;
        if (exchangeHandlerProxy == null) {
            responseCatcher = new ResponseCatcher();
            exchangeHandlerProxy = this.createHandlerProxy(responseCatcher);
        }
        Exchange exchange = this.createExchange(ExchangePattern.IN_ONLY, exchangeHandlerProxy._exchangeHandlerProxy);
        Message message = exchange.createMessage().setContent(messagePayload);
        exchange.send(message);
    }

    public Message sendInOut(Object messagePayload) throws InvocationFaultException {
        ExchangeHandlerProxy exchangeHandlerProxy = this._exchangeHandlerProxy;
        ResponseCatcher responseCatcher = null;
        if (exchangeHandlerProxy == null) {
            responseCatcher = new ResponseCatcher();
            exchangeHandlerProxy = this.createHandlerProxy(responseCatcher);
        }
        Exchange exchange = this.createExchange(ExchangePattern.IN_OUT, exchangeHandlerProxy._exchangeHandlerProxy);
        Message message = exchange.createMessage().setContent(messagePayload);
        exchange.send(message);
        exchangeHandlerProxy._proxyInvocationHandler.waitForResponse(this._timeoutMillis);
        if (responseCatcher != null) {
            if (responseCatcher._isFault) {
                throw new InvocationFaultException(responseCatcher._response);
            }
            return responseCatcher._response;
        }
        return null;
    }

    public Exchange createExchange(ExchangeHandler handler) {
        return this.createExchange(null, handler);
    }

    private Exchange createExchange(ExchangePattern pattern, ExchangeHandler handler) {
        Object operation = this._serviceOperation;
        if (operation == null) {
            operation = ExchangePattern.IN_ONLY.equals((Object)pattern) ? new InOnlyOperation(this._operationName, this._inputType) : new InOutOperation(this._operationName, this._inputType, this._expectedOutputType, this._expectedFaultType);
        }
        ServiceReference reference = this._domain.registerServiceReference(this._serviceName, (ServiceInterface)new BaseService(operation), handler);
        return this._operationName == null ? reference.createExchange() : reference.createExchange(this._operationName);
    }

    private ExchangeHandlerProxy createHandlerProxy(ExchangeHandler handler) {
        ProxyInvocationHandler proxyInvocationHandler = new ProxyInvocationHandler(handler);
        ExchangeHandler exchangeHandlerProxy = (ExchangeHandler)Proxy.newProxyInstance(ExchangeHandler.class.getClassLoader(), new Class[]{ExchangeHandler.class}, (InvocationHandler)proxyInvocationHandler);
        return new ExchangeHandlerProxy(proxyInvocationHandler, exchangeHandlerProxy);
    }

    private static final class ResponseCatcher
    implements ExchangeHandler {
        private Message _response;
        private boolean _isFault;

        private ResponseCatcher() {
        }

        public void handleMessage(Exchange exchange) throws HandlerException {
            this._response = exchange.getMessage();
        }

        public void handleFault(Exchange exchange) {
            this._isFault = true;
            this._response = exchange.getMessage();
        }
    }

    private static final class ProxyInvocationHandler
    implements InvocationHandler {
        private ExchangeHandler _handler;
        private boolean _responseReceived;

        public ProxyInvocationHandler(ExchangeHandler handler) {
            this._handler = handler;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            try {
                Object object = method.invoke((Object)this._handler, args);
                return object;
            }
            finally {
                if (method.getName().equals("handleMessage") || method.getName().equals("handleFault")) {
                    this._responseReceived = true;
                }
            }
        }

        private void waitForResponse(long timeout) {
            long startTime = System.currentTimeMillis();
            while (!this._responseReceived) {
                if (System.currentTimeMillis() > startTime + timeout) {
                    Assert.fail((String)"Timed out waiting on response.");
                    break;
                }
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException e) {
                    Assert.fail((String)("Unexpected InterruptedException: " + e.getMessage()));
                }
            }
        }
    }

    private static final class ExchangeHandlerProxy {
        private ProxyInvocationHandler _proxyInvocationHandler;
        private ExchangeHandler _exchangeHandlerProxy;

        private ExchangeHandlerProxy(ProxyInvocationHandler proxyInvocationHandler, ExchangeHandler exchangeHandlerProxy) {
            this._proxyInvocationHandler = proxyInvocationHandler;
            this._exchangeHandlerProxy = exchangeHandlerProxy;
        }
    }
}

