/*
 * Decompiled with CFR 0.152.
 */
package org.tio.http.server;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tio.core.Aio;
import org.tio.core.ChannelContext;
import org.tio.core.intf.Packet;
import org.tio.core.ssl.SslFacadeContext;
import org.tio.http.common.HttpConst;
import org.tio.http.common.HttpRequest;
import org.tio.http.common.HttpResponse;
import org.tio.server.intf.ServerAioListener;

public class HttpServerAioListener
implements ServerAioListener {
    private static Logger iplog = LoggerFactory.getLogger((String)"tio-ip-trace-log");
    static Map<String, AtomicLong> ipmap = new ConcurrentHashMap<String, AtomicLong>();
    static AtomicLong accessCount = new AtomicLong();

    public static void main(String[] args) {
    }

    public void onAfterClose(ChannelContext channelContext, Throwable throwable, String remark, boolean isRemove) {
    }

    public void onAfterConnected(ChannelContext channelContext, boolean isConnected, boolean isReconnect) {
        if (isConnected) {
            String ip = channelContext.getClientNode().getIp();
            AtomicLong ipcount = ipmap.get(ip);
            if (ipcount == null) {
                ipcount = new AtomicLong();
                ipmap.put(ip, ipcount);
            }
            ipcount.incrementAndGet();
            String accessCountStr = StringUtils.rightPad((String)(accessCount.incrementAndGet() + ""), (int)9);
            String ipCountStr = StringUtils.rightPad((String)(ipmap.size() + ""), (int)9);
            String ipStr = StringUtils.leftPad((String)ip, (int)15);
            iplog.info("\u603b\u8bbf\u95ee\u6b21\u6570:{}, \u5171\u6709{}\u4e2a\u4e0d\u540cip\u8bbf\u95ee, [{}]\u7684\u8bbf\u95ee\u6b21\u6570{}, ", new Object[]{accessCountStr, ipCountStr, ipStr, ipcount});
        }
    }

    public void onAfterReceived(ChannelContext channelContext, Packet packet, int packetSize) {
    }

    public void onAfterSent(ChannelContext channelContext, Packet packet, boolean isSentSuccess) {
        HttpResponse httpResponse;
        String Connection2;
        SslFacadeContext sslFacadeContext = channelContext.getSslFacadeContext();
        if ((sslFacadeContext == null || sslFacadeContext.isHandshakeCompleted()) && packet instanceof HttpResponse && StringUtils.equalsIgnoreCase((CharSequence)(Connection2 = (httpResponse = (HttpResponse)packet).getHeader(HttpConst.ResponseHeaderKey.Connection)), (CharSequence)HttpConst.ResponseHeaderValue.Connection.close)) {
            HttpRequest request = httpResponse.getHttpRequest();
            String line = request.getRequestLine().getLine();
            Aio.remove((ChannelContext)channelContext, (String)("onAfterSent, " + line));
        }
    }

    public void onBeforeClose(ChannelContext channelContext, Throwable throwable, String remark, boolean isRemove) {
    }
}

