/*
 * Decompiled with CFR 0.152.
 */
package org.tio.http.server.handler;

import com.xiaoleilu.hutool.bean.BeanUtil;
import com.xiaoleilu.hutool.convert.Convert;
import com.xiaoleilu.hutool.util.ArrayUtil;
import com.xiaoleilu.hutool.util.ClassUtil;
import com.xiaoleilu.hutool.util.ZipUtil;
import freemarker.cache.FileTemplateLoader;
import freemarker.template.Configuration;
import java.io.File;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import jodd.io.FileNameUtil;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tio.core.Aio;
import org.tio.core.ChannelContext;
import org.tio.http.common.Cookie;
import org.tio.http.common.HttpConfig;
import org.tio.http.common.HttpConst;
import org.tio.http.common.HttpRequest;
import org.tio.http.common.HttpResponse;
import org.tio.http.common.HttpResponseStatus;
import org.tio.http.common.RequestLine;
import org.tio.http.common.handler.HttpRequestHandler;
import org.tio.http.common.session.HttpSession;
import org.tio.http.common.utils.IpUtils;
import org.tio.http.server.handler.FileCache;
import org.tio.http.server.intf.HttpServerInterceptor;
import org.tio.http.server.intf.HttpSessionListener;
import org.tio.http.server.intf.ThrowableHandler;
import org.tio.http.server.mvc.Routes;
import org.tio.http.server.session.SessionCookieDecorator;
import org.tio.http.server.stat.ip.path.IpPathAccessStats;
import org.tio.http.server.util.ClassUtils;
import org.tio.http.server.util.Resps;
import org.tio.http.server.view.freemarker.FreemarkerConfig;
import org.tio.utils.SystemTimer;
import org.tio.utils.cache.guava.GuavaCache;
import org.tio.utils.freemarker.FreemarkerUtils;

public class DefaultHttpRequestHandler
implements HttpRequestHandler {
    private static Logger log = LoggerFactory.getLogger(DefaultHttpRequestHandler.class);
    private static final String STATIC_RES_CONTENT_CACHENAME = "TIO_HTTP_STATIC_RES_CONTENT";
    protected HttpConfig httpConfig;
    protected Routes routes = null;
    private HttpServerInterceptor httpServerInterceptor;
    private HttpSessionListener httpSessionListener;
    private ThrowableHandler throwableHandler;
    private SessionCookieDecorator sessionCookieDecorator;
    private IpPathAccessStats ipPathAccessStats;
    private GuavaCache staticResCache;
    private String contextPath;
    private int contextPathLength = 0;
    private String suffix;
    private int suffixLength = 0;
    private FreemarkerConfig freemarkerConfig;

    public static void main(String[] args) {
    }

    public DefaultHttpRequestHandler(HttpConfig httpConfig, Routes routes) {
        if (httpConfig == null) {
            throw new RuntimeException("httpConfig can not be null");
        }
        this.contextPath = httpConfig.getContextPath();
        this.suffix = httpConfig.getSuffix();
        if (StringUtils.isNotBlank((CharSequence)this.contextPath)) {
            this.contextPathLength = this.contextPath.length();
        }
        if (StringUtils.isNotBlank((CharSequence)this.suffix)) {
            this.suffixLength = this.suffix.length();
        }
        this.httpConfig = httpConfig;
        if (httpConfig.getMaxLiveTimeOfStaticRes() > 0) {
            this.staticResCache = GuavaCache.register((String)STATIC_RES_CONTENT_CACHENAME, (Long)Long.valueOf(httpConfig.getMaxLiveTimeOfStaticRes()), null);
        }
        this.routes = routes;
    }

    private HttpSession createSession(HttpRequest request) {
        String sessionId = this.httpConfig.getSessionIdGenerator().sessionId(this.httpConfig, request);
        HttpSession httpSession = new HttpSession(sessionId);
        if (this.httpSessionListener != null) {
            this.httpSessionListener.doAfterCreated(request, httpSession, this.httpConfig);
        }
        return httpSession;
    }

    public HttpConfig getHttpConfig() {
        return this.httpConfig;
    }

    public HttpServerInterceptor getHttpServerInterceptor() {
        return this.httpServerInterceptor;
    }

    public static Cookie getSessionCookie(HttpRequest request, HttpConfig httpConfig) {
        Cookie sessionCookie = request.getCookie(httpConfig.getSessionCookieName());
        return sessionCookie;
    }

    public GuavaCache getStaticResCache() {
        return this.staticResCache;
    }

    private boolean checkDomain(HttpRequest request) {
        Object[] allowDomains = this.httpConfig.getAllowDomains();
        if (allowDomains == null || allowDomains.length == 0) {
            return true;
        }
        String host = request.getHost();
        return ArrayUtil.contains((Object[])allowDomains, (Object)host);
    }

    private static void gzip(HttpRequest request, HttpResponse response) {
        if (response == null) {
            return;
        }
        if (request.getIsSupportGzip().booleanValue()) {
            byte[] bs2;
            byte[] bs = response.getBody();
            if (bs != null && bs.length >= 600 && (bs2 = ZipUtil.gzip((byte[])bs)).length < bs.length) {
                response.setBody(bs2, request);
                response.addHeader(HttpConst.ResponseHeaderKey.Content_Encoding, "gzip");
            }
        } else {
            log.info("{} \u7adf\u7136\u4e0d\u652f\u6301gzip, {}", (Object)request.getChannelContext(), (Object)request.getHeader(HttpConst.RequestHeaderKey.User_Agent));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public HttpResponse handler(HttpRequest request) throws Exception {
        if (!this.checkDomain(request)) {
            Aio.remove((ChannelContext)request.getChannelContext(), (String)("\u8fc7\u6765\u7684\u57df\u540d[" + request.getDomain() + "]\u4e0d\u5bf9"));
            return null;
        }
        ret = null;
        requestLine = request.getRequestLine();
        path = requestLine.getPath();
        if (StringUtils.isNotBlank((CharSequence)this.contextPath) && StringUtils.startsWith((CharSequence)path, (CharSequence)this.contextPath)) {
            path = StringUtils.substring((String)path, (int)this.contextPathLength);
        }
        if (StringUtils.isNotBlank((CharSequence)this.suffix) && StringUtils.endsWith((CharSequence)path, (CharSequence)this.suffix)) {
            path = StringUtils.substring((String)path, (int)0, (int)(path.length() - this.suffixLength));
        }
        requestLine.setPath(path);
        if (this.ipPathAccessStats != null) {
            ip = IpUtils.getRealIp((HttpRequest)request);
            list = this.ipPathAccessStats.durationList;
            cookie = DefaultHttpRequestHandler.getSessionCookie(request, this.httpConfig);
            for (Long duration : list) {
                ipAccessStat = this.ipPathAccessStats.get(duration, ip);
                ipAccessStat.count.incrementAndGet();
                ipAccessStat.setLastAccessTime(SystemTimer.currentTimeMillis());
                ipPathAccessStat = ipAccessStat.get(path);
                ipPathAccessStat.count.incrementAndGet();
                ipPathAccessStat.setLastAccessTime(SystemTimer.currentTimeMillis());
                if (cookie == null) {
                    ipAccessStat.noSessionCount.incrementAndGet();
                    ipPathAccessStat.noSessionCount.incrementAndGet();
                } else {
                    ipAccessStat.sessionIds.add((Object)cookie.getValue());
                }
                if ((ipPathAccessStatListener = this.ipPathAccessStats.getListener(duration)) == null || (isContinue = ipPathAccessStatListener.onChanged(request, ip, path, ipAccessStat, ipPathAccessStat))) continue;
                return null;
            }
        }
        this.processCookieBeforeHandler(request, requestLine);
        httpSession = request.getHttpSession();
        if (this.httpServerInterceptor == null || (ret = this.httpServerInterceptor.doBeforeHandler(request, requestLine, ret)) == null) ** GOTO lbl-1000
        list = ret;
        if (ret == null) return list;
        ** GOTO lbl62
        {
            catch (Throwable e) {
                try {
                    this.logError(request, requestLine, e);
                    var6_7 = ret = this.resp500(request, requestLine, e);
                    if (ret == null) return var6_7;
                    ** GOTO lbl305
                }
                catch (Throwable var37_62) {
                    if (ret == null) throw var37_62;
                    try {
                        this.processCookieAfterHandler(request, requestLine, ret);
                        if (this.httpServerInterceptor != null) {
                            this.httpServerInterceptor.doAfterHandler(request, requestLine, ret);
                        }
                        ** GOTO lbl316
                    }
                    catch (Throwable e) {
                        block100: {
                            try {
                                this.logError(request, requestLine, e);
                            }
                            catch (Throwable var39_64) {
                                DefaultHttpRequestHandler.gzip(request, ret);
                                throw var39_64;
                            }
lbl62:
                            // 1 sources

                            try {
                                this.processCookieAfterHandler(request, requestLine, ret);
                                if (this.httpServerInterceptor == null) return list;
                                this.httpServerInterceptor.doAfterHandler(request, requestLine, ret);
                                return list;
                            }
                            catch (Throwable e) {
                                this.logError(request, requestLine, e);
                                return list;
                            }
                            finally {
                                DefaultHttpRequestHandler.gzip(request, ret);
                            }
lbl-1000:
                            // 1 sources

                            {
                                requestLine = request.getRequestLine();
                                path = requestLine.getPath();
                                method = null;
                                if (this.routes != null) {
                                    method = this.routes.pathMethodMap.get(path);
                                }
                                if (method == null) ** GOTO lbl-1000
                                paramnames = this.routes.methodParamnameMap.get(method);
                                parameterTypes = method.getParameterTypes();
                                bean = this.routes.methodBeanMap.get(method);
                                obj = null;
                                params = request.getParams();
                                if (parameterTypes == null || parameterTypes.length == 0) {
                                    obj = method.invoke(bean, new Object[0]);
                                } else {
                                    paramValues = new Object[parameterTypes.length];
                                    i = 0;
                                    for (Class<Object> var17_37 : parameterTypes) {
                                        try {
                                            if (var17_37.isAssignableFrom(HttpRequest.class)) {
                                                paramValues[i] = request;
                                                continue;
                                            }
                                            if (var17_37 == HttpSession.class) {
                                                paramValues[i] = httpSession;
                                                continue;
                                            }
                                            if (var17_37.isAssignableFrom(HttpConfig.class)) {
                                                paramValues[i] = this.httpConfig;
                                                continue;
                                            }
                                            if (var17_37.isAssignableFrom(ChannelContext.class)) {
                                                paramValues[i] = request.getChannelContext();
                                                continue;
                                            }
                                            if (params == null) continue;
                                            if (ClassUtils.isSimpleTypeOrArray(var17_37)) {
                                                value = (Object[])params.get(paramnames[i]);
                                                if (value == null || value.length <= 0) continue;
                                                if (var17_37.isArray()) {
                                                    paramValues[i] = Convert.convert(var17_37, (Object)value);
                                                    continue;
                                                }
                                                paramValues[i] = Convert.convert(var17_37, (Object)value[0]);
                                                continue;
                                            }
                                            paramValues[i] = var17_37.newInstance();
                                            set = params.entrySet();
                                            for (Map.Entry<K, V> entry : set) {
                                                fieldName = (String)entry.getKey();
                                                fieldValue = (Object[])entry.getValue();
                                                propertyDescriptor = BeanUtil.getPropertyDescriptor(var17_37, (String)fieldName, (boolean)true);
                                                if (propertyDescriptor == null || (writeMethod = propertyDescriptor.getWriteMethod()) == null) continue;
                                                clazzes = (writeMethod = ClassUtil.setAccessible((Method)writeMethod)).getParameterTypes();
                                                if (clazzes == null || clazzes.length != 1) {
                                                    DefaultHttpRequestHandler.log.info("\u65b9\u6cd5\u7684\u53c2\u6570\u957f\u5ea6\u4e0d\u4e3a1\uff0c{}.{}", (Object)var17_37.getName(), (Object)writeMethod.getName());
                                                    continue;
                                                }
                                                clazz = clazzes[0];
                                                if (!ClassUtils.isSimpleTypeOrArray(clazz) || fieldValue == null || fieldValue.length <= 0) continue;
                                                if (clazz.isArray()) {
                                                    writeMethod.invoke((Object)paramValues[i], new Object[]{Convert.convert(clazz, (Object)fieldValue)});
                                                    continue;
                                                }
                                                writeMethod.invoke((Object)paramValues[i], new Object[]{Convert.convert(clazz, (Object)fieldValue[0])});
                                            }
                                        }
                                        catch (Throwable e) {
                                            DefaultHttpRequestHandler.log.error(e.toString(), e);
                                        }
                                        finally {
                                            ++i;
                                        }
                                    }
                                    obj = method.invoke(bean, (Object[])paramValues);
                                }
                                if (!(obj instanceof HttpResponse)) ** GOTO lbl-1000
                                paramValues = ret = (HttpResponse)obj;
                                if (ret == null) return paramValues;
                            }
                            try {
                                this.processCookieAfterHandler(request, requestLine, ret);
                                if (this.httpServerInterceptor == null) return paramValues;
                                this.httpServerInterceptor.doAfterHandler(request, requestLine, ret);
                                return paramValues;
                            }
                            catch (Throwable e) {
                                this.logError(request, requestLine, e);
                                return paramValues;
                            }
                            finally {
                                DefaultHttpRequestHandler.gzip(request, ret);
                            }
lbl-1000:
                            // 1 sources

                            {
                                if (obj != null) ** GOTO lbl-1000
                                paramValues = null;
                                if (ret == null) return paramValues;
                            }
                            try {
                                this.processCookieAfterHandler(request, requestLine, ret);
                                if (this.httpServerInterceptor == null) return paramValues;
                                this.httpServerInterceptor.doAfterHandler(request, requestLine, ret);
                                return paramValues;
                            }
                            catch (Throwable e) {
                                this.logError(request, requestLine, e);
                                return paramValues;
                            }
                            finally {
                                DefaultHttpRequestHandler.gzip(request, ret);
                            }
lbl-1000:
                            // 1 sources

                            {
                                paramValues = ret = Resps.json(request, obj);
                                if (ret == null) return paramValues;
                            }
                            try {
                                this.processCookieAfterHandler(request, requestLine, ret);
                                if (this.httpServerInterceptor == null) return paramValues;
                                this.httpServerInterceptor.doAfterHandler(request, requestLine, ret);
                                return paramValues;
                            }
                            catch (Throwable e) {
                                this.logError(request, requestLine, e);
                                return paramValues;
                            }
                            finally {
                                DefaultHttpRequestHandler.gzip(request, ret);
                            }
lbl-1000:
                            // 1 sources

                            {
                                contentCache = null;
                                fileCache = null;
                                if (this.httpConfig.getMaxLiveTimeOfStaticRes() > 0) {
                                    contentCache = GuavaCache.getCache((String)"TIO_HTTP_STATIC_RES_CONTENT");
                                    fileCache = (FileCache)contentCache.get(path);
                                }
                                if (fileCache == null) break block100;
                                bodyBytes = fileCache.getData();
                                headers = fileCache.getHeaders();
                                lastModified = fileCache.getLastModified();
                                DefaultHttpRequestHandler.log.info("\u4ece\u7f13\u5b58\u83b7\u53d6:[{}], {}", (Object)path, (Object)bodyBytes.length);
                                ret = Resps.try304(request, lastModified);
                                if (ret == null) ** GOTO lbl-1000
                                ret.addHeader("tio-from-cache", "true");
                                e = ret;
                                if (ret == null) return e;
                            }
                            try {
                                this.processCookieAfterHandler(request, requestLine, ret);
                                if (this.httpServerInterceptor == null) return e;
                                this.httpServerInterceptor.doAfterHandler(request, requestLine, ret);
                                return e;
                            }
                            catch (Throwable e) {
                                this.logError(request, requestLine, e);
                                return e;
                            }
                            finally {
                                DefaultHttpRequestHandler.gzip(request, ret);
                            }
lbl-1000:
                            // 1 sources

                            {
                                ret = new HttpResponse(request, this.httpConfig);
                                ret.setBody(bodyBytes, request);
                                ret.addHeaders(headers);
                                e = ret;
                                if (ret == null) return e;
                            }
                            try {
                                this.processCookieAfterHandler(request, requestLine, ret);
                                if (this.httpServerInterceptor == null) return e;
                                this.httpServerInterceptor.doAfterHandler(request, requestLine, ret);
                                return e;
                            }
                            catch (Throwable e) {
                                this.logError(request, requestLine, e);
                                return e;
                            }
                            finally {
                                DefaultHttpRequestHandler.gzip(request, ret);
                            }
                        }
                        pageRoot = this.httpConfig.getPageRoot();
                        if (pageRoot == null) ** GOTO lbl-1000
                        file = new File(pageRoot + path);
                        if (!file.exists() || file.isDirectory()) {
                            path = StringUtils.endsWith((CharSequence)path, (CharSequence)"/") != false ? path + "index.html" : path + "/index.html";
                            file = new File(pageRoot, path);
                        }
                        if (!file.exists()) ** GOTO lbl-1000
                        if (this.freemarkerConfig == null) ** GOTO lbl257
                        extension = FileNameUtil.getExtension((String)file.getName());
                        if (!ArrayUtil.contains((Object[])this.freemarkerConfig.getSuffixes(), (Object)extension)) ** GOTO lbl257
                        configuration = this.freemarkerConfig.getConfiguration();
                        model = this.freemarkerConfig.getModelMaker().maker(request);
                        if (configuration == null || !((templateLoader = configuration.getTemplateLoader()) instanceof FileTemplateLoader)) ** GOTO lbl257
                        filePath = file.getCanonicalPath();
                        pageRootPath = this.httpConfig.getPageRoot().getCanonicalPath();
                        var17_38 = StringUtils.substring((String)filePath, (int)pageRootPath.length());
                        retStr = FreemarkerUtils.generateStringByFile((String)var17_38, (Configuration)configuration, (Object)model);
                        var19_43 = ret = Resps.file(request, retStr.getBytes(configuration.getDefaultEncoding()), extension);
                        if (ret == null) return var19_43;
                        try {
                            this.processCookieAfterHandler(request, requestLine, ret);
                            if (this.httpServerInterceptor == null) return var19_43;
                            this.httpServerInterceptor.doAfterHandler(request, requestLine, ret);
                            return var19_43;
                        }
                        catch (Throwable e) {
                            this.logError(request, requestLine, e);
                            return var19_43;
                        }
                        finally {
                            DefaultHttpRequestHandler.gzip(request, ret);
                        }
                        catch (Exception e) {}
                        {
                            DefaultHttpRequestHandler.log.error(e.toString());
lbl257:
                            // 4 sources

                            ret = Resps.file(request, file);
                            ret.setStaticRes(true);
                            if (contentCache != null && request.getIsSupportGzip().booleanValue() && ret.getBody() != null && ret.getStatus() == HttpResponseStatus.C200) {
                                contentType = ret.getHeader(HttpConst.ResponseHeaderKey.Content_Type);
                                contentEncoding = ret.getHeader(HttpConst.ResponseHeaderKey.Content_Encoding);
                                lastModified = ret.getHeader(HttpConst.ResponseHeaderKey.Last_Modified);
                                headers = new HashMap<String, String>();
                                if (StringUtils.isNotBlank((CharSequence)contentType)) {
                                    headers.put(HttpConst.ResponseHeaderKey.Content_Type, contentType);
                                }
                                if (StringUtils.isNotBlank((CharSequence)contentEncoding)) {
                                    headers.put(HttpConst.ResponseHeaderKey.Content_Encoding, contentEncoding);
                                }
                                if (StringUtils.isNotBlank((CharSequence)lastModified)) {
                                    headers.put(HttpConst.ResponseHeaderKey.Last_Modified, lastModified);
                                }
                                headers.put("tio-from-cache", "true");
                                fileCache = new FileCache(headers, file.lastModified(), ret.getBody());
                                contentCache.put(path, (Serializable)fileCache);
                                DefaultHttpRequestHandler.log.info("\u653e\u5165\u7f13\u5b58:[{}], {}", (Object)path, (Object)ret.getBody().length);
                            }
                            var11_15 = ret;
                            if (ret == null) return var11_15;
                        }
                        try {
                            this.processCookieAfterHandler(request, requestLine, ret);
                            if (this.httpServerInterceptor == null) return var11_15;
                            this.httpServerInterceptor.doAfterHandler(request, requestLine, ret);
                            return var11_15;
                        }
                        catch (Throwable e) {
                            this.logError(request, requestLine, e);
                            return var11_15;
                        }
                        finally {
                            DefaultHttpRequestHandler.gzip(request, ret);
                        }
lbl-1000:
                        // 2 sources

                        {
                            ret = this.resp404(request, requestLine);
                            contentCache = ret;
                            if (ret == null) return contentCache;
                        }
                        try {
                            this.processCookieAfterHandler(request, requestLine, ret);
                            if (this.httpServerInterceptor == null) return contentCache;
                            this.httpServerInterceptor.doAfterHandler(request, requestLine, ret);
                            return contentCache;
                        }
                        catch (Throwable e) {
                            this.logError(request, requestLine, e);
                            return contentCache;
                        }
                        finally {
                            DefaultHttpRequestHandler.gzip(request, ret);
                        }
lbl305:
                        // 1 sources

                        try {
                            this.processCookieAfterHandler(request, requestLine, ret);
                            if (this.httpServerInterceptor == null) return var6_7;
                            this.httpServerInterceptor.doAfterHandler(request, requestLine, ret);
                            return var6_7;
                        }
                        catch (Throwable e) {
                            this.logError(request, requestLine, e);
                            return var6_7;
                        }
                        finally {
                            DefaultHttpRequestHandler.gzip(request, ret);
                        }
lbl316:
                        // 1 sources

                        DefaultHttpRequestHandler.gzip(request, ret);
                        throw var37_62;
                        DefaultHttpRequestHandler.gzip(request, ret);
                        throw var37_62;
                    }
                }
            }
        }
    }

    private void logError(HttpRequest request, RequestLine requestLine, Throwable e) {
        StringBuilder sb = new StringBuilder();
        sb.append("\r\n").append("remote  :").append(request.getRemote());
        sb.append("\r\n").append("request :").append(requestLine.getLine());
        log.error(sb.toString(), e);
    }

    private void processCookieAfterHandler(HttpRequest request, RequestLine requestLine, HttpResponse httpResponse) throws ExecutionException {
        HttpSession httpSession = request.getHttpSession();
        Cookie cookie = DefaultHttpRequestHandler.getSessionCookie(request, this.httpConfig);
        String sessionId = null;
        if (cookie == null) {
            this.createSessionCookie(request, httpSession, httpResponse);
            log.info("{} \u521b\u5efa\u4f1a\u8bddCookie, {}", (Object)request.getChannelContext(), (Object)cookie);
        } else {
            sessionId = cookie.getValue();
            HttpSession httpSession1 = (HttpSession)this.httpConfig.getSessionStore().get(sessionId);
            if (httpSession1 == null) {
                this.createSessionCookie(request, httpSession, httpResponse);
            }
        }
    }

    private Cookie createSessionCookie(HttpRequest request, HttpSession httpSession, HttpResponse httpResponse) {
        String sessionId = httpSession.getId();
        String domain = request.getDomain();
        String name = this.httpConfig.getSessionCookieName();
        long maxAge = this.httpConfig.getSessionTimeout();
        Cookie sessionCookie = new Cookie(domain, name, sessionId, Long.valueOf(maxAge));
        if (this.sessionCookieDecorator != null) {
            this.sessionCookieDecorator.decorate(sessionCookie);
        }
        httpResponse.addCookie(sessionCookie);
        this.httpConfig.getSessionStore().put(sessionId, (Serializable)httpSession);
        return sessionCookie;
    }

    private void processCookieBeforeHandler(HttpRequest request, RequestLine requestLine) throws ExecutionException {
        Cookie cookie = DefaultHttpRequestHandler.getSessionCookie(request, this.httpConfig);
        HttpSession httpSession = null;
        if (cookie == null) {
            httpSession = this.createSession(request);
        } else {
            String sessionId = cookie.getValue();
            httpSession = (HttpSession)this.httpConfig.getSessionStore().get(sessionId);
            if (httpSession == null) {
                log.info("{} session\u3010{}\u3011\u8d85\u65f6", (Object)request.getChannelContext(), (Object)sessionId);
                httpSession = this.createSession(request);
            }
        }
        request.setHttpSession(httpSession);
    }

    public HttpResponse resp404(HttpRequest request, RequestLine requestLine) {
        return Resps.resp404(request, requestLine, this.httpConfig);
    }

    public HttpResponse resp500(HttpRequest request, RequestLine requestLine, Throwable throwable) {
        if (this.throwableHandler != null) {
            return this.throwableHandler.handler(request, requestLine, throwable);
        }
        return Resps.resp500(request, requestLine, this.httpConfig, throwable);
    }

    public void setHttpConfig(HttpConfig httpConfig) {
        this.httpConfig = httpConfig;
    }

    public void setHttpServerInterceptor(HttpServerInterceptor httpServerInterceptor) {
        this.httpServerInterceptor = httpServerInterceptor;
    }

    public void setStaticResCache(GuavaCache staticResCache) {
        this.staticResCache = staticResCache;
    }

    public void clearStaticResCache(HttpRequest request) {
        if (this.staticResCache != null) {
            this.staticResCache.clear();
        }
    }

    public HttpSessionListener getHttpSessionListener() {
        return this.httpSessionListener;
    }

    public void setHttpSessionListener(HttpSessionListener httpSessionListener) {
        this.httpSessionListener = httpSessionListener;
    }

    public SessionCookieDecorator getSessionCookieDecorator() {
        return this.sessionCookieDecorator;
    }

    public void setSessionCookieDecorator(SessionCookieDecorator sessionCookieDecorator) {
        this.sessionCookieDecorator = sessionCookieDecorator;
    }

    public IpPathAccessStats getIpPathAccessStats() {
        return this.ipPathAccessStats;
    }

    public void setIpPathAccessStats(IpPathAccessStats ipPathAccessStats) {
        this.ipPathAccessStats = ipPathAccessStats;
    }

    public FreemarkerConfig getFreemarkerConfig() {
        return this.freemarkerConfig;
    }

    public void setFreemarkerConfig(FreemarkerConfig freemarkerConfig) {
        this.freemarkerConfig = freemarkerConfig;
    }

    public ThrowableHandler getThrowableHandler() {
        return this.throwableHandler;
    }

    public void setThrowableHandler(ThrowableHandler throwableHandler) {
        this.throwableHandler = throwableHandler;
    }
}

