/*
 * Decompiled with CFR 0.152.
 */
package org.tio.http.server.stat.ip.path;

import com.xiaoleilu.hutool.date.BetweenFormater;
import java.io.Serializable;
import java.util.concurrent.atomic.AtomicInteger;
import org.tio.utils.SystemTimer;

public class IpPathAccessStat
implements Serializable {
    private static final long serialVersionUID = 5314797979230623121L;
    private Long durationType;
    private long duration;
    private String ip;
    private String path;
    private long firstAccessTime = SystemTimer.currentTimeMillis();
    private long lastAccessTime = SystemTimer.currentTimeMillis();
    public final AtomicInteger count = new AtomicInteger();
    public final AtomicInteger noSessionCount = new AtomicInteger();

    public IpPathAccessStat(Long durationType, String ip, String path) {
        this.durationType = durationType;
        this.ip = ip;
        this.path = path;
    }

    public String getFormatedDuration() {
        this.duration = SystemTimer.currentTimeMillis() - this.firstAccessTime;
        BetweenFormater betweenFormater = new BetweenFormater(this.duration, BetweenFormater.Level.MILLSECOND);
        return betweenFormater.format();
    }

    public double getPerSecond() {
        int count = this.count.get();
        long duration = this.getDuration();
        double perSecond = (double)count / (double)duration * 1000.0;
        return perSecond;
    }

    public Long getDurationType() {
        return this.durationType;
    }

    public void setDurationType(Long durationType) {
        this.durationType = durationType;
    }

    public String getIp() {
        return this.ip;
    }

    public void setIp(String ip) {
        this.ip = ip;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public long getFirstAccessTime() {
        return this.firstAccessTime;
    }

    public void setFirstAccessTime(long firstAccessTime) {
        this.firstAccessTime = firstAccessTime;
    }

    public long getLastAccessTime() {
        return this.lastAccessTime;
    }

    public void setLastAccessTime(long lastAccessTime) {
        this.lastAccessTime = lastAccessTime;
    }

    public long getDuration() {
        this.duration = SystemTimer.currentTimeMillis() - this.firstAccessTime;
        return this.duration;
    }

    public void setDuration(long duration) {
        this.duration = duration;
    }
}

