/*
 * Decompiled with CFR 0.152.
 */
package org.tio.http.server.stat.ip.path;

import com.google.common.cache.RemovalListener;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tio.core.GroupContext;
import org.tio.http.server.stat.ip.path.IpAccessStat;
import org.tio.http.server.stat.ip.path.IpPathAccessStatListener;
import org.tio.http.server.stat.ip.path.IpPathAccessStatRemovalListener;
import org.tio.utils.cache.guava.GuavaCache;

public class IpPathAccessStats {
    private static Logger log = LoggerFactory.getLogger(IpPathAccessStats.class);
    private static final String CACHE_NAME = "TIO_IP_ACCESSPATH";
    private GroupContext groupContext;
    private String groupContextId;
    public final Map<Long, GuavaCache> cacheMap = new HashMap<Long, GuavaCache>();
    public final List<Long> durationList = new ArrayList<Long>();
    private final Map<Long, IpPathAccessStatListener> listenerMap = new HashMap<Long, IpPathAccessStatListener>();

    public IpPathAccessStats(GroupContext groupContext, IpPathAccessStatListener ipPathAccessStatListener, Long[] durations) {
        this.groupContext = groupContext;
        this.groupContextId = groupContext.getId();
        if (durations != null) {
            for (Long duration : durations) {
                this.addDuration(duration, ipPathAccessStatListener);
            }
        }
    }

    public void addDuration(Long duration, IpPathAccessStatListener ipPathAccessStatListener) {
        GuavaCache guavaCache = GuavaCache.register((String)this.getCacheName(duration), (Long)duration, null, (RemovalListener)new IpPathAccessStatRemovalListener(this.groupContext, ipPathAccessStatListener));
        this.cacheMap.put(duration, guavaCache);
        this.durationList.add(duration);
        if (ipPathAccessStatListener != null) {
            this.listenerMap.put(duration, ipPathAccessStatListener);
        }
    }

    public IpPathAccessStatListener getListener(Long duration) {
        return this.listenerMap.get(duration);
    }

    public void addDurations(Long[] durations, IpPathAccessStatListener ipPathAccessStatListener) {
        if (durations != null) {
            for (Long duration : durations) {
                this.addDuration(duration, ipPathAccessStatListener);
            }
        }
    }

    public void removeMonitor(Long duration) {
        this.clear(duration);
        this.cacheMap.remove(duration);
        this.durationList.remove(duration);
    }

    public String getCacheName(Long duration) {
        String cacheName = "TIO_IP_ACCESSPATH_" + this.groupContextId + "_";
        return cacheName + duration;
    }

    public void clear(Long duration) {
        GuavaCache guavaCache = this.cacheMap.get(duration);
        if (guavaCache == null) {
            return;
        }
        guavaCache.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IpAccessStat get(Long duration, String ip, boolean forceCreate) {
        if (StringUtils.isBlank((CharSequence)ip)) {
            return null;
        }
        GuavaCache guavaCache = this.cacheMap.get(duration);
        if (guavaCache == null) {
            return null;
        }
        IpAccessStat ipAccessStat = (IpAccessStat)guavaCache.get(ip);
        if (ipAccessStat == null && forceCreate) {
            GuavaCache guavaCache2 = guavaCache;
            synchronized (guavaCache2) {
                ipAccessStat = (IpAccessStat)guavaCache.get(ip);
                if (ipAccessStat == null) {
                    ipAccessStat = new IpAccessStat(duration, ip);
                    guavaCache.put(ip, (Serializable)ipAccessStat);
                }
            }
        }
        return ipAccessStat;
    }

    public IpAccessStat get(Long duration, String ip) {
        return this.get(duration, ip, true);
    }

    public ConcurrentMap<String, Serializable> map(Long duration) {
        GuavaCache guavaCache = this.cacheMap.get(duration);
        if (guavaCache == null) {
            return null;
        }
        ConcurrentMap map = guavaCache.asMap();
        return map;
    }

    public Long size(Long duration) {
        GuavaCache guavaCache = this.cacheMap.get(duration);
        if (guavaCache == null) {
            return null;
        }
        return guavaCache.size();
    }

    public Collection<Serializable> values(Long duration) {
        GuavaCache guavaCache = this.cacheMap.get(duration);
        if (guavaCache == null) {
            return null;
        }
        Collection<Serializable> set = guavaCache.asMap().values();
        return set;
    }
}

