/*
 * Decompiled with CFR 0.152.
 */
package tachyon;

import com.google.common.base.Preconditions;
import java.io.Closeable;
import java.io.IOException;
import java.net.InetSocketAddress;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tachyon.Constants;
import tachyon.Version;
import tachyon.conf.TachyonConf;
import tachyon.org.apache.thrift.protocol.TBinaryProtocol;
import tachyon.org.apache.thrift.protocol.TMultiplexedProtocol;
import tachyon.org.apache.thrift.protocol.TProtocol;
import tachyon.org.apache.thrift.transport.TTransportException;
import tachyon.retry.ExponentialBackoffRetry;
import tachyon.security.authentication.AuthenticationUtils;

public abstract class ClientBase
implements Closeable {
    private static final Logger LOG = LoggerFactory.getLogger((String)Constants.LOGGER_TYPE);
    protected static final int RPC_MAX_NUM_RETRY = 30;
    protected final TachyonConf mTachyonConf;
    protected final String mMode;
    protected InetSocketAddress mAddress = null;
    protected TProtocol mProtocol = null;
    protected boolean mConnected = false;
    protected boolean mClosed = false;

    public ClientBase(InetSocketAddress address, TachyonConf tachyonConf, String mode) {
        this.mTachyonConf = (TachyonConf)Preconditions.checkNotNull((Object)tachyonConf);
        this.mAddress = (InetSocketAddress)Preconditions.checkNotNull((Object)address);
        this.mMode = mode;
    }

    protected abstract String getServiceName();

    protected void afterConnect() {
    }

    protected void afterDisconnect() {
    }

    public synchronized void connect() throws IOException {
        if (this.mConnected) {
            return;
        }
        this.disconnect();
        Preconditions.checkState((!this.mClosed ? 1 : 0) != 0, (Object)"Client is closed, will not try to connect.");
        int maxConnectsTry = this.mTachyonConf.getInt("tachyon.master.retry");
        int BASE_SLEEP_MS = 50;
        ExponentialBackoffRetry retry = new ExponentialBackoffRetry(50, 1000, maxConnectsTry);
        while (!this.mClosed) {
            this.mAddress = this.getAddress();
            LOG.info("Tachyon client (version " + Version.VERSION + ") is trying to connect with " + this.getServiceName() + " " + this.mMode + " @ " + this.mAddress);
            TBinaryProtocol binaryProtocol = new TBinaryProtocol(AuthenticationUtils.getClientTransport(this.mTachyonConf, this.mAddress));
            this.mProtocol = new TMultiplexedProtocol(binaryProtocol, this.getServiceName());
            try {
                this.mProtocol.getTransport().open();
                LOG.info("Client registered with " + this.getServiceName() + " " + this.mMode + " @ " + this.mAddress);
                this.mConnected = true;
                this.afterConnect();
                return;
            }
            catch (TTransportException e) {
                LOG.error("Failed to connect (" + retry.getRetryCount() + ") to " + this.getServiceName() + " " + this.mMode + " @ " + this.mAddress + " : " + e.getMessage());
                if (retry.attemptRetry()) continue;
                break;
            }
        }
        throw new IOException("Failed to connect to " + this.getServiceName() + " " + this.mMode + " @ " + this.mAddress + " after " + retry.getRetryCount() + " attempts");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void disconnect() {
        if (this.mConnected) {
            LOG.debug("Disconnecting from the " + this.getServiceName() + " " + this.mMode + " {}", (Object)this.mAddress);
            this.mConnected = false;
        }
        try {
            if (this.mProtocol != null) {
                this.mProtocol.getTransport().close();
            }
        }
        finally {
            this.afterDisconnect();
        }
    }

    public synchronized boolean isConnected() {
        return this.mConnected;
    }

    @Override
    public synchronized void close() {
        this.disconnect();
        this.mClosed = true;
    }

    public synchronized void resetConnection() {
        this.disconnect();
        this.mAddress = this.getAddress();
    }

    protected synchronized InetSocketAddress getAddress() {
        return this.mAddress;
    }
}

