/*
 * Decompiled with CFR 0.152.
 */
package tachyon.client.block;

import com.google.common.io.Closer;
import java.io.Closeable;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tachyon.Constants;
import tachyon.client.ClientContext;
import tachyon.client.block.BufferedBlockOutStream;
import tachyon.util.io.BufferUtils;
import tachyon.util.io.FileUtils;
import tachyon.util.network.NetworkAddressUtils;
import tachyon.worker.WorkerClient;

public final class LocalBlockOutStream
extends BufferedBlockOutStream {
    private static final Logger LOG = LoggerFactory.getLogger((String)Constants.LOGGER_TYPE);
    private final Closer mCloser = Closer.create();
    private final WorkerClient mWorkerClient = this.mContext.acquireWorkerClient(NetworkAddressUtils.getLocalHostName(ClientContext.getConf()));
    private final FileChannel mLocalFileChannel;
    private long mReservedBytes;

    public LocalBlockOutStream(long blockId, long blockSize) throws IOException {
        super(blockId, blockSize);
        try {
            long initialSize = ClientContext.getConf().getBytes("tachyon.user.file.buffer.bytes");
            String blockPath = this.mWorkerClient.requestBlockLocation(this.mBlockId, initialSize);
            this.mReservedBytes += initialSize;
            FileUtils.createBlockPath(blockPath);
            RandomAccessFile localFile = (RandomAccessFile)this.mCloser.register((Closeable)new RandomAccessFile(blockPath, "rw"));
            this.mLocalFileChannel = (FileChannel)this.mCloser.register((Closeable)localFile.getChannel());
            LOG.info("LocalBlockOutStream created new file block, block path: " + blockPath);
        }
        catch (IOException ioe) {
            this.mContext.releaseWorkerClient(this.mWorkerClient);
            throw ioe;
        }
    }

    @Override
    public void cancel() throws IOException {
        if (this.mClosed) {
            return;
        }
        this.mCloser.close();
        this.mWorkerClient.cancelBlock(this.mBlockId);
        this.mContext.releaseWorkerClient(this.mWorkerClient);
        this.mClosed = true;
    }

    @Override
    public void close() throws IOException {
        if (this.mClosed) {
            return;
        }
        this.flush();
        this.mCloser.close();
        if (this.mWrittenBytes > 0L) {
            this.mWorkerClient.cacheBlock(this.mBlockId);
            ClientContext.getClientMetrics().incBlocksWrittenLocal(1L);
        }
        this.mContext.releaseWorkerClient(this.mWorkerClient);
        this.mClosed = true;
    }

    @Override
    public void flush() throws IOException {
        int bytesToWrite = this.mBuffer.position();
        if (this.mReservedBytes < (long)bytesToWrite) {
            this.mReservedBytes += this.requestSpace((long)bytesToWrite - this.mReservedBytes);
        }
        MappedByteBuffer mappedBuffer = this.mLocalFileChannel.map(FileChannel.MapMode.READ_WRITE, this.mFlushedBytes, bytesToWrite);
        mappedBuffer.put(this.mBuffer.array(), 0, bytesToWrite);
        BufferUtils.cleanDirectBuffer(mappedBuffer);
        this.mReservedBytes -= (long)bytesToWrite;
        this.mFlushedBytes += (long)bytesToWrite;
        this.mBuffer.clear();
        ClientContext.getClientMetrics().incBytesWrittenLocal(bytesToWrite);
    }

    @Override
    protected void unBufferedWrite(byte[] b, int off, int len) throws IOException {
        if (this.mReservedBytes < (long)len) {
            this.mReservedBytes += this.requestSpace((long)len - this.mReservedBytes);
        }
        MappedByteBuffer mappedBuffer = this.mLocalFileChannel.map(FileChannel.MapMode.READ_WRITE, this.mFlushedBytes, len);
        mappedBuffer.put(b, off, len);
        BufferUtils.cleanDirectBuffer(mappedBuffer);
        this.mReservedBytes -= (long)len;
        this.mFlushedBytes += (long)len;
        ClientContext.getClientMetrics().incBytesWrittenLocal(len);
    }

    private long requestSpace(long requestBytes) throws IOException {
        if (!this.mWorkerClient.requestSpace(this.mBlockId, requestBytes)) {
            throw new IOException("Unable to request space from worker.");
        }
        return requestBytes;
    }
}

