/*
 * Decompiled with CFR 0.152.
 */
package tachyon.network.protocol.databuffer;

import com.google.common.base.Preconditions;
import io.netty.buffer.ByteBuf;
import java.nio.ByteBuffer;
import tachyon.network.protocol.databuffer.DataBuffer;

public final class DataNettyBuffer
implements DataBuffer {
    private final ByteBuffer mBuffer;
    private final long mLength;
    private final ByteBuf mNettyBuf;

    public DataNettyBuffer(ByteBuf bytebuf, long length) {
        Preconditions.checkArgument((bytebuf.nioBufferCount() == 1 ? 1 : 0) != 0, (String)"Number of nioBuffers of this bytebuf is %s (1 expected).", (Object[])new Object[]{bytebuf.nioBufferCount()});
        Preconditions.checkArgument((bytebuf.refCnt() == 1 ? 1 : 0) != 0, (String)"Reference count of this bytebuf is %s (1 expected).", (Object[])new Object[]{bytebuf.refCnt()});
        bytebuf.retain();
        this.mNettyBuf = bytebuf;
        this.mBuffer = bytebuf.nioBuffer();
        this.mLength = length;
    }

    @Override
    public Object getNettyOutput() {
        throw new UnsupportedOperationException("DataNettyBuffer doesn't support getNettyOutput()");
    }

    @Override
    public long getLength() {
        return this.mLength;
    }

    @Override
    public ByteBuffer getReadOnlyByteBuffer() {
        ByteBuffer buffer = this.mBuffer.asReadOnlyBuffer();
        buffer.position(0);
        return buffer;
    }

    @Override
    public void release() {
        Preconditions.checkState((this.mNettyBuf != null ? 1 : 0) != 0);
        Preconditions.checkState((this.mNettyBuf.refCnt() == 1 ? 1 : 0) != 0, (String)"Reference count of the netty buffer is %s (1 expected).", (Object[])new Object[]{this.mNettyBuf.refCnt()});
        Preconditions.checkState((this.mNettyBuf.release() ? 1 : 0) != 0, (Object)"Release Netty ByteBuf failed.");
    }
}

