/*
 * Decompiled with CFR 0.152.
 */
package tachyon.util.io;

import com.google.common.base.Preconditions;
import com.google.common.io.ByteStreams;
import com.google.common.io.Closer;
import com.google.common.io.Files;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tachyon.exception.InvalidPathException;
import tachyon.util.io.PathUtils;

public final class FileUtils {
    private static final Logger LOG = LoggerFactory.getLogger((String)"");

    public static void changeLocalFilePermission(String filePath, String perms) throws IOException {
        ArrayList<String> commands = new ArrayList<String>();
        commands.add("/bin/chmod");
        commands.add(perms);
        File file = new File(filePath);
        commands.add(file.getAbsolutePath());
        try {
            ProcessBuilder builder = new ProcessBuilder(commands);
            Process process = builder.start();
            process.waitFor();
            FileUtils.redirectIO(process);
            if (process.exitValue() != 0) {
                throw new IOException("Can not change the file " + file.getAbsolutePath() + " 's permission to be " + perms);
            }
        }
        catch (InterruptedException e) {
            LOG.error(e.getMessage());
            throw new IOException(e);
        }
    }

    private static void redirectIO(Process process) throws IOException {
        Preconditions.checkNotNull((Object)process);
        Closer closer = Closer.create();
        try {
            ByteStreams.copy((InputStream)((InputStream)closer.register((Closeable)process.getInputStream())), (OutputStream)System.out);
            ByteStreams.copy((InputStream)((InputStream)closer.register((Closeable)process.getErrorStream())), (OutputStream)System.err);
        }
        catch (Throwable e) {
            throw closer.rethrow(e);
        }
        finally {
            closer.close();
        }
    }

    public static void changeLocalFileToFullPermission(String filePath) throws IOException {
        FileUtils.changeLocalFilePermission(filePath, "777");
    }

    public static void setLocalDirStickyBit(String dir) {
        try {
            if (dir.startsWith("/")) {
                Runtime.getRuntime().exec("chmod +t " + dir);
            }
        }
        catch (IOException e) {
            LOG.info("Can not set the sticky bit of the direcotry : " + dir);
        }
    }

    public static void createBlockPath(String path) throws IOException {
        try {
            FileUtils.createStorageDirPath(PathUtils.getParent(path));
        }
        catch (InvalidPathException e) {
            throw new IOException("Failed to create block path, get parent path of " + path + "failed");
        }
        catch (IOException ioe) {
            throw new IOException("Failed to create block path " + path);
        }
    }

    public static void move(String srcPath, String dstPath) throws IOException {
        Files.move((File)new File(srcPath), (File)new File(dstPath));
    }

    public static void delete(String path) throws IOException {
        File file = new File(path);
        boolean deletionSucceeded = file.delete();
        if (!deletionSucceeded) {
            throw new IOException("Failed to delete " + path);
        }
    }

    public static void createStorageDirPath(String path) throws IOException {
        File dir = new File(path);
        String absolutePath = dir.getAbsolutePath();
        if (!dir.exists()) {
            if (dir.mkdirs()) {
                FileUtils.changeLocalFileToFullPermission(absolutePath);
                FileUtils.setLocalDirStickyBit(absolutePath);
                LOG.info("Folder {} was created!", (Object)path);
            } else {
                throw new IOException("Failed to create folder " + path);
            }
        }
    }

    public static void createFile(String filePath) throws IOException {
        File file = new File(filePath);
        Files.createParentDirs((File)file);
        if (!file.createNewFile()) {
            throw new IOException("File already exists " + filePath);
        }
    }

    public static void createDir(String path) throws IOException {
        new File(path).mkdirs();
    }

    public static boolean exists(String path) {
        return new File(path).exists();
    }

    private FileUtils() {
    }
}

