/*
 * Decompiled with CFR 0.152.
 */
package org.talend.sdk.component.sample;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Serializable;
import java.util.Map;
import java.util.Optional;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.talend.sdk.component.api.component.Icon;
import org.talend.sdk.component.api.component.MigrationHandler;
import org.talend.sdk.component.api.component.Version;
import org.talend.sdk.component.api.configuration.Option;
import org.talend.sdk.component.api.input.Emitter;
import org.talend.sdk.component.api.input.Producer;
import org.talend.sdk.component.api.service.Service;
import org.talend.sdk.component.sample.FileService;
import org.talend.sdk.component.sample.Person;

@Version(value=2, migrationHandler=Migrations.class)
@Icon(value=Icon.IconType.USER_CIRCLE)
@Emitter(name="reader")
public class PersonReader
implements Serializable {
    private final File file;
    private final FileService service;
    private transient BufferedReader reader;

    public PersonReader(@Option(value="file") File file, FileService service) {
        this.file = file;
        this.service = service;
    }

    @PostConstruct
    public void open() throws FileNotFoundException {
        this.reader = this.service.createInput(this.file);
    }

    @Producer
    public Person readNext() throws IOException {
        String line = this.reader.readLine();
        if (line == null) {
            return null;
        }
        String[] info = line.split(";");
        return new Person(info[0], Integer.parseInt(info[1].trim()));
    }

    @PreDestroy
    public void close() throws IOException {
        if (this.reader != null) {
            this.reader.close();
        }
    }

    @Service
    public static class MigrationV1V2 {
        public Map<String, String> migrate(Map<String, String> incomingData) {
            Optional.ofNullable(incomingData.get("old_file")).ifPresent(v -> {
                incomingData.put("file", (String)v);
                incomingData.remove("old_file");
            });
            return incomingData;
        }
    }

    public static class Migrations
    implements MigrationHandler {
        private static final Logger log = LoggerFactory.getLogger(Migrations.class);
        private final MigrationV1V2 migrationV1V2;

        public Map<String, String> migrate(int incomingVersion, Map<String, String> incomingData) {
            switch (incomingVersion) {
                case 1: {
                    log.info("Migration incoming data to version 2 from version 1");
                    return this.migrationV1V2.migrate(incomingData);
                }
            }
            log.info("No active migration from version " + incomingData);
            return incomingData;
        }

        public Migrations(MigrationV1V2 migrationV1V2) {
            this.migrationV1V2 = migrationV1V2;
        }
    }
}

