/*
 * Decompiled with CFR 0.152.
 */
package org.thymeleaf.spring3;

import org.springframework.context.MessageSource;
import org.springframework.context.MessageSourceAware;
import org.thymeleaf.TemplateEngine;
import org.thymeleaf.dialect.IDialect;
import org.thymeleaf.messageresolver.IMessageResolver;
import org.thymeleaf.messageresolver.StandardMessageResolver;
import org.thymeleaf.spring3.ISpringTemplateEngine;
import org.thymeleaf.spring3.dialect.SpringStandardDialect;
import org.thymeleaf.spring3.messageresolver.SpringMessageResolver;

public class SpringTemplateEngine
extends TemplateEngine
implements ISpringTemplateEngine,
MessageSourceAware {
    private static final SpringStandardDialect SPRINGSTANDARD_DIALECT = new SpringStandardDialect();
    private MessageSource messageSource = null;
    private MessageSource templateEngineMessageSource = null;

    public SpringTemplateEngine() {
        super.setDialect((IDialect)SPRINGSTANDARD_DIALECT);
    }

    public void setMessageSource(MessageSource messageSource) {
        this.messageSource = messageSource;
    }

    @Override
    public void setTemplateEngineMessageSource(MessageSource templateEngineMessageSource) {
        this.templateEngineMessageSource = templateEngineMessageSource;
    }

    protected final void initializeSpecific() {
        Object messageResolver;
        MessageSource messageSource;
        this.initializeSpringSpecific();
        super.initializeSpecific();
        MessageSource messageSource2 = messageSource = this.templateEngineMessageSource == null ? this.messageSource : this.templateEngineMessageSource;
        if (messageSource != null) {
            SpringMessageResolver springMessageResolver = new SpringMessageResolver();
            springMessageResolver.setMessageSource(messageSource);
            messageResolver = springMessageResolver;
        } else {
            messageResolver = new StandardMessageResolver();
        }
        super.setMessageResolver((IMessageResolver)messageResolver);
    }

    protected void initializeSpringSpecific() {
    }
}

