/*
 * Decompiled with CFR 0.152.
 */
package org.thymeleaf.spring3.expression;

import org.thymeleaf.exceptions.ConfigurationException;
import org.thymeleaf.util.ClassLoaderUtils;

public class Mvc {
    private static final MvcUriComponentsBuilderDelegate mvcUriComponentsBuilderDelegate;
    private static final String NON_SPRING41_MVC_URI_COMPONENTS_BUILDER_DELEGATE_CLASS_NAME;

    public MethodArgumentBuilderWrapper url(String mappingName) {
        return mvcUriComponentsBuilderDelegate.fromMappingName(mappingName);
    }

    static {
        String delegateClassName = NON_SPRING41_MVC_URI_COMPONENTS_BUILDER_DELEGATE_CLASS_NAME = Mvc.class.getName() + "$NonSpring41MvcUriComponentsBuilderDelegate";
        try {
            Class implClass = ClassLoaderUtils.loadClass((String)delegateClassName);
            mvcUriComponentsBuilderDelegate = (MvcUriComponentsBuilderDelegate)implClass.newInstance();
        }
        catch (Exception e) {
            throw new ExceptionInInitializerError((Throwable)new ConfigurationException("Thymeleaf could not initialize a delegate of class \"" + delegateClassName + "\" for taking care of the " + "mvc" + " expression utility object", (Throwable)e));
        }
    }

    public static interface MethodArgumentBuilderWrapper {
        public MethodArgumentBuilderWrapper arg(int var1, Object var2);

        public String build();

        public String buildAndExpand(Object ... var1);
    }

    static class NonSpring41MvcUriComponentsBuilderDelegate
    implements MvcUriComponentsBuilderDelegate {
        NonSpring41MvcUriComponentsBuilderDelegate() {
        }

        @Override
        public MethodArgumentBuilderWrapper fromMappingName(String mappingName) {
            throw new UnsupportedOperationException("MVC URI component building is only supported in Spring versions 4.1 or newer");
        }
    }

    static interface MvcUriComponentsBuilderDelegate {
        public MethodArgumentBuilderWrapper fromMappingName(String var1);
    }
}

