/*
 * Decompiled with CFR 0.152.
 */
package org.thymeleaf.spring4.processor.attr;

import java.util.Map;
import org.springframework.web.servlet.support.BindStatus;
import org.springframework.web.servlet.tags.form.ValueFormatterWrapper;
import org.thymeleaf.Arguments;
import org.thymeleaf.context.IProcessingContext;
import org.thymeleaf.dom.Element;
import org.thymeleaf.processor.ProcessorResult;
import org.thymeleaf.spring4.processor.attr.AbstractSpringFieldAttrProcessor;
import org.thymeleaf.spring4.requestdata.RequestDataValueProcessorUtils;
import org.thymeleaf.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SpringInputGeneralFieldAttrProcessor
extends AbstractSpringFieldAttrProcessor {
    public static final String TEXT_INPUT_TYPE_ATTR_VALUE = "text";
    public static final String HIDDEN_INPUT_TYPE_ATTR_VALUE = "hidden";
    public static final String DATETIME_INPUT_TYPE_ATTR_VALUE = "datetime";
    public static final String DATETIMELOCAL_INPUT_TYPE_ATTR_VALUE = "datetime-local";
    public static final String DATE_INPUT_TYPE_ATTR_VALUE = "date";
    public static final String MONTH_INPUT_TYPE_ATTR_VALUE = "month";
    public static final String TIME_INPUT_TYPE_ATTR_VALUE = "time";
    public static final String WEEK_INPUT_TYPE_ATTR_VALUE = "week";
    public static final String NUMBER_INPUT_TYPE_ATTR_VALUE = "number";
    public static final String RANGE_INPUT_TYPE_ATTR_VALUE = "range";
    public static final String EMAIL_INPUT_TYPE_ATTR_VALUE = "email";
    public static final String URL_INPUT_TYPE_ATTR_VALUE = "url";
    public static final String SEARCH_INPUT_TYPE_ATTR_VALUE = "search";
    public static final String TEL_INPUT_TYPE_ATTR_VALUE = "tel";
    public static final String COLOR_INPUT_TYPE_ATTR_VALUE = "color";
    private static final String[] ALL_TYPE_ATTR_VALUES = new String[]{null, "text", "hidden", "datetime", "datetime-local", "date", "month", "time", "week", "number", "range", "email", "url", "search", "tel", "color"};
    public static final SpringInputGeneralFieldAttrProcessor[] PROCESSORS = new SpringInputGeneralFieldAttrProcessor[ALL_TYPE_ATTR_VALUES.length];
    private boolean computedType;

    private SpringInputGeneralFieldAttrProcessor(String hostFilterAttributeValue) {
        super("field", "input", "type", hostFilterAttributeValue);
        this.computedType = hostFilterAttributeValue == null;
    }

    @Override
    protected ProcessorResult doProcess(Arguments arguments, Element element, String attributeName, String attributeValue, BindStatus bindStatus, Map<String, Object> localVariables) {
        if (this.computedType && !StringUtils.isEmptyOrWhitespace((String)element.getAttributeValueFromNormalizedName("type"))) {
            element.setRecomputeProcessorsImmediately(true);
            return ProcessorResult.OK;
        }
        String name = bindStatus.getExpression();
        name = name == null ? "" : name;
        String id = this.computeId(arguments, element, name, false);
        String type = element.getAttributeValueFromNormalizedName("type");
        String value = SpringInputGeneralFieldAttrProcessor.applyConversion(type) ? ValueFormatterWrapper.getDisplayString(bindStatus.getValue(), bindStatus.getEditor(), false) : ValueFormatterWrapper.getDisplayString(bindStatus.getActualValue(), false);
        element.setAttribute("id", id);
        element.setAttribute("name", name);
        element.setAttribute("value", RequestDataValueProcessorUtils.processFormFieldValue(arguments.getConfiguration(), (IProcessingContext)arguments, name, value, type));
        element.removeAttribute(attributeName);
        return ProcessorResult.setLocalVariables(localVariables);
    }

    private static boolean applyConversion(String type) {
        return type == null || !NUMBER_INPUT_TYPE_ATTR_VALUE.equalsIgnoreCase(type) && !RANGE_INPUT_TYPE_ATTR_VALUE.equalsIgnoreCase(type);
    }

    static {
        for (int i = 0; i < ALL_TYPE_ATTR_VALUES.length; ++i) {
            SpringInputGeneralFieldAttrProcessor.PROCESSORS[i] = new SpringInputGeneralFieldAttrProcessor(ALL_TYPE_ATTR_VALUES[i]);
        }
    }
}

