/*
 * Decompiled with CFR 0.152.
 */
package org.thymeleaf.spring5.context.reactive;

import org.reactivestreams.Publisher;
import org.springframework.core.ReactiveAdapterRegistry;
import org.thymeleaf.spring5.context.reactive.IReactiveDataDriverContextVariable;
import org.thymeleaf.spring5.context.reactive.ReactiveContextVariableUtils;
import org.thymeleaf.util.Validate;
import reactor.core.publisher.Flux;

public class ReactiveDataDriverContextVariable
implements IReactiveDataDriverContextVariable {
    public static final int DEFAULT_DATA_DRIVER_BUFFER_SIZE_ELEMENTS = 100;
    private final Object dataStream;
    private final int dataStreamBufferSizeElements;
    private ReactiveAdapterRegistry adapterRegistry;

    public ReactiveDataDriverContextVariable(Object dataStream) {
        this(dataStream, 100);
    }

    public ReactiveDataDriverContextVariable(Object dataStream, int dataStreamBufferSizeElements) {
        Validate.notNull((Object)dataStream, (String)"Data stream cannot be null");
        Validate.isTrue((dataStreamBufferSizeElements > 0 ? 1 : 0) != 0, (String)"Data Buffer Size cannot be <= 0");
        this.dataStream = dataStream;
        this.dataStreamBufferSizeElements = dataStreamBufferSizeElements;
    }

    public final void setReactiveAdapterRegistry(ReactiveAdapterRegistry reactiveAdapterRegistry) {
        this.adapterRegistry = reactiveAdapterRegistry;
    }

    @Override
    public Publisher<Object> getDataStream() {
        Publisher<Object> publisher = ReactiveContextVariableUtils.computePublisherValue(this.dataStream, this.adapterRegistry);
        if (!(publisher instanceof Flux)) {
            throw new IllegalArgumentException("Reactive Data Driver context variable was set single-valued aynchronous object. But data driver variables must wrap multi-valued data streams (so that they can be iterated at the template");
        }
        return publisher;
    }

    @Override
    public final int getBufferSizeElements() {
        return this.dataStreamBufferSizeElements;
    }
}

