/*
 * Decompiled with CFR 0.152.
 */
package org.thymeleaf.spring5.context.reactive;

import java.util.AbstractList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.http.server.reactive.ServerHttpResponse;
import org.springframework.web.server.ServerWebExchange;
import org.springframework.web.server.WebSession;
import org.thymeleaf.IEngineConfiguration;
import org.thymeleaf.context.AbstractEngineContext;
import org.thymeleaf.context.EngineContext;
import org.thymeleaf.context.IEngineContext;
import org.thymeleaf.context.ILazyContextVariable;
import org.thymeleaf.engine.TemplateData;
import org.thymeleaf.inline.IInliner;
import org.thymeleaf.model.IProcessableElementTag;
import org.thymeleaf.spring5.context.reactive.ISpringWebReactiveContext;
import org.thymeleaf.util.Validate;
import reactor.core.publisher.Mono;

public class SpringWebReactiveEngineContext
extends AbstractEngineContext
implements IEngineContext,
ISpringWebReactiveContext {
    private static final String PARAM_VARIABLE_NAME = "param";
    private static final String SESSION_VARIABLE_NAME = "session";
    private final ServerHttpRequest request;
    private final ServerHttpResponse response;
    private final Mono<WebSession> session;
    private final ServerWebExchange exchange;
    private final WebExchangeAttributesVariablesMap webExchangeAttributesVariablesMap;
    private final Map<String, Object> requestParametersVariablesMap;
    private final Map<String, Object> sessionAttributesVariablesMap;

    public SpringWebReactiveEngineContext(IEngineConfiguration configuration, TemplateData templateData, Map<String, Object> templateResolutionAttributes, ServerWebExchange exchange, Locale locale, Map<String, Object> variables) {
        super(configuration, templateResolutionAttributes, locale);
        Validate.notNull((Object)exchange, (String)"Server Web Exchange cannot be null in web variables map");
        this.exchange = exchange;
        this.request = this.exchange.getRequest();
        this.response = this.exchange.getResponse();
        this.session = this.exchange.getSession();
        this.webExchangeAttributesVariablesMap = new WebExchangeAttributesVariablesMap(configuration, templateData, templateResolutionAttributes, this.exchange, locale, variables);
        this.requestParametersVariablesMap = new RequestParametersMap(this.request);
        this.sessionAttributesVariablesMap = new SessionAttributesMap(this.session);
    }

    @Override
    public ServerHttpRequest getRequest() {
        return this.request;
    }

    @Override
    public ServerHttpResponse getResponse() {
        return this.response;
    }

    @Override
    public Mono<WebSession> getSession() {
        return this.session;
    }

    @Override
    public ServerWebExchange getExchange() {
        return this.exchange;
    }

    public boolean containsVariable(String name) {
        return SESSION_VARIABLE_NAME.equals(name) || PARAM_VARIABLE_NAME.equals(name) || this.webExchangeAttributesVariablesMap.containsVariable(name);
    }

    public Object getVariable(String key) {
        if (SESSION_VARIABLE_NAME.equals(key)) {
            return this.sessionAttributesVariablesMap;
        }
        if (PARAM_VARIABLE_NAME.equals(key)) {
            return this.requestParametersVariablesMap;
        }
        return this.webExchangeAttributesVariablesMap.getVariable(key);
    }

    public Set<String> getVariableNames() {
        return this.webExchangeAttributesVariablesMap.getVariableNames();
    }

    public void setVariable(String name, Object value) {
        if (SESSION_VARIABLE_NAME.equals(name) || PARAM_VARIABLE_NAME.equals(name)) {
            throw new IllegalArgumentException("Cannot set variable called '" + name + "' into web variables map: such name is a reserved word");
        }
        this.webExchangeAttributesVariablesMap.setVariable(name, value);
    }

    public void setVariables(Map<String, Object> variables) {
        if (variables == null || variables.isEmpty()) {
            return;
        }
        for (String name : variables.keySet()) {
            if (!SESSION_VARIABLE_NAME.equals(name) && !PARAM_VARIABLE_NAME.equals(name)) continue;
            throw new IllegalArgumentException("Cannot set variable called '" + name + "' into web variables map: such name is a reserved word");
        }
        this.webExchangeAttributesVariablesMap.setVariables(variables);
    }

    public void removeVariable(String name) {
        if (SESSION_VARIABLE_NAME.equals(name) || PARAM_VARIABLE_NAME.equals(name)) {
            throw new IllegalArgumentException("Cannot remove variable called '" + name + "' in web variables map: such name is a reserved word");
        }
        this.webExchangeAttributesVariablesMap.removeVariable(name);
    }

    public boolean isVariableLocal(String name) {
        return this.webExchangeAttributesVariablesMap.isVariableLocal(name);
    }

    public boolean hasSelectionTarget() {
        return this.webExchangeAttributesVariablesMap.hasSelectionTarget();
    }

    public Object getSelectionTarget() {
        return this.webExchangeAttributesVariablesMap.getSelectionTarget();
    }

    public void setSelectionTarget(Object selectionTarget) {
        this.webExchangeAttributesVariablesMap.setSelectionTarget(selectionTarget);
    }

    public IInliner getInliner() {
        return this.webExchangeAttributesVariablesMap.getInliner();
    }

    public void setInliner(IInliner inliner) {
        this.webExchangeAttributesVariablesMap.setInliner(inliner);
    }

    public TemplateData getTemplateData() {
        return this.webExchangeAttributesVariablesMap.getTemplateData();
    }

    public void setTemplateData(TemplateData templateData) {
        this.webExchangeAttributesVariablesMap.setTemplateData(templateData);
    }

    public List<TemplateData> getTemplateStack() {
        return this.webExchangeAttributesVariablesMap.getTemplateStack();
    }

    public void setElementTag(IProcessableElementTag elementTag) {
        this.webExchangeAttributesVariablesMap.setElementTag(elementTag);
    }

    public List<IProcessableElementTag> getElementStack() {
        return this.webExchangeAttributesVariablesMap.getElementStack();
    }

    public List<IProcessableElementTag> getElementStackAbove(int contextLevel) {
        return this.webExchangeAttributesVariablesMap.getElementStackAbove(contextLevel);
    }

    public int level() {
        return this.webExchangeAttributesVariablesMap.level();
    }

    public void increaseLevel() {
        this.webExchangeAttributesVariablesMap.increaseLevel();
    }

    public void decreaseLevel() {
        this.webExchangeAttributesVariablesMap.decreaseLevel();
    }

    public String getStringRepresentationByLevel() {
        return this.webExchangeAttributesVariablesMap.getStringRepresentationByLevel();
    }

    public String toString() {
        return this.webExchangeAttributesVariablesMap.toString();
    }

    static Object resolveLazy(Object variable) {
        if (variable != null && variable instanceof ILazyContextVariable) {
            return ((ILazyContextVariable)variable).getValue();
        }
        return variable;
    }

    private static final class RequestParameterValues
    extends AbstractList<String> {
        private final List<String> parameterValues;

        RequestParameterValues(List<String> parameterValues) {
            this.parameterValues = parameterValues;
        }

        @Override
        public int size() {
            return this.parameterValues.size();
        }

        @Override
        public Object[] toArray() {
            return this.parameterValues.toArray();
        }

        @Override
        public <T> T[] toArray(T[] arr) {
            return this.parameterValues.toArray(arr);
        }

        @Override
        public String get(int index) {
            return this.parameterValues.get(index);
        }

        @Override
        public int indexOf(Object obj) {
            return this.parameterValues.indexOf(obj);
        }

        @Override
        public boolean contains(Object obj) {
            return this.parameterValues.contains(obj);
        }

        @Override
        public String toString() {
            int size = this.parameterValues.size();
            if (size == 0) {
                return "";
            }
            if (size == 1) {
                return this.parameterValues.get(0);
            }
            return this.parameterValues.toString();
        }
    }

    private static abstract class NoOpMapImpl
    implements Map<String, Object> {
        protected NoOpMapImpl() {
        }

        @Override
        public int size() {
            return 0;
        }

        @Override
        public boolean isEmpty() {
            return true;
        }

        @Override
        public boolean containsKey(Object key) {
            return false;
        }

        @Override
        public boolean containsValue(Object value) {
            return false;
        }

        @Override
        public Object get(Object key) {
            return null;
        }

        @Override
        public Object put(String key, Object value) {
            throw new UnsupportedOperationException("Cannot add new entry: map is immutable");
        }

        @Override
        public Object remove(Object key) {
            throw new UnsupportedOperationException("Cannot remove entry: map is immutable");
        }

        @Override
        public void putAll(Map<? extends String, ? extends Object> m) {
            throw new UnsupportedOperationException("Cannot add new entry: map is immutable");
        }

        @Override
        public void clear() {
            throw new UnsupportedOperationException("Cannot clear: map is immutable");
        }

        @Override
        public Set<String> keySet() {
            return Collections.emptySet();
        }

        @Override
        public Collection<Object> values() {
            return Collections.emptyList();
        }

        @Override
        public Set<Map.Entry<String, Object>> entrySet() {
            return Collections.emptySet();
        }

        static final class MapEntry
        implements Map.Entry<String, Object> {
            private final String key;
            private final Object value;

            MapEntry(String key, Object value) {
                this.key = key;
                this.value = value;
            }

            @Override
            public String getKey() {
                return this.key;
            }

            @Override
            public Object getValue() {
                return this.value;
            }

            @Override
            public Object setValue(Object value) {
                throw new UnsupportedOperationException("Cannot set value: map is immutable");
            }
        }
    }

    private static final class WebExchangeAttributesVariablesMap
    extends EngineContext {
        private final ServerWebExchange exchange;

        WebExchangeAttributesVariablesMap(IEngineConfiguration configuration, TemplateData templateData, Map<String, Object> templateResolutionAttributes, ServerWebExchange exchange, Locale locale, Map<String, Object> variables) {
            super(configuration, templateData, templateResolutionAttributes, locale, variables);
            this.exchange = exchange;
        }

        public boolean containsVariable(String name) {
            if (super.containsVariable(name)) {
                return true;
            }
            return this.exchange.getAttributes().containsKey(name);
        }

        public Object getVariable(String key) {
            Object value = super.getVariable(key);
            if (value != null) {
                return value;
            }
            return this.exchange.getAttributes().get(key);
        }

        public Set<String> getVariableNames() {
            Set variableNames = super.getVariableNames();
            variableNames.addAll(this.exchange.getAttributes().keySet());
            return variableNames;
        }

        public String getStringRepresentationByLevel() {
            StringBuilder strBuilder = new StringBuilder(super.getStringRepresentationByLevel());
            strBuilder.append("[[EXCHANGE: " + this.exchange.getAttributes() + "]]");
            return strBuilder.toString();
        }

        public String toString() {
            StringBuilder strBuilder = new StringBuilder(super.toString());
            strBuilder.append("[[EXCHANGE: " + this.exchange.getAttributes() + "]]");
            return strBuilder.toString();
        }
    }

    private static final class RequestParametersMap
    extends NoOpMapImpl {
        private final ServerHttpRequest request;

        RequestParametersMap(ServerHttpRequest request) {
            this.request = request;
        }

        @Override
        public int size() {
            return this.request.getQueryParams().size();
        }

        @Override
        public boolean isEmpty() {
            return this.request.getQueryParams().isEmpty();
        }

        @Override
        public boolean containsKey(Object key) {
            return true;
        }

        @Override
        public boolean containsValue(Object value) {
            throw new UnsupportedOperationException("Map does not support #containsValue()");
        }

        @Override
        public Object get(Object key) {
            List parameterValues = (List)this.request.getQueryParams().get((Object)(key != null ? key.toString() : null));
            if (parameterValues == null) {
                return null;
            }
            return new RequestParameterValues(parameterValues);
        }

        @Override
        public Set<String> keySet() {
            return this.request.getQueryParams().keySet();
        }

        @Override
        public Collection<Object> values() {
            return this.request.getQueryParams().values();
        }

        @Override
        public Set<Map.Entry<String, Object>> entrySet() {
            return this.request.getQueryParams().entrySet();
        }
    }

    private static final class SessionAttributesMap
    extends NoOpMapImpl {
        private final Mono<WebSession> sessionFlux;
        private WebSession session = null;

        SessionAttributesMap(Mono<WebSession> sessionFlux) {
            this.sessionFlux = sessionFlux;
        }

        private WebSession getSession() {
            if (this.session == null) {
                this.session = (WebSession)this.sessionFlux.block();
            }
            return this.session;
        }

        @Override
        public int size() {
            return this.getSession().getAttributes().size();
        }

        @Override
        public boolean isEmpty() {
            return this.getSession().getAttributes().isEmpty();
        }

        @Override
        public boolean containsKey(Object key) {
            return true;
        }

        @Override
        public boolean containsValue(Object value) {
            throw new UnsupportedOperationException("Map does not support #containsValue()");
        }

        @Override
        public Object get(Object key) {
            return SpringWebReactiveEngineContext.resolveLazy(this.getSession().getAttributes().get(key != null ? key.toString() : null));
        }

        @Override
        public Set<String> keySet() {
            return this.getSession().getAttributes().keySet();
        }

        @Override
        public Collection<Object> values() {
            return this.getSession().getAttributes().values();
        }

        @Override
        public Set<Map.Entry<String, Object>> entrySet() {
            return this.getSession().getAttributes().entrySet();
        }
    }
}

