/*
 * Decompiled with CFR 0.152.
 */
package org.thymeleaf.spring5.linkbuilder.reactive;

import java.util.Map;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.http.server.reactive.ServerHttpResponse;
import org.thymeleaf.context.IExpressionContext;
import org.thymeleaf.exceptions.TemplateProcessingException;
import org.thymeleaf.linkbuilder.StandardLinkBuilder;
import org.thymeleaf.spring5.context.reactive.ISpringWebReactiveContext;

public class SpringWebReactiveLinkBuilder
extends StandardLinkBuilder {
    protected String computeContextPath(IExpressionContext context, String base, Map<String, Object> parameters) {
        if (!(context instanceof ISpringWebReactiveContext)) {
            throw new TemplateProcessingException("Link base \"" + base + "\" cannot be context relative (/...) unless the context used for executing the engine implements the " + ISpringWebReactiveContext.class.getName() + " interface");
        }
        ServerHttpRequest request = ((ISpringWebReactiveContext)context).getRequest();
        return request.getContextPath();
    }

    protected String processLink(IExpressionContext context, String link) {
        if (!(context instanceof ISpringWebReactiveContext)) {
            return link;
        }
        ServerHttpResponse response = ((ISpringWebReactiveContext)context).getResponse();
        return response.encodeUrl(link);
    }
}

