/*
 * Decompiled with CFR 0.152.
 */
package org.thymeleaf.spring5.context.webflux;

import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.TimeZone;
import org.springframework.context.MessageSource;
import org.springframework.context.MessageSourceResolvable;
import org.springframework.context.NoSuchMessageException;
import org.springframework.ui.context.Theme;
import org.springframework.validation.Errors;
import org.springframework.web.reactive.result.view.RequestContext;
import org.springframework.web.server.ServerWebExchange;
import org.thymeleaf.exceptions.TemplateProcessingException;
import org.thymeleaf.spring5.context.IThymeleafBindStatus;
import org.thymeleaf.spring5.context.IThymeleafRequestContext;
import org.thymeleaf.spring5.context.IThymeleafRequestDataValueProcessor;
import org.thymeleaf.spring5.context.webflux.SpringWebFluxThymeleafBindStatus;
import org.thymeleaf.spring5.context.webflux.SpringWebFluxThymeleafRequestDataValueProcessor;
import org.thymeleaf.util.Validate;

public class SpringWebFluxThymeleafRequestContext
implements IThymeleafRequestContext {
    private final RequestContext requestContext;
    private final ServerWebExchange serverWebExchange;
    private final SpringWebFluxThymeleafRequestDataValueProcessor thymeleafRequestDataValueProcessor;

    public SpringWebFluxThymeleafRequestContext(RequestContext requestContext, ServerWebExchange serverWebExchange) {
        Validate.notNull((Object)requestContext, (String)"Spring WebFlux RequestContext cannot be null");
        Validate.notNull((Object)serverWebExchange, (String)"Server Web Exchange cannot be null");
        this.requestContext = requestContext;
        this.serverWebExchange = serverWebExchange;
        this.thymeleafRequestDataValueProcessor = new SpringWebFluxThymeleafRequestDataValueProcessor(this.requestContext.getRequestDataValueProcessor(), this.serverWebExchange);
    }

    public ServerWebExchange getServerWebExchange() {
        return this.serverWebExchange;
    }

    @Override
    public MessageSource getMessageSource() {
        return this.requestContext.getMessageSource();
    }

    @Override
    public Map<String, Object> getModel() {
        return this.requestContext.getModel();
    }

    @Override
    public Locale getLocale() {
        return this.requestContext.getLocale();
    }

    @Override
    public TimeZone getTimeZone() {
        return this.requestContext.getTimeZone();
    }

    @Override
    public void changeLocale(Locale locale) {
        this.requestContext.changeLocale(locale);
    }

    @Override
    public void changeLocale(Locale locale, TimeZone timeZone) {
        this.requestContext.changeLocale(locale, timeZone);
    }

    @Override
    public void setDefaultHtmlEscape(boolean defaultHtmlEscape) {
        this.requestContext.setDefaultHtmlEscape(defaultHtmlEscape);
    }

    @Override
    public boolean isDefaultHtmlEscape() {
        return this.requestContext.isDefaultHtmlEscape();
    }

    @Override
    public Boolean getDefaultHtmlEscape() {
        return this.requestContext.getDefaultHtmlEscape();
    }

    @Override
    public String getContextPath() {
        return this.requestContext.getContextPath();
    }

    @Override
    public String getContextUrl(String relativeUrl) {
        return this.requestContext.getContextUrl(relativeUrl);
    }

    @Override
    public String getContextUrl(String relativeUrl, Map<String, ?> params) {
        return this.requestContext.getContextUrl(relativeUrl, params);
    }

    @Override
    public String getRequestPath() {
        return this.requestContext.getRequestPath();
    }

    @Override
    public String getQueryString() {
        return this.requestContext.getQueryString();
    }

    @Override
    public String getMessage(String code, String defaultMessage) {
        return this.requestContext.getMessage(code, defaultMessage);
    }

    @Override
    public String getMessage(String code, Object[] args, String defaultMessage) {
        return this.requestContext.getMessage(code, args, defaultMessage);
    }

    @Override
    public String getMessage(String code, List<?> args, String defaultMessage) {
        return this.requestContext.getMessage(code, args, defaultMessage);
    }

    @Override
    public String getMessage(String code, Object[] args, String defaultMessage, boolean htmlEscape) {
        return this.requestContext.getMessage(code, args, defaultMessage, htmlEscape);
    }

    @Override
    public String getMessage(String code) throws NoSuchMessageException {
        return this.requestContext.getMessage(code);
    }

    @Override
    public String getMessage(String code, Object[] args) throws NoSuchMessageException {
        return this.requestContext.getMessage(code, args);
    }

    @Override
    public String getMessage(String code, List<?> args) throws NoSuchMessageException {
        return this.requestContext.getMessage(code, args);
    }

    @Override
    public String getMessage(String code, Object[] args, boolean htmlEscape) throws NoSuchMessageException {
        return this.requestContext.getMessage(code, args, htmlEscape);
    }

    @Override
    public String getMessage(MessageSourceResolvable resolvable) throws NoSuchMessageException {
        return this.requestContext.getMessage(resolvable);
    }

    @Override
    public String getMessage(MessageSourceResolvable resolvable, boolean htmlEscape) throws NoSuchMessageException {
        return this.requestContext.getMessage(resolvable, htmlEscape);
    }

    @Override
    public Optional<Errors> getErrors(String name) {
        return this.requestContext.getErrors(name);
    }

    @Override
    public Optional<Errors> getErrors(String name, boolean htmlEscape) {
        return this.requestContext.getErrors(name, htmlEscape);
    }

    @Override
    public Theme getTheme() {
        throw new TemplateProcessingException("Themes are not supported in Thymeleaf's Spring WebFlux integration");
    }

    @Override
    public IThymeleafRequestDataValueProcessor getRequestDataValueProcessor() {
        return this.thymeleafRequestDataValueProcessor;
    }

    @Override
    public IThymeleafBindStatus getBindStatus(String path) throws IllegalStateException {
        return Optional.ofNullable(this.requestContext.getBindStatus(path)).map(SpringWebFluxThymeleafBindStatus::new).orElse(null);
    }

    @Override
    public IThymeleafBindStatus getBindStatus(String path, boolean htmlEscape) throws IllegalStateException {
        return Optional.ofNullable(this.requestContext.getBindStatus(path, htmlEscape)).map(SpringWebFluxThymeleafBindStatus::new).orElse(null);
    }

    public String toString() {
        return this.requestContext.toString();
    }
}

