/*
 * Decompiled with CFR 0.152.
 */
package org.thymeleaf.spring5.context.webflux;

import org.reactivestreams.Publisher;
import org.springframework.core.ReactiveAdapterRegistry;
import org.thymeleaf.spring5.context.webflux.IReactiveSSEDataDriverContextVariable;
import org.thymeleaf.spring5.context.webflux.ReactiveContextVariableUtils;
import org.thymeleaf.util.Validate;
import reactor.core.publisher.Flux;

public class ReactiveDataDriverContextVariable
implements IReactiveSSEDataDriverContextVariable {
    public static final int DEFAULT_DATA_DRIVER_BUFFER_SIZE_ELEMENTS = 100;
    public static final long DEFAULT_FIRST_EVENT_ID = 0L;
    private final Object dataStream;
    private final int dataStreamBufferSizeElements;
    private final long firstEventID;
    private ReactiveAdapterRegistry adapterRegistry;

    public ReactiveDataDriverContextVariable(Object dataStream) {
        this(dataStream, 100, 0L);
    }

    public ReactiveDataDriverContextVariable(Object dataStream, int dataStreamBufferSizeElements) {
        this(dataStream, dataStreamBufferSizeElements, 0L);
    }

    public ReactiveDataDriverContextVariable(Object dataStream, int dataStreamBufferSizeElements, long firstEventID) {
        Validate.notNull((Object)dataStream, (String)"Data stream cannot be null");
        Validate.isTrue((dataStreamBufferSizeElements > 0 ? 1 : 0) != 0, (String)"Data Buffer Size cannot be <= 0");
        Validate.isTrue((firstEventID >= 0L ? 1 : 0) != 0, (String)"First Event ID cannot be < 0");
        this.dataStream = dataStream;
        this.dataStreamBufferSizeElements = dataStreamBufferSizeElements;
        this.firstEventID = firstEventID;
    }

    public final void setReactiveAdapterRegistry(ReactiveAdapterRegistry reactiveAdapterRegistry) {
        this.adapterRegistry = reactiveAdapterRegistry;
    }

    @Override
    public Publisher<Object> getDataStream() {
        Publisher<Object> publisher = ReactiveContextVariableUtils.computePublisherValue(this.dataStream, this.adapterRegistry);
        if (!(publisher instanceof Flux)) {
            throw new IllegalArgumentException("Reactive Data Driver context variable was set single-valued aynchronous object. But data driver variables must wrap multi-valued data streams (so that they can be iterated at the template");
        }
        return publisher;
    }

    @Override
    public final int getBufferSizeElements() {
        return this.dataStreamBufferSizeElements;
    }

    @Override
    public final long getFirstEventID() {
        return this.firstEventID;
    }
}

