/*
 * Decompiled with CFR 0.152.
 */
package org.thymeleaf.spring5.web.webflux;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.springframework.http.HttpCookie;
import org.springframework.util.MultiValueMap;

final class MultiValueMapUtil {
    static Map<String, String[]> stringToStringArrayMultiMap(MultiValueMap<String, String> multiValueMap) {
        if (multiValueMap == null) {
            return null;
        }
        LinkedHashMap<String, String[]> stringArrayMap = new LinkedHashMap<String, String[]>(multiValueMap.size() + 1, 1.0f);
        for (Map.Entry multiValueMapEntry : multiValueMap.entrySet()) {
            List multiValueMapEntryValue = (List)multiValueMapEntry.getValue();
            stringArrayMap.put((String)multiValueMapEntry.getKey(), ((List)multiValueMapEntry.getValue()).toArray(new String[multiValueMapEntryValue.size()]));
        }
        return Collections.unmodifiableMap(stringArrayMap);
    }

    static Map<String, String[]> cookieToStringArrayMultiMap(MultiValueMap<String, HttpCookie> multiValueMap) {
        if (multiValueMap == null) {
            return null;
        }
        LinkedHashMap<String, String[]> stringArrayMap = new LinkedHashMap<String, String[]>(multiValueMap.size() + 1, 1.0f);
        for (Map.Entry multiValueMapEntry : multiValueMap.entrySet()) {
            stringArrayMap.put((String)multiValueMapEntry.getKey(), (String[])((List)multiValueMapEntry.getValue()).stream().map(HttpCookie::getValue).toArray(String[]::new));
        }
        return Collections.unmodifiableMap(stringArrayMap);
    }

    private MultiValueMapUtil() {
    }
}

