/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.svnclientadapter.javahl;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import org.apache.subversion.javahl.ClientException;
import org.apache.subversion.javahl.ConflictResult;
import org.apache.subversion.javahl.ISVNClient;
import org.apache.subversion.javahl.SubversionException;
import org.apache.subversion.javahl.callback.BlameCallback;
import org.apache.subversion.javahl.callback.CommitCallback;
import org.apache.subversion.javahl.callback.CommitMessageCallback;
import org.apache.subversion.javahl.callback.ConflictResolverCallback;
import org.apache.subversion.javahl.callback.DiffSummaryCallback;
import org.apache.subversion.javahl.callback.InfoCallback;
import org.apache.subversion.javahl.callback.InheritedProplistCallback;
import org.apache.subversion.javahl.callback.ListCallback;
import org.apache.subversion.javahl.callback.LogMessageCallback;
import org.apache.subversion.javahl.callback.ProplistCallback;
import org.apache.subversion.javahl.callback.StatusCallback;
import org.apache.subversion.javahl.callback.UserPasswordCallback;
import org.apache.subversion.javahl.types.CopySource;
import org.apache.subversion.javahl.types.Depth;
import org.apache.subversion.javahl.types.DirEntry;
import org.apache.subversion.javahl.types.Lock;
import org.apache.subversion.javahl.types.Mergeinfo;
import org.apache.subversion.javahl.types.NodeKind;
import org.apache.subversion.javahl.types.Revision;
import org.apache.subversion.javahl.types.RevisionRange;
import org.apache.subversion.javahl.types.Status;
import org.tigris.subversion.svnclientadapter.AbstractClientAdapter;
import org.tigris.subversion.svnclientadapter.ISVNAnnotations;
import org.tigris.subversion.svnclientadapter.ISVNConflictResolver;
import org.tigris.subversion.svnclientadapter.ISVNDirEntry;
import org.tigris.subversion.svnclientadapter.ISVNDirEntryWithLock;
import org.tigris.subversion.svnclientadapter.ISVNInfo;
import org.tigris.subversion.svnclientadapter.ISVNLogMessage;
import org.tigris.subversion.svnclientadapter.ISVNLogMessageCallback;
import org.tigris.subversion.svnclientadapter.ISVNMergeInfo;
import org.tigris.subversion.svnclientadapter.ISVNNotifyListener;
import org.tigris.subversion.svnclientadapter.ISVNProgressListener;
import org.tigris.subversion.svnclientadapter.ISVNPromptUserPassword;
import org.tigris.subversion.svnclientadapter.ISVNProperty;
import org.tigris.subversion.svnclientadapter.ISVNStatus;
import org.tigris.subversion.svnclientadapter.ISVNStatusCallback;
import org.tigris.subversion.svnclientadapter.SVNBaseDir;
import org.tigris.subversion.svnclientadapter.SVNClientException;
import org.tigris.subversion.svnclientadapter.SVNDiffSummary;
import org.tigris.subversion.svnclientadapter.SVNInfoUnversioned;
import org.tigris.subversion.svnclientadapter.SVNLogMessageCallback;
import org.tigris.subversion.svnclientadapter.SVNNodeKind;
import org.tigris.subversion.svnclientadapter.SVNNotificationHandler;
import org.tigris.subversion.svnclientadapter.SVNRevision;
import org.tigris.subversion.svnclientadapter.SVNRevisionRange;
import org.tigris.subversion.svnclientadapter.SVNScheduleKind;
import org.tigris.subversion.svnclientadapter.SVNStatusKind;
import org.tigris.subversion.svnclientadapter.SVNStatusUnversioned;
import org.tigris.subversion.svnclientadapter.SVNUrl;
import org.tigris.subversion.svnclientadapter.javahl.InheritedJhlProplistCallback;
import org.tigris.subversion.svnclientadapter.javahl.JhlAnnotations;
import org.tigris.subversion.svnclientadapter.javahl.JhlCommitCallback;
import org.tigris.subversion.svnclientadapter.javahl.JhlCommitMessage;
import org.tigris.subversion.svnclientadapter.javahl.JhlConflictResolver;
import org.tigris.subversion.svnclientadapter.javahl.JhlConverter;
import org.tigris.subversion.svnclientadapter.javahl.JhlDiffSummaryReceiver;
import org.tigris.subversion.svnclientadapter.javahl.JhlDirEntry;
import org.tigris.subversion.svnclientadapter.javahl.JhlDirEntryWithLock;
import org.tigris.subversion.svnclientadapter.javahl.JhlInfoCallback;
import org.tigris.subversion.svnclientadapter.javahl.JhlLogMessageCallback;
import org.tigris.subversion.svnclientadapter.javahl.JhlMergeInfo;
import org.tigris.subversion.svnclientadapter.javahl.JhlNotificationHandler;
import org.tigris.subversion.svnclientadapter.javahl.JhlProgressListener;
import org.tigris.subversion.svnclientadapter.javahl.JhlPromptUserPassword;
import org.tigris.subversion.svnclientadapter.javahl.JhlPropertyData;
import org.tigris.subversion.svnclientadapter.javahl.JhlProplistCallback;
import org.tigris.subversion.svnclientadapter.javahl.JhlStatus;
import org.tigris.subversion.svnclientadapter.javahl.JhlStatusCallback;
import org.tigris.subversion.svnclientadapter.javahl.SVNUrlWithPegRevision;
import org.tigris.subversion.svnclientadapter.utils.Messages;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractJhlClientAdapter
extends AbstractClientAdapter {
    protected ISVNClient svnClient;
    protected JhlNotificationHandler notificationHandler;
    protected JhlConflictResolver conflictResolver;
    protected JhlProgressListener progressListener;
    private String postCommitError;

    public ISVNClient getSVNClient() {
        return this.svnClient;
    }

    @Override
    public void addNotifyListener(ISVNNotifyListener listener) {
        this.notificationHandler.add(listener);
    }

    @Override
    public void removeNotifyListener(ISVNNotifyListener listener) {
        this.notificationHandler.remove(listener);
    }

    @Override
    public SVNNotificationHandler getNotificationHandler() {
        return this.notificationHandler;
    }

    @Override
    public void setUsername(String username) {
        this.svnClient.username(username);
    }

    @Override
    public void setPassword(String password) {
        this.notificationHandler.setCommand(0);
        this.svnClient.password(password);
    }

    public void setPromptUserPassword(UserPasswordCallback prompt) {
        this.svnClient.setPrompt(prompt);
    }

    protected static String fileToSVNPath(File file, boolean canonical) {
        if (file == null) {
            return null;
        }
        if (canonical) {
            try {
                return file.getCanonicalPath().replace('\\', '/');
            }
            catch (IOException e) {
                return null;
            }
        }
        return file.getPath().replace('\\', '/');
    }

    @Override
    public void addFile(File file) throws SVNClientException {
        try {
            this.notificationHandler.setCommand(1);
            this.notificationHandler.logCommandLine("add -N " + file.toString());
            this.notificationHandler.setBaseDir(SVNBaseDir.getBaseDir(file));
            this.svnClient.add(AbstractJhlClientAdapter.fileToSVNPath(file, false), Depth.infinity, false, true, true);
        }
        catch (ClientException e) {
            this.notificationHandler.logException((Exception)((Object)e));
            throw new SVNClientException(e);
        }
    }

    @Override
    public void addDirectory(File file, boolean recurse) throws SVNClientException {
        this.addDirectory(file, recurse, false);
    }

    @Override
    public void addDirectory(File dir, boolean recurse, boolean force) throws SVNClientException {
        try {
            this.notificationHandler.setCommand(1);
            this.notificationHandler.logCommandLine("add" + (recurse ? "" : " -N") + (force ? " --force" : "") + " " + dir.toString());
            this.notificationHandler.setBaseDir(SVNBaseDir.getBaseDir(dir));
            boolean noIgnores = false;
            boolean addParents = true;
            this.svnClient.add(AbstractJhlClientAdapter.fileToSVNPath(dir, false), Depth.infinityOrEmpty((boolean)recurse), force, noIgnores, addParents);
        }
        catch (ClientException e) {
            this.notificationHandler.logException((Exception)((Object)e));
            throw new SVNClientException(e);
        }
    }

    @Override
    public void checkout(SVNUrl moduleName, File destPath, SVNRevision revision, boolean recurse) throws SVNClientException {
        this.checkout(moduleName, destPath, revision, Depth.infinityOrImmediates((boolean)recurse).ordinal(), false, true);
    }

    @Override
    public void checkout(SVNUrl moduleName, File destPath, SVNRevision revision, int depth, boolean ignoreExternals, boolean force) throws SVNClientException {
        try {
            String url = moduleName.toString();
            Depth d = JhlConverter.depth(depth);
            this.notificationHandler.setCommand(2);
            StringBuffer commandLine = new StringBuffer("checkout " + url + " -r " + revision.toString() + this.depthCommandLine(d));
            if (ignoreExternals) {
                commandLine.append(" --ignore-externals");
            }
            if (force) {
                commandLine.append(" --force");
            }
            this.notificationHandler.logCommandLine(commandLine.toString());
            this.notificationHandler.setBaseDir(new File("."));
            this.svnClient.checkout(url, AbstractJhlClientAdapter.fileToSVNPath(destPath, false), JhlConverter.convert(revision), JhlConverter.convert(revision), d, ignoreExternals, force);
        }
        catch (ClientException e) {
            this.notificationHandler.logException((Exception)((Object)e));
            throw new SVNClientException(e);
        }
    }

    @Override
    public long commit(File[] paths, String message, boolean recurse) throws SVNClientException {
        return this.commit(paths, message, recurse, false);
    }

    @Override
    public long commit(File[] paths, String message, boolean recurse, boolean keepLocks) throws SVNClientException {
        try {
            this.postCommitError = null;
            String fixedMessage = this.fixSVNString(message);
            if (fixedMessage == null) {
                fixedMessage = "";
            }
            this.notificationHandler.setCommand(3);
            HashSet<String> files = new HashSet<String>(paths.length);
            String commandLine = "commit -m \"" + this.getFirstMessageLine(fixedMessage) + "\"";
            if (!recurse) {
                commandLine = commandLine + " -N";
            }
            if (keepLocks) {
                commandLine = commandLine + " --no-unlock";
            }
            for (int i = 0; i < paths.length; ++i) {
                files.add(AbstractJhlClientAdapter.fileToSVNPath(paths[i], false));
            }
            commandLine = this.appendPaths(commandLine, files);
            this.notificationHandler.logCommandLine(commandLine);
            this.notificationHandler.setBaseDir(SVNBaseDir.getBaseDir(paths));
            boolean keepChangeLists = false;
            JhlCommitCallback callback = new JhlCommitCallback();
            this.svnClient.commit(files, Depth.infinityOrEmpty((boolean)recurse), keepLocks, keepChangeLists, null, null, (CommitMessageCallback)new JhlCommitMessage(fixedMessage), (CommitCallback)callback);
            this.postCommitError = callback.getPostCommitError();
            long newRev = callback.getRevision();
            if (newRev > 0L) {
                this.notificationHandler.logCompleted("Committed revision " + newRev + ".");
            }
            return newRev;
        }
        catch (ClientException e) {
            this.notificationHandler.logException((Exception)((Object)e));
            throw new SVNClientException(e);
        }
    }

    @Override
    public String getPostCommitError() {
        return this.postCommitError;
    }

    @Override
    public ISVNDirEntry[] getList(SVNUrl url, SVNRevision revision, boolean recurse) throws SVNClientException {
        String target = url.toString();
        return this.list(target, revision, SVNRevision.HEAD, recurse);
    }

    @Override
    public ISVNDirEntry[] getList(SVNUrl url, SVNRevision revision, SVNRevision pegRevision, boolean recurse) throws SVNClientException {
        String target = url.toString();
        return this.list(target, revision, pegRevision, recurse);
    }

    @Override
    public ISVNDirEntry[] getList(File path, SVNRevision revision, boolean recurse) throws SVNClientException {
        String target = AbstractJhlClientAdapter.fileToSVNPath(path, false);
        return this.list(target, revision, SVNRevision.HEAD, recurse);
    }

    @Override
    public ISVNDirEntry[] getList(File path, SVNRevision revision, SVNRevision pegRevision, boolean recurse) throws SVNClientException {
        String target = AbstractJhlClientAdapter.fileToSVNPath(path, false);
        return this.list(target, revision, pegRevision, recurse);
    }

    private ISVNDirEntry[] list(String path, SVNRevision revision, SVNRevision pegRevision, boolean recurse) throws SVNClientException {
        final ArrayList dirEntryList = new ArrayList();
        ListCallback callback = new ListCallback(){

            public void doEntry(DirEntry dirent, Lock lock) {
                if (dirent.getPath().length() == 0) {
                    if (dirent.getNodeKind() == NodeKind.file) {
                        String absPath = dirent.getAbsPath();
                        int lastSeparator = absPath.lastIndexOf(47);
                        String path = absPath.substring(lastSeparator, absPath.length());
                        dirent.setPath(path);
                    } else {
                        return;
                    }
                }
                dirEntryList.add(new JhlDirEntry(dirent));
            }
        };
        try {
            this.notificationHandler.setCommand(11);
            String commandLine = "list -r " + revision.toString() + (recurse ? "-R" : "") + " " + path;
            this.notificationHandler.logCommandLine(commandLine);
            this.notificationHandler.setBaseDir(new File("."));
            this.svnClient.list(path, JhlConverter.convert(revision), JhlConverter.convert(pegRevision), Depth.infinityOrImmediates((boolean)recurse), -1, false, callback);
        }
        catch (ClientException e) {
            this.notificationHandler.logException((Exception)((Object)e));
            throw new SVNClientException(e);
        }
        ISVNDirEntry[] dirEntries = new ISVNDirEntry[dirEntryList.size()];
        dirEntryList.toArray(dirEntries);
        return dirEntries;
    }

    @Override
    public ISVNDirEntryWithLock[] getListWithLocks(SVNUrl url, SVNRevision revision, SVNRevision pegRevision, boolean recurse) throws SVNClientException {
        final ArrayList dirEntryList = new ArrayList();
        ListCallback callback = new ListCallback(){

            public void doEntry(DirEntry dirent, Lock lock) {
                if (dirent.getPath().length() == 0) {
                    if (dirent.getNodeKind() == NodeKind.file) {
                        String absPath = dirent.getAbsPath();
                        int lastSeparator = absPath.lastIndexOf(47);
                        String path = absPath.substring(lastSeparator, absPath.length());
                        dirent.setPath(path);
                    } else {
                        return;
                    }
                }
                dirEntryList.add(new JhlDirEntryWithLock(dirent, lock));
            }
        };
        try {
            this.notificationHandler.setCommand(11);
            String commandLine = "list -r " + revision.toString() + (recurse ? "-R" : "") + " " + url.toString();
            this.notificationHandler.logCommandLine(commandLine);
            this.notificationHandler.setBaseDir(new File("."));
            this.svnClient.list(url.toString(), JhlConverter.convert(revision), JhlConverter.convert(pegRevision), Depth.infinityOrImmediates((boolean)recurse), -1, true, callback);
        }
        catch (ClientException e) {
            this.notificationHandler.logException((Exception)((Object)e));
            throw new SVNClientException(e);
        }
        ISVNDirEntryWithLock[] dirEntries = new ISVNDirEntryWithLock[dirEntryList.size()];
        dirEntryList.toArray(dirEntries);
        return dirEntries;
    }

    @Override
    public ISVNDirEntry getDirEntry(SVNUrl url, SVNRevision revision) throws SVNClientException {
        ISVNDirEntry[] entries = this.getList(url.getParent(), revision, false);
        String expectedPath = url.getLastPathSegment();
        for (int i = 0; i < entries.length; ++i) {
            if (!entries[i].getPath().equals(expectedPath)) continue;
            return entries[i];
        }
        return null;
    }

    @Override
    public ISVNDirEntry getDirEntry(File path, SVNRevision revision) throws SVNClientException {
        ISVNDirEntry[] entries = this.getList(path.getParentFile(), revision, false);
        String expectedPath = path.getName();
        for (int i = 0; i < entries.length; ++i) {
            if (!entries[i].getPath().equals(expectedPath)) continue;
            return entries[i];
        }
        return null;
    }

    @Override
    public ISVNStatus getSingleStatus(File path) throws SVNClientException {
        return this.getStatus(new File[]{path})[0];
    }

    @Override
    public ISVNStatus[] getStatus(File[] path) throws SVNClientException {
        ISVNStatus[] statuses = new ISVNStatus[path.length];
        for (int i = 0; i < path.length; ++i) {
            ISVNStatus[] s = this.getStatus(path[i], false, true, false, false);
            statuses[i] = s == null || s.length == 0 ? new SVNStatusUnversioned(path[i]) : s[0];
        }
        return statuses;
    }

    @Override
    public ISVNStatus[] getStatus(File path, boolean descend, boolean getAll) throws SVNClientException {
        return this.getStatus(path, descend, getAll, false);
    }

    @Override
    public ISVNStatus[] getStatus(File path, boolean descend, boolean getAll, boolean contactServer) throws SVNClientException {
        return this.getStatus(path, descend, getAll, contactServer, false);
    }

    @Override
    public ISVNStatus[] getStatus(File path, boolean descend, boolean getAll, boolean contactServer, boolean ignoreExternals) throws SVNClientException {
        return this.getStatus(path, descend, getAll, contactServer, ignoreExternals, null);
    }

    @Override
    public ISVNStatus[] getStatus(File path, boolean descend, boolean getAll, boolean contactServer, boolean ignoreExternals, ISVNStatusCallback callback) throws SVNClientException {
        return this.getStatus(path, descend, getAll, contactServer, ignoreExternals, true, callback);
    }

    @Override
    public ISVNStatus[] getStatus(File path, boolean descend, boolean getAll, boolean contactServer, boolean ignoreExternals, boolean noIgnore, ISVNStatusCallback callback) throws SVNClientException {
        this.notificationHandler.setCommand(12);
        String filePathSVN = AbstractJhlClientAdapter.fileToSVNPath(path, false);
        Depth depth = Depth.unknownOrImmediates((boolean)descend);
        this.notificationHandler.logCommandLine("status" + (contactServer ? " -u" : "") + this.depthCommandLine(depth) + " " + filePathSVN);
        this.notificationHandler.setBaseDir(SVNBaseDir.getBaseDir(path));
        try {
            Object statusCallback = callback == null ? new MyStatusCallback() : new JhlStatusCallback(callback);
            this.svnClient.status(filePathSVN, depth, contactServer, getAll, noIgnore, ignoreExternals, null, (StatusCallback)statusCallback);
            List<Status> statusList = null;
            statusList = statusCallback instanceof MyStatusCallback ? ((MyStatusCallback)statusCallback).getStatusList() : ((JhlStatusCallback)statusCallback).getStatusList();
            return this.processFolderStatuses(this.processExternalStatuses(JhlConverter.convertStatus(statusList, this.svnClient)), getAll, contactServer);
        }
        catch (ClientException e) {
            if (e.getAprError() == 155007 || e.getAprError() == 155010) {
                return new ISVNStatus[]{new SVNStatusUnversioned(path)};
            }
            this.notificationHandler.logException((Exception)((Object)e));
            throw new SVNClientException(e);
        }
    }

    protected JhlStatus[] processExternalStatuses(JhlStatus[] statuses) throws SVNClientException {
        ArrayList<Integer> externalStatusesIndexes = new ArrayList<Integer>();
        for (int i = 0; i < statuses.length; ++i) {
            if (!SVNStatusKind.EXTERNAL.equals(statuses[i].getTextStatus())) continue;
            externalStatusesIndexes.add(new Integer(i));
        }
        if (externalStatusesIndexes.isEmpty()) {
            return statuses;
        }
        for (Integer integer : externalStatusesIndexes) {
            int index = integer;
            JhlStatus jhlStatus = statuses[index];
            for (int i = 0; i < statuses.length; ++i) {
                if (statuses[i].getPath() == null || !statuses[i].getPath().equals(jhlStatus.getPath())) continue;
                statuses[i] = new JhlStatus.JhlStatusExternal(statuses[i], this.svnClient);
                statuses[index] = statuses[i];
            }
        }
        return statuses;
    }

    protected ISVNStatus[] processFolderStatuses(JhlStatus[] statuses, boolean getAll, boolean contactServer) throws SVNClientException {
        JhlStatus jhlStatus;
        int i;
        if (!getAll || !contactServer) {
            return statuses;
        }
        ArrayList<JhlStatus> folders = new ArrayList<JhlStatus>();
        for (i = 0; i < statuses.length; ++i) {
            jhlStatus = statuses[i];
            if (SVNNodeKind.DIR != jhlStatus.getNodeKind() || jhlStatus.getReposLastChangedRevision() != null) continue;
            folders.add(jhlStatus);
        }
        for (i = 0; i < statuses.length; ++i) {
            jhlStatus = statuses[i];
            if (jhlStatus.getLastChangedRevision() == null) continue;
            for (JhlStatus folder : folders) {
                if (jhlStatus.getUrlString() == null || !jhlStatus.getUrlString().startsWith(folder.getUrlString() + "/") || folder.getLastChangedRevision() != null && folder.getLastChangedRevision().getNumber() >= jhlStatus.getLastChangedRevision().getNumber()) continue;
                folder.updateFromStatus(jhlStatus);
            }
        }
        return statuses;
    }

    @Override
    public void copy(File srcPath, File destPath) throws SVNClientException {
        try {
            this.notificationHandler.setCommand(6);
            String src = AbstractJhlClientAdapter.fileToSVNPath(srcPath, false);
            String dest = AbstractJhlClientAdapter.fileToSVNPath(destPath, false);
            this.notificationHandler.logCommandLine("copy " + src + " " + dest);
            this.notificationHandler.setBaseDir(SVNBaseDir.getBaseDir(new File[]{srcPath, destPath}));
            ArrayList<CopySource> copySources = new ArrayList<CopySource>();
            copySources.add(new CopySource(src, Revision.WORKING, Revision.WORKING));
            this.svnClient.copy(copySources, dest, true, true, false, null, null, null);
        }
        catch (ClientException e) {
            this.notificationHandler.logException((Exception)((Object)e));
            throw new SVNClientException(e);
        }
    }

    @Override
    public void copy(File srcPath, SVNUrl destUrl, String message) throws SVNClientException {
        try {
            String fixedMessage = this.fixSVNString(message);
            if (fixedMessage == null) {
                fixedMessage = "";
            }
            this.notificationHandler.setCommand(6);
            String src = AbstractJhlClientAdapter.fileToSVNPath(srcPath, false);
            String dest = destUrl.toString();
            this.notificationHandler.logCommandLine("copy " + src + " " + dest);
            this.notificationHandler.setBaseDir(SVNBaseDir.getBaseDir(srcPath));
            ArrayList<CopySource> copySources = new ArrayList<CopySource>();
            copySources.add(new CopySource(src, Revision.WORKING, Revision.WORKING));
            this.svnClient.copy(copySources, dest, true, true, true, null, (CommitMessageCallback)new JhlCommitMessage(fixedMessage), null);
        }
        catch (ClientException e) {
            this.notificationHandler.logException((Exception)((Object)e));
            throw new SVNClientException(e);
        }
    }

    @Override
    public void copy(File[] srcPaths, SVNUrl destUrl, String message, boolean copyAsChild, boolean makeParents) throws SVNClientException {
        String fixedMessage = this.fixSVNString(message);
        if (srcPaths.length > 1) {
            this.mkdir(destUrl, makeParents, fixedMessage);
            for (int i = 0; i < srcPaths.length; ++i) {
                File[] file = new File[]{srcPaths[i]};
                this.copy(file, destUrl, fixedMessage, copyAsChild, makeParents);
            }
            return;
        }
        try {
            if (fixedMessage == null) {
                fixedMessage = "";
            }
            this.notificationHandler.setCommand(6);
            ArrayList<CopySource> copySources = new ArrayList<CopySource>(srcPaths.length);
            for (int i = 0; i < srcPaths.length; ++i) {
                copySources.add(new CopySource(AbstractJhlClientAdapter.fileToSVNPath(srcPaths[i], false), Revision.WORKING, Revision.WORKING));
            }
            String dest = destUrl.toString();
            String commandLine = "copy";
            HashSet<String> paths = new HashSet<String>(srcPaths.length);
            for (int i = 0; i < srcPaths.length; ++i) {
                paths.add(AbstractJhlClientAdapter.fileToSVNPath(srcPaths[i], false));
            }
            commandLine = this.appendPaths(commandLine, paths) + " " + dest;
            this.notificationHandler.logCommandLine(commandLine.toString());
            this.notificationHandler.setBaseDir();
            this.svnClient.copy(copySources, dest, copyAsChild, makeParents, true, null, (CommitMessageCallback)new JhlCommitMessage(fixedMessage), null);
        }
        catch (ClientException e) {
            this.notificationHandler.logException((Exception)((Object)e));
            throw new SVNClientException(e);
        }
    }

    @Override
    public void copy(SVNUrl srcUrl, File destPath, SVNRevision revision) throws SVNClientException {
        this.copy(srcUrl, destPath, revision, true, false);
    }

    @Override
    public void copy(SVNUrl srcUrl, File destPath, SVNRevision revision, boolean copyAsChild, boolean makeParents) throws SVNClientException {
        this.copy(srcUrl, destPath, revision, SVNRevision.HEAD, copyAsChild, makeParents);
    }

    @Override
    public void copy(SVNUrl srcUrl, File destPath, SVNRevision revision, SVNRevision pegRevision, boolean copyAsChild, boolean makeParents) throws SVNClientException {
        try {
            this.notificationHandler.setCommand(6);
            String dest = AbstractJhlClientAdapter.fileToSVNPath(destPath, false);
            ArrayList<CopySource> copySources = new ArrayList<CopySource>();
            copySources.add(new CopySource(srcUrl.toString(), JhlConverter.convert(revision), JhlConverter.convert(pegRevision)));
            this.notificationHandler.logCommandLine("copy " + srcUrl + " " + dest);
            this.notificationHandler.setBaseDir(SVNBaseDir.getBaseDir(destPath));
            this.svnClient.copy(copySources, dest, copyAsChild, makeParents, true, null, null, null);
        }
        catch (ClientException e) {
            this.notificationHandler.logException((Exception)((Object)e));
            throw new SVNClientException(e);
        }
    }

    @Override
    public void copy(SVNUrl srcUrl, SVNUrl destUrl, String message, SVNRevision revision) throws SVNClientException {
        this.copy(srcUrl, destUrl, message, revision, false);
    }

    @Override
    public void copy(SVNUrl srcUrl, SVNUrl destUrl, String message, SVNRevision revision, boolean makeParents) throws SVNClientException {
        this.copy(new SVNUrl[]{srcUrl}, destUrl, message, revision, true, makeParents);
    }

    @Override
    public void copy(SVNUrl[] srcUrls, SVNUrl destUrl, String message, SVNRevision revision, boolean copyAsChild, boolean makeParents) throws SVNClientException {
        try {
            String fixedMessage = this.fixSVNString(message);
            if (fixedMessage == null) {
                fixedMessage = "";
            }
            this.notificationHandler.setCommand(6);
            ArrayList<CopySource> copySources = new ArrayList<CopySource>(srcUrls.length);
            for (int i = 0; i < srcUrls.length; ++i) {
                copySources.add(new CopySource(srcUrls[i].toString(), JhlConverter.convert(revision), JhlConverter.convert(SVNRevision.HEAD)));
            }
            String dest = destUrl.toString();
            String commandLine = "copy -r" + revision.toString();
            HashSet<String> paths = new HashSet<String>(srcUrls.length);
            for (int i = 0; i < srcUrls.length; ++i) {
                paths.add(srcUrls[i].toString());
            }
            commandLine = this.appendPaths(commandLine, paths) + " " + dest;
            this.notificationHandler.logCommandLine(commandLine);
            this.notificationHandler.setBaseDir();
            this.svnClient.copy(copySources, dest, copyAsChild, makeParents, true, null, (CommitMessageCallback)new JhlCommitMessage(fixedMessage), null);
        }
        catch (ClientException e) {
            this.notificationHandler.logException((Exception)((Object)e));
            throw new SVNClientException(e);
        }
    }

    @Override
    public void remove(SVNUrl[] url, String message) throws SVNClientException {
        try {
            String fixedMessage = this.fixSVNString(message);
            if (fixedMessage == null) {
                fixedMessage = "";
            }
            this.notificationHandler.setCommand(7);
            String commandLine = "delete -m \"" + this.getFirstMessageLine(fixedMessage) + "\"";
            HashSet<String> targets = new HashSet<String>(url.length);
            for (int i = 0; i < url.length; ++i) {
                targets.add(url[i].toString());
            }
            commandLine = this.appendPaths(commandLine, targets);
            this.notificationHandler.logCommandLine(commandLine);
            this.notificationHandler.setBaseDir();
            this.svnClient.remove(targets, false, false, null, (CommitMessageCallback)new JhlCommitMessage(fixedMessage), null);
        }
        catch (ClientException e) {
            this.notificationHandler.logException((Exception)((Object)e));
            throw new SVNClientException(e);
        }
    }

    @Override
    public void remove(File[] file, boolean force) throws SVNClientException {
        try {
            this.notificationHandler.setCommand(7);
            String commandLine = "delete" + (force ? " --force" : "");
            HashSet<String> targets = new HashSet<String>(file.length);
            for (int i = 0; i < file.length; ++i) {
                targets.add(AbstractJhlClientAdapter.fileToSVNPath(file[i], false));
            }
            commandLine = this.appendPaths(commandLine, targets);
            this.notificationHandler.logCommandLine(commandLine);
            this.notificationHandler.setBaseDir(SVNBaseDir.getBaseDir(file));
            this.svnClient.remove(targets, force, false, null, null, null);
        }
        catch (ClientException e) {
            this.notificationHandler.logException((Exception)((Object)e));
            throw new SVNClientException(e);
        }
    }

    @Override
    public void doExport(SVNUrl srcUrl, File destPath, SVNRevision revision, boolean force) throws SVNClientException {
        try {
            this.notificationHandler.setCommand(8);
            String src = srcUrl.toString();
            String dest = AbstractJhlClientAdapter.fileToSVNPath(destPath, false);
            this.notificationHandler.logCommandLine("export -r " + revision.toString() + ' ' + src + ' ' + dest);
            this.notificationHandler.setBaseDir(SVNBaseDir.getBaseDir(destPath));
            this.svnClient.doExport(src, dest, JhlConverter.convert(revision), Revision.HEAD, force, false, Depth.infinity, null);
        }
        catch (ClientException e) {
            this.notificationHandler.logException((Exception)((Object)e));
            throw new SVNClientException(e);
        }
    }

    @Override
    public void doExport(File srcPath, File destPath, boolean force) throws SVNClientException {
        try {
            this.notificationHandler.setCommand(8);
            String src = AbstractJhlClientAdapter.fileToSVNPath(srcPath, false);
            String dest = AbstractJhlClientAdapter.fileToSVNPath(destPath, false);
            this.notificationHandler.logCommandLine("export " + src + ' ' + dest);
            this.notificationHandler.setBaseDir(SVNBaseDir.getBaseDir(new File[]{srcPath, destPath}));
            this.svnClient.doExport(src, dest, Revision.WORKING, Revision.BASE, force, false, Depth.infinity, null);
        }
        catch (ClientException e) {
            this.notificationHandler.logException((Exception)((Object)e));
            throw new SVNClientException(e);
        }
    }

    @Override
    public void doImport(File path, SVNUrl url, String message, boolean recurse) throws SVNClientException {
        try {
            String fixedMessage = this.fixSVNString(message);
            if (fixedMessage == null) {
                fixedMessage = "";
            }
            this.notificationHandler.setCommand(9);
            String src = AbstractJhlClientAdapter.fileToSVNPath(path, false);
            String dest = url.toString();
            this.notificationHandler.logCommandLine("import -m \"" + this.getFirstMessageLine(fixedMessage) + "\" " + (recurse ? "" : "-N ") + src + ' ' + dest);
            this.notificationHandler.setBaseDir(SVNBaseDir.getBaseDir(path));
            this.svnClient.doImport(src, dest, Depth.infinityOrEmpty((boolean)recurse), false, true, null, (CommitMessageCallback)new JhlCommitMessage(fixedMessage), null);
            this.notificationHandler.logCompleted(Messages.bind("notify.import.complete"));
        }
        catch (ClientException e) {
            this.notificationHandler.logException((Exception)((Object)e));
            throw new SVNClientException(e);
        }
    }

    @Override
    public void mkdir(SVNUrl url, String message) throws SVNClientException {
        this.mkdir(url, false, message);
    }

    @Override
    public void mkdir(File file) throws SVNClientException {
        try {
            this.notificationHandler.setCommand(10);
            HashSet<String> target = new HashSet<String>();
            target.add(AbstractJhlClientAdapter.fileToSVNPath(file, false));
            this.notificationHandler.logCommandLine("mkdir " + target);
            this.notificationHandler.setBaseDir(SVNBaseDir.getBaseDir(file));
            this.svnClient.mkdir(target, false, null, null, null);
        }
        catch (ClientException e) {
            this.notificationHandler.logException((Exception)((Object)e));
            throw new SVNClientException(e);
        }
    }

    @Override
    public void move(File srcPath, File destPath, boolean force) throws SVNClientException {
        try {
            this.notificationHandler.setCommand(5);
            HashSet<String> src = new HashSet<String>();
            src.add(AbstractJhlClientAdapter.fileToSVNPath(srcPath, false));
            String dest = AbstractJhlClientAdapter.fileToSVNPath(destPath, false);
            this.notificationHandler.logCommandLine("move " + AbstractJhlClientAdapter.fileToSVNPath(srcPath, false) + ' ' + dest);
            this.notificationHandler.setBaseDir(SVNBaseDir.getBaseDir(new File[]{srcPath, destPath}));
            this.svnClient.move(src, dest, force, false, false, null, null, null);
        }
        catch (ClientException e) {
            this.notificationHandler.logException((Exception)((Object)e));
            throw new SVNClientException(e);
        }
    }

    @Override
    public void move(SVNUrl srcUrl, SVNUrl destUrl, String message, SVNRevision revision) throws SVNClientException {
        try {
            String fixedMessage = this.fixSVNString(message);
            if (fixedMessage == null) {
                fixedMessage = "";
            }
            this.notificationHandler.setCommand(5);
            HashSet<String> src = new HashSet<String>();
            src.add(srcUrl.toString());
            String dest = destUrl.toString();
            this.notificationHandler.logCommandLine("move -m \"" + this.getFirstMessageLine(fixedMessage) + ' ' + srcUrl.toString() + ' ' + dest);
            this.notificationHandler.setBaseDir();
            this.svnClient.move(src, dest, false, false, false, null, (CommitMessageCallback)new JhlCommitMessage(fixedMessage), null);
        }
        catch (ClientException e) {
            this.notificationHandler.logException((Exception)((Object)e));
            throw new SVNClientException(e);
        }
    }

    @Override
    public long update(File path, SVNRevision revision, boolean recurse) throws SVNClientException {
        return this.update(path, revision, Depth.unknownOrFiles((boolean)recurse).ordinal(), false, false, true);
    }

    @Override
    public long update(File path, SVNRevision revision, int depth, boolean setDepth, boolean ignoreExternals, boolean force) throws SVNClientException {
        try {
            StringBuffer commandLine;
            this.notificationHandler.setCommand(4);
            HashSet<String> target = new HashSet<String>();
            String t = AbstractJhlClientAdapter.fileToSVNPath(path, false);
            target.add(t);
            Depth d = JhlConverter.depth(depth);
            if (d == Depth.exclude) {
                commandLine = new StringBuffer("update " + t + " --set-depth=exclude");
            } else {
                commandLine = new StringBuffer("update " + t + " -r " + revision.toString() + this.depthCommandLine(d));
                if (ignoreExternals) {
                    commandLine.append(" --ignore-externals");
                }
                if (force) {
                    commandLine.append(" --force");
                }
            }
            this.notificationHandler.logCommandLine(commandLine.toString());
            this.notificationHandler.setBaseDir(SVNBaseDir.getBaseDir(path));
            boolean makeParents = false;
            long[] rev = this.svnClient.update(target, JhlConverter.convert(revision), d, setDepth, makeParents, ignoreExternals, force);
            return rev[0];
        }
        catch (ClientException e) {
            this.notificationHandler.logException((Exception)((Object)e));
            throw new SVNClientException(e);
        }
    }

    @Override
    public long[] update(File[] path, SVNRevision revision, boolean recurse, boolean ignoreExternals) throws SVNClientException {
        return this.update(path, revision, Depth.unknownOrFiles((boolean)recurse).ordinal(), false, ignoreExternals, true);
    }

    @Override
    public long[] update(File[] path, SVNRevision revision, int depth, boolean setDepth, boolean ignoreExternals, boolean force) throws SVNClientException {
        try {
            this.notificationHandler.setCommand(4);
            HashSet<String> targets = new HashSet<String>(path.length);
            for (int i = 0; i < path.length; ++i) {
                targets.add(AbstractJhlClientAdapter.fileToSVNPath(path[i], false));
            }
            Depth d = JhlConverter.depth(depth);
            StringBuffer commandLine = new StringBuffer(this.appendPaths("update ", targets) + " -r " + revision.toString() + this.depthCommandLine(d));
            if (ignoreExternals) {
                commandLine.append(" --ignore-externals");
            }
            if (force) {
                commandLine.append(" --force");
            }
            this.notificationHandler.logCommandLine(commandLine.toString());
            this.notificationHandler.setBaseDir(SVNBaseDir.getBaseDir(path));
            this.notificationHandler.holdStats();
            boolean makeParents = false;
            long[] rtnCode = this.svnClient.update(targets, JhlConverter.convert(revision), d, setDepth, makeParents, ignoreExternals, force);
            this.notificationHandler.releaseStats();
            return rtnCode;
        }
        catch (ClientException e) {
            this.notificationHandler.logException((Exception)((Object)e));
            throw new SVNClientException(e);
        }
    }

    @Override
    public void revert(File path, boolean recurse) throws SVNClientException {
        try {
            this.notificationHandler.setCommand(16);
            String target = AbstractJhlClientAdapter.fileToSVNPath(path, false);
            this.notificationHandler.logCommandLine("revert " + (recurse ? "" : "-N ") + target);
            this.notificationHandler.setBaseDir(SVNBaseDir.getBaseDir(path));
            this.svnClient.revert(target, Depth.infinityOrEmpty((boolean)recurse), null);
        }
        catch (ClientException e) {
            this.notificationHandler.logException((Exception)((Object)e));
            throw new SVNClientException(e);
        }
    }

    @Override
    public InputStream getContent(SVNUrl url, SVNRevision revision, SVNRevision pegRevision) throws SVNClientException {
        try {
            this.notificationHandler.setCommand(18);
            String commandLine = "cat -r " + revision + " " + url;
            if (pegRevision != null) {
                commandLine = commandLine + "@" + pegRevision;
            }
            this.notificationHandler.logCommandLine(commandLine);
            this.notificationHandler.setBaseDir();
            byte[] contents = this.svnClient.fileContent(url.toString(), JhlConverter.convert(revision), JhlConverter.convert(pegRevision));
            ByteArrayInputStream input = new ByteArrayInputStream(contents);
            return input;
        }
        catch (ClientException e) {
            this.notificationHandler.logException((Exception)((Object)e));
            throw new SVNClientException(e);
        }
    }

    @Override
    public InputStream getContent(SVNUrl url, SVNRevision revision) throws SVNClientException {
        return this.getContent(url, revision, SVNRevision.HEAD);
    }

    @Override
    public InputStream getContent(File path, SVNRevision revision) throws SVNClientException {
        try {
            ISVNStatus status;
            String target = AbstractJhlClientAdapter.fileToSVNPath(path, false);
            this.notificationHandler.setCommand(18);
            this.notificationHandler.logCommandLine("cat -r " + revision.toString() + " " + target);
            this.notificationHandler.setBaseDir();
            if (revision.equals(SVNRevision.BASE) && (status = this.getSingleStatus(path)).getTextStatus().equals(SVNStatusKind.ADDED)) {
                return new ByteArrayInputStream(new byte[0]);
            }
            byte[] contents = this.svnClient.fileContent(target, JhlConverter.convert(revision), Revision.BASE);
            ByteArrayInputStream input = new ByteArrayInputStream(contents);
            return input;
        }
        catch (ClientException e) {
            this.notificationHandler.logException((Exception)((Object)e));
            throw new SVNClientException(e);
        }
    }

    @Override
    public ISVNProperty[] getProperties(File path) throws SVNClientException {
        return this.getProperties(path, false);
    }

    @Override
    public ISVNProperty[] getProperties(File path, boolean descend) throws SVNClientException {
        try {
            this.notificationHandler.setCommand(21);
            String target = AbstractJhlClientAdapter.fileToSVNPath(path, false);
            StringBuffer commandLine = new StringBuffer("propList ");
            if (descend) {
                commandLine.append(" -R ");
            }
            commandLine.append(target);
            this.notificationHandler.logCommandLine(commandLine.toString());
            this.notificationHandler.setBaseDir(SVNBaseDir.getBaseDir(path));
            JhlProplistCallback callback = new JhlProplistCallback(true);
            if (descend) {
                this.svnClient.properties(target, null, null, Depth.infinity, null, (ProplistCallback)callback);
            } else {
                this.svnClient.properties(target, null, null, Depth.empty, null, (ProplistCallback)callback);
            }
            return callback.getPropertyData();
        }
        catch (ClientException e) {
            this.notificationHandler.logException((Exception)((Object)e));
            throw new SVNClientException(e);
        }
    }

    @Override
    public ISVNProperty[] getProperties(SVNUrl url) throws SVNClientException {
        return this.getProperties(url, SVNRevision.HEAD, SVNRevision.HEAD);
    }

    @Override
    public ISVNProperty[] getProperties(SVNUrl url, SVNRevision revision, SVNRevision pegRevision) throws SVNClientException {
        return this.getProperties(url, revision, pegRevision, true);
    }

    @Override
    public ISVNProperty[] getProperties(SVNUrl url, SVNRevision revision, SVNRevision pegRevision, boolean recurse) throws SVNClientException {
        try {
            this.notificationHandler.setCommand(21);
            String target = url.toString();
            this.notificationHandler.logCommandLine("proplist " + target);
            this.notificationHandler.setBaseDir();
            JhlProplistCallback callback = new JhlProplistCallback(false);
            Depth depth = recurse ? Depth.infinity : Depth.empty;
            this.svnClient.properties(target, JhlConverter.convert(revision), JhlConverter.convert(pegRevision), depth, null, (ProplistCallback)callback);
            return callback.getPropertyData();
        }
        catch (ClientException e) {
            this.notificationHandler.logException((Exception)((Object)e));
            throw new SVNClientException(e);
        }
    }

    @Override
    public ISVNProperty[] getPropertiesIncludingInherited(File path, boolean includeEmptyProperties, boolean includeClosestOnly, List<String> filterProperties) throws SVNClientException {
        ISVNProperty[] properties = this.getPropertiesIncludingInherited(AbstractJhlClientAdapter.fileToSVNPath(path, false), true);
        return this.filterProperties(properties, includeEmptyProperties, includeClosestOnly, filterProperties);
    }

    @Override
    public ISVNProperty[] getPropertiesIncludingInherited(SVNUrl path, boolean includeEmptyProperties, boolean includeClosestOnly, List<String> filterProperties) throws SVNClientException {
        ISVNProperty[] properties = this.getPropertiesIncludingInherited(path.toString(), false);
        return this.filterProperties(properties, includeEmptyProperties, includeClosestOnly, filterProperties);
    }

    private ISVNProperty[] filterProperties(ISVNProperty[] properties, boolean includeEmptyProperties, boolean includeClosestOnly, List<String> filterProperties) {
        ISVNProperty[] propertyArray;
        if (includeEmptyProperties && filterProperties == null) {
            return properties;
        }
        ArrayList<ISVNProperty> allProperties = null;
        HashMap<String, ISVNProperty> propertyMap = null;
        if (includeClosestOnly) {
            propertyMap = new HashMap<String, ISVNProperty>();
        } else {
            allProperties = new ArrayList<ISVNProperty>();
        }
        for (ISVNProperty property : properties) {
            if (filterProperties != null && !filterProperties.contains(property.getName())) continue;
            if (includeClosestOnly) {
                propertyMap.put(property.getName(), property);
                continue;
            }
            allProperties.add(property);
        }
        if (includeClosestOnly) {
            propertyArray = new ISVNProperty[propertyMap.size()];
            propertyMap.values().toArray(propertyArray);
        } else {
            propertyArray = new ISVNProperty[allProperties.size()];
            allProperties.toArray(propertyArray);
        }
        return propertyArray;
    }

    @Override
    public ISVNProperty[] getPropertiesIncludingInherited(File path) throws SVNClientException {
        return this.getPropertiesIncludingInherited(AbstractJhlClientAdapter.fileToSVNPath(path, false), true);
    }

    @Override
    public ISVNProperty[] getPropertiesIncludingInherited(SVNUrl path) throws SVNClientException {
        return this.getPropertiesIncludingInherited(path.toString(), false);
    }

    private ISVNProperty[] getPropertiesIncludingInherited(String path, boolean isFile) throws SVNClientException {
        try {
            this.notificationHandler.setCommand(21);
            this.notificationHandler.logCommandLine("proplist " + path);
            this.notificationHandler.setBaseDir();
            InheritedJhlProplistCallback callback = new InheritedJhlProplistCallback(isFile);
            Revision revision = null;
            if (!isFile) {
                revision = JhlConverter.convert(SVNRevision.HEAD);
            }
            this.svnClient.properties(path, revision, revision, Depth.empty, null, (InheritedProplistCallback)callback);
            return callback.getPropertyData();
        }
        catch (ClientException e) {
            this.notificationHandler.logException((Exception)((Object)e));
            throw new SVNClientException(e);
        }
    }

    @Override
    public void propertySet(SVNUrl url, SVNRevision.Number baseRev, String propertyName, String propertyValue, String message) throws SVNClientException {
        try {
            this.notificationHandler.setCommand(14);
            if (propertyName.startsWith("svn:")) {
                this.svnClient.propertySetRemote(url.toString(), baseRev.getNumber(), propertyName, this.fixSVNString(propertyValue).getBytes(), (CommitMessageCallback)new JhlCommitMessage(message), false, null, (CommitCallback)new JhlCommitCallback());
            } else {
                this.svnClient.propertySetRemote(url.toString(), baseRev.getNumber(), propertyName, propertyValue.getBytes(), (CommitMessageCallback)new JhlCommitMessage(message), false, null, (CommitCallback)new JhlCommitCallback());
            }
        }
        catch (ClientException e) {
            this.notificationHandler.logException((Exception)((Object)e));
            throw new SVNClientException(e);
        }
    }

    @Override
    public void propertySet(File path, String propertyName, String propertyValue, boolean recurse) throws SVNClientException {
        try {
            this.notificationHandler.setCommand(14);
            String target = AbstractJhlClientAdapter.fileToSVNPath(path, false);
            this.notificationHandler.logCommandLine("propset " + (recurse ? "-R " : "") + propertyName + " \"" + propertyValue + "\" " + target);
            this.notificationHandler.setBaseDir(SVNBaseDir.getBaseDir(path));
            HashSet<String> statusBefore = null;
            if (recurse) {
                statusBefore = new HashSet<String>();
                ISVNStatus[] statuses = this.getStatus(path, recurse, false);
                for (int i = 0; i < statuses.length; ++i) {
                    statusBefore.add(statuses[i].getFile().getAbsolutePath());
                }
            }
            HashSet<String> paths = new HashSet<String>(1);
            paths.add(target);
            if (propertyName.startsWith("svn:")) {
                this.svnClient.propertySetLocal(paths, propertyName, this.fixSVNString(propertyValue).getBytes(), Depth.infinityOrEmpty((boolean)recurse), null, false);
            } else {
                this.svnClient.propertySetLocal(paths, propertyName, propertyValue.getBytes(), Depth.infinityOrEmpty((boolean)recurse), null, false);
            }
            if (recurse) {
                ISVNStatus[] statuses = this.getStatus(path, recurse, false);
                for (int i = 0; i < statuses.length; ++i) {
                    String statusPath = statuses[i].getFile().getAbsolutePath();
                    this.notificationHandler.notifyListenersOfChange(statusPath);
                    statusBefore.remove(statusPath);
                }
                for (String status : statusBefore) {
                    this.notificationHandler.notifyListenersOfChange(status);
                }
            } else {
                this.notificationHandler.notifyListenersOfChange(path.getAbsolutePath());
            }
        }
        catch (ClientException e) {
            this.notificationHandler.logException((Exception)((Object)e));
            throw new SVNClientException(e);
        }
    }

    @Override
    public void propertySet(File path, String propertyName, File propertyFile, boolean recurse) throws SVNClientException {
        try {
            this.notificationHandler.setCommand(14);
            String target = AbstractJhlClientAdapter.fileToSVNPath(path, false);
            this.notificationHandler.logCommandLine("propset " + (recurse ? "-R " : "") + propertyName + "-F \"" + propertyFile.toString() + "\" " + target);
            this.notificationHandler.setBaseDir(SVNBaseDir.getBaseDir(path));
            byte[] propertyBytes = new byte[(int)propertyFile.length()];
            FileInputStream is = null;
            try {
                is = new FileInputStream(propertyFile);
                is.read(propertyBytes);
            }
            catch (IOException ioe) {
                throw new SVNClientException(ioe);
            }
            finally {
                if (is != null) {
                    try {
                        is.close();
                    }
                    catch (IOException e) {}
                }
            }
            HashSet<String> statusBefore = null;
            if (recurse) {
                statusBefore = new HashSet<String>();
                ISVNStatus[] statuses = this.getStatus(path, recurse, false);
                for (int i = 0; i < statuses.length; ++i) {
                    statusBefore.add(statuses[i].getFile().getAbsolutePath());
                }
            }
            HashSet<String> paths = new HashSet<String>(1);
            paths.add(target);
            this.svnClient.propertySetLocal(paths, propertyName, propertyBytes, Depth.infinityOrEmpty((boolean)recurse), null, false);
            if (recurse) {
                ISVNStatus[] statuses = this.getStatus(path, recurse, false);
                for (int i = 0; i < statuses.length; ++i) {
                    String statusPath = statuses[i].getFile().getAbsolutePath();
                    this.notificationHandler.notifyListenersOfChange(statusPath);
                    statusBefore.remove(statusPath);
                }
                for (String status : statusBefore) {
                    this.notificationHandler.notifyListenersOfChange(status);
                }
            } else {
                this.notificationHandler.notifyListenersOfChange(path.getAbsolutePath());
            }
        }
        catch (ClientException e) {
            this.notificationHandler.logException((Exception)((Object)e));
            throw new SVNClientException(e);
        }
    }

    @Override
    public ISVNProperty propertyGet(File path, String propertyName) throws SVNClientException {
        try {
            this.notificationHandler.setCommand(20);
            String target = AbstractJhlClientAdapter.fileToSVNPath(path, false);
            this.notificationHandler.logCommandLine("propget " + propertyName + " " + target);
            this.notificationHandler.setBaseDir(SVNBaseDir.getBaseDir(path));
            byte[] bytes = this.svnClient.propertyGet(target, propertyName, null, null);
            if (bytes == null) {
                return null;
            }
            return JhlPropertyData.newForFile(target, propertyName, bytes);
        }
        catch (ClientException e) {
            this.notificationHandler.logException((Exception)((Object)e));
            throw new SVNClientException(e);
        }
    }

    @Override
    public ISVNProperty propertyGet(SVNUrl url, SVNRevision revision, SVNRevision peg, String propertyName) throws SVNClientException {
        try {
            this.notificationHandler.setCommand(20);
            String target = url.toString();
            String commandLine = "propget -r " + revision.toString() + " " + propertyName + " " + target;
            if (!peg.equals(SVNRevision.HEAD)) {
                commandLine = commandLine + "@" + peg.toString();
            }
            this.notificationHandler.logCommandLine(commandLine);
            this.notificationHandler.setBaseDir();
            byte[] bytes = this.svnClient.propertyGet(target, propertyName, JhlConverter.convert(revision), JhlConverter.convert(peg));
            if (bytes == null) {
                return null;
            }
            return JhlPropertyData.newForUrl(target, propertyName, bytes);
        }
        catch (ClientException e) {
            this.notificationHandler.logException((Exception)((Object)e));
            throw new SVNClientException(e);
        }
    }

    @Override
    public void propertyDel(File path, String propertyName, boolean recurse) throws SVNClientException {
        try {
            this.notificationHandler.setCommand(15);
            String target = AbstractJhlClientAdapter.fileToSVNPath(path, false);
            this.notificationHandler.logCommandLine("propdel " + propertyName + " " + target);
            this.notificationHandler.setBaseDir(SVNBaseDir.getBaseDir(path));
            HashSet<String> statusBefore = null;
            if (recurse) {
                statusBefore = new HashSet<String>();
                ISVNStatus[] statuses = this.getStatus(path, recurse, false);
                for (int i = 0; i < statuses.length; ++i) {
                    statusBefore.add(statuses[i].getFile().getAbsolutePath());
                }
            }
            HashSet<String> paths = new HashSet<String>(1);
            paths.add(target);
            this.svnClient.propertySetLocal(paths, propertyName, null, Depth.infinityOrEmpty((boolean)recurse), null, true);
            if (recurse) {
                ISVNStatus[] statuses = this.getStatus(path, recurse, false);
                for (int i = 0; i < statuses.length; ++i) {
                    String statusPath = statuses[i].getFile().getAbsolutePath();
                    this.notificationHandler.notifyListenersOfChange(statusPath);
                    statusBefore.remove(statusPath);
                }
                for (String status : statusBefore) {
                    this.notificationHandler.notifyListenersOfChange(status);
                }
            } else {
                this.notificationHandler.notifyListenersOfChange(path.getAbsolutePath());
            }
        }
        catch (ClientException e) {
            this.notificationHandler.logException((Exception)((Object)e));
            throw new SVNClientException(e);
        }
    }

    @Override
    public void diff(File oldPath, SVNRevision oldPathRevision, File newPath, SVNRevision newPathRevision, File outFile, boolean recurse) throws SVNClientException {
        this.diff(oldPath, oldPathRevision, newPath, newPathRevision, outFile, recurse, true, false, false);
    }

    private void diffRelative(File oldPath, SVNRevision oldPathRevision, File newPath, SVNRevision newPathRevision, File outFile, boolean recurse, boolean ignoreAncestry, boolean noDiffDeleted, boolean force, File relativeTo) throws SVNClientException {
        try {
            this.notificationHandler.setCommand(17);
            if (oldPath == null) {
                oldPath = new File(".");
            }
            if (newPath == null) {
                newPath = oldPath;
            }
            if (oldPathRevision == null) {
                oldPathRevision = SVNRevision.BASE;
            }
            if (newPathRevision == null) {
                newPathRevision = SVNRevision.WORKING;
            }
            String oldTarget = AbstractJhlClientAdapter.fileToSVNPath(oldPath, false);
            String newTarget = AbstractJhlClientAdapter.fileToSVNPath(newPath, false);
            String svnOutFile = AbstractJhlClientAdapter.fileToSVNPath(outFile, false);
            String relativeToDir = AbstractJhlClientAdapter.fileToSVNPath(relativeTo, false);
            String commandLine = "diff ";
            if (oldPathRevision.getKind() != Revision.Kind.base.ordinal() || newPathRevision.getKind() != Revision.Kind.working.ordinal()) {
                commandLine = commandLine + "-r " + oldPathRevision.toString();
                if (newPathRevision.getKind() != Revision.Kind.working.ordinal()) {
                    commandLine = commandLine + ":" + newPathRevision.toString();
                }
                commandLine = commandLine + " ";
            }
            if (!oldPath.equals(new File("."))) {
                commandLine = commandLine + "--old " + oldTarget + " ";
            }
            if (!newPath.equals(oldPath)) {
                commandLine = commandLine + "--new " + newTarget + " ";
            }
            int depth = Depth.empty.ordinal();
            if (recurse) {
                depth = Depth.infinity.ordinal();
            } else if (oldPath.isFile()) {
                depth = Depth.files.ordinal();
            }
            this.notificationHandler.logCommandLine(commandLine);
            this.notificationHandler.setBaseDir(SVNBaseDir.getBaseDir(new File[]{oldPath, newPath}));
            this.svnClient.diff(oldTarget, JhlConverter.convert(oldPathRevision), newTarget, JhlConverter.convert(newPathRevision), relativeToDir, svnOutFile, JhlConverter.depth(depth), null, ignoreAncestry, noDiffDeleted, force, true);
        }
        catch (ClientException e) {
            this.notificationHandler.logException((Exception)((Object)e));
            throw new SVNClientException(e);
        }
    }

    @Override
    public void diff(File oldPath, SVNRevision oldPathRevision, File newPath, SVNRevision newPathRevision, File outFile, boolean recurse, boolean ignoreAncestry, boolean noDiffDeleted, boolean force) throws SVNClientException {
        try {
            this.notificationHandler.setCommand(17);
            if (oldPath == null) {
                oldPath = new File(".");
            }
            if (newPath == null) {
                newPath = oldPath;
            }
            if (oldPathRevision == null) {
                oldPathRevision = SVNRevision.BASE;
            }
            if (newPathRevision == null) {
                newPathRevision = SVNRevision.WORKING;
            }
            String oldTarget = AbstractJhlClientAdapter.fileToSVNPath(oldPath, false);
            String newTarget = AbstractJhlClientAdapter.fileToSVNPath(newPath, false);
            String svnOutFile = AbstractJhlClientAdapter.fileToSVNPath(outFile, false);
            String commandLine = "diff ";
            if (oldPathRevision.getKind() != Revision.Kind.base.ordinal() || newPathRevision.getKind() != Revision.Kind.working.ordinal()) {
                commandLine = commandLine + "-r " + oldPathRevision.toString();
                if (newPathRevision.getKind() != Revision.Kind.working.ordinal()) {
                    commandLine = commandLine + ":" + newPathRevision.toString();
                }
                commandLine = commandLine + " ";
            }
            if (!oldPath.equals(new File("."))) {
                commandLine = commandLine + "--old " + oldTarget + " ";
            }
            if (!newPath.equals(oldPath)) {
                commandLine = commandLine + "--new " + newTarget + " ";
            }
            this.notificationHandler.logCommandLine(commandLine);
            this.notificationHandler.setBaseDir(SVNBaseDir.getBaseDir(new File[]{oldPath, newPath}));
            this.svnClient.diff(oldTarget, JhlConverter.convert(oldPathRevision), newTarget, JhlConverter.convert(newPathRevision), null, svnOutFile, Depth.infinityOrEmpty((boolean)recurse), null, ignoreAncestry, noDiffDeleted, force, true);
        }
        catch (ClientException e) {
            this.notificationHandler.logException((Exception)((Object)e));
            throw new SVNClientException(e);
        }
    }

    @Override
    public void diff(File path, File outFile, boolean recurse) throws SVNClientException {
        this.diff(path, null, null, null, outFile, recurse);
    }

    @Override
    public void diff(SVNUrl oldUrl, SVNRevision oldUrlRevision, SVNUrl newUrl, SVNRevision newUrlRevision, File outFile, boolean recurse) throws SVNClientException {
        this.diff(oldUrl, oldUrlRevision, newUrl, newUrlRevision, outFile, recurse, true, false, false);
    }

    @Override
    public void diff(SVNUrl target, SVNRevision pegRevision, SVNRevision startRevision, SVNRevision endRevision, File outFile, int depth, boolean ignoreAncestry, boolean noDiffDeleted, boolean force) throws SVNClientException {
        try {
            this.notificationHandler.setCommand(17);
            if (pegRevision == null) {
                pegRevision = SVNRevision.HEAD;
            }
            if (startRevision == null) {
                startRevision = SVNRevision.HEAD;
            }
            if (endRevision == null) {
                endRevision = SVNRevision.HEAD;
            }
            String commandLine = "diff ";
            Depth d = JhlConverter.depth(depth);
            commandLine = commandLine + this.depthCommandLine(d);
            if (ignoreAncestry) {
                commandLine = commandLine + " --ignoreAncestry";
            }
            commandLine = commandLine + " -r " + startRevision + ":" + endRevision + " " + target;
            this.notificationHandler.logCommandLine(commandLine);
            this.notificationHandler.setBaseDir();
            this.svnClient.diff(target.toString(), JhlConverter.convert(pegRevision), JhlConverter.convert(startRevision), JhlConverter.convert(endRevision), null, outFile.getAbsolutePath(), d, null, ignoreAncestry, noDiffDeleted, force, false);
        }
        catch (ClientException e) {
            this.notificationHandler.logException((Exception)((Object)e));
            throw new SVNClientException(e);
        }
    }

    @Override
    public void diff(SVNUrl target, SVNRevision pegRevision, SVNRevision startRevision, SVNRevision endRevision, File outFile, boolean recurse) throws SVNClientException {
        this.diff(target, pegRevision, startRevision, endRevision, outFile, Depth.infinityOrImmediates((boolean)recurse).ordinal(), true, false, false);
    }

    @Override
    public void diff(SVNUrl oldUrl, SVNRevision oldUrlRevision, SVNUrl newUrl, SVNRevision newUrlRevision, File outFile, boolean recurse, boolean ignoreAncestry, boolean noDiffDeleted, boolean force) throws SVNClientException {
        try {
            this.notificationHandler.setCommand(17);
            if (newUrl == null) {
                newUrl = oldUrl;
            }
            if (oldUrlRevision == null) {
                oldUrlRevision = SVNRevision.HEAD;
            }
            if (newUrlRevision == null) {
                newUrlRevision = SVNRevision.HEAD;
            }
            String svnOutFile = AbstractJhlClientAdapter.fileToSVNPath(outFile, false);
            String commandLine = "diff ";
            if (oldUrlRevision.getKind() != Revision.Kind.head.ordinal() || newUrlRevision.getKind() != Revision.Kind.head.ordinal()) {
                commandLine = commandLine + "-r " + oldUrlRevision.toString();
                if (newUrlRevision.getKind() != Revision.Kind.head.ordinal()) {
                    commandLine = commandLine + ":" + newUrlRevision.toString();
                }
                commandLine = commandLine + " ";
            }
            commandLine = commandLine + oldUrl + " ";
            if (!newUrl.equals(oldUrl)) {
                commandLine = commandLine + newUrl + " ";
            }
            this.notificationHandler.logCommandLine(commandLine);
            this.notificationHandler.setBaseDir();
            this.svnClient.diff(oldUrl.toString(), JhlConverter.convert(oldUrlRevision), newUrl.toString(), JhlConverter.convert(newUrlRevision), null, svnOutFile, Depth.infinityOrEmpty((boolean)recurse), null, ignoreAncestry, noDiffDeleted, force, false);
        }
        catch (ClientException e) {
            this.notificationHandler.logException((Exception)((Object)e));
            throw new SVNClientException(e);
        }
    }

    @Override
    public void diff(SVNUrl url, SVNRevision oldUrlRevision, SVNRevision newUrlRevision, File outFile, boolean recurse) throws SVNClientException {
        this.diff(url, oldUrlRevision, url, newUrlRevision, outFile, recurse);
    }

    @Override
    public ISVNAnnotations annotate(File file, SVNRevision revisionStart, SVNRevision revisionEnd, boolean ignoreMimeType, boolean includeMergedRevisions) throws SVNClientException {
        return this.annotate(file, revisionStart, revisionEnd, null, ignoreMimeType, includeMergedRevisions);
    }

    @Override
    public ISVNAnnotations annotate(File file, SVNRevision revisionStart, SVNRevision revisionEnd, SVNRevision pegRevision, boolean ignoreMimeType, boolean includeMergedRevisions) throws SVNClientException {
        String target = AbstractJhlClientAdapter.fileToSVNPath(file, false);
        ISVNInfo info = this.getInfoFromWorkingCopy(file);
        if (SVNScheduleKind.ADD == info.getSchedule() && info.getCopyUrl() != null) {
            target = info.getCopyUrl().toString();
        }
        return this.annotate(target, revisionStart, revisionEnd, pegRevision, ignoreMimeType, includeMergedRevisions);
    }

    @Override
    public ISVNAnnotations annotate(SVNUrl url, SVNRevision revisionStart, SVNRevision revisionEnd, SVNRevision pegRevision, boolean ignoreMimeType, boolean includeMergedRevisions) throws SVNClientException {
        return this.annotate(url.toString(), revisionStart, revisionEnd, pegRevision, ignoreMimeType, includeMergedRevisions);
    }

    private ISVNAnnotations annotate(String target, SVNRevision revisionStart, SVNRevision revisionEnd, SVNRevision pegRevision, boolean ignoreMimeType, boolean includeMergedRevisions) throws SVNClientException {
        try {
            this.notificationHandler.setCommand(25);
            if (revisionStart == null) {
                revisionStart = new SVNRevision.Number(1L);
            }
            if (revisionEnd == null) {
                revisionEnd = SVNRevision.HEAD;
            }
            if (pegRevision == null) {
                pegRevision = SVNRevision.HEAD;
            }
            String commandLine = "blame ";
            if (includeMergedRevisions) {
                commandLine = commandLine + "-g ";
            }
            commandLine = commandLine + "-r " + revisionStart.toString() + ":" + revisionEnd.toString() + " ";
            commandLine = commandLine + target + "@" + pegRevision;
            this.notificationHandler.logCommandLine(commandLine);
            this.notificationHandler.setBaseDir();
            JhlAnnotations annotations = new JhlAnnotations();
            this.svnClient.blame(target, JhlConverter.convert(pegRevision), JhlConverter.convert(revisionStart), JhlConverter.convert(revisionEnd), ignoreMimeType, includeMergedRevisions, (BlameCallback)annotations);
            return annotations;
        }
        catch (ClientException e) {
            if (includeMergedRevisions && e.getAprError() == 200007) {
                return this.annotate(target, revisionStart, revisionEnd, pegRevision, ignoreMimeType, false);
            }
            if (e.getAprError() == 160013 && pegRevision != null && !pegRevision.equals(revisionEnd)) {
                return this.annotate(target, revisionStart, pegRevision, pegRevision, ignoreMimeType, includeMergedRevisions);
            }
            this.notificationHandler.logException((Exception)((Object)e));
            throw new SVNClientException(e);
        }
    }

    @Override
    public ISVNAnnotations annotate(SVNUrl url, SVNRevision revisionStart, SVNRevision revisionEnd) throws SVNClientException {
        return this.annotate(url.toString(), revisionStart, revisionEnd, null, false, false);
    }

    @Override
    public ISVNAnnotations annotate(File file, SVNRevision revisionStart, SVNRevision revisionEnd) throws SVNClientException {
        String target = AbstractJhlClientAdapter.fileToSVNPath(file, false);
        ISVNInfo info = this.getInfoFromWorkingCopy(file);
        if (SVNScheduleKind.ADD == info.getSchedule() && info.getCopyUrl() != null) {
            target = info.getCopyUrl().toString();
        }
        return this.annotate(target, revisionStart, revisionEnd, null, false, false);
    }

    @Override
    public void resolved(File path) throws SVNClientException {
        this.resolve(path, 6);
    }

    @Override
    public void resolve(File path, int result) throws SVNClientException {
        try {
            this.notificationHandler.setCommand(31);
            String target = AbstractJhlClientAdapter.fileToSVNPath(path, true);
            String commandLine = "resolve ";
            ConflictResult.Choice choice = ConflictResult.Choice.chooseMerged;
            switch (result) {
                case 6: {
                    commandLine = commandLine + "--accept=working ";
                    choice = ConflictResult.Choice.chooseMerged;
                    break;
                }
                case 1: {
                    commandLine = commandLine + "--accept=base ";
                    choice = ConflictResult.Choice.chooseBase;
                    break;
                }
                case 2: {
                    commandLine = commandLine + "--accept=theirs-full ";
                    choice = ConflictResult.Choice.chooseTheirsFull;
                    break;
                }
                case 4: {
                    commandLine = commandLine + "--accept=theirs-conflict ";
                    choice = ConflictResult.Choice.chooseTheirsConflict;
                    break;
                }
                case 3: {
                    commandLine = commandLine + "--accept=mine-full ";
                    choice = ConflictResult.Choice.chooseMineFull;
                    break;
                }
                case 5: {
                    commandLine = commandLine + "--accept=mine-conflict ";
                    choice = ConflictResult.Choice.chooseMineConflict;
                    break;
                }
                default: {
                    choice = ConflictResult.Choice.chooseMerged;
                }
            }
            commandLine = commandLine + target;
            this.notificationHandler.logCommandLine(commandLine);
            this.notificationHandler.setBaseDir(SVNBaseDir.getBaseDir(path));
            this.svnClient.resolve(target, Depth.empty, choice);
        }
        catch (SubversionException e) {
            this.notificationHandler.logException((Exception)((Object)e));
            throw new SVNClientException(e);
        }
    }

    @Override
    public void cancelOperation() throws SVNClientException {
        try {
            this.svnClient.cancelOperation();
        }
        catch (ClientException e) {
            this.notificationHandler.logException((Exception)((Object)e));
            throw new SVNClientException(e);
        }
    }

    @Override
    public ISVNInfo getInfoFromWorkingCopy(File path) throws SVNClientException {
        try {
            this.notificationHandler.setCommand(19);
            String target = AbstractJhlClientAdapter.fileToSVNPath(path, false);
            this.notificationHandler.logCommandLine("info " + target);
            this.notificationHandler.setBaseDir(SVNBaseDir.getBaseDir(path));
            JhlInfoCallback callback = new JhlInfoCallback();
            this.svnClient.info2(target, null, null, Depth.empty, null, (InfoCallback)callback);
            ISVNInfo[] items = callback.getInfo();
            if (items == null) {
                return new SVNInfoUnversioned(path);
            }
            return items[0];
        }
        catch (ClientException e) {
            if (e.getAprError() == 155007 || e.getAprError() == 155010) {
                return new SVNInfoUnversioned(path);
            }
            this.notificationHandler.logException((Exception)((Object)e));
            throw new SVNClientException(e);
        }
    }

    @Override
    public ISVNInfo getInfo(File path) throws SVNClientException {
        try {
            this.notificationHandler.setCommand(19);
            String target = AbstractJhlClientAdapter.fileToSVNPath(path, false);
            this.notificationHandler.logCommandLine("info " + target);
            this.notificationHandler.setBaseDir(SVNBaseDir.getBaseDir(path));
            JhlInfoCallback callback = new JhlInfoCallback();
            this.svnClient.info2(target, Revision.WORKING, Revision.BASE, Depth.infinity, null, (InfoCallback)callback);
            ISVNInfo[] items = callback.getInfo();
            if (items == null || items.length == 0) {
                return new SVNInfoUnversioned(path);
            }
            return items[0];
        }
        catch (ClientException e) {
            if (e.getAprError() == 155007 || e.getAprError() == 155010) {
                return new SVNInfoUnversioned(path);
            }
            this.notificationHandler.logException((Exception)((Object)e));
            throw new SVNClientException(e);
        }
    }

    @Override
    public ISVNInfo[] getInfo(File path, boolean descend) throws SVNClientException {
        try {
            this.notificationHandler.setCommand(19);
            String target = AbstractJhlClientAdapter.fileToSVNPath(path, false);
            if (descend) {
                this.notificationHandler.logCommandLine("info " + target + " --depth=infinity");
            } else {
                this.notificationHandler.logCommandLine("info " + target);
            }
            this.notificationHandler.setBaseDir(SVNBaseDir.getBaseDir(path));
            JhlInfoCallback callback = new JhlInfoCallback();
            this.svnClient.info2(target, null, null, Depth.infinityOrEmpty((boolean)descend), null, (InfoCallback)callback);
            ISVNInfo[] items = callback.getInfo();
            if (items == null) {
                return new ISVNInfo[]{new SVNInfoUnversioned(path)};
            }
            return items;
        }
        catch (ClientException e) {
            if (e.getAprError() == 155007 || e.getAprError() == 155010) {
                return new ISVNInfo[]{new SVNInfoUnversioned(path)};
            }
            this.notificationHandler.logException((Exception)((Object)e));
            throw new SVNClientException(e);
        }
    }

    @Override
    public ISVNInfo getInfo(SVNUrl url, SVNRevision revision, SVNRevision peg) throws SVNClientException {
        try {
            this.notificationHandler.setCommand(19);
            String target = url.toString();
            this.notificationHandler.logCommandLine("info " + target);
            JhlInfoCallback callback = new JhlInfoCallback();
            this.svnClient.info2(target, JhlConverter.convert(revision), JhlConverter.convert(peg), Depth.empty, null, (InfoCallback)callback);
            ISVNInfo[] items = callback.getInfo();
            if (items == null || items.length == 0) {
                return new SVNInfoUnversioned(null);
            }
            return items[0];
        }
        catch (ClientException e) {
            if (e.getAprError() == 155007 || e.getAprError() == 155010) {
                return new SVNInfoUnversioned(null);
            }
            this.notificationHandler.logException((Exception)((Object)e));
            throw new SVNClientException(e);
        }
    }

    @Override
    public void switchToUrl(File path, SVNUrl url, SVNRevision revision, boolean recurse) throws SVNClientException {
        this.switchToUrl(path, url, revision, Depth.unknownOrFiles((boolean)recurse).ordinal(), false, false, true);
    }

    @Override
    public void switchToUrl(File path, SVNUrl url, SVNRevision revision, int depth, boolean setDepth, boolean ignoreExternals, boolean force) throws SVNClientException {
        this.switchToUrl(path, url, revision, revision, depth, setDepth, ignoreExternals, force);
    }

    @Override
    public void switchToUrl(File path, SVNUrl url, SVNRevision revision, SVNRevision pegRevision, int depth, boolean setDepth, boolean ignoreExternals, boolean force) throws SVNClientException {
        this.switchToUrl(path, url, revision, pegRevision, depth, setDepth, ignoreExternals, force, false);
    }

    @Override
    public void switchToUrl(File path, SVNUrl url, SVNRevision revision, SVNRevision pegRevision, int depth, boolean setDepth, boolean ignoreExternals, boolean force, boolean ignoreAncestry) throws SVNClientException {
        if (depth == Depth.exclude.ordinal()) {
            this.update(path, pegRevision, depth, true, ignoreExternals, force);
            return;
        }
        try {
            this.notificationHandler.setCommand(26);
            Depth d = JhlConverter.depth(depth);
            String target = AbstractJhlClientAdapter.fileToSVNPath(path, false);
            StringBuffer commandLine = new StringBuffer("switch " + url + " " + target + " -r " + revision.toString() + this.depthCommandLine(d));
            if (ignoreExternals) {
                commandLine.append(" --ignore-externals");
            }
            if (force) {
                commandLine.append(" --force");
            }
            this.notificationHandler.logCommandLine(commandLine.toString());
            File baseDir = SVNBaseDir.getBaseDir(path);
            this.notificationHandler.setBaseDir(baseDir);
            Revision rev = JhlConverter.convert(revision);
            Revision pegRev = JhlConverter.convert(pegRevision);
            this.svnClient.doSwitch(target, url.toString(), rev, pegRev, d, setDepth, ignoreExternals, force, ignoreAncestry);
        }
        catch (ClientException e) {
            this.notificationHandler.logException((Exception)((Object)e));
            throw new SVNClientException(e);
        }
    }

    @Override
    public void setConfigDirectory(File dir) throws SVNClientException {
        try {
            this.svnClient.setConfigDirectory(AbstractJhlClientAdapter.fileToSVNPath(dir, false));
        }
        catch (ClientException e) {
            this.notificationHandler.logException((Exception)((Object)e));
            throw new SVNClientException(e);
        }
    }

    @Override
    public void cleanup(File path) throws SVNClientException {
        try {
            this.notificationHandler.setCommand(24);
            String target = AbstractJhlClientAdapter.fileToSVNPath(path, false);
            String commandLine = "cleanup " + target;
            this.notificationHandler.logCommandLine(commandLine);
            this.svnClient.cleanup(target);
        }
        catch (ClientException e) {
            this.notificationHandler.logException((Exception)((Object)e));
            throw new SVNClientException(e);
        }
    }

    @Override
    public void upgrade(File path) throws SVNClientException {
        try {
            this.notificationHandler.setCommand(33);
            String target = AbstractJhlClientAdapter.fileToSVNPath(path, false);
            String commandLine = "upgrade " + target;
            this.notificationHandler.logCommandLine(commandLine);
            this.svnClient.upgrade(target);
        }
        catch (ClientException e) {
            this.notificationHandler.logException((Exception)((Object)e));
            throw new SVNClientException(e);
        }
    }

    @Override
    public void merge(SVNUrl path1, SVNRevision revision1, SVNUrl path2, SVNRevision revision2, File localPath, boolean force, boolean recurse, boolean dryRun, boolean ignoreAncestry) throws SVNClientException {
        this.merge(path1, revision1, path2, revision2, localPath, force, Depth.infinityOrFiles((boolean)recurse).ordinal(), dryRun, ignoreAncestry, false);
    }

    public void merge(SVNUrl path1, SVNRevision revision1, SVNUrl path2, SVNRevision revision2, SVNRevision pegRevision, File localPath, boolean force, int depth, boolean dryRun, boolean ignoreAncestry, boolean recordOnly) throws SVNClientException {
        try {
            this.notificationHandler.setCommand(27);
            Depth d = JhlConverter.depth(depth);
            String target = AbstractJhlClientAdapter.fileToSVNPath(localPath, false);
            String commandLine = "merge";
            boolean samePath = false;
            if (dryRun) {
                commandLine = commandLine + " --dry-run";
            }
            commandLine = commandLine + this.depthCommandLine(d);
            if (force) {
                commandLine = commandLine + " --force";
            }
            if (ignoreAncestry) {
                commandLine = commandLine + " --ignore-ancestry";
            }
            if (path1.toString().equals(path2.toString())) {
                samePath = true;
                commandLine = revision1 == null || revision2 == null ? commandLine + " " + path1 : commandLine + " -r" + revision1.toString() + ":" + revision2.toString() + " " + path1;
            } else {
                commandLine = commandLine + " " + path1 + "@" + revision1.toString() + " " + path2 + "@" + revision2.toString();
            }
            commandLine = commandLine + " " + target;
            this.notificationHandler.logCommandLine(commandLine);
            File baseDir = SVNBaseDir.getBaseDir(localPath);
            this.notificationHandler.setBaseDir(baseDir);
            if (samePath) {
                ArrayList<RevisionRange> revisionRanges;
                if (revision1 == null && revision2 == null) {
                    revisionRanges = null;
                } else {
                    Revision rev1 = revision1 == null ? Revision.START : JhlConverter.convert(revision1);
                    Revision rev2 = revision2 == null ? Revision.START : JhlConverter.convert(revision2);
                    revisionRanges = new ArrayList<RevisionRange>();
                    revisionRanges.add(new RevisionRange(rev1, rev2));
                }
                this.svnClient.merge(path1.toString(), JhlConverter.convert(pegRevision), revisionRanges, target, force, d, ignoreAncestry, dryRun, recordOnly);
            } else {
                this.svnClient.merge(path1.toString(), JhlConverter.convert(revision1), path2.toString(), JhlConverter.convert(revision2), target, force, d, ignoreAncestry, dryRun, recordOnly);
            }
            if (dryRun) {
                this.notificationHandler.logCompleted("Dry-run merge complete.");
            } else {
                this.notificationHandler.logCompleted("Merge complete.");
            }
        }
        catch (ClientException e) {
            this.notificationHandler.logException((Exception)((Object)e));
            if (dryRun) {
                this.notificationHandler.logCompleted("Dry-run merge completed abnormally.");
            } else {
                this.notificationHandler.logCompleted("Merge completed abnormally.");
            }
            SVNClientException svnClientException = new SVNClientException(e);
            svnClientException.setAprError(e.getAprError());
            throw svnClientException;
        }
    }

    @Override
    public void merge(SVNUrl path1, SVNRevision revision1, SVNUrl path2, SVNRevision revision2, File localPath, boolean force, int depth, boolean dryRun, boolean ignoreAncestry, boolean recordOnly) throws SVNClientException {
        SVNUrlWithPegRevision svnUrlWithPegRevision = new SVNUrlWithPegRevision(path1);
        SVNRevision pegRevision = svnUrlWithPegRevision.getPegRevision();
        if (pegRevision == null) {
            pegRevision = revision2 == null ? SVNRevision.HEAD : revision2;
        }
        this.merge(svnUrlWithPegRevision.getUrl(), revision1, new SVNUrlWithPegRevision(path2).getUrl(), revision2, pegRevision, localPath, force, depth, dryRun, ignoreAncestry, recordOnly);
    }

    @Override
    public void mergeReintegrate(SVNUrl path, SVNRevision pegRevision, File localPath, boolean force, boolean dryRun) throws SVNClientException {
        try {
            this.notificationHandler.setCommand(27);
            String target = AbstractJhlClientAdapter.fileToSVNPath(localPath, false);
            String commandLine = "merge --reintegrate";
            if (dryRun) {
                commandLine = commandLine + " --dry-run";
            }
            if (force) {
                commandLine = commandLine + " --force";
            }
            commandLine = commandLine + " " + path + " " + target;
            this.notificationHandler.logCommandLine(commandLine);
            File baseDir = SVNBaseDir.getBaseDir(localPath);
            this.notificationHandler.setBaseDir(baseDir);
            Revision peg = JhlConverter.convert(pegRevision);
            if (peg == null) {
                peg = Revision.HEAD;
            }
            this.svnClient.mergeReintegrate(path.toString(), peg, target, dryRun);
            if (dryRun) {
                this.notificationHandler.logCompleted("Dry-run merge complete.");
            } else {
                this.notificationHandler.logCompleted("Merge complete.");
            }
        }
        catch (ClientException e) {
            this.notificationHandler.logException((Exception)((Object)e));
            if (dryRun) {
                this.notificationHandler.logCompleted("Dry-run merge completed abnormally.");
            } else {
                this.notificationHandler.logCompleted("Merge completed abnormally.");
            }
            SVNClientException svnClientException = new SVNClientException(e);
            svnClientException.setAprError(e.getAprError());
            throw svnClientException;
        }
    }

    @Override
    public void addPasswordCallback(ISVNPromptUserPassword callback) {
        if (callback != null) {
            JhlPromptUserPassword prompt = new JhlPromptUserPassword(callback);
            this.setPromptUserPassword(prompt);
        }
    }

    @Override
    public void lock(SVNUrl[] uris, String comment, boolean force) throws SVNClientException {
        this.notImplementedYet();
    }

    @Override
    public void unlock(SVNUrl[] uris, boolean force) throws SVNClientException {
        this.notImplementedYet();
    }

    @Override
    public void lock(File[] paths, String comment, boolean force) throws SVNClientException {
        try {
            this.notificationHandler.setCommand(28);
            HashSet<String> files = new HashSet<String>(paths.length);
            String commandLine = "lock -m \"" + comment + "\"";
            if (force) {
                commandLine = commandLine + " --force";
            }
            for (int i = 0; i < paths.length; ++i) {
                files.add(AbstractJhlClientAdapter.fileToSVNPath(paths[i], false));
            }
            commandLine = this.appendPaths(commandLine, files);
            this.notificationHandler.logCommandLine(commandLine);
            this.notificationHandler.setBaseDir(SVNBaseDir.getBaseDir(paths));
            this.svnClient.lock(files, comment, force);
            for (String file : files) {
                this.notificationHandler.notifyListenersOfChange(file);
            }
        }
        catch (ClientException e) {
            this.notificationHandler.logException((Exception)((Object)e));
        }
    }

    @Override
    public void unlock(File[] paths, boolean force) throws SVNClientException {
        try {
            this.notificationHandler.setCommand(28);
            HashSet<String> files = new HashSet<String>(paths.length);
            String commandLine = "unlock ";
            if (force) {
                commandLine = commandLine + " --force";
            }
            for (int i = 0; i < paths.length; ++i) {
                files.add(AbstractJhlClientAdapter.fileToSVNPath(paths[i], false));
            }
            commandLine = this.appendPaths(commandLine, files);
            this.notificationHandler.logCommandLine(commandLine);
            this.notificationHandler.setBaseDir(SVNBaseDir.getBaseDir(paths));
            this.svnClient.unlock(files, force);
            for (String file : files) {
                this.notificationHandler.notifyListenersOfChange(file);
            }
        }
        catch (ClientException e) {
            this.notificationHandler.logException((Exception)((Object)e));
        }
    }

    @Override
    public void setRevProperty(SVNUrl url, SVNRevision.Number revisionNo, String propName, String propertyData, boolean force) throws SVNClientException {
        try {
            this.notificationHandler.setCommand(14);
            this.notificationHandler.logCommandLine("propset --revprop -r " + revisionNo.toString() + (force ? " --force " : "") + " \"" + propName + "\"  \"" + propertyData + "\" " + url.toString());
            this.notificationHandler.setBaseDir();
            if (propName.startsWith("svn:")) {
                this.svnClient.setRevProperty(url.toString(), propName, Revision.getInstance((long)revisionNo.getNumber()), this.fixSVNString(propertyData), null, true);
            } else {
                this.svnClient.setRevProperty(url.toString(), propName, Revision.getInstance((long)revisionNo.getNumber()), propertyData, null, true);
            }
        }
        catch (ClientException e) {
            this.notificationHandler.logException((Exception)((Object)e));
            throw new SVNClientException(e);
        }
    }

    @Override
    public String getRevProperty(SVNUrl url, SVNRevision.Number revisionNo, String propName) throws SVNClientException {
        String propData = null;
        try {
            this.notificationHandler.setCommand(20);
            this.notificationHandler.logCommandLine("propget --revprop -r " + revisionNo.toString() + " \"" + propName + "\"  " + url.toString());
            this.notificationHandler.setBaseDir();
            byte[] bytes = this.svnClient.revProperty(url.toString(), propName, Revision.getInstance((long)revisionNo.getNumber()));
            try {
                propData = new String(bytes, "UTF8");
            }
            catch (UnsupportedEncodingException e) {
                propData = new String(bytes);
            }
            if (propName.startsWith("svn:")) {
                this.fixSVNString(propData);
            }
        }
        catch (ClientException e) {
            this.notificationHandler.logException((Exception)((Object)e));
            throw new SVNClientException(e);
        }
        return propData;
    }

    @Override
    public ISVNProperty[] getRevProperties(SVNUrl url, SVNRevision.Number revisionNo) throws SVNClientException {
        try {
            this.notificationHandler.setCommand(21);
            String target = url.toString();
            this.notificationHandler.logCommandLine("proplist --revprop -r " + revisionNo.toString() + target);
            this.notificationHandler.setBaseDir();
            Map propertiesData = this.svnClient.revProperties(target, Revision.getInstance((long)revisionNo.getNumber()));
            if (propertiesData == null) {
                return new JhlPropertyData[0];
            }
            Set keys = propertiesData.keySet();
            ISVNProperty[] svnProperties = new JhlPropertyData[keys.size()];
            int i = 0;
            for (String key : keys) {
                svnProperties[i] = JhlPropertyData.newForUrl(target, key, (byte[])propertiesData.get(key));
                ++i;
            }
            return svnProperties;
        }
        catch (ClientException e) {
            this.notificationHandler.logException((Exception)((Object)e));
            throw new SVNClientException(e);
        }
    }

    @Override
    public String getAdminDirectoryName() {
        return this.svnClient.getAdminDirectoryName();
    }

    @Override
    public boolean isAdminDirectory(String name) {
        return this.svnClient.isAdminDirectory(name);
    }

    private void getLogMessages(String target, SVNRevision pegRevision, SVNRevision revisionStart, SVNRevision revisionEnd, boolean stopOnCopy, boolean fetchChangePath, long limit, boolean includeMergedRevisions, String[] requestedProperties, ISVNLogMessageCallback worker) throws SVNClientException {
        try {
            this.notificationHandler.setCommand(13);
            String logExtras = "";
            if (includeMergedRevisions) {
                logExtras = logExtras + " -g";
            }
            if (stopOnCopy) {
                logExtras = logExtras + " --stop-on-copy";
            }
            if (limit > 0L) {
                logExtras = logExtras + " --limit " + limit;
            }
            this.notificationHandler.logCommandLine("log -r " + revisionStart.toString() + ":" + revisionEnd.toString() + " " + target + logExtras);
            JhlLogMessageCallback callback = new JhlLogMessageCallback(worker);
            HashSet<String> revProps = new HashSet<String>(requestedProperties.length);
            for (int i = 0; i < requestedProperties.length; ++i) {
                revProps.add(requestedProperties[i]);
            }
            ArrayList<RevisionRange> range = new ArrayList<RevisionRange>();
            range.add(new RevisionRange(JhlConverter.convert(revisionStart), JhlConverter.convert(revisionEnd)));
            this.svnClient.logMessages(target, JhlConverter.convert(pegRevision), range, stopOnCopy, fetchChangePath, includeMergedRevisions, revProps, limit, (LogMessageCallback)callback);
        }
        catch (ClientException e) {
            if (e.getAprError() == 200007 && includeMergedRevisions) {
                this.getLogMessages(target, pegRevision, revisionStart, revisionEnd, stopOnCopy, fetchChangePath, limit, false, requestedProperties, worker);
            }
            if (!(e.getAprError() != 160013 && e.getAprError() != 195012 || pegRevision == null || pegRevision.equals(revisionStart))) {
                this.getLogMessages(target, pegRevision, pegRevision, revisionEnd, stopOnCopy, fetchChangePath, limit, includeMergedRevisions, requestedProperties, worker);
            }
            this.notificationHandler.logException((Exception)((Object)e));
            throw new SVNClientException(e);
        }
    }

    @Override
    public void getLogMessages(File path, SVNRevision pegRevision, SVNRevision revisionStart, SVNRevision revisionEnd, boolean stopOnCopy, boolean fetchChangePath, long limit, boolean includeMergedRevisions, String[] requestedProperties, ISVNLogMessageCallback worker) throws SVNClientException {
        String target = AbstractJhlClientAdapter.fileToSVNPath(path, false);
        this.notificationHandler.setBaseDir();
        this.getLogMessages(target, pegRevision, revisionStart, revisionEnd, stopOnCopy, fetchChangePath, limit, includeMergedRevisions, requestedProperties, worker);
    }

    @Override
    public void getLogMessages(SVNUrl url, SVNRevision pegRevision, SVNRevision revisionStart, SVNRevision revisionEnd, boolean stopOnCopy, boolean fetchChangePath, long limit, boolean includeMergedRevisions, String[] requestedProperties, ISVNLogMessageCallback worker) throws SVNClientException {
        String target = url.toString();
        this.notificationHandler.setBaseDir();
        this.getLogMessages(target, pegRevision, revisionStart, revisionEnd, stopOnCopy, fetchChangePath, limit, includeMergedRevisions, requestedProperties, worker);
    }

    @Override
    public void relocate(String from, String to, String path, boolean recurse) throws SVNClientException {
        try {
            this.notificationHandler.setCommand(30);
            this.notificationHandler.logCommandLine("switch --relocate " + from + " " + to + " " + path);
            this.notificationHandler.setBaseDir(SVNBaseDir.getBaseDir(new File(path)));
            boolean ignoreAncestry = false;
            this.svnClient.relocate(from, to, path, ignoreAncestry);
        }
        catch (ClientException e) {
            this.notificationHandler.logException((Exception)((Object)e));
            throw new SVNClientException(e);
        }
    }

    @Override
    public void diff(File path, SVNUrl url, SVNRevision urlRevision, File outFile, boolean recurse) throws SVNClientException {
        try {
            this.notificationHandler.setCommand(17);
            String wcPath = AbstractJhlClientAdapter.fileToSVNPath(path, false);
            String svnOutFile = AbstractJhlClientAdapter.fileToSVNPath(outFile, false);
            String commandLine = "diff --old " + wcPath + " ";
            commandLine = commandLine + "--new " + url.toString();
            if (!urlRevision.equals(SVNRevision.HEAD)) {
                commandLine = commandLine + "@" + urlRevision.toString();
            }
            this.notificationHandler.logCommandLine(commandLine);
            this.notificationHandler.setBaseDir(SVNBaseDir.getBaseDir(path));
            this.svnClient.diff(wcPath, Revision.WORKING, url.toString(), JhlConverter.convert(urlRevision), null, svnOutFile, Depth.infinityOrEmpty((boolean)recurse), null, false, true, false, true);
        }
        catch (ClientException e) {
            this.notificationHandler.logException((Exception)((Object)e));
            throw new SVNClientException(e);
        }
    }

    @Override
    public void mkdir(SVNUrl url, boolean makeParents, String message) throws SVNClientException {
        try {
            String fixedMessage = this.fixSVNString(message);
            if (fixedMessage == null) {
                fixedMessage = "";
            }
            this.notificationHandler.setCommand(10);
            HashSet<String> target = new HashSet<String>();
            target.add(url.toString());
            if (makeParents) {
                this.notificationHandler.logCommandLine("mkdir --parents -m \"" + this.getFirstMessageLine(fixedMessage) + "\" " + target);
            } else {
                this.notificationHandler.logCommandLine("mkdir -m \"" + this.getFirstMessageLine(fixedMessage) + "\" " + target);
            }
            this.notificationHandler.setBaseDir();
            this.svnClient.mkdir(target, makeParents, null, (CommitMessageCallback)new JhlCommitMessage(fixedMessage), null);
        }
        catch (ClientException e) {
            this.notificationHandler.logException((Exception)((Object)e));
            throw new SVNClientException(e);
        }
    }

    @Override
    public void merge(SVNUrl url, SVNRevision pegRevision, SVNRevisionRange[] revisions, File localPath, boolean force, int depth, boolean ignoreAncestry, boolean dryRun, boolean recordOnly) throws SVNClientException {
        try {
            this.notificationHandler.setCommand(27);
            String target = AbstractJhlClientAdapter.fileToSVNPath(localPath, false);
            String commandLine = "merge";
            if (dryRun) {
                commandLine = commandLine + " --dry-run";
            }
            Depth d = JhlConverter.depth(depth);
            commandLine = commandLine + this.depthCommandLine(d);
            if (force) {
                commandLine = commandLine + " --force";
            }
            if (ignoreAncestry) {
                commandLine = commandLine + " --ignore-ancestry";
            }
            List<RevisionRange> range = JhlConverter.convert(revisions);
            for (int i = 0; i < revisions.length; ++i) {
                commandLine = commandLine + " " + revisions[i].toMergeString();
            }
            commandLine = commandLine + " " + url.toString();
            commandLine = commandLine + " " + target;
            this.notificationHandler.logCommandLine(commandLine);
            File baseDir = SVNBaseDir.getBaseDir(localPath);
            this.notificationHandler.setBaseDir(baseDir);
            Revision peg = JhlConverter.convert(pegRevision);
            if (peg == null) {
                peg = Revision.HEAD;
            }
            this.svnClient.merge(url.toString(), peg, range, target, force, d, ignoreAncestry, dryRun, recordOnly);
            if (dryRun) {
                this.notificationHandler.logCompleted("Dry-run merge complete.");
            } else {
                this.notificationHandler.logCompleted("Merge complete.");
            }
        }
        catch (ClientException e) {
            this.notificationHandler.logException((Exception)((Object)e));
            if (dryRun) {
                this.notificationHandler.logCompleted("Dry-run merge completed abnormally.");
            } else {
                this.notificationHandler.logCompleted("Merge completed abnormally.");
            }
            SVNClientException svnClientException = new SVNClientException(e);
            svnClientException.setAprError(e.getAprError());
            throw svnClientException;
        }
    }

    private String depthCommandLine(Depth depth) {
        switch (depth) {
            case empty: {
                return " --depth=empty";
            }
            case files: {
                return " --depth=files";
            }
            case immediates: {
                return " --depth=immediates";
            }
            case infinity: {
                return " --depth=infinity";
            }
            case exclude: {
                return " --depth=exclude";
            }
        }
        return "";
    }

    @Override
    public ISVNMergeInfo getMergeInfo(File path, SVNRevision revision) throws SVNClientException {
        return this.getMergeInfo(AbstractJhlClientAdapter.fileToSVNPath(path, false), JhlConverter.convert(revision));
    }

    @Override
    public ISVNMergeInfo getMergeInfo(SVNUrl url, SVNRevision revision) throws SVNClientException {
        return this.getMergeInfo(url.toString(), JhlConverter.convert(revision));
    }

    private ISVNMergeInfo getMergeInfo(String path, Revision revision) throws SVNClientException {
        try {
            Mergeinfo info = this.svnClient.getMergeinfo(path, revision);
            if (info == null) {
                return null;
            }
            return new JhlMergeInfo(info);
        }
        catch (SubversionException e) {
            throw new SVNClientException(e);
        }
    }

    @Override
    public void addConflictResolutionCallback(ISVNConflictResolver callback) {
        this.conflictResolver = callback == null ? null : new JhlConflictResolver(callback);
        this.svnClient.setConflictResolver((ConflictResolverCallback)this.conflictResolver);
    }

    @Override
    public void setProgressListener(ISVNProgressListener listener) {
        this.progressListener.setWorker(listener);
    }

    private SVNDiffSummary[] diffSummarize(String target1, SVNRevision revision1, String target2, SVNRevision revision2, int depth, boolean ignoreAncestry) throws SVNClientException {
        try {
            this.notificationHandler.setCommand(17);
            if (revision1 == null) {
                revision1 = SVNRevision.HEAD;
            }
            if (revision2 == null) {
                revision2 = SVNRevision.HEAD;
            }
            String commandLine = "diff --summarize";
            Depth d = JhlConverter.depth(depth);
            commandLine = commandLine + this.depthCommandLine(d);
            if (ignoreAncestry) {
                commandLine = commandLine + " --ignoreAncestry";
            }
            commandLine = commandLine + " " + target1 + "@" + revision1 + " " + target2 + "@" + revision2;
            this.notificationHandler.logCommandLine(commandLine);
            this.notificationHandler.setBaseDir();
            JhlDiffSummaryReceiver callback = new JhlDiffSummaryReceiver();
            this.svnClient.diffSummarize(target1, JhlConverter.convert(revision1), target2, JhlConverter.convert(revision2), d, null, ignoreAncestry, (DiffSummaryCallback)callback);
            return callback.getDiffSummary();
        }
        catch (ClientException e) {
            this.notificationHandler.logException((Exception)((Object)e));
            throw new SVNClientException(e);
        }
    }

    private SVNDiffSummary[] diffSummarize(String target, SVNRevision pegRevision, SVNRevision startRevision, SVNRevision endRevision, int depth, boolean ignoreAncestry) throws SVNClientException {
        try {
            this.notificationHandler.setCommand(17);
            if (pegRevision == null) {
                pegRevision = SVNRevision.HEAD;
            }
            if (startRevision == null) {
                startRevision = SVNRevision.HEAD;
            }
            if (endRevision == null) {
                endRevision = SVNRevision.HEAD;
            }
            String commandLine = "diff --summarize";
            Depth d = JhlConverter.depth(depth);
            commandLine = commandLine + this.depthCommandLine(d);
            if (ignoreAncestry) {
                commandLine = commandLine + " --ignoreAncestry";
            }
            commandLine = commandLine + " -r " + startRevision + ":" + endRevision + " " + target;
            this.notificationHandler.logCommandLine(commandLine);
            this.notificationHandler.setBaseDir();
            JhlDiffSummaryReceiver callback = new JhlDiffSummaryReceiver();
            this.svnClient.diffSummarize(target, JhlConverter.convert(pegRevision), JhlConverter.convert(startRevision), JhlConverter.convert(endRevision), d, null, ignoreAncestry, (DiffSummaryCallback)callback);
            return callback.getDiffSummary();
        }
        catch (ClientException e) {
            this.notificationHandler.logException((Exception)((Object)e));
            throw new SVNClientException(e);
        }
    }

    public SVNDiffSummary[] diffSummarize(File path, SVNRevision pegRevision, SVNRevision startRevision, SVNRevision endRevision, int depth, boolean ignoreAncestry) throws SVNClientException {
        String target = AbstractJhlClientAdapter.fileToSVNPath(path, false);
        return this.diffSummarize(target, pegRevision, startRevision, endRevision, depth, ignoreAncestry);
    }

    @Override
    public SVNDiffSummary[] diffSummarize(SVNUrl url, SVNRevision pegRevision, SVNRevision startRevision, SVNRevision endRevision, int depth, boolean ignoreAncestry) throws SVNClientException {
        return this.diffSummarize(url.toString(), pegRevision, startRevision, endRevision, depth, ignoreAncestry);
    }

    public SVNDiffSummary[] diffSummarize(File target1, SVNRevision revision1, SVNUrl target2, SVNRevision revision2, int depth, boolean ignoreAncestry) throws SVNClientException {
        return this.diffSummarize(AbstractJhlClientAdapter.fileToSVNPath(target1, false), revision1, target2.toString(), revision2, depth, ignoreAncestry);
    }

    @Override
    public SVNDiffSummary[] diffSummarize(SVNUrl target1, SVNRevision revision1, SVNUrl target2, SVNRevision revision2, int depth, boolean ignoreAncestry) throws SVNClientException {
        return this.diffSummarize(target1.toString(), revision1, target2.toString(), revision2, depth, ignoreAncestry);
    }

    @Override
    public SVNDiffSummary[] diffSummarize(File path, SVNUrl toUrl, SVNRevision toRevision, boolean recurse) throws SVNClientException {
        return this.diffSummarize(path.getAbsolutePath(), SVNRevision.WORKING, toUrl.toString(), toRevision, Depth.infinity.ordinal(), true);
    }

    private SVNDiffSummary.SVNDiffKind getDiffKind(String changedResource, boolean deletedLines, boolean addedLines, boolean contextLines, boolean oldRev0, boolean newRev0) {
        SVNDiffSummary.SVNDiffKind diffKind = oldRev0 && newRev0 ? SVNDiffSummary.SVNDiffKind.DELETED : (addedLines && !deletedLines && !contextLines ? SVNDiffSummary.SVNDiffKind.ADDED : (!deletedLines && !addedLines || deletedLines && !addedLines && !contextLines ? (this.exists(changedResource) ? SVNDiffSummary.SVNDiffKind.DELETED : SVNDiffSummary.SVNDiffKind.ADDED) : SVNDiffSummary.SVNDiffKind.MODIFIED));
        return diffKind;
    }

    private boolean exists(String changedResource) {
        File file = new File(changedResource);
        return file.exists();
    }

    @Override
    public String[] suggestMergeSources(File path) throws SVNClientException {
        String[] sources = null;
        try {
            Set s = this.svnClient.suggestMergeSources(AbstractJhlClientAdapter.fileToSVNPath(path, false), Revision.HEAD);
            sources = new String[s.size()];
            s.toArray(sources);
        }
        catch (SubversionException e) {
            throw new SVNClientException(e);
        }
        return sources;
    }

    @Override
    public String[] suggestMergeSources(SVNUrl url, SVNRevision peg) throws SVNClientException {
        String[] sources = null;
        try {
            Set s = this.svnClient.suggestMergeSources(url.toString(), JhlConverter.convert(peg));
            sources = new String[s.size()];
            s.toArray(sources);
        }
        catch (SubversionException e) {
            throw new SVNClientException(e);
        }
        return sources;
    }

    @Override
    public void createPatch(File[] paths, File relativeToPath, File outFile, boolean recurse) throws SVNClientException {
        FileOutputStream os = null;
        try {
            ArrayList<File> tempFiles = new ArrayList<File>();
            for (int i = 0; i < paths.length; ++i) {
                File tempFile = File.createTempFile("tempDiff", ".txt");
                tempFile.deleteOnExit();
                this.diffRelative(paths[i], SVNRevision.BASE, paths[i], SVNRevision.WORKING, tempFile, recurse, false, false, false, relativeToPath);
                tempFiles.add(tempFile);
            }
            os = new FileOutputStream(outFile);
            for (File tempFile : tempFiles) {
                int bytes_read;
                FileInputStream is = new FileInputStream(tempFile);
                byte[] buffer = new byte[4096];
                while ((bytes_read = is.read(buffer)) != -1) {
                    os.write(buffer, 0, bytes_read);
                }
                is.close();
            }
        }
        catch (Exception e) {
            throw new SVNClientException(e);
        }
        finally {
            if (os != null) {
                try {
                    os.close();
                }
                catch (IOException e) {}
            }
        }
    }

    @Override
    public void dispose() {
        this.svnClient.dispose();
    }

    @Override
    public ISVNLogMessage[] getMergeinfoLog(int kind, File path, SVNRevision pegRevision, SVNUrl mergeSourceUrl, SVNRevision srcPegRevision, boolean discoverChangedPaths) throws SVNClientException {
        return this.getMergeinfoLog(kind, AbstractJhlClientAdapter.fileToSVNPath(path, false), pegRevision, mergeSourceUrl, srcPegRevision, discoverChangedPaths);
    }

    @Override
    public ISVNLogMessage[] getMergeinfoLog(int kind, SVNUrl url, SVNRevision pegRevision, SVNUrl mergeSourceUrl, SVNRevision srcPegRevision, boolean discoverChangedPaths) throws SVNClientException {
        return this.getMergeinfoLog(kind, url.toString(), pegRevision, mergeSourceUrl, srcPegRevision, discoverChangedPaths);
    }

    private ISVNLogMessage[] getMergeinfoLog(int kind, String target, SVNRevision pegRevision, SVNUrl mergeSourceUrl, SVNRevision srcPegRevision, boolean discoverChangedPaths) throws SVNClientException {
        try {
            this.notificationHandler.setCommand(32);
            String show = "";
            Mergeinfo.LogKind mergeKind = Mergeinfo.LogKind.eligible;
            if (kind == 0) {
                show = show + " --show-revs eligible ";
            }
            if (kind == 1) {
                show = show + " --show-revs merged ";
                mergeKind = Mergeinfo.LogKind.merged;
            }
            this.notificationHandler.logCommandLine("mergeinfo " + show + mergeSourceUrl.toString() + " " + target);
            SVNLogMessageCallback worker = new SVNLogMessageCallback();
            JhlLogMessageCallback callback = new JhlLogMessageCallback(worker);
            HashSet<String> revProps = new HashSet<String>();
            revProps.add("svn:author");
            revProps.add("svn:date");
            revProps.add("svn:log");
            this.svnClient.getMergeinfoLog(mergeKind, target, JhlConverter.convert(pegRevision), mergeSourceUrl.toString(), JhlConverter.convert(srcPegRevision), discoverChangedPaths, Depth.infinity, revProps, (LogMessageCallback)callback);
            return worker.getLogMessages();
        }
        catch (ClientException e) {
            if (e.getAprError() == 200007) {
                return this.getLogMessages(mergeSourceUrl, srcPegRevision, (SVNRevision)new SVNRevision.Number(0L), SVNRevision.HEAD, true, discoverChangedPaths, 0L, false);
            }
            this.notificationHandler.logException((Exception)((Object)e));
            throw new SVNClientException(e);
        }
    }

    private String appendPaths(String commandLine, Set<String> paths) {
        StringBuffer stringBuffer = new StringBuffer(commandLine);
        if (paths.size() > 5) {
            stringBuffer.append(" (" + paths.size() + " paths specified)");
        } else {
            for (String s : paths) {
                stringBuffer.append(" " + s);
            }
        }
        return stringBuffer.toString();
    }

    private String getFirstMessageLine(String message) {
        StringTokenizer tokenizer = new StringTokenizer(message, "\n");
        int count = tokenizer.countTokens();
        if (count > 1) {
            return tokenizer.nextToken() + "...";
        }
        return message;
    }

    protected String fixSVNString(String message) {
        if (message == null) {
            return null;
        }
        return message.replaceAll("\r\n", "\n").replaceAll("\r", "\n");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class MyStatusCallback
    implements StatusCallback {
        private List<Status> statuses = new ArrayList<Status>();

        private MyStatusCallback() {
        }

        public void doStatus(String path, Status status) {
            if (status != null) {
                this.statuses.add(status);
            }
        }

        public List<Status> getStatusList() {
            return this.statuses;
        }
    }

    public static class DefaultPromptUserPassword
    implements UserPasswordCallback {
        public int askTrustSSLServer(String info, boolean allowPermanently) {
            return 1;
        }

        public String askQuestion(String realm, String question, boolean showAnswer) {
            return "";
        }

        public boolean askYesNo(String realm, String question, boolean yesIsDefault) {
            return yesIsDefault;
        }

        public String getPassword() {
            return "";
        }

        public String getUsername() {
            return "";
        }

        public boolean prompt(String realm, String username) {
            return false;
        }

        public boolean prompt(String realm, String username, boolean maySave) {
            return false;
        }

        public String askQuestion(String realm, String question, boolean showAnswer, boolean maySave) {
            return null;
        }

        public boolean userAllowedSave() {
            return false;
        }
    }
}

