/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.svnclientadapter.javahl;

import org.apache.subversion.javahl.ClientNotifyInformation;
import org.apache.subversion.javahl.callback.ClientNotifyCallback;
import org.apache.subversion.javahl.types.Revision;
import org.apache.subversion.javahl.types.RevisionRange;
import org.tigris.subversion.svnclientadapter.SVNNotificationHandler;
import org.tigris.subversion.svnclientadapter.javahl.JhlConverter;
import org.tigris.subversion.svnclientadapter.utils.Messages;

public class JhlNotificationHandler
extends SVNNotificationHandler
implements ClientNotifyCallback {
    private boolean receivedSomeChange;
    private boolean sentFirstTxdelta;
    private int updates;
    private int adds;
    private int deletes;
    private int conflicts;
    private int merges;
    private int exists;
    private int propConflicts;
    private int treeConflicts;
    private int propMerges;
    private int propUpdates;
    private boolean inExternal;
    private boolean holdStats;
    private String lastUpdate;
    private String lastExternalUpdate;
    private boolean statsCommand = false;
    private static final int COMMIT_ACROSS_WC_COMPLETED = -11;
    private static final int ENDED_ABNORMAL = -1;

    public void onNotify(ClientNotifyInformation info) {
        boolean notify = true;
        switch (info.getAction()) {
            case foreign_merge_begin: {
                if (info.getMergeRange() != null) {
                    if (info.getMergeRange().getFromRevision().equals((Object)info.getMergeRange().getToRevision())) {
                        this.logMessage("--- Merging (from foreign repository) r" + info.getMergeRange().getFromRevision().toString() + " into " + info.getPath());
                    } else if (info.getMergeRange().getToRevision().equals((Object)Revision.HEAD) || RevisionRange.getRevisionAsLong((Revision)info.getMergeRange().getToRevision()) > RevisionRange.getRevisionAsLong((Revision)info.getMergeRange().getFromRevision())) {
                        this.logMessage("--- Merging (from foreign repository) r" + info.getMergeRange().getFromRevision().toString() + " through r" + info.getMergeRange().getToRevision().toString() + " into " + info.getPath());
                    } else {
                        this.logMessage("--- Reverse-merging (from foreign repository) r" + info.getMergeRange().getFromRevision().toString() + " through r" + info.getMergeRange().getToRevision().toString() + " into " + info.getPath());
                    }
                } else {
                    this.logMessage("--- Merging differences between foreign repository URLs into " + info.getPath());
                }
                notify = false;
                break;
            }
            case merge_begin: {
                if (info.getMergeRange() != null) {
                    if (info.getMergeRange().getFromRevision().equals((Object)info.getMergeRange().getToRevision())) {
                        this.logMessage("--- Merging r" + info.getMergeRange().getFromRevision().toString() + " into " + info.getPath());
                    } else if (info.getMergeRange().getToRevision().equals((Object)Revision.HEAD) || RevisionRange.getRevisionAsLong((Revision)info.getMergeRange().getToRevision()) > RevisionRange.getRevisionAsLong((Revision)info.getMergeRange().getFromRevision())) {
                        this.logMessage("--- Merging r" + info.getMergeRange().getFromRevision().toString() + " through r" + info.getMergeRange().getToRevision().toString() + " into " + info.getPath());
                    } else {
                        this.logMessage("--- Reverse-merging r" + info.getMergeRange().getFromRevision().toString() + " through r" + info.getMergeRange().getToRevision().toString() + " into " + info.getPath());
                    }
                } else {
                    this.logMessage("--- Merging differences between repository URLs into " + info.getPath());
                }
                notify = false;
                break;
            }
            case skip: {
                notify = this.logSkipped(info, Messages.bind("notify.skipped", info.getPath()));
                break;
            }
            case skip_conflicted: {
                notify = this.logSkipped(info, Messages.bind("notify.skipped.conflicted", info.getPath()));
                break;
            }
            case update_skip_obstruction: {
                notify = this.logSkipped(info, Messages.bind("notify.update.skip.obstruction", info.getPath()));
                break;
            }
            case update_skip_working_only: {
                notify = this.logSkipped(info, Messages.bind("notify.update.skip.working.only", info.getPath()));
                break;
            }
            case update_skip_access_denied: {
                notify = this.logSkipped(info, Messages.bind("notify.update.skip.access.denied", info.getPath()));
                break;
            }
            case failed_lock: {
                notify = this.logFailedOperation(info, Messages.bind("notify.lock.failed", info.getPath()));
                break;
            }
            case failed_unlock: {
                notify = this.logFailedOperation(info, Messages.bind("notify.unlock.failed", info.getPath()));
                break;
            }
            case locked: {
                if (info.getLock() != null && info.getLock().getOwner() != null) {
                    this.logMessage(Messages.bind("notify.lock.other", info.getLock().getPath(), info.getLock().getOwner()));
                } else {
                    this.logMessage(Messages.bind("notify.lock", info.getPath()));
                }
                notify = false;
                break;
            }
            case unlocked: {
                this.logMessage(Messages.bind("notify.unlock", info.getPath()));
                notify = false;
                break;
            }
            case update_delete: 
            case update_shadowed_delete: {
                this.logMessage("D   " + info.getPath());
                this.receivedSomeChange = true;
                ++this.deletes;
                break;
            }
            case update_replaced: {
                this.logMessage("R   " + info.getPath());
                this.receivedSomeChange = true;
                ++this.adds;
                ++this.deletes;
                break;
            }
            case update_add: 
            case update_shadowed_add: {
                this.logMessage("A   " + info.getPath());
                this.receivedSomeChange = true;
                ++this.adds;
                break;
            }
            case exists: {
                this.logMessage("E   " + info.getPath());
                this.receivedSomeChange = true;
                ++this.exists;
                break;
            }
            case changelist_set: {
                this.logMessage(Messages.bind("notify.changelist.set", info.getPath()));
                notify = false;
                break;
            }
            case changelist_clear: {
                this.logMessage(Messages.bind("notify.changelist.clear", info.getPath()));
                notify = false;
                break;
            }
            case changelist_moved: {
                this.logMessage(Messages.bind("notify.changelist.moved", info.getPath()));
                notify = false;
                break;
            }
            case restore: {
                this.logMessage(Messages.bind("notify.restored", info.getPath()));
                break;
            }
            case revert: {
                this.logMessage(Messages.bind("notify.reverted", info.getPath()));
                break;
            }
            case failed_revert: {
                this.logError(Messages.bind("notify.revert.failed", info.getPath()));
                notify = false;
                break;
            }
            case resolved: {
                this.logMessage(Messages.bind("notify.resolved", info.getPath()));
                break;
            }
            case add: {
                this.logMessage("A         " + info.getPath());
                break;
            }
            case copy: {
                this.logMessage(Messages.bind("notify.copy", info.getPath()));
                notify = false;
                break;
            }
            case delete: {
                this.logMessage("D         " + info.getPath());
                this.receivedSomeChange = true;
                break;
            }
            case tree_conflict: {
                this.logError("  C " + info.getPath());
                this.receivedSomeChange = true;
                ++this.treeConflicts;
                break;
            }
            case update_update: 
            case update_shadowed_update: {
                boolean error = false;
                if (info.getKind().ordinal() == 2 && (info.getPropState() == ClientNotifyInformation.Status.inapplicable || info.getPropState() == ClientNotifyInformation.Status.unknown || info.getPropState() == ClientNotifyInformation.Status.unchanged)) break;
                this.receivedSomeChange = true;
                char[] statecharBuf = new char[]{' ', ' '};
                if (info.getKind().ordinal() == 1) {
                    if (info.getContentState() == ClientNotifyInformation.Status.conflicted) {
                        statecharBuf[0] = 67;
                        ++this.conflicts;
                        error = true;
                    } else if (info.getContentState() == ClientNotifyInformation.Status.merged) {
                        statecharBuf[0] = 71;
                        ++this.merges;
                        error = true;
                    } else if (info.getContentState() == ClientNotifyInformation.Status.changed) {
                        statecharBuf[0] = 85;
                        ++this.updates;
                    } else if (info.getContentState() == ClientNotifyInformation.Status.unchanged && info.getPropState().ordinal() < ClientNotifyInformation.Status.obstructed.ordinal()) break;
                }
                if (info.getPropState() == ClientNotifyInformation.Status.conflicted) {
                    statecharBuf[1] = 67;
                    ++this.propConflicts;
                    error = true;
                } else if (info.getPropState() == ClientNotifyInformation.Status.merged) {
                    statecharBuf[1] = 71;
                    ++this.propMerges;
                    error = true;
                } else if (info.getPropState() == ClientNotifyInformation.Status.changed) {
                    statecharBuf[1] = 85;
                    ++this.propUpdates;
                }
                if (info.getContentState() == ClientNotifyInformation.Status.unknown && info.getPropState() == ClientNotifyInformation.Status.unknown) break;
                if (error) {
                    this.logError("" + statecharBuf[0] + statecharBuf[1] + "  " + info.getPath());
                    break;
                }
                this.logMessage("" + statecharBuf[0] + statecharBuf[1] + "  " + info.getPath());
                break;
            }
            case update_external: {
                this.logMessage(Messages.bind("notify.update.external", info.getPath()));
                this.inExternal = true;
                break;
            }
            case update_external_removed: {
                this.logMessage(Messages.bind("notify.update.external.removed", info.getPath()));
                break;
            }
            case update_completed: {
                notify = false;
                if (info.getRevision() >= 0L) {
                    this.logRevision(info.getRevision(), info.getPath());
                    if (this.command == 8) {
                        this.logCompleted(Messages.bind("notify.export", Long.toString(info.getRevision())));
                        break;
                    }
                    if (this.command == 2) {
                        this.logCompleted(Messages.bind("notify.checkout", Long.toString(info.getRevision())));
                        break;
                    }
                    if (this.receivedSomeChange) {
                        if (this.holdStats) {
                            if (this.inExternal) {
                                this.lastExternalUpdate = Messages.bind("notify.update", Long.toString(info.getRevision()));
                                break;
                            }
                            this.lastUpdate = Messages.bind("notify.update", Long.toString(info.getRevision()));
                            break;
                        }
                        this.logCompleted(Messages.bind("notify.update", Long.toString(info.getRevision())));
                        break;
                    }
                    this.logCompleted(Messages.bind("notify.at", Long.toString(info.getRevision())));
                    break;
                }
                if (this.command == 8) {
                    this.logCompleted(Messages.bind("notify.export.complete"));
                    break;
                }
                if (this.command == 2) {
                    this.logCompleted(Messages.bind("notify.checkout.complete"));
                    break;
                }
                this.logCompleted(Messages.bind("notify.update.complete"));
                break;
            }
            case status_external: {
                if (!this.skipCommand()) {
                    this.logMessage(Messages.bind("notify.status.external", info.getPath()));
                }
                notify = false;
                break;
            }
            case status_completed: {
                notify = false;
                if (info.getRevision() < 0L) break;
                this.logRevision(info.getRevision(), info.getPath());
                if (this.skipCommand()) break;
                this.logMessage(Messages.bind("notify.status.revision", Long.toString(info.getRevision())));
                break;
            }
            case commit_modified: {
                this.logMessage(Messages.bind("notify.commit.modified", info.getPath()));
                break;
            }
            case commit_added: 
            case commit_copied: {
                this.logMessage(Messages.bind("notify.commit.add", info.getPath()));
                break;
            }
            case commit_deleted: {
                this.logMessage(Messages.bind("notify.commit.delete", info.getPath()));
                break;
            }
            case commit_replaced: 
            case commit_copied_replaced: {
                this.logMessage(Messages.bind("notify.commit.replace", info.getPath()));
                break;
            }
            case commit_postfix_txdelta: {
                notify = false;
                if (this.sentFirstTxdelta) break;
                this.logMessage(Messages.bind("notify.commit.transmit"));
                this.sentFirstTxdelta = true;
                break;
            }
            case url_redirect: {
                break;
            }
            case property_added: {
                this.logMessage(Messages.bind("notify.property.set", info.getPath()));
                break;
            }
            case property_modified: {
                this.logMessage(Messages.bind("notify.property.set", info.getPath()));
                break;
            }
            case property_deleted: {
                this.logMessage(Messages.bind("notify.property.deleted", info.getPath()));
                break;
            }
            case property_deleted_nonexistent: {
                notify = false;
                this.logMessage(Messages.bind("notify.property.deleted.nonexistent"));
                break;
            }
            case revprop_set: {
                notify = false;
                this.logMessage(Messages.bind("notify.revision.property.set"));
                break;
            }
            case revprop_deleted: {
                notify = false;
                this.logMessage(Messages.bind("notify.revision.property.deleted"));
                break;
            }
            case merge_completed: {
                break;
            }
            case blame_revision: {
                break;
            }
            case update_started: {
                break;
            }
            case merge_record_info: {
                this.logMessage(Messages.bind("notify.merge.record.info", info.getPath()));
                ++this.propUpdates;
                break;
            }
            case merge_record_info_begin: {
                break;
            }
            case merge_elide_info: {
                break;
            }
            case patch: {
                notify = false;
                this.logMessage(Messages.bind("notify.patch"));
                break;
            }
            case patch_applied_hunk: {
                this.logMessage(Messages.bind("notify.patch.applied.hunk", info.getPath()));
                break;
            }
            case patch_rejected_hunk: {
                notify = this.logFailedOperation(info, Messages.bind("notify.patch.rejected.hunk", info.getPath()));
                break;
            }
            case patch_hunk_already_applied: {
                notify = this.logFailedOperation(info, Messages.bind("notify.patch.hunk.already.applied", info.getPath()));
                break;
            }
            case upgraded_path: {
                this.logMessage(Messages.bind("notify.upgraded.path", info.getPath()));
                break;
            }
            case failed_external: {
                notify = this.logFailedOperation(info, Messages.bind("notify.external", info.getPath()));
                break;
            }
            case failed_conflict: {
                notify = this.logFailedOperation(info, Messages.bind("notify.conflict", info.getPath()));
                break;
            }
            case failed_missing: {
                notify = this.logFailedOperation(info, Messages.bind("notify.missing", info.getPath()));
                break;
            }
            case failed_out_of_date: {
                notify = this.logFailedOperation(info, Messages.bind("notify.out.of.date", info.getPath()));
                break;
            }
            case failed_no_parent: {
                notify = this.logFailedOperation(info, Messages.bind("notify.no.parent"));
                break;
            }
            case failed_locked: {
                notify = this.logFailedOperation(info, Messages.bind("notify.locked", info.getPath()));
                break;
            }
            case failed_forbidden_by_server: {
                notify = this.logFailedOperation(info, Messages.bind("notify.forbidden.by.server"));
                break;
            }
            case failed_obstructed: {
                notify = this.logFailedOperation(info, Messages.bind("notify.obstructed"));
                break;
            }
            case path_nonexistent: {
                notify = this.logFailedOperation(info, Messages.bind("notify.path.nonexistent", info.getPath()));
                break;
            }
            case exclude: {
                this.logMessage(Messages.bind("notify.exclude", info.getPath()));
                break;
            }
            case conflict_resolver_starting: {
                break;
            }
            case conflict_resolver_done: {
                break;
            }
            case left_local_modifications: {
                this.logMessage(Messages.bind("notify.left.local.modifications", info.getPath()));
                break;
            }
            case foreign_copy_begin: {
                break;
            }
            case update_broken_lock: {
                this.logError(Messages.bind("notify.lock.broken", info.getPath()));
                break;
            }
            case move_broken: {
                this.logError(Messages.bind("notify.move.broken", info.getPath()));
                break;
            }
            default: {
                if (info.getAction().ordinal() == -1) {
                    if (this.command == 3) {
                        this.logError(Messages.bind("notify.commit.abnormal"));
                    } else {
                        this.logError(Messages.bind("notify.end.abnormal"));
                    }
                    if (info.getErrMsg() != null) {
                        this.logError(info.getErrMsg());
                    }
                    notify = false;
                    break;
                }
                if (info.getAction().ordinal() == -11) {
                    notify = false;
                    this.logCompleted(Messages.bind("notify.commit", Long.toString(info.getRevision())));
                    break;
                }
                this.logMessage("Unknown action received: " + info.getAction());
            }
        }
        if (notify) {
            this.notifyListenersOfChange(info.getPath(), JhlConverter.convertNodeKind(info.getKind()));
        }
    }

    private boolean logFailedOperation(ClientNotifyInformation info, String defaultErrorMessage) {
        if (info.getErrMsg() == null) {
            this.logError(defaultErrorMessage);
        } else {
            this.logError(info.getErrMsg());
        }
        return false;
    }

    private boolean logSkipped(ClientNotifyInformation info, String defaultErrorMessage) {
        if (info.getErrMsg() == null) {
            this.logMessage(defaultErrorMessage);
        } else {
            this.logError(info.getErrMsg());
        }
        return false;
    }

    public void setCommand(int command) {
        this.receivedSomeChange = false;
        this.sentFirstTxdelta = false;
        if (command == 4 || command == 27 || command == 26) {
            this.clearStats();
            this.statsCommand = true;
        }
        super.setCommand(command);
    }

    public void logCompleted(String message) {
        super.logCompleted(message);
        if (this.inExternal) {
            this.inExternal = false;
        } else {
            this.logStats();
        }
    }

    private void clearStats() {
        this.adds = 0;
        this.updates = 0;
        this.deletes = 0;
        this.conflicts = 0;
        this.merges = 0;
        this.exists = 0;
        this.propConflicts = 0;
        this.treeConflicts = 0;
        this.propMerges = 0;
        this.propUpdates = 0;
        this.inExternal = false;
        this.holdStats = false;
        this.lastUpdate = null;
        this.lastExternalUpdate = null;
    }

    private void logStats() {
        if (this.holdStats) {
            return;
        }
        if (this.statsCommand) {
            if (this.fileStats()) {
                this.logMessage(Messages.bind("notify.stats.file.head"));
                if (this.merges > 0) {
                    this.logMessage(Messages.bind("notify.stats.merge", Integer.toString(this.merges)));
                }
                if (this.deletes > 0) {
                    this.logMessage(Messages.bind("notify.stats.delete", Integer.toString(this.deletes)));
                }
                if (this.adds > 0) {
                    this.logMessage(Messages.bind("notify.stats.add", Integer.toString(this.adds)));
                }
                if (this.updates > 0) {
                    this.logMessage(Messages.bind("notify.stats.update", Integer.toString(this.updates)));
                }
                if (this.exists > 0) {
                    this.logMessage(Messages.bind("notify.stats.exists", Integer.toString(this.exists)));
                }
            }
            if (this.propStats()) {
                this.logMessage(Messages.bind("notify.stats.prop.head"));
                if (this.propMerges > 0) {
                    this.logMessage(Messages.bind("notify.stats.merge", Integer.toString(this.propMerges)));
                }
                if (this.propUpdates > 0) {
                    this.logMessage(Messages.bind("notify.stats.update", Integer.toString(this.propUpdates)));
                }
            }
            if (this.conflictStats()) {
                this.logMessage(Messages.bind("notify.stats.conflict.head"));
                if (this.conflicts > 0) {
                    this.logMessage(Messages.bind("notify.stats.conflict", Integer.toString(this.conflicts)));
                }
                if (this.propConflicts > 0) {
                    this.logMessage(Messages.bind("notify.stats.prop.conflicts", Integer.toString(this.propConflicts)));
                }
                if (this.treeConflicts > 0) {
                    this.logMessage(Messages.bind("notify.stats.tree.conflicts", Integer.toString(this.treeConflicts)));
                }
            }
            this.statsCommand = false;
            this.clearStats();
        }
    }

    private boolean fileStats() {
        return this.updates > 0 || this.adds > 0 || this.deletes > 0 || this.merges > 0 || this.exists > 0;
    }

    private boolean conflictStats() {
        return this.treeConflicts > 0 || this.propConflicts > 0 || this.conflicts > 0;
    }

    private boolean propStats() {
        return this.propUpdates > 0 || this.propMerges > 0;
    }

    public void holdStats() {
        this.holdStats = true;
    }

    public void releaseStats() {
        this.holdStats = false;
        if (this.command == 4) {
            if (this.lastExternalUpdate != null) {
                this.logCompleted(this.lastExternalUpdate);
            }
            if (this.lastUpdate != null) {
                this.logCompleted(this.lastUpdate);
            }
        }
        this.logStats();
    }
}

