/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.svnclientadapter.svnkit;

import java.io.File;
import org.apache.subversion.javahl.callback.ClientNotifyCallback;
import org.apache.subversion.javahl.callback.ProgressCallback;
import org.apache.subversion.javahl.callback.UserPasswordCallback;
import org.tigris.subversion.svnclientadapter.ISVNPromptUserPassword;
import org.tigris.subversion.svnclientadapter.ISVNStatus;
import org.tigris.subversion.svnclientadapter.SVNClientException;
import org.tigris.subversion.svnclientadapter.SVNStatusUnversioned;
import org.tigris.subversion.svnclientadapter.javahl.AbstractJhlClientAdapter;
import org.tigris.subversion.svnclientadapter.javahl.JhlNotificationHandler;
import org.tigris.subversion.svnclientadapter.javahl.JhlProgressListener;
import org.tigris.subversion.svnclientadapter.svnkit.SvnKitPromptUserPassword;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.io.SVNRepositoryFactory;
import org.tmatesoft.svn.core.javahl17.SVNClientImpl;

public class SvnKitClientAdapter
extends AbstractJhlClientAdapter {
    public SvnKitClientAdapter() {
        this.svnClient = SVNClientImpl.newInstance();
        this.notificationHandler = new JhlNotificationHandler();
        this.progressListener = new JhlProgressListener();
        this.svnClient.notification2((ClientNotifyCallback)this.notificationHandler);
        this.svnClient.setPrompt((UserPasswordCallback)new AbstractJhlClientAdapter.DefaultPromptUserPassword());
        this.svnClient.setProgressCallback((ProgressCallback)this.progressListener);
    }

    public boolean isThreadsafe() {
        return false;
    }

    public void createRepository(File path, String repositoryType) throws SVNClientException {
        if ("bdb".equalsIgnoreCase(repositoryType)) {
            throw new SVNClientException("SVNKit only supports fsfs repository type.");
        }
        try {
            boolean force = false;
            boolean enableRevisionProperties = false;
            SVNRepositoryFactory.createLocalRepository((File)path, (boolean)enableRevisionProperties, (boolean)force);
        }
        catch (SVNException e) {
            this.notificationHandler.logException((Exception)((Object)e));
            throw new SVNClientException(e);
        }
    }

    public void addPasswordCallback(ISVNPromptUserPassword callback) {
        if (callback != null) {
            SvnKitPromptUserPassword prompt = new SvnKitPromptUserPassword(callback);
            this.setPromptUserPassword((UserPasswordCallback)prompt);
        }
    }

    public boolean statusReturnsRemoteInfo() {
        return true;
    }

    public boolean canCommitAcrossWC() {
        return false;
    }

    public ISVNStatus[] getStatus(File path, boolean descend, boolean getAll, boolean contactServer, boolean ignoreExternals) throws SVNClientException {
        ISVNStatus[] statuses = super.getStatus(path, descend, getAll, contactServer, ignoreExternals);
        if (statuses.length == 0) {
            if (getAll) {
                return new ISVNStatus[]{new SVNStatusUnversioned(path)};
            }
            ISVNStatus[] reCheckStatuses = super.getStatus(path, false, true, false, true);
            if (reCheckStatuses.length == 0) {
                return new ISVNStatus[]{new SVNStatusUnversioned(path)};
            }
            return new ISVNStatus[0];
        }
        return statuses;
    }
}

