/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.cli.svn;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.tmatesoft.svn.cli.svn.SVNCommand;
import org.tmatesoft.svn.cli.svn.SVNNotifyPrinter;
import org.tmatesoft.svn.cli.svn.SVNOption;
import org.tmatesoft.svn.core.SVNDepth;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.internal.util.SVNEncodingUtil;
import org.tmatesoft.svn.core.internal.util.SVNPathUtil;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.core.internal.wc.SVNPath;
import org.tmatesoft.svn.core.wc.ISVNEventHandler;
import org.tmatesoft.svn.core.wc.SVNRevision;
import org.tmatesoft.svn.core.wc.SVNUpdateClient;
import org.tmatesoft.svn.util.SVNLogType;

public class SVNExportCommand
extends SVNCommand {
    public SVNExportCommand() {
        super("export", null);
    }

    @Override
    protected Collection createSupportedOptions() {
        LinkedList<SVNOption> options = new LinkedList<SVNOption>();
        options.add(SVNOption.REVISION);
        options.add(SVNOption.QUIET);
        options.add(SVNOption.NON_RECURSIVE);
        options.add(SVNOption.DEPTH);
        options.add(SVNOption.FORCE);
        options.add(SVNOption.NATIVE_EOL);
        options.add(SVNOption.IGNORE_EXTERNALS);
        options.add(SVNOption.IGNORE_KEYWORDS);
        return options;
    }

    @Override
    public void run() throws SVNException {
        SVNDepth depth;
        String to;
        List<String> targets = this.getSVNEnvironment().combineTargets(new ArrayList(), true);
        if (targets.isEmpty()) {
            SVNErrorManager.error((SVNErrorMessage)SVNErrorMessage.create((SVNErrorCode)SVNErrorCode.CL_INSUFFICIENT_ARGS), (SVNLogType)SVNLogType.CLIENT);
        }
        if (targets.size() > 2) {
            SVNErrorManager.error((SVNErrorMessage)SVNErrorMessage.create((SVNErrorCode)SVNErrorCode.CL_ARG_PARSING_ERROR), (SVNLogType)SVNLogType.CLIENT);
        }
        SVNPath from = new SVNPath(targets.get(0), true);
        SVNRevision pegRevision = from.getPegRevision();
        if (targets.size() == 1) {
            to = SVNPathUtil.tail((String)from.getTarget());
            if (from.isURL()) {
                to = SVNEncodingUtil.uriDecode((String)to);
            }
        } else {
            to = targets.get(1);
        }
        SVNUpdateClient client = this.getSVNEnvironment().getClientManager().getUpdateClient();
        if (!this.getSVNEnvironment().isQuiet()) {
            client.setEventHandler((ISVNEventHandler)new SVNNotifyPrinter(this.getSVNEnvironment(), false, true, false));
        }
        if ((depth = this.getSVNEnvironment().getDepth()) == SVNDepth.UNKNOWN) {
            depth = SVNDepth.INFINITY;
        }
        try {
            SVNPath dst = new SVNPath(to);
            String eol = this.getSVNEnvironment().getNativeEOL();
            SVNRevision revision = this.getSVNEnvironment().getStartRevision();
            client.setExportExpandsKeywords(!this.getSVNEnvironment().isIgnoreKeywords());
            if (from.isFile()) {
                client.doExport(from.getFile(), dst.getFile(), pegRevision, revision, eol, this.getSVNEnvironment().isForce(), depth);
            } else {
                client.doExport(from.getURL(), dst.getFile(), pegRevision, revision, eol, this.getSVNEnvironment().isForce(), depth);
            }
        }
        catch (SVNException e) {
            SVNErrorMessage err = e.getErrorMessage();
            if (err != null && err.getErrorCode() == SVNErrorCode.WC_OBSTRUCTED_UPDATE) {
                err = err.wrap("Destination directory exists; please remove the directory or use --force to overwrite");
            }
            SVNErrorManager.error((SVNErrorMessage)err, (SVNLogType)SVNLogType.CLIENT);
        }
    }
}

