/*
 * Decompiled with CFR 0.152.
 */
package org.togglz.console.shade.jmte.token;

import java.util.List;
import org.togglz.console.shade.jmte.TemplateContext;
import org.togglz.console.shade.jmte.token.IfToken;

public class IfCmpToken
extends IfToken {
    private final String operand;

    public IfCmpToken(String expression, String operand, boolean negated) {
        super(expression, negated);
        this.operand = operand;
    }

    public IfCmpToken(List<String> segments, String expression, String operand, boolean negated) {
        super(segments, expression, negated);
        this.operand = operand;
    }

    public String getOperand() {
        return this.operand;
    }

    @Override
    public String getText() {
        if (this.text == null) {
            this.text = String.format("if %s='%s'", this.getExpression(), this.getOperand());
        }
        return this.text;
    }

    @Override
    public Object evaluate(TemplateContext context) {
        Object value = this.evaluatePlain(context);
        boolean condition = this.getOperand().equals(value.toString());
        Boolean evaluated = this.negated ? !condition : condition;
        return evaluated;
    }
}

