/*
 * Decompiled with CFR 0.152.
 */
package org.togglz.console.shade.jmte.token;

import java.util.List;
import org.togglz.console.shade.jmte.NamedRenderer;
import org.togglz.console.shade.jmte.Renderer;
import org.togglz.console.shade.jmte.TemplateContext;
import org.togglz.console.shade.jmte.token.ExpressionToken;

public class StringToken
extends ExpressionToken {
    private final String defaultValue;
    private final String prefix;
    private final String suffix;
    private final String rendererName;
    private final String parameters;

    public StringToken() {
        this("", "", null, null, null, null, null);
    }

    public StringToken(String text, String variableName, String defaultValue, String prefix, String suffix, String rendererName, String parameters) {
        super(variableName);
        this.defaultValue = defaultValue;
        this.prefix = prefix;
        this.suffix = suffix;
        this.rendererName = rendererName;
        this.parameters = parameters;
        this.setText(text);
    }

    public StringToken(String variableName) {
        this(variableName, variableName, null, null, null, null, null);
    }

    public StringToken(String text, List<String> segments, String variableName, String defaultValue, String prefix, String suffix, String rendererName, String parameters) {
        super(segments, variableName);
        this.defaultValue = defaultValue;
        this.prefix = prefix;
        this.suffix = suffix;
        this.rendererName = rendererName;
        this.parameters = parameters;
        this.setText(text);
    }

    public StringToken(List<String> segments, String variableName) {
        super(segments, variableName);
        this.defaultValue = null;
        this.prefix = null;
        this.suffix = null;
        this.rendererName = null;
        this.parameters = null;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public String getSuffix() {
        return this.suffix;
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    @Override
    public Object evaluate(TemplateContext context) {
        String renderedResult;
        Object value = this.evaluatePlain(context);
        if (value == null || value.equals("")) {
            renderedResult = this.defaultValue != null ? this.defaultValue : "";
        } else {
            Renderer<?> rendererForClass;
            NamedRenderer rendererForName;
            String namedRendererResult = null;
            if (this.rendererName != null && !this.rendererName.equals("") && (rendererForName = context.resolveNamedRenderer(this.rendererName)) != null) {
                namedRendererResult = rendererForName.render(value, this.parameters, context.locale);
            }
            renderedResult = namedRendererResult != null ? namedRendererResult : ((rendererForClass = context.resolveRendererForClass(value.getClass())) != null ? rendererForClass.render(value, context.locale) : value.toString());
        }
        if (renderedResult == null || renderedResult.equals("")) {
            return renderedResult;
        }
        return (this.prefix != null ? this.prefix : "") + renderedResult + (this.suffix != null ? this.suffix : "");
    }

    public String getRendererName() {
        return this.rendererName;
    }

    public String getParameters() {
        return this.parameters;
    }
}

