/*
 * Decompiled with CFR 0.152.
 */
package org.togglz.console;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ServiceLoader;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.togglz.console.RequestEvent;
import org.togglz.console.RequestHandler;
import org.togglz.core.manager.FeatureManager;
import org.togglz.core.manager.LazyResolvingFeatureManager;
import org.togglz.core.user.FeatureUser;

public class TogglzConsoleServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    protected final List<RequestHandler> handlers = new ArrayList<RequestHandler>();
    protected ServletContext servletContext;
    protected FeatureManager featureManager;

    public void init(ServletConfig config) throws ServletException {
        this.featureManager = new LazyResolvingFeatureManager();
        this.servletContext = config.getServletContext();
        Iterator<RequestHandler> handlerIterator = ServiceLoader.load(RequestHandler.class).iterator();
        while (handlerIterator.hasNext()) {
            this.handlers.add(handlerIterator.next());
        }
    }

    protected void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        FeatureUser user = this.featureManager.getCurrentFeatureUser();
        if (user == null || !user.isFeatureAdmin()) {
            response.sendError(403, "You are not allowed to access the Togglz Console");
            return;
        }
        RequestEvent consoleRequest = new RequestEvent(this.featureManager, this.servletContext, request, response);
        String path = consoleRequest.getPath();
        for (RequestHandler page : this.handlers) {
            if (!page.handles(path)) continue;
            page.process(consoleRequest);
            return;
        }
        response.sendError(404);
    }
}

