/*
 * Decompiled with CFR 0.152.
 */
package org.togglz.console.shade.jmte.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.Properties;
import org.togglz.console.shade.jmte.Engine;
import org.togglz.console.shade.jmte.util.Util;

public final class Tool {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String transform(File template, File propertiesFile, String charsetName) throws UnsupportedEncodingException, FileNotFoundException, IOException {
        if (!template.exists()) {
            throw new IllegalArgumentException(String.format("Tempalte file '%s' does not exist", template.getCanonicalPath()));
        }
        if (!propertiesFile.exists()) {
            throw new IllegalArgumentException(String.format("Properties file '%s' does not exist", propertiesFile.getCanonicalPath()));
        }
        FileInputStream stream = null;
        try {
            String transformed;
            String input = Util.fileToString(template, charsetName);
            Engine engine = new Engine();
            Properties properties = new Properties();
            stream = new FileInputStream(propertiesFile);
            properties.load(stream);
            Properties model = properties;
            String string = transformed = engine.transform(input, model);
            return string;
        }
        finally {
            try {
                stream.close();
            }
            catch (IOException iOException) {}
        }
    }

    public static void main(String[] args) {
        try {
            String charsetName = "ISO-8859-15";
            if (args.length < 2) {
                System.err.println("We need at least template and properties file as input");
                System.exit(-1);
            }
            File template = new File(args[0]);
            File propertiesFile = new File(args[1]);
            if (args.length > 2) {
                charsetName = args[2];
            }
            String transformed = Tool.transform(template, propertiesFile, charsetName);
            System.out.println(transformed);
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
            System.exit(-1);
        }
    }
}

