/*
 * Decompiled with CFR 0.152.
 */
package org.togglz.console.model;

import javax.servlet.http.HttpServletRequest;
import org.togglz.console.model.StrategyModel;
import org.togglz.core.activation.Parameter;
import org.togglz.core.repository.FeatureState;
import org.togglz.core.util.Strings;

public class ParameterModel {
    private final int index;
    private final Parameter parameter;
    private final StrategyModel strategy;
    private String value;

    public ParameterModel(int index, Parameter parameter, StrategyModel strategy) {
        this.index = index;
        this.parameter = parameter;
        this.strategy = strategy;
    }

    public void readValueFrom(FeatureState featureState) {
        this.value = featureState.getParameter(this.parameter.getName());
    }

    public void readValueFrom(HttpServletRequest request) {
        this.value = request.getParameter(this.getInputId());
    }

    public String getValidationError() {
        if (Strings.isBlank((String)this.value) && !this.parameter.isOptional()) {
            return "Please enter a value for parameter: " + this.getLabel();
        }
        if (Strings.isNotBlank((String)this.value) && !this.parameter.isValid(this.value.trim())) {
            return "Please enter a valid value for: " + this.getLabel();
        }
        return null;
    }

    public boolean isValid() {
        return Strings.isBlank((String)this.getValidationError());
    }

    public String getLabel() {
        return this.parameter.getLabel();
    }

    public String getInputId() {
        return "p" + this.index;
    }

    public String getId() {
        return this.parameter.getName();
    }

    public String getValue() {
        return this.value == null ? "" : this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public int getStrategyIndex() {
        return this.strategy.getStrategyIndex();
    }

    public boolean isVisible() {
        return this.strategy.isSelected();
    }

    public String getDescription() {
        return this.parameter.getDescription();
    }

    public boolean isHasDescription() {
        return Strings.isNotBlank((String)this.getDescription());
    }

    public boolean isLargeText() {
        return this.parameter.isLargeText();
    }

    public boolean isHasValue() {
        return Strings.isNotBlank((String)this.value);
    }
}

