/*
 * Decompiled with CFR 0.152.
 */
package org.togglz.console.handlers;

import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.togglz.console.RequestEvent;
import org.togglz.console.RequestHandlerBase;

public class ResourceHandler
extends RequestHandlerBase {
    private final Pattern PATTERN = Pattern.compile(".*/(\\w+)\\.(css|css\\.map|js|png|eot|svg|ttf|woff|woff2)$");

    @Override
    public boolean handles(String path) {
        return this.PATTERN.matcher(path).matches();
    }

    @Override
    public boolean adminOnly() {
        return false;
    }

    @Override
    public void process(RequestEvent event) throws IOException {
        HttpServletResponse response = event.getResponse();
        Matcher matcher = this.PATTERN.matcher(event.getRequest().getRequestURI());
        if (matcher.matches()) {
            String type;
            String basename = matcher.group(1);
            InputStream stream = this.loadResource(basename + "." + (type = matcher.group(2)));
            if (stream == null) {
                response.sendError(404);
                return;
            }
            if ("css".equals(type)) {
                response.setContentType("text/css");
            } else if ("js".equals(type)) {
                response.setContentType("text/javascript");
            } else if ("png".equals(type)) {
                response.setContentType("image/png");
            } else {
                response.setContentType("image/" + type);
            }
            this.copy(stream, (OutputStream)response.getOutputStream());
        }
    }
}

