/*
 * Decompiled with CFR 0.152.
 */
package twitter4j;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import twitter4j.ConnectionLifeCycleListener;
import twitter4j.FilterQuery;
import twitter4j.SiteStreamsImpl;
import twitter4j.SiteStreamsListener;
import twitter4j.StatusListener;
import twitter4j.StatusStream;
import twitter4j.StatusStreamImpl;
import twitter4j.StreamController;
import twitter4j.StreamImplementation;
import twitter4j.StreamListener;
import twitter4j.StreamingReadTimeoutConfiguration;
import twitter4j.TwitterBaseImpl;
import twitter4j.TwitterException;
import twitter4j.TwitterStream;
import twitter4j.UserStream;
import twitter4j.UserStreamImpl;
import twitter4j.UserStreamListener;
import twitter4j.auth.Authorization;
import twitter4j.conf.Configuration;
import twitter4j.internal.async.Dispatcher;
import twitter4j.internal.async.DispatcherFactory;
import twitter4j.internal.http.HttpClientWrapper;
import twitter4j.internal.http.HttpClientWrapperConfiguration;
import twitter4j.internal.http.HttpParameter;
import twitter4j.internal.logging.Logger;
import twitter4j.internal.util.z_T4JInternalStringUtil;

class TwitterStreamImpl
extends TwitterBaseImpl
implements TwitterStream {
    private static final long serialVersionUID = 5529611191443189901L;
    private final HttpClientWrapper http;
    private static final Logger logger = Logger.getLogger(TwitterStreamImpl.class);
    private StreamListener[] streamListeners = new StreamListener[0];
    private List<ConnectionLifeCycleListener> lifeCycleListeners = new ArrayList<ConnectionLifeCycleListener>(0);
    private TwitterStreamConsumer handler = null;
    private String stallWarningsGetParam;
    private HttpParameter stallWarningsParam;
    private static transient Dispatcher dispatcher;
    private static int numberOfHandlers;
    private static final int TCP_ERROR_INITIAL_WAIT = 250;
    private static final int TCP_ERROR_WAIT_CAP = 16000;
    private static final int HTTP_ERROR_INITIAL_WAIT = 10000;
    private static final int HTTP_ERROR_WAIT_CAP = 240000;
    private static final int NO_WAIT = 0;
    static int count;

    TwitterStreamImpl(Configuration conf, Authorization auth) {
        super(conf, auth);
        this.http = new HttpClientWrapper((HttpClientWrapperConfiguration)new StreamingReadTimeoutConfiguration(conf));
        this.stallWarningsGetParam = "stall_warnings=" + (conf.isStallWarningsEnabled() ? "true" : "false");
        this.stallWarningsParam = new HttpParameter("stall_warnings", conf.isStallWarningsEnabled());
    }

    public void firehose(final int count) {
        this.ensureAuthorizationEnabled();
        this.ensureListenerIsSet();
        this.ensureStatusStreamListenerIsSet();
        this.startHandler(new TwitterStreamConsumer(){

            public StatusStream getStream() throws TwitterException {
                return TwitterStreamImpl.this.getFirehoseStream(count);
            }
        });
    }

    public StatusStream getFirehoseStream(int count) throws TwitterException {
        this.ensureAuthorizationEnabled();
        return this.getCountStream("statuses/firehose.json", count);
    }

    public void links(final int count) {
        this.ensureAuthorizationEnabled();
        this.ensureListenerIsSet();
        this.ensureStatusStreamListenerIsSet();
        this.startHandler(new TwitterStreamConsumer(){

            public StatusStream getStream() throws TwitterException {
                return TwitterStreamImpl.this.getLinksStream(count);
            }
        });
    }

    public StatusStream getLinksStream(int count) throws TwitterException {
        this.ensureAuthorizationEnabled();
        return this.getCountStream("statuses/links.json", count);
    }

    private StatusStream getCountStream(String relativeUrl, int count) throws TwitterException {
        this.ensureAuthorizationEnabled();
        try {
            return new StatusStreamImpl(this.getDispatcher(), this.http.post(this.conf.getStreamBaseURL() + relativeUrl, new HttpParameter[]{new HttpParameter("count", String.valueOf(count)), this.stallWarningsParam}, this.auth), this.conf);
        }
        catch (IOException e) {
            throw new TwitterException((Exception)e);
        }
    }

    public void retweet() {
        this.ensureAuthorizationEnabled();
        this.ensureListenerIsSet();
        this.ensureStatusStreamListenerIsSet();
        this.startHandler(new TwitterStreamConsumer(){

            public StatusStream getStream() throws TwitterException {
                return TwitterStreamImpl.this.getRetweetStream();
            }
        });
    }

    public StatusStream getRetweetStream() throws TwitterException {
        this.ensureAuthorizationEnabled();
        try {
            return new StatusStreamImpl(this.getDispatcher(), this.http.post(this.conf.getStreamBaseURL() + "statuses/retweet.json", new HttpParameter[]{this.stallWarningsParam}, this.auth), this.conf);
        }
        catch (IOException e) {
            throw new TwitterException((Exception)e);
        }
    }

    public void sample() {
        this.ensureAuthorizationEnabled();
        this.ensureListenerIsSet();
        this.ensureStatusStreamListenerIsSet();
        this.startHandler(new TwitterStreamConsumer(){

            public StatusStream getStream() throws TwitterException {
                return TwitterStreamImpl.this.getSampleStream();
            }
        });
    }

    public StatusStream getSampleStream() throws TwitterException {
        this.ensureAuthorizationEnabled();
        try {
            return new StatusStreamImpl(this.getDispatcher(), this.http.get(this.conf.getStreamBaseURL() + "statuses/sample.json?" + this.stallWarningsGetParam, this.auth), this.conf);
        }
        catch (IOException e) {
            throw new TwitterException((Exception)e);
        }
    }

    public void user() {
        this.user(null);
    }

    public void user(final String[] track) {
        this.ensureAuthorizationEnabled();
        this.ensureListenerIsSet();
        for (StreamListener listener : this.streamListeners) {
            if (listener instanceof UserStreamListener) continue;
            throw new IllegalStateException("Only UserStreamListener is supported. found: " + listener.getClass());
        }
        this.startHandler(new TwitterStreamConsumer(){

            public UserStream getStream() throws TwitterException {
                return TwitterStreamImpl.this.getUserStream(track);
            }
        });
    }

    public UserStream getUserStream() throws TwitterException {
        return this.getUserStream(null);
    }

    public UserStream getUserStream(String[] track) throws TwitterException {
        this.ensureAuthorizationEnabled();
        try {
            ArrayList<HttpParameter> params = new ArrayList<HttpParameter>();
            params.add(this.stallWarningsParam);
            if (this.conf.isUserStreamRepliesAllEnabled()) {
                params.add(new HttpParameter("replies", "all"));
            }
            if (track != null) {
                params.add(new HttpParameter("track", z_T4JInternalStringUtil.join((String[])track)));
            }
            return new UserStreamImpl(this.getDispatcher(), this.http.post(this.conf.getUserStreamBaseURL() + "user.json", params.toArray(new HttpParameter[params.size()]), this.auth), this.conf);
        }
        catch (IOException e) {
            throw new TwitterException((Exception)e);
        }
    }

    public StreamController site(final boolean withFollowings, final long[] follow) {
        this.ensureOAuthEnabled();
        this.ensureListenerIsSet();
        final StreamController cs = new StreamController(this.http, this.auth);
        for (StreamListener listener : this.streamListeners) {
            if (listener instanceof SiteStreamsListener) continue;
            throw new IllegalStateException("Only SiteStreamListener is supported. found: " + listener.getClass());
        }
        this.startHandler(new TwitterStreamConsumer(){

            public StreamImplementation getStream() throws TwitterException {
                try {
                    return new SiteStreamsImpl(TwitterStreamImpl.this.getDispatcher(), TwitterStreamImpl.this.getSiteStream(withFollowings, follow), TwitterStreamImpl.this.conf, cs);
                }
                catch (IOException e) {
                    throw new TwitterException((Exception)e);
                }
            }
        });
        return cs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Dispatcher getDispatcher() {
        if (null != dispatcher) return dispatcher;
        Class<TwitterStreamImpl> clazz = TwitterStreamImpl.class;
        synchronized (TwitterStreamImpl.class) {
            if (null != dispatcher) return dispatcher;
            dispatcher = new DispatcherFactory(this.conf).getInstance();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return dispatcher;
        }
    }

    InputStream getSiteStream(boolean withFollowings, long[] follow) throws TwitterException {
        this.ensureOAuthEnabled();
        return this.http.post(this.conf.getSiteStreamBaseURL() + "site.json", new HttpParameter[]{new HttpParameter("with", withFollowings ? "followings" : "user"), new HttpParameter("follow", z_T4JInternalStringUtil.join((long[])follow)), this.stallWarningsParam}, this.auth).asStream();
    }

    public void filter(final FilterQuery query) {
        this.ensureAuthorizationEnabled();
        this.ensureListenerIsSet();
        this.ensureStatusStreamListenerIsSet();
        this.startHandler(new TwitterStreamConsumer(){

            public StatusStream getStream() throws TwitterException {
                return TwitterStreamImpl.this.getFilterStream(query);
            }
        });
    }

    public StatusStream getFilterStream(FilterQuery query) throws TwitterException {
        this.ensureAuthorizationEnabled();
        try {
            return new StatusStreamImpl(this.getDispatcher(), this.http.post(this.conf.getStreamBaseURL() + "statuses/filter.json", query.asHttpParameterArray(this.stallWarningsParam), this.auth), this.conf);
        }
        catch (IOException e) {
            throw new TwitterException((Exception)e);
        }
    }

    private void ensureListenerIsSet() {
        if (this.streamListeners.length == 0) {
            throw new IllegalStateException("No listener is set.");
        }
    }

    private void ensureStatusStreamListenerIsSet() {
        for (StreamListener listener : this.streamListeners) {
            if (listener instanceof StatusListener) continue;
            throw new IllegalStateException("Only StatusListener is supported. found: " + listener.getClass());
        }
    }

    private synchronized void startHandler(TwitterStreamConsumer handler) {
        this.cleanUp();
        if (this.streamListeners.length == 0) {
            throw new IllegalStateException("StatusListener is not set.");
        }
        this.handler = handler;
        this.handler.start();
        ++numberOfHandlers;
    }

    public synchronized void cleanUp() {
        if (this.handler != null) {
            this.handler.close();
            --numberOfHandlers;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void shutdown() {
        super.shutdown();
        this.cleanUp();
        Class<TwitterStreamImpl> clazz = TwitterStreamImpl.class;
        synchronized (TwitterStreamImpl.class) {
            if (0 == numberOfHandlers && dispatcher != null) {
                dispatcher.shutdown();
                dispatcher = null;
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    public void addConnectionLifeCycleListener(ConnectionLifeCycleListener listener) {
        this.lifeCycleListeners.add(listener);
    }

    public void addListener(UserStreamListener listener) {
        this.addListener((StreamListener)listener);
    }

    public void addListener(StatusListener listener) {
        this.addListener((StreamListener)listener);
    }

    public void addListener(SiteStreamsListener listener) {
        this.addListener((StreamListener)listener);
    }

    private synchronized void addListener(StreamListener listener) {
        StreamListener[] newListeners = new StreamListener[this.streamListeners.length + 1];
        System.arraycopy(this.streamListeners, 0, newListeners, 0, this.streamListeners.length);
        newListeners[newListeners.length - 1] = listener;
        this.streamListeners = newListeners;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        TwitterStreamImpl that = (TwitterStreamImpl)o;
        if (this.handler != null ? !this.handler.equals(that.handler) : that.handler != null) {
            return false;
        }
        if (this.http != null ? !this.http.equals((Object)that.http) : that.http != null) {
            return false;
        }
        if (this.lifeCycleListeners != null ? !this.lifeCycleListeners.equals(that.lifeCycleListeners) : that.lifeCycleListeners != null) {
            return false;
        }
        return Arrays.equals(this.streamListeners, that.streamListeners);
    }

    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.http != null ? this.http.hashCode() : 0);
        result = 31 * result + (this.streamListeners != null ? Arrays.hashCode(this.streamListeners) : 0);
        result = 31 * result + (this.lifeCycleListeners != null ? this.lifeCycleListeners.hashCode() : 0);
        result = 31 * result + (this.handler != null ? this.handler.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "TwitterStreamImpl{http=" + this.http + ", streamListeners=" + (this.streamListeners == null ? null : Arrays.asList(this.streamListeners)) + ", lifeCycleListeners=" + this.lifeCycleListeners + ", handler=" + this.handler + '}';
    }

    static {
        numberOfHandlers = 0;
        count = 0;
    }

    abstract class TwitterStreamConsumer
    extends Thread {
        private StreamImplementation stream = null;
        private final String NAME = "Twitter Stream consumer-" + ++count;
        private volatile boolean closed = false;

        TwitterStreamConsumer() {
            this.setName(this.NAME + "[initializing]");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            int timeToSleep = 0;
            boolean connected = false;
            block31: while (!this.closed) {
                try {
                    if (this.closed || null != this.stream) continue;
                    logger.info("Establishing connection.");
                    this.setStatus("[Establishing connection]");
                    this.stream = this.getStream();
                    connected = true;
                    logger.info("Connection established.");
                    for (ConnectionLifeCycleListener listener : TwitterStreamImpl.this.lifeCycleListeners) {
                        try {
                            listener.onConnect();
                        }
                        catch (Exception e) {
                            logger.warn(e.getMessage());
                        }
                    }
                    timeToSleep = 0;
                    logger.info("Receiving status stream.");
                    this.setStatus("[Receiving stream]");
                    while (!this.closed) {
                        try {
                            this.stream.next(TwitterStreamImpl.this.streamListeners);
                        }
                        catch (IllegalStateException ise) {
                            logger.warn(ise.getMessage());
                            continue block31;
                        }
                        catch (TwitterException e) {
                            logger.info(e.getMessage());
                            this.stream.onException((Exception)((Object)e));
                            throw e;
                        }
                        catch (Exception e) {
                            logger.info(e.getMessage());
                            this.stream.onException(e);
                            this.closed = true;
                        }
                    }
                }
                catch (TwitterException te) {
                    logger.info(te.getMessage());
                    if (this.closed) continue;
                    if (0 == timeToSleep) {
                        if (te.getStatusCode() == 403) {
                            logger.warn("This account is not in required role. ", te.getMessage());
                            this.closed = true;
                            for (StreamListener statusListener : TwitterStreamImpl.this.streamListeners) {
                                statusListener.onException((Exception)((Object)te));
                            }
                            break;
                        }
                        if (te.getStatusCode() == 406) {
                            logger.warn("Parameter not accepted with the role. ", te.getMessage());
                            this.closed = true;
                            for (StreamListener statusListener : TwitterStreamImpl.this.streamListeners) {
                                statusListener.onException((Exception)((Object)te));
                            }
                            break;
                        }
                        connected = false;
                        for (ConnectionLifeCycleListener listener : TwitterStreamImpl.this.lifeCycleListeners) {
                            try {
                                listener.onDisconnect();
                            }
                            catch (Exception e) {
                                logger.warn(e.getMessage());
                            }
                        }
                        if (te.getStatusCode() > 200) {
                            timeToSleep = 10000;
                        } else if (0 == timeToSleep) {
                            timeToSleep = 250;
                        }
                    }
                    if (te.getStatusCode() > 200 && timeToSleep < 10000) {
                        timeToSleep = 10000;
                    }
                    if (connected) {
                        for (ConnectionLifeCycleListener listener : TwitterStreamImpl.this.lifeCycleListeners) {
                            try {
                                listener.onDisconnect();
                            }
                            catch (Exception e) {
                                logger.warn(e.getMessage());
                            }
                        }
                    }
                    for (StreamListener statusListener : TwitterStreamImpl.this.streamListeners) {
                        statusListener.onException((Exception)((Object)te));
                    }
                    if (!this.closed) {
                        logger.info("Waiting for " + timeToSleep + " milliseconds");
                        this.setStatus("[Waiting for " + timeToSleep + " milliseconds]");
                        try {
                            Thread.sleep(timeToSleep);
                        }
                        catch (InterruptedException ignore) {
                            // empty catch block
                        }
                        timeToSleep = Math.min(timeToSleep * 2, te.getStatusCode() > 200 ? 240000 : 16000);
                    }
                    this.stream = null;
                    logger.debug(te.getMessage());
                    connected = false;
                }
            }
            if (this.stream != null && connected) {
                try {
                    this.stream.close();
                }
                catch (IOException ignore) {
                    for (ConnectionLifeCycleListener listener : TwitterStreamImpl.this.lifeCycleListeners) {
                        try {
                            listener.onDisconnect();
                        }
                        catch (Exception e) {
                            logger.warn(e.getMessage());
                        }
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    logger.warn(e.getMessage());
                }
                finally {
                    for (ConnectionLifeCycleListener listener : TwitterStreamImpl.this.lifeCycleListeners) {
                        try {
                            listener.onDisconnect();
                        }
                        catch (Exception e) {
                            logger.warn(e.getMessage());
                        }
                    }
                }
            }
            for (ConnectionLifeCycleListener listener : TwitterStreamImpl.this.lifeCycleListeners) {
                try {
                    listener.onCleanUp();
                }
                catch (Exception e) {
                    logger.warn(e.getMessage());
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized void close() {
            this.setStatus("[Disposing thread]");
            try {
                if (this.stream != null) {
                    try {
                        this.stream.close();
                    }
                    catch (IOException ignore) {
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        logger.warn(e.getMessage());
                    }
                }
            }
            finally {
                this.closed = true;
            }
        }

        private void setStatus(String message) {
            String actualMessage = this.NAME + message;
            this.setName(actualMessage);
            logger.debug(actualMessage);
        }

        abstract StreamImplementation getStream() throws TwitterException;
    }
}

