/*
 * Decompiled with CFR 0.152.
 */
package twitter4j;

import java.io.IOException;
import java.io.InputStream;
import twitter4j.DirectMessage;
import twitter4j.StatusStreamImpl;
import twitter4j.StreamListener;
import twitter4j.TwitterException;
import twitter4j.UserStream;
import twitter4j.UserStreamListener;
import twitter4j.conf.Configuration;
import twitter4j.internal.async.Dispatcher;
import twitter4j.internal.http.HttpResponse;
import twitter4j.internal.org.json.JSONException;
import twitter4j.internal.org.json.JSONObject;

class UserStreamImpl
extends StatusStreamImpl
implements UserStream {
    UserStreamImpl(Dispatcher dispatcher, InputStream stream, Configuration conf) throws IOException {
        super(dispatcher, stream, conf);
    }

    UserStreamImpl(Dispatcher dispatcher, HttpResponse response, Configuration conf) throws IOException {
        super(dispatcher, response, conf);
    }

    public void next(UserStreamListener listener) throws TwitterException {
        StreamListener[] list = new StreamListener[]{listener};
        this.listeners = list;
        this.handleNextElement();
    }

    public void next(StreamListener[] listeners) throws TwitterException {
        this.listeners = listeners;
        this.handleNextElement();
    }

    protected String parseLine(String line) {
        this.line = line;
        return line;
    }

    protected void onSender(JSONObject json) throws TwitterException {
        for (StreamListener listener : this.listeners) {
            ((UserStreamListener)listener).onDirectMessage(this.factory.createDirectMessage(json));
        }
    }

    protected void onDirectMessage(JSONObject json) throws TwitterException, JSONException {
        DirectMessage directMessage = this.asDirectMessage(json);
        for (StreamListener listener : this.listeners) {
            ((UserStreamListener)listener).onDirectMessage(directMessage);
        }
    }

    protected void onScrubGeo(JSONObject json) throws TwitterException {
        logger.info("Geo-tagging deletion notice (not implemented yet): " + this.line);
    }

    protected void onFriends(JSONObject json) throws TwitterException, JSONException {
        long[] friendIds = this.asFriendList(json);
        for (StreamListener listener : this.listeners) {
            ((UserStreamListener)listener).onFriendList(friendIds);
        }
    }

    protected void onFavorite(JSONObject source, JSONObject target, JSONObject targetObject) throws TwitterException {
        for (StreamListener listener : this.listeners) {
            ((UserStreamListener)listener).onFavorite(this.asUser(source), this.asUser(target), this.asStatus(targetObject));
        }
    }

    protected void onUnfavorite(JSONObject source, JSONObject target, JSONObject targetObject) throws TwitterException {
        for (StreamListener listener : this.listeners) {
            ((UserStreamListener)listener).onUnfavorite(this.asUser(source), this.asUser(target), this.asStatus(targetObject));
        }
    }

    protected void onFollow(JSONObject source, JSONObject target) throws TwitterException {
        for (StreamListener listener : this.listeners) {
            ((UserStreamListener)listener).onFollow(this.asUser(source), this.asUser(target));
        }
    }

    protected void onUserListMemberAddition(JSONObject addedMember, JSONObject owner, JSONObject target) throws TwitterException, JSONException {
        for (StreamListener listener : this.listeners) {
            ((UserStreamListener)listener).onUserListMemberAddition(this.asUser(addedMember), this.asUser(owner), this.asUserList(target));
        }
    }

    protected void onUserListMemberDeletion(JSONObject deletedMember, JSONObject owner, JSONObject target) throws TwitterException, JSONException {
        for (StreamListener listener : this.listeners) {
            ((UserStreamListener)listener).onUserListMemberDeletion(this.asUser(deletedMember), this.asUser(owner), this.asUserList(target));
        }
    }

    protected void onUserListSubscription(JSONObject source, JSONObject owner, JSONObject target) throws TwitterException, JSONException {
        for (StreamListener listener : this.listeners) {
            ((UserStreamListener)listener).onUserListSubscription(this.asUser(source), this.asUser(owner), this.asUserList(target));
        }
    }

    protected void onUserListUnsubscription(JSONObject source, JSONObject owner, JSONObject target) throws TwitterException, JSONException {
        for (StreamListener listener : this.listeners) {
            ((UserStreamListener)listener).onUserListUnsubscription(this.asUser(source), this.asUser(owner), this.asUserList(target));
        }
    }

    protected void onUserListCreation(JSONObject source, JSONObject target) throws TwitterException, JSONException {
        for (StreamListener listener : this.listeners) {
            ((UserStreamListener)listener).onUserListCreation(this.asUser(source), this.asUserList(target));
        }
    }

    protected void onUserListUpdated(JSONObject source, JSONObject target) throws TwitterException, JSONException {
        for (StreamListener listener : this.listeners) {
            ((UserStreamListener)listener).onUserListUpdate(this.asUser(source), this.asUserList(target));
        }
    }

    protected void onUserListDestroyed(JSONObject source, JSONObject target) throws TwitterException {
        for (StreamListener listener : this.listeners) {
            ((UserStreamListener)listener).onUserListDeletion(this.asUser(source), this.asUserList(target));
        }
    }

    protected void onUserUpdate(JSONObject source, JSONObject target) throws TwitterException {
        for (StreamListener listener : this.listeners) {
            ((UserStreamListener)listener).onUserProfileUpdate(this.asUser(source));
        }
    }

    protected void onBlock(JSONObject source, JSONObject target) throws TwitterException {
        for (StreamListener listener : this.listeners) {
            ((UserStreamListener)listener).onBlock(this.asUser(source), this.asUser(target));
        }
    }

    protected void onUnblock(JSONObject source, JSONObject target) throws TwitterException {
        for (StreamListener listener : this.listeners) {
            ((UserStreamListener)listener).onUnblock(this.asUser(source), this.asUser(target));
        }
    }

    public void onException(Exception e) {
        for (StreamListener listener : this.listeners) {
            listener.onException(e);
        }
    }
}

