/*
 * Decompiled with CFR 0.152.
 */
package twitter4j;

import java.io.Serializable;
import java.util.Arrays;
import twitter4j.ControlStreamInfo;
import twitter4j.CursorSupport;
import twitter4j.HttpClient;
import twitter4j.HttpClientConfiguration;
import twitter4j.HttpClientFactory;
import twitter4j.HttpParameter;
import twitter4j.HttpResponse;
import twitter4j.JSONArray;
import twitter4j.JSONException;
import twitter4j.JSONObject;
import twitter4j.ParseUtil;
import twitter4j.StringUtil;
import twitter4j.TwitterException;
import twitter4j.auth.Authorization;
import twitter4j.auth.AuthorizationFactory;
import twitter4j.conf.Configuration;

public class StreamController {
    private String controlURI = null;
    private final HttpClient http;
    private final Authorization AUTH;
    Object lock = new Object();

    StreamController(HttpClient http, Authorization auth) {
        this.http = http;
        this.AUTH = auth;
    }

    StreamController(Configuration conf) {
        this.http = HttpClientFactory.getInstance((HttpClientConfiguration)conf.getHttpClientConfiguration());
        this.AUTH = AuthorizationFactory.getInstance((Configuration)conf);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setControlURI(String controlURI) {
        this.controlURI = controlURI.replace("/1.1//1.1/", "/1.1/");
        Object object = this.lock;
        synchronized (object) {
            this.lock.notifyAll();
        }
    }

    String getControlURI() {
        return this.controlURI;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void ensureControlURISet() throws TwitterException {
        Object object = this.lock;
        synchronized (object) {
            try {
                if (this.controlURI == null) {
                    this.lock.wait(30000L);
                    throw new TwitterException("timed out for control uri to be ready");
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    public ControlStreamInfo getInfo() throws TwitterException {
        this.ensureControlURISet();
        HttpResponse res = this.http.get(this.controlURI + "/info.json", null, this.AUTH, null);
        return new ControlStreamInfo(this, res.asJSONObject());
    }

    public String addUsers(long[] userIds) throws TwitterException {
        this.ensureControlURISet();
        HttpParameter param = new HttpParameter("user_id", StringUtil.join((long[])userIds));
        HttpResponse res = this.http.post(this.controlURI + "/add_user.json", new HttpParameter[]{param}, this.AUTH, null);
        return res.asString();
    }

    public String removeUsers(long[] userIds) throws TwitterException {
        this.ensureControlURISet();
        HttpParameter param = new HttpParameter("user_id", StringUtil.join((long[])userIds));
        HttpResponse res = this.http.post(this.controlURI + "/remove_user.json", new HttpParameter[]{param}, this.AUTH, null);
        return res.asString();
    }

    public FriendsIDs getFriendsIDs(long userId, long cursor) throws TwitterException {
        this.ensureControlURISet();
        HttpResponse res = this.http.post(this.controlURI + "/friends/ids.json", new HttpParameter[]{new HttpParameter("user_id", userId), new HttpParameter("cursor", cursor)}, this.AUTH, null);
        return new FriendsIDs(res);
    }

    User createUser(JSONObject json) {
        return new User(json);
    }

    public final class User
    implements Serializable {
        private static final long serialVersionUID = -8741743249755418730L;
        private long id;
        private String name;
        private boolean dm;

        User(JSONObject json) {
            this.id = ParseUtil.getLong((String)"id", (JSONObject)json);
            this.name = ParseUtil.getRawString((String)"name", (JSONObject)json);
            this.dm = ParseUtil.getBoolean((String)"dm", (JSONObject)json);
        }

        public long getId() {
            return this.id;
        }

        public String getName() {
            return this.name;
        }

        public boolean isDMAccessible() {
            return this.dm;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            User user = (User)o;
            if (this.dm != user.dm) {
                return false;
            }
            if (this.id != user.id) {
                return false;
            }
            return !(this.name != null ? !this.name.equals(user.name) : user.name != null);
        }

        public int hashCode() {
            int result = (int)(this.id ^ this.id >>> 32);
            result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
            result = 31 * result + (this.dm ? 1 : 0);
            return result;
        }

        public String toString() {
            return "User{id=" + this.id + ", name='" + this.name + '\'' + ", dm=" + this.dm + '}';
        }
    }

    public final class FriendsIDs
    implements CursorSupport,
    Serializable {
        private static final long serialVersionUID = -7393320878760329794L;
        private long[] ids;
        private long previousCursor = -1L;
        private long nextCursor = -1L;
        private User user;

        FriendsIDs(HttpResponse res) throws TwitterException {
            this.init(res.asJSONObject());
        }

        private void init(JSONObject json) throws TwitterException {
            try {
                JSONObject follow = json.getJSONObject("follow");
                JSONArray idList = follow.getJSONArray("friends");
                this.ids = new long[idList.length()];
                for (int i = 0; i < idList.length(); ++i) {
                    try {
                        this.ids[i] = Long.parseLong(idList.getString(i));
                        continue;
                    }
                    catch (NumberFormatException nfe) {
                        throw new TwitterException("Twitter API returned malformed response: " + json, (Throwable)nfe);
                    }
                }
                this.user = new User(follow.getJSONObject("user"));
                this.previousCursor = ParseUtil.getLong((String)"previous_cursor", (JSONObject)json);
                this.nextCursor = ParseUtil.getLong((String)"next_cursor", (JSONObject)json);
            }
            catch (JSONException jsone) {
                throw new TwitterException((Exception)((Object)jsone));
            }
        }

        public boolean hasPrevious() {
            return 0L != this.previousCursor;
        }

        public long getPreviousCursor() {
            return this.previousCursor;
        }

        public boolean hasNext() {
            return 0L != this.nextCursor;
        }

        public long getNextCursor() {
            return this.nextCursor;
        }

        public User getUser() {
            return this.user;
        }

        public long[] getIds() {
            return this.ids;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            FriendsIDs that = (FriendsIDs)o;
            if (this.nextCursor != that.nextCursor) {
                return false;
            }
            if (this.previousCursor != that.previousCursor) {
                return false;
            }
            if (!Arrays.equals(this.ids, that.ids)) {
                return false;
            }
            return !(this.user != null ? !this.user.equals(that.user) : that.user != null);
        }

        public int hashCode() {
            int result = this.ids != null ? Arrays.hashCode(this.ids) : 0;
            result = 31 * result + (int)(this.previousCursor ^ this.previousCursor >>> 32);
            result = 31 * result + (int)(this.nextCursor ^ this.nextCursor >>> 32);
            result = 31 * result + (this.user != null ? this.user.hashCode() : 0);
            return result;
        }

        public String toString() {
            return "FriendsIDs{ids=" + this.ids + ", previousCursor=" + this.previousCursor + ", nextCursor=" + this.nextCursor + ", user=" + this.user + '}';
        }
    }
}

