/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.io.regex;

import java.net.URI;
import java.util.Collection;
import org.uberfire.commons.validation.Preconditions;
import org.uberfire.java.nio.file.Path;

public final class AntPathMatcher {
    private static final String PATTERNS = "patterns";
    private static org.uberfire.commons.regex.util.AntPathMatcher matcher = new org.uberfire.commons.regex.util.AntPathMatcher();

    public static boolean filter(Collection<String> includes, Collection<String> excludes, Path path) {
        Preconditions.checkNotNull((String)"includes", includes);
        Preconditions.checkNotNull((String)"excludes", excludes);
        Preconditions.checkNotNull((String)"path", (Object)path);
        if (includes.isEmpty() && excludes.isEmpty()) {
            return true;
        }
        if (includes.isEmpty()) {
            return !AntPathMatcher.excludes(excludes, path);
        }
        if (excludes.isEmpty()) {
            return AntPathMatcher.includes(includes, path);
        }
        return AntPathMatcher.includes(includes, path) && !AntPathMatcher.excludes(excludes, path);
    }

    public static boolean filter(Collection<String> includes, Collection<String> excludes, URI uri) {
        Preconditions.checkNotNull((String)"includes", includes);
        Preconditions.checkNotNull((String)"excludes", excludes);
        Preconditions.checkNotNull((String)"uri", (Object)uri);
        if (includes.isEmpty() && excludes.isEmpty()) {
            return true;
        }
        if (includes.isEmpty()) {
            return !AntPathMatcher.excludes(excludes, uri);
        }
        if (excludes.isEmpty()) {
            return AntPathMatcher.includes(includes, uri);
        }
        return AntPathMatcher.includes(includes, uri) && !AntPathMatcher.excludes(excludes, uri);
    }

    public static boolean includes(Collection<String> patterns, Path path) {
        Preconditions.checkNotNull((String)PATTERNS, patterns);
        Preconditions.checkNotNull((String)"path", (Object)path);
        return AntPathMatcher.matches(patterns, path);
    }

    public static boolean includes(Collection<String> patterns, URI uri) {
        Preconditions.checkNotNull((String)PATTERNS, patterns);
        Preconditions.checkNotNull((String)"uri", (Object)uri);
        return AntPathMatcher.matches(patterns, uri);
    }

    public static boolean excludes(Collection<String> patterns, URI uri) {
        Preconditions.checkNotNull((String)PATTERNS, patterns);
        Preconditions.checkNotNull((String)"uri", (Object)uri);
        return AntPathMatcher.matches(patterns, uri);
    }

    public static boolean excludes(Collection<String> patterns, Path path) {
        Preconditions.checkNotNull((String)PATTERNS, patterns);
        Preconditions.checkNotNull((String)"path", (Object)path);
        return AntPathMatcher.matches(patterns, path);
    }

    private static boolean matches(Collection<String> patterns, Path path) {
        return AntPathMatcher.matches(patterns, path.toUri());
    }

    private static boolean matches(Collection<String> patterns, URI uri) {
        for (String pattern : patterns) {
            if (!matcher.match(pattern, uri.toString())) continue;
            return true;
        }
        return false;
    }
}

