/*
 * Decompiled with CFR 0.152.
 */
package org.utplsql.api.testRunner;

import java.sql.Array;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import oracle.jdbc.OracleConnection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.utplsql.api.FileMapperOptions;
import org.utplsql.api.FileMapping;
import org.utplsql.api.KeyValuePair;
import org.utplsql.api.db.DynamicParameterList;

final class FileMapper {
    private static final Logger logger = LoggerFactory.getLogger(FileMapper.class);

    private FileMapper() {
    }

    private static Array buildFileMappingArray(Connection conn, FileMapperOptions mapperOptions) throws SQLException {
        Object[] filePathsArray;
        OracleConnection oraConn = conn.unwrap(OracleConnection.class);
        Map<String, Class<?>> typeMap = conn.getTypeMap();
        typeMap.put("UT_FILE_MAPPING", FileMapping.class);
        typeMap.put("UT_KEY_VALUE_PAIR", KeyValuePair.class);
        conn.setTypeMap(typeMap);
        logger.debug("Building fileMappingArray");
        for (Object elem : filePathsArray = mapperOptions.getFilePaths().toArray()) {
            logger.debug("Path: " + elem);
        }
        Object[] typeMapArray = null;
        if (mapperOptions.getTypeMappings() != null) {
            typeMapArray = mapperOptions.getTypeMappings().toArray();
        }
        DynamicParameterList parameterList = DynamicParameterList.builder().add("a_file_paths", filePathsArray, "UT_VARCHAR2_LIST", oraConn).addIfNotEmpty("a_object_owner", mapperOptions.getObjectOwner()).addIfNotEmpty("a_file_to_object_type_mapping", typeMapArray, "UT_KEY_VALUE_PAIRS", oraConn).addIfNotEmpty("a_regex_pattern", mapperOptions.getRegexPattern()).addIfNotEmpty("a_object_owner_subexpression", mapperOptions.getOwnerSubExpression()).addIfNotEmpty("a_object_name_subexpression", mapperOptions.getNameSubExpression()).addIfNotEmpty("a_object_type_subexpression", mapperOptions.getTypeSubExpression()).build();
        CallableStatement callableStatement = conn.prepareCall("BEGIN ? := ut_file_mapper.build_file_mappings(" + parameterList.getSql() + "); END;");
        int paramIdx = 0;
        callableStatement.registerOutParameter(++paramIdx, 2003, "UT_FILE_MAPPINGS");
        parameterList.setParamsStartWithIndex(callableStatement, ++paramIdx);
        callableStatement.execute();
        return callableStatement.getArray(1);
    }

    static List<FileMapping> buildFileMappingList(Connection conn, FileMapperOptions mapperOptions) throws SQLException {
        Array fileMappings = FileMapper.buildFileMappingArray(conn, mapperOptions);
        ArrayList<FileMapping> mappingList = new ArrayList<FileMapping>();
        for (Object obj : (Object[])fileMappings.getArray()) {
            mappingList.add((FileMapping)obj);
        }
        return mappingList;
    }
}

