/*
 * Decompiled with CFR 0.152.
 */
package org.webjars;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.net.URI;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.webjars.CloseQuietly;
import org.webjars.WebJarAssetLocator;

public class WebJarExtractor {
    public static final String PACKAGE_JSON_NAME = "\"name\"";
    public static final String PACKAGE_JSON = "package.json";
    private static final Logger log = LoggerFactory.getLogger(WebJarExtractor.class);
    private final Cache cache;
    private final ClassLoader classLoader;
    public static Cache NO_CACHE = new NoCache();

    public WebJarExtractor() {
        this(WebJarExtractor.class.getClassLoader());
    }

    public WebJarExtractor(ClassLoader classLoader) {
        this(NO_CACHE, classLoader);
    }

    public WebJarExtractor(Cache cache, ClassLoader classLoader) {
        this.cache = cache;
        this.classLoader = classLoader;
    }

    public void extractAllWebJarsTo(File to) throws IOException {
        this.extractWebJarsTo(null, false, to);
    }

    public void extractWebJarTo(String name, File to) throws IOException {
        this.extractWebJarsTo(name, false, to);
    }

    public void extractAllNodeModulesTo(File to) throws IOException {
        this.extractWebJarsTo(null, true, to);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void extractWebJarsTo(String name, boolean nodeModules, File to) throws IOException {
        String fullPath = "META-INF/resources/webjars/";
        String searchPath = name != null ? fullPath + name + "/" : fullPath;
        for (URL url : WebJarAssetLocator.listParentURLsWithResource(new ClassLoader[]{this.classLoader}, searchPath)) {
            if ("jar".equals(url.getProtocol())) {
                String urlPath = url.getPath();
                File file = new File(URI.create(urlPath.substring(0, urlPath.indexOf("!"))));
                log.debug("Loading webjar from {}", (Object)file);
                JarFile jarFile = new JarFile(file);
                try {
                    String moduleId = null;
                    boolean determinedModuleId = false;
                    Enumeration<JarEntry> entries = jarFile.entries();
                    while (entries.hasMoreElements()) {
                        JarEntry entry = entries.nextElement();
                        if (entry.isDirectory() || !entry.getName().startsWith(fullPath)) continue;
                        String webJarPath = entry.getName().substring(fullPath.length());
                        String[] nameVersion = webJarPath.split("/", 3);
                        if (nameVersion.length == 3) {
                            if (!determinedModuleId) {
                                moduleId = nodeModules ? this.getJarNodeModuleIdEntry(jarFile, fullPath + nameVersion[0] + "/" + nameVersion[1] + "/" + PACKAGE_JSON) : nameVersion[0];
                                determinedModuleId = true;
                            }
                            if (moduleId == null) continue;
                            String relativeName = moduleId + File.separator + nameVersion[2];
                            File copyTo = new File(to, relativeName);
                            this.copyJarEntry(jarFile, entry, copyTo, relativeName);
                            continue;
                        }
                        log.debug("Found file entry {} where webjar version directory was expected in {}", (Object)webJarPath, (Object)url);
                    }
                    continue;
                }
                finally {
                    CloseQuietly.closeQuietly(jarFile);
                    continue;
                }
            }
            log.debug("Ignoring given unsupported protocol for: {}", (Object)url);
        }
    }

    private void ensureIsDirectory(File dir) {
        boolean created;
        if (dir.exists() && !dir.isDirectory()) {
            log.debug("Destination directory is not a directory, deleting {}", (Object)dir);
            boolean isDeleted = dir.delete();
            if (!isDeleted) {
                log.debug("Destination directory {} wasn't deleted", (Object)dir);
            }
        }
        if (!(created = dir.mkdirs())) {
            log.debug("Destination directory {} didn't need creation", (Object)dir);
        }
    }

    private void copyJarEntry(JarFile jarFile, JarEntry entry, File copyTo, String key) throws IOException {
        Cacheable forCache = new Cacheable(entry.getName(), entry.getTime());
        log.debug("Checking whether {} is up to date at {}", (Object)entry.getName(), (Object)copyTo);
        if (!copyTo.exists() || !this.cache.isUpToDate(key, forCache)) {
            log.debug("Up to date check failed, copying {} to {}", (Object)entry.getName(), (Object)copyTo);
            this.ensureIsDirectory(copyTo.getParentFile());
            WebJarExtractor.copyAndClose(jarFile.getInputStream(entry), copyTo);
            this.cache.put(key, forCache);
        }
    }

    private String getJarNodeModuleIdEntry(JarFile jarFile, String moduleIdPath) throws IOException {
        String moduleId = null;
        ZipEntry entry = jarFile.getEntry(moduleIdPath);
        if (entry != null) {
            String packageJson = WebJarExtractor.copyAndClose(jarFile.getInputStream(entry));
            moduleId = this.getJsonNodeModuleId(packageJson);
        }
        return moduleId;
    }

    private String getJsonNodeModuleId(String packageJson) {
        String moduleId = null;
        int namePosn = packageJson.indexOf(PACKAGE_JSON_NAME);
        if (namePosn > -1) {
            int moduleIdPosn;
            for (moduleIdPosn = namePosn + PACKAGE_JSON_NAME.length(); moduleIdPosn < packageJson.length() && Character.isWhitespace(packageJson.charAt(moduleIdPosn)); ++moduleIdPosn) {
            }
            if (moduleIdPosn < packageJson.length() && packageJson.charAt(moduleIdPosn) == ':') {
                ++moduleIdPosn;
                while (moduleIdPosn < packageJson.length() && Character.isWhitespace(packageJson.charAt(moduleIdPosn))) {
                    ++moduleIdPosn;
                }
                if (moduleIdPosn < packageJson.length() && packageJson.charAt(moduleIdPosn) == '\"') {
                    ++moduleIdPosn;
                    StringBuilder sb = new StringBuilder();
                    while (moduleIdPosn < packageJson.length() && packageJson.charAt(moduleIdPosn) != '\"') {
                        sb.append(packageJson.charAt(moduleIdPosn++));
                    }
                    moduleId = sb.toString();
                }
            }
        }
        return moduleId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void copyAndClose(InputStream source, File to) throws IOException {
        FileOutputStream dest = new FileOutputStream(to);
        try {
            byte[] buffer = new byte[8192];
            int read = source.read(buffer);
            while (read > 0) {
                ((OutputStream)dest).write(buffer, 0, read);
                read = source.read(buffer);
            }
            dest.flush();
        }
        finally {
            CloseQuietly.closeQuietly(source);
            CloseQuietly.closeQuietly(dest);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String copyAndClose(InputStream source) throws IOException {
        StringBuilder sb = new StringBuilder();
        InputStreamReader is = new InputStreamReader(source, "UTF-8");
        try {
            char[] buffer = new char[8192];
            int read = ((Reader)is).read(buffer, 0, buffer.length);
            sb.append(buffer, 0, read);
        }
        finally {
            CloseQuietly.closeQuietly(source);
            CloseQuietly.closeQuietly(is);
        }
        return sb.toString();
    }

    public static final class Cacheable {
        private final String path;
        private final long lastModified;

        public Cacheable(String path, long lastModified) {
            this.path = path;
            this.lastModified = lastModified;
        }

        public String getPath() {
            return this.path;
        }

        public long getLastModified() {
            return this.lastModified;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Cacheable cacheable = (Cacheable)o;
            return this.lastModified == cacheable.lastModified && this.path.equals(cacheable.path);
        }

        public int hashCode() {
            int result = this.path.hashCode();
            result = 31 * result + (int)(this.lastModified ^ this.lastModified >>> 32);
            return result;
        }
    }

    public static class MemoryCache
    implements Cache {
        private final Map<String, Cacheable> cache = new HashMap<String, Cacheable>();

        @Override
        public boolean isUpToDate(String key, Cacheable cacheable) {
            return cacheable.equals(this.cache.get(key));
        }

        @Override
        public void put(String key, Cacheable cacheable) {
            this.cache.put(key, cacheable);
        }
    }

    private static class NoCache
    implements Cache {
        private NoCache() {
        }

        @Override
        public boolean isUpToDate(String key, Cacheable cacheable) {
            return false;
        }

        @Override
        public void put(String key, Cacheable cacheable) {
        }
    }

    public static interface Cache {
        public boolean isUpToDate(String var1, Cacheable var2);

        public void put(String var1, Cacheable var2);
    }
}

