/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.common._private;

import java.io.IOException;
import java.io.Serializable;
import java.security.PrivilegedActionException;
import java.util.Arrays;
import org.wildfly.common._private.CommonMessages;

public class CommonMessages_$bundle
implements Serializable,
CommonMessages {
    private static final long serialVersionUID = 1L;
    public static final CommonMessages_$bundle INSTANCE = new CommonMessages_$bundle();
    private static final String nullParam = "Parameter '%s' may not be null";
    private static final String paramLessThan = "COM00001: Parameter '%s' must not be less than %d";
    private static final String paramGreaterThan = "COM00002: Parameter '%s' must not be greater than than %d";
    private static final String arrayOffsetGreaterThanLength = "COM00003: Given offset of %d is greater than array length of %d";
    private static final String arrayOffsetLengthGreaterThanLength = "COM00004: Given offset of %d plus length of %d is greater than array length of %d";
    private static final String nullArrayParam = "COM00005: Array index %d of parameter '%s' may not be null";
    private static final String nullParamNPE = "COM00006: Parameter '%s' may not be null";
    private static final String invalidPermissionAction = "COM00007: Invalid permission action '%s'";
    private static final String emptyParam = "COM00008: Parameter '%s' must not be empty";
    private static final String invalidExpressionSyntax = "COM00009: Invalid expression syntax at position %d";
    private static final String unresolvedEnvironmentProperty = "COM00010: No environment property found named \"%s\"";
    private static final String unresolvedSystemProperty = "COM00011: No system property found named \"%s\"";
    private static final String invalidAddressBytes = "COM00012: Invalid address length of %d; must be 4 or 16";
    private static final String unsupported = "COM00100: Method \"%s\" of class \"%s\" is not implemented";
    private static final String privilegedActionFailed = "COM00200: Privileged action failed";
    private static final String readOnlyPermissionCollection = "COM00300: Permission collection is read-only";
    private static final String invalidPermissionType = "COM00301: Invalid permission type (expected %s, actual value was %s)";
    private static final String invalidOddFields = "COM00400: Invalid serialized remote exception cause object with odd number of strings in fields key/value list";
    private static final String cannotContainNullFieldNameOrValue = "COM00401: Field name or field value cannot be null";
    private static final String corruptedStream = "COM00402: Remote exception stream is corrupted and cannot be read";
    private static final String remoteException2 = "Remote exception %s: %s";
    private static final String remoteException1 = "Remote exception %s";
    private static final String unexpectedNullValue = "COM01000: Internal error: Assertion failure: Unexpectedly null value";
    private static final String expectedLockHold = "COM01001: Internal error: Assertion failure: Current thread expected to hold lock for %s";
    private static final String expectedLockNotHold = "COM01002: Internal error: Assertion failure: Current thread expected to not hold lock for %s";
    private static final String expectedBoolean = "COM01003: Internal error: Assertion failure: Expected boolean value to be %s";
    private static final String unreachableCode = "COM02000: Internal error: Unreachable code has been reached";
    private static final String impossibleSwitchCase = "COM02001: Internal error: Impossible switch condition encountered: %s";

    protected CommonMessages_$bundle() {
    }

    protected Object readResolve() {
        return INSTANCE;
    }

    @Override
    public final IllegalArgumentException nullParam(String paramName) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.nullParam$str(), paramName));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String nullParam$str() {
        return nullParam;
    }

    @Override
    public final IllegalArgumentException paramLessThan(String name, long min) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.paramLessThan$str(), name, min));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String paramLessThan$str() {
        return paramLessThan;
    }

    @Override
    public final IllegalArgumentException paramGreaterThan(String name, long max) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.paramGreaterThan$str(), name, max));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String paramGreaterThan$str() {
        return paramGreaterThan;
    }

    @Override
    public final ArrayIndexOutOfBoundsException arrayOffsetGreaterThanLength(int offs, int arrayLength) {
        ArrayIndexOutOfBoundsException result = new ArrayIndexOutOfBoundsException(String.format(this.arrayOffsetGreaterThanLength$str(), offs, arrayLength));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String arrayOffsetGreaterThanLength$str() {
        return arrayOffsetGreaterThanLength;
    }

    @Override
    public final ArrayIndexOutOfBoundsException arrayOffsetLengthGreaterThanLength(int offs, int len, int arrayLength) {
        ArrayIndexOutOfBoundsException result = new ArrayIndexOutOfBoundsException(String.format(this.arrayOffsetLengthGreaterThanLength$str(), offs, len, arrayLength));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String arrayOffsetLengthGreaterThanLength$str() {
        return arrayOffsetLengthGreaterThanLength;
    }

    @Override
    public final IllegalArgumentException nullArrayParam(int index, String name) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.nullArrayParam$str(), index, name));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String nullArrayParam$str() {
        return nullArrayParam;
    }

    @Override
    public final NullPointerException nullParamNPE(String name) {
        NullPointerException result = new NullPointerException(String.format(this.nullParamNPE$str(), name));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String nullParamNPE$str() {
        return nullParamNPE;
    }

    @Override
    public final IllegalArgumentException invalidPermissionAction(String action) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.invalidPermissionAction$str(), action));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String invalidPermissionAction$str() {
        return invalidPermissionAction;
    }

    @Override
    public final IllegalArgumentException emptyParam(String name) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.emptyParam$str(), name));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String emptyParam$str() {
        return emptyParam;
    }

    @Override
    public final String invalidExpressionSyntax(int index) {
        String result = String.format(this.invalidExpressionSyntax$str(), index);
        return result;
    }

    protected String invalidExpressionSyntax$str() {
        return invalidExpressionSyntax;
    }

    @Override
    public final IllegalArgumentException unresolvedEnvironmentProperty(String name) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.unresolvedEnvironmentProperty$str(), name));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String unresolvedEnvironmentProperty$str() {
        return unresolvedEnvironmentProperty;
    }

    @Override
    public final IllegalArgumentException unresolvedSystemProperty(String name) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.unresolvedSystemProperty$str(), name));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String unresolvedSystemProperty$str() {
        return unresolvedSystemProperty;
    }

    @Override
    public final IllegalArgumentException invalidAddressBytes(int length) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.invalidAddressBytes$str(), length));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String invalidAddressBytes$str() {
        return invalidAddressBytes;
    }

    @Override
    public final UnsupportedOperationException unsupported(String methodName, String className) {
        UnsupportedOperationException result = new UnsupportedOperationException(String.format(this.unsupported$str(), methodName, className));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String unsupported$str() {
        return unsupported;
    }

    @Override
    public final PrivilegedActionException privilegedActionFailed(Exception e) {
        PrivilegedActionException result = new PrivilegedActionException(e);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String privilegedActionFailed$str() {
        return privilegedActionFailed;
    }

    @Override
    public final SecurityException readOnlyPermissionCollection() {
        SecurityException result = new SecurityException(String.format(this.readOnlyPermissionCollection$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String readOnlyPermissionCollection$str() {
        return readOnlyPermissionCollection;
    }

    public final IllegalArgumentException invalidPermissionType(Class expectedType, Class actualType) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.invalidPermissionType$str(), expectedType, actualType));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String invalidPermissionType$str() {
        return invalidPermissionType;
    }

    @Override
    public final IllegalStateException invalidOddFields() {
        IllegalStateException result = new IllegalStateException(String.format(this.invalidOddFields$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String invalidOddFields$str() {
        return invalidOddFields;
    }

    @Override
    public final IllegalArgumentException cannotContainNullFieldNameOrValue() {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.cannotContainNullFieldNameOrValue$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String cannotContainNullFieldNameOrValue$str() {
        return cannotContainNullFieldNameOrValue;
    }

    @Override
    public final IOException corruptedStream() {
        IOException result = new IOException(String.format(this.corruptedStream$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String corruptedStream$str() {
        return corruptedStream;
    }

    @Override
    public final String remoteException(String exceptionClassName, String message) {
        String result = String.format(this.remoteException2$str(), exceptionClassName, message);
        return result;
    }

    protected String remoteException2$str() {
        return remoteException2;
    }

    @Override
    public final String remoteException(String exceptionClassName) {
        String result = String.format(this.remoteException1$str(), exceptionClassName);
        return result;
    }

    protected String remoteException1$str() {
        return remoteException1;
    }

    @Override
    public final String unexpectedNullValue() {
        String result = String.format(this.unexpectedNullValue$str(), new Object[0]);
        return result;
    }

    protected String unexpectedNullValue$str() {
        return unexpectedNullValue;
    }

    @Override
    public final String expectedLockHold(Object monitor) {
        String result = String.format(this.expectedLockHold$str(), monitor);
        return result;
    }

    protected String expectedLockHold$str() {
        return expectedLockHold;
    }

    @Override
    public final String expectedLockNotHold(Object monitor) {
        String result = String.format(this.expectedLockNotHold$str(), monitor);
        return result;
    }

    protected String expectedLockNotHold$str() {
        return expectedLockNotHold;
    }

    @Override
    public final String expectedBoolean(boolean expr) {
        String result = String.format(this.expectedBoolean$str(), expr);
        return result;
    }

    protected String expectedBoolean$str() {
        return expectedBoolean;
    }

    @Override
    public final IllegalStateException unreachableCode() {
        IllegalStateException result = new IllegalStateException(String.format(this.unreachableCode$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String unreachableCode$str() {
        return unreachableCode;
    }

    @Override
    public final IllegalStateException impossibleSwitchCase(Object cond) {
        IllegalStateException result = new IllegalStateException(String.format(this.impossibleSwitchCase$str(), cond));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String impossibleSwitchCase$str() {
        return impossibleSwitchCase;
    }
}

