/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.container.runtime.marshal;

import java.net.URL;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.Instance;
import javax.inject.Inject;
import org.jboss.dmr.ModelNode;
import org.wildfly.swarm.container.runtime.xmlconfig.StandaloneXMLParser;
import org.wildfly.swarm.container.runtime.xmlconfig.XMLConfig;
import org.wildfly.swarm.internal.SwarmConfigMessages;
import org.wildfly.swarm.spi.runtime.ConfigurationMarshaller;

@ApplicationScoped
public class XMLMarshaller
implements ConfigurationMarshaller {
    @Inject
    @XMLConfig
    private Instance<URL> xmlConfig;
    @Inject
    private StandaloneXMLParser parser;

    public void marshal(List<ModelNode> list) {
        if (this.xmlConfig.isUnsatisfied()) {
            return;
        }
        HashSet seen = new HashSet();
        this.xmlConfig.forEach(url -> this.parse((URL)url, seen, list));
    }

    protected void parse(URL url, Set<URL> seen, List<ModelNode> list) {
        if (url == null) {
            return;
        }
        if (seen.contains(url)) {
            return;
        }
        seen.add(url);
        try {
            List<ModelNode> subList = this.parser.parse(url);
            SwarmConfigMessages.MESSAGES.marshalXml(url.toExternalForm(), subList.toString());
            list.addAll(subList);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

