/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.container.runtime.wildfly;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.security.DigestOutputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.enterprise.context.ApplicationScoped;
import org.jboss.as.repository.ContentReference;
import org.jboss.as.repository.ContentRepository;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.vfs.VFS;
import org.jboss.vfs.VirtualFile;

@ApplicationScoped
public class SwarmContentRepository
implements ContentRepository,
Service<ContentRepository> {
    private Map<String, Path> index = new HashMap<String, Path>();

    public static void addService(ServiceTarget serviceTarget, SwarmContentRepository repository) {
        serviceTarget.addService(SERVICE_NAME, (Service)repository).setInitialMode(ServiceController.Mode.ACTIVE).install();
    }

    public byte[] addContent(InputStream stream) throws IOException {
        try {
            byte[] sha1Bytes;
            MessageDigest messageDigest = MessageDigest.getInstance("SHA-1");
            Path tmp = File.createTempFile("content", ".tmp").toPath();
            try (OutputStream fos = Files.newOutputStream(tmp, new OpenOption[0]);){
                int read;
                messageDigest.reset();
                DigestOutputStream dos = new DigestOutputStream(fos, messageDigest);
                BufferedInputStream bis = new BufferedInputStream(stream);
                byte[] bytes = new byte[8192];
                while ((read = bis.read(bytes)) > -1) {
                    dos.write(bytes, 0, read);
                }
                fos.flush();
                sha1Bytes = messageDigest.digest();
            }
            String key = SwarmContentRepository.toKey(sha1Bytes);
            this.index.put(key, tmp);
            return sha1Bytes;
        }
        catch (NoSuchAlgorithmException e) {
            throw new IOException(e);
        }
    }

    public void addContentReference(ContentReference contentReference) {
    }

    public VirtualFile getContent(byte[] sha1Bytes) {
        String key = SwarmContentRepository.toKey(sha1Bytes);
        VirtualFile result = VFS.getChild((URI)this.index.get(key).toUri());
        return result;
    }

    public boolean hasContent(byte[] sha1Bytes) {
        String key = SwarmContentRepository.toKey(sha1Bytes);
        boolean result = this.index.containsKey(key);
        return result;
    }

    public static String toKey(byte[] hash) {
        StringBuilder str = new StringBuilder();
        for (int i = 0; i < hash.length; ++i) {
            int bit = Math.abs(hash[i]);
            str.append(Integer.toHexString(bit));
        }
        return str.toString();
    }

    public boolean syncContent(ContentReference contentReference) {
        return true;
    }

    public void removeContent(ContentReference contentReference) {
    }

    public void removeAllContent() throws IOException {
        IOException exception = null;
        for (Path path : this.index.values()) {
            try {
                Files.delete(path);
            }
            catch (IOException e) {
                exception = e;
            }
        }
        if (exception != null) {
            throw exception;
        }
    }

    public Map<String, Set<String>> cleanObsoleteContent() {
        HashMap<String, Set<String>> result = new HashMap<String, Set<String>>();
        result.put("marked-contents", Collections.emptySet());
        result.put("deleted-contents", Collections.emptySet());
        return result;
    }

    public void start(StartContext startContext) throws StartException {
    }

    public void stop(StopContext stopContext) {
    }

    public ContentRepository getValue() throws IllegalStateException, IllegalArgumentException {
        return this;
    }
}

