/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.container.util;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.nio.file.Paths;
import java.util.HashSet;
import java.util.Set;
import java.util.jar.JarFile;
import org.jboss.modules.DependencySpec;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleClassLoader;
import org.jboss.modules.ModuleIdentifier;
import org.jboss.modules.ModuleLoadException;
import org.jboss.modules.ModuleSpec;
import org.jboss.modules.ResourceLoader;
import org.jboss.modules.ResourceLoaderSpec;
import org.jboss.modules.ResourceLoaders;
import org.wildfly.swarm.bootstrap.modules.DynamicModuleFinder;
import org.wildfly.swarm.container.util.Messages;

public abstract class DriverModuleBuilder {
    private static final String FILE_PREFIX = "file:";
    private static final String JAR_FILE_PREFIX = "jar:file:";
    private final String name;
    private final String detectableClassName;
    private final String[] optionalClassNames;
    private final ModuleIdentifier[] driverModuleDependencies;
    private boolean installed;

    public DriverModuleBuilder(String name, String detectableClassName, String[] optionalClassNames, ModuleIdentifier[] driverModuleDependencies) {
        this.name = name;
        this.detectableClassName = detectableClassName;
        this.optionalClassNames = optionalClassNames;
        this.driverModuleDependencies = driverModuleDependencies;
    }

    public String name() {
        return this.name;
    }

    public boolean detect(String moduleName) {
        Messages.MESSAGES.attemptToAutoDetectDriver(this.name);
        File primaryJar = this.attemptDetection();
        if (primaryJar != null) {
            Set<File> optionalJars = this.findOptionalJars();
            optionalJars.add(primaryJar);
            ModuleIdentifier moduleIdentifier = ModuleIdentifier.create((String)moduleName);
            DynamicModuleFinder.register((ModuleIdentifier)moduleIdentifier, (id, loader) -> {
                ModuleSpec.Builder builder = ModuleSpec.build((ModuleIdentifier)id);
                for (File eachJar : optionalJars) {
                    try {
                        JarFile jar = new JarFile(eachJar);
                        builder.addResourceRoot(ResourceLoaderSpec.createResourceLoaderSpec((ResourceLoader)ResourceLoaders.createIterableJarResourceLoader((String)jar.getName(), (JarFile)jar)));
                    }
                    catch (IOException e) {
                        Messages.MESSAGES.errorLoadingAutodetectedDriver(this.name, e);
                        return null;
                    }
                }
                for (ModuleIdentifier eachModuleIdentifier : this.driverModuleDependencies) {
                    builder.addDependency(DependencySpec.createModuleDependencySpec((ModuleIdentifier)eachModuleIdentifier));
                }
                builder.addDependency(DependencySpec.createLocalDependencySpec());
                return builder.create();
            });
            this.installed = true;
        }
        return this.installed;
    }

    private File attemptDetection() {
        return this.findLocationOfClass(this.detectableClassName);
    }

    private Set<File> findOptionalJars() {
        HashSet<File> optionalJars = new HashSet<File>();
        if (this.optionalClassNames != null) {
            for (String each : this.optionalClassNames) {
                File file = this.findLocationOfClass(each);
                if (file == null) continue;
                optionalJars.add(file);
            }
        }
        return optionalJars;
    }

    private File findLocationOfClass(String className) {
        try {
            ModuleClassLoader cl = Module.getBootModuleLoader().loadModule(ModuleIdentifier.create((String)"swarm.application")).getClassLoader();
            File candidate = this.findLocationOfClass((ClassLoader)cl, className);
            if (candidate == null) {
                candidate = this.findLocationOfClass(ClassLoader.getSystemClassLoader(), className);
            }
            return candidate;
        }
        catch (ModuleLoadException cl) {
        }
        catch (IOException e) {
            Messages.MESSAGES.errorLoadingAutodetectedDriver(this.name, e);
        }
        return null;
    }

    private File findLocationOfClass(ClassLoader classLoader, String className) throws IOException {
        try {
            Class<?> driverClass = classLoader.loadClass(className);
            URL location = driverClass.getProtectionDomain().getCodeSource().getLocation();
            String locationStr = location.toExternalForm();
            if (locationStr.startsWith(JAR_FILE_PREFIX)) {
                locationStr = locationStr.substring(JAR_FILE_PREFIX.length());
            } else if (locationStr.startsWith(FILE_PREFIX)) {
                locationStr = locationStr.substring(FILE_PREFIX.length());
            }
            int bangLoc = locationStr.indexOf(33);
            if (bangLoc >= 0) {
                locationStr = locationStr.substring(0, bangLoc);
            }
            locationStr = this.getPlatformPath(locationStr);
            File locationFile = Paths.get(locationStr, new String[0]).toFile();
            return locationFile;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    private String getPlatformPath(String path) {
        if (!this.isWindows()) {
            return path;
        }
        URI uri = URI.create("file://" + path);
        return Paths.get(uri).toString();
    }

    private boolean isWindows() {
        return System.getProperty("os.name").toLowerCase().contains("win");
    }

    public boolean isInstalled() {
        return this.installed;
    }

    public String toString() {
        return "[DriverModuleBuilder: detectable=" + this.detectableClassName + "]";
    }
}

