/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.container.config;

import java.io.IOException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.stream.Stream;
import org.wildfly.swarm.container.config.ConfigLocator;

public class FilesystemConfigLocator
extends ConfigLocator {
    private final Path root;

    public FilesystemConfigLocator() {
        this(Paths.get(".", new String[0]));
    }

    public FilesystemConfigLocator(Path root) {
        this.root = root;
    }

    @Override
    public Stream<URL> locate(String profileName) throws IOException {
        ArrayList<URL> located = new ArrayList<URL>();
        Path path = this.root.resolve("project-" + profileName + ".yml");
        if (Files.exists(path, new LinkOption[0])) {
            located.add(path.toUri().toURL());
        }
        if (Files.exists(path = this.root.resolve("project-" + profileName + ".properties"), new LinkOption[0])) {
            located.add(path.toUri().toURL());
        }
        return located.stream();
    }
}

