/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.container.runtime.cdi;

import java.io.File;
import java.io.IOException;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import javax.annotation.PostConstruct;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.Disposes;
import javax.enterprise.inject.Produces;
import javax.inject.Singleton;
import org.jboss.vfs.TempFileProvider;
import org.wildfly.swarm.bootstrap.util.TempFileManager;

@ApplicationScoped
public class TempFileProviderProducer {
    private static final String TEMP_DIR_NAME = "wildfly-swarm";
    private TempFileProvider tempFileProvider = null;

    @PostConstruct
    void init() {
        try {
            File serverTmp = TempFileManager.INSTANCE.newTempDirectory(TEMP_DIR_NAME, ".d");
            System.setProperty("jboss.server.temp.dir", serverTmp.getAbsolutePath());
            ScheduledExecutorService tempFileExecutor = Executors.newSingleThreadScheduledExecutor();
            this.tempFileProvider = TempFileProvider.create((String)TEMP_DIR_NAME, (ScheduledExecutorService)tempFileExecutor, (boolean)true);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Produces
    @Singleton
    TempFileProvider tempFileProvider() {
        return this.tempFileProvider;
    }

    void dispose(@Disposes TempFileProvider provider) {
        if (this.tempFileProvider == provider) {
            try {
                this.tempFileProvider.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }
}

