/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.container.runtime.marshal;

import java.util.List;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.jboss.dmr.ModelNode;
import org.wildfly.swarm.bootstrap.performance.Performance;
import org.wildfly.swarm.container.runtime.marshal.ConfigViewPropertyMarshaller;
import org.wildfly.swarm.container.runtime.marshal.ConfigurationMarshaller;
import org.wildfly.swarm.container.runtime.marshal.ExtensionMarshaller;
import org.wildfly.swarm.container.runtime.marshal.InterfaceMarshaller;
import org.wildfly.swarm.container.runtime.marshal.SocketBindingGroupMarshaller;
import org.wildfly.swarm.container.runtime.marshal.SubsystemMarshaller;
import org.wildfly.swarm.container.runtime.marshal.XMLMarshaller;

@ApplicationScoped
public class DMRMarshaller
implements ConfigurationMarshaller {
    @Inject
    private XMLMarshaller xmlMarshaller;
    @Inject
    private ConfigViewPropertyMarshaller configViewPropertyMarshaller;
    @Inject
    private ExtensionMarshaller extensionMarshaller;
    @Inject
    private SubsystemMarshaller subsystemMarshaller;
    @Inject
    private InterfaceMarshaller interfaceMarshaller;
    @Inject
    private SocketBindingGroupMarshaller socketBindingGroupMarshaller;

    @Override
    public void marshal(List<ModelNode> list) {
        try {
            try (AutoCloseable handle = Performance.time((String)"marshal XML");){
                this.xmlMarshaller.marshal(list);
            }
            handle = Performance.time((String)"marshal extensions");
            var3_4 = null;
            try {
                this.extensionMarshaller.marshal(list);
            }
            catch (Throwable throwable) {
                var3_4 = throwable;
                throw throwable;
            }
            finally {
                if (handle != null) {
                    if (var3_4 != null) {
                        try {
                            handle.close();
                        }
                        catch (Throwable throwable) {
                            var3_4.addSuppressed(throwable);
                        }
                    } else {
                        handle.close();
                    }
                }
            }
            handle = Performance.time((String)"marshal config-view properties");
            var3_4 = null;
            try {
                this.configViewPropertyMarshaller.marshal(list);
            }
            catch (Throwable throwable) {
                var3_4 = throwable;
                throw throwable;
            }
            finally {
                if (handle != null) {
                    if (var3_4 != null) {
                        try {
                            handle.close();
                        }
                        catch (Throwable throwable) {
                            var3_4.addSuppressed(throwable);
                        }
                    } else {
                        handle.close();
                    }
                }
            }
            handle = Performance.time((String)"marshal subsystems");
            var3_4 = null;
            try {
                this.subsystemMarshaller.marshal(list);
            }
            catch (Throwable throwable) {
                var3_4 = throwable;
                throw throwable;
            }
            finally {
                if (handle != null) {
                    if (var3_4 != null) {
                        try {
                            handle.close();
                        }
                        catch (Throwable throwable) {
                            var3_4.addSuppressed(throwable);
                        }
                    } else {
                        handle.close();
                    }
                }
            }
            handle = Performance.time((String)"marshal interfaces");
            var3_4 = null;
            try {
                this.interfaceMarshaller.marshal(list);
            }
            catch (Throwable throwable) {
                var3_4 = throwable;
                throw throwable;
            }
            finally {
                if (handle != null) {
                    if (var3_4 != null) {
                        try {
                            handle.close();
                        }
                        catch (Throwable throwable) {
                            var3_4.addSuppressed(throwable);
                        }
                    } else {
                        handle.close();
                    }
                }
            }
            handle = Performance.time((String)"marshal socket-bindings");
            var3_4 = null;
            try {
                this.socketBindingGroupMarshaller.marshal(list);
            }
            catch (Throwable throwable) {
                var3_4 = throwable;
                throw throwable;
            }
            finally {
                if (handle != null) {
                    if (var3_4 != null) {
                        try {
                            handle.close();
                        }
                        catch (Throwable throwable) {
                            var3_4.addSuppressed(throwable);
                        }
                    } else {
                        handle.close();
                    }
                }
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

