/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.container.runtime.marshal;

import java.util.LinkedList;
import java.util.List;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.Any;
import javax.enterprise.inject.Instance;
import javax.inject.Inject;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.dmr.ModelNode;
import org.wildfly.swarm.bootstrap.performance.Performance;
import org.wildfly.swarm.config.runtime.invocation.Marshaller;
import org.wildfly.swarm.container.runtime.marshal.ConfigurationMarshaller;
import org.wildfly.swarm.spi.api.Fraction;
import org.wildfly.swarm.spi.api.annotations.MarshalDMR;
import org.wildfly.swarm.spi.api.annotations.WildFlySubsystem;

@ApplicationScoped
public class SubsystemMarshaller
implements ConfigurationMarshaller {
    @Inject
    @Any
    private Instance<Fraction> fractions;

    @Override
    public void marshal(List<ModelNode> list) {
        for (Fraction each : this.fractions) {
            PathAddress address;
            MarshalDMR anno = each.getClass().getAnnotation(MarshalDMR.class);
            if (anno != null) {
                try {
                    AutoCloseable handle = Performance.time((String)("marshall " + each.getClass().getSimpleName()));
                    Throwable throwable = null;
                    try {
                        LinkedList subList = Marshaller.marshal((Object)each);
                        if (this.isAlreadyConfigured(subList, list)) continue;
                        list.addAll(subList);
                        continue;
                    }
                    catch (Throwable subList) {
                        throwable = subList;
                        throw subList;
                    }
                    finally {
                        if (handle == null) continue;
                        if (throwable != null) {
                            try {
                                handle.close();
                            }
                            catch (Throwable subList) {
                                throwable.addSuppressed(subList);
                            }
                            continue;
                        }
                        handle.close();
                        continue;
                    }
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
            WildFlySubsystem subsysAnno = each.getClass().getAnnotation(WildFlySubsystem.class);
            if (subsysAnno == null || this.isAlreadyConfigured((address = PathAddress.pathAddress((PathElement[])new PathElement[]{PathElement.pathElement((String)"subsystem", (String)subsysAnno.value())})).toModelNode(), list)) continue;
            ModelNode node = new ModelNode();
            node.get("address").set(address.toModelNode());
            node.get("operation").set("add");
            list.add(node);
        }
    }
}

