/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.internal;

import java.net.URL;
import org.jboss.logging.BasicLogger;
import org.jboss.logging.Logger;
import org.jboss.logging.annotations.Cause;
import org.jboss.logging.annotations.LogMessage;
import org.jboss.logging.annotations.Message;
import org.jboss.logging.annotations.MessageLogger;

@MessageLogger(projectCode="WFSWARM", length=4)
public interface SwarmConfigMessages
extends BasicLogger {
    public static final SwarmConfigMessages MESSAGES = (SwarmConfigMessages)Logger.getMessageLogger(SwarmConfigMessages.class, (String)"org.wildfly.swarm.config");

    @Message(id=1, value="Stage config is not present.")
    public RuntimeException missingStageConfig();

    @Message(id=3, value="Project stage '%s' cannot be found.")
    public RuntimeException stageNotFound(String var1);

    @Message(id=10, value="Failed to load stage configuration from URL : %s")
    public RuntimeException failedLoadingStageConfig(@Cause Throwable var1, URL var2);

    @Message(id=11, value="Missing stage 'default' in project-stages.yml")
    public RuntimeException missingDefaultStage();

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=20, value="Stage Config found in %s at location: %s")
    public void stageConfigLocation(String var1, String var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=21, value="Failed to parse project stage URL reference, ignoring: %s")
    public void malformedStageConfigUrl(String var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=22, value="Project stage superseded by external configuration %s")
    public void stageConfigSuperseded(String var1);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=24, value="Using project stage: %s")
    public void usingProjectStage(String var1);

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(id=30, value="Marshalling Project Stage property %s")
    public void marshalProjectStageProperty(String var1);

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(id=31, value="Marshalling XML from %s as: \n %s")
    public void marshalXml(String var1, String var2);

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(id=32, value="Load standalone.xml via %s from %s")
    public void loadingStandaloneXml(String var1, String var2);

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(id=37, value="Configuration:\n%s")
    public void configuration(String var1);
}

