package org.wildfly.swarm.internal;

import java.lang.IllegalStateException;
import java.io.Serializable;
import javax.annotation.Generated;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.logging.DelegatingBasicLogger;
import java.lang.String;
import org.jboss.logging.Logger;
import java.lang.RuntimeException;
import org.wildfly.swarm.spi.api.annotations.DeploymentModule;
import org.jboss.logging.BasicLogger;
import java.lang.Throwable;
import java.util.Collection;
import org.wildfly.swarm.container.DeploymentException;
import java.util.List;
import org.wildfly.swarm.spi.api.Customizer;
import java.util.Arrays;
import java.lang.IllegalArgumentException;
import java.lang.UnsupportedOperationException;

/**
 * Warning this class consists of generated code.
 */
@Generated(value = "org.jboss.logging.processor.generator.model.MessageLoggerImplementor", date = "2017-06-16T09:42:59-0700")
public class SwarmMessages_$logger extends DelegatingBasicLogger implements SwarmMessages,BasicLogger,Serializable {
    private static final long serialVersionUID = 1L;
    private static final String FQCN = SwarmMessages_$logger.class.getName();
    public SwarmMessages_$logger(final Logger log) {
        super(log);
    }
    private static final String containerNotStarted = "WFSWARM0001: Cannot invoke %s on a container that has not been started.";
    protected String containerNotStarted$str() {
        return containerNotStarted;
    }
    @Override
    public final IllegalStateException containerNotStarted(final String method) {
        final IllegalStateException result = new IllegalStateException(String.format(containerNotStarted$str(), method));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String argumentRequired = "WFSWARM0002: %s requires an argument.";
    protected String argumentRequired$str() {
        return argumentRequired;
    }
    @Override
    public final RuntimeException argumentRequired(final String arg) {
        final RuntimeException result = new RuntimeException(String.format(argumentRequired$str(), arg));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String failToMountDeployment = "WFSWARM0003: Failed to mount deployment.";
    protected String failToMountDeployment$str() {
        return failToMountDeployment;
    }
    @Override
    public final DeploymentException failToMountDeployment(final Throwable cause, final Archive<? extends Object> archive) {
        final DeploymentException result = new DeploymentException(String.format(failToMountDeployment$str()), cause, archive);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String deploymentFailed1 = "WFSWARM0004: Deployment failed: %s";
    protected String deploymentFailed1$str() {
        return deploymentFailed1;
    }
    @Override
    public final String deploymentFailed(final String failureMessage) {
        return String.format(deploymentFailed1$str(), failureMessage);
    }
    private static final String deploymentFailed0 = "WFSWARM0005: Failure during deployment";
    protected String deploymentFailed0$str() {
        return deploymentFailed0;
    }
    @Override
    public final DeploymentException deploymentFailed(final Throwable cause, final Archive<? extends Object> archive) {
        final DeploymentException result = new DeploymentException(String.format(deploymentFailed0$str()), cause, archive);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String librariesNotSupported = "WFSWARM0006: JavaArchive spec does not support Libraries";
    protected String librariesNotSupported$str() {
        return librariesNotSupported;
    }
    @Override
    public final UnsupportedOperationException librariesNotSupported() {
        final UnsupportedOperationException result = new UnsupportedOperationException(String.format(librariesNotSupported$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String fractionHasMultipleExtensions = "WFSWARM0007: Fraction \"%s\" was configured using @WildFlyExtension with a module='', but has multiple extension classes.  Please use classname='' to specify exactly one, or noClass=true to ignore all. %s";
    protected String fractionHasMultipleExtensions$str() {
        return fractionHasMultipleExtensions;
    }
    @Override
    public final RuntimeException fractionHasMultipleExtensions(final String className, final Collection<String> extensions) {
        final RuntimeException result = new RuntimeException(String.format(fractionHasMultipleExtensions$str(), className, extensions));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String artifactNotFound = "WFSWARM0008: Artifact '%s' not found.";
    protected String artifactNotFound$str() {
        return artifactNotFound;
    }
    @Override
    public final RuntimeException artifactNotFound(final String gav) {
        final RuntimeException result = new RuntimeException(String.format(artifactNotFound$str(), gav));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String unableToDetermineVersion = "WFSWARM0009: Unable to determine version number from GAV: %s";
    protected String unableToDetermineVersion$str() {
        return unableToDetermineVersion;
    }
    @Override
    public final RuntimeException unableToDetermineVersion(final String gav) {
        final RuntimeException result = new RuntimeException(String.format(unableToDetermineVersion$str(), gav));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String gavMinimumSegments = "WFSWARM0010: GAV must includes at least 2 segments";
    protected String gavMinimumSegments$str() {
        return gavMinimumSegments;
    }
    @Override
    public final RuntimeException gavMinimumSegments() {
        final RuntimeException result = new RuntimeException(String.format(gavMinimumSegments$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String systemPropertyNotFound = "WFSWARM0011: System property '%s' not provided.";
    protected String systemPropertyNotFound$str() {
        return systemPropertyNotFound;
    }
    @Override
    public final IllegalStateException systemPropertyNotFound(final String key) {
        final IllegalStateException result = new IllegalStateException(String.format(systemPropertyNotFound$str(), key));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String cannotIdentifyFileSystemLayout = "WFSWARM0012: Cannot identify FileSystemLayout for given path: %s";
    protected String cannotIdentifyFileSystemLayout$str() {
        return cannotIdentifyFileSystemLayout;
    }
    @Override
    public final IllegalArgumentException cannotIdentifyFileSystemLayout(final String path) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(cannotIdentifyFileSystemLayout$str(), path));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String availableFraction = "WFSWARM0013: Installed fraction: %24s - %-15s %s:%s:%s";
    protected String availableFraction$str() {
        return availableFraction;
    }
    @Override
    public final String availableFraction(final String name, final String stabilityLevel, final String groupId, final String artifactId, final String version) {
        return String.format(availableFraction$str(), name, stabilityLevel, groupId, artifactId, version);
    }
    @Override
    public final void shrinkwrapDomainSetupFailed(final Throwable cause) {
        super.log.logf(FQCN, org.jboss.logging.Logger.Level.ERROR, cause, shrinkwrapDomainSetupFailed$str());
    }
    private static final String shrinkwrapDomainSetupFailed = "WFSWARM0014: Unable to setup Shrinkwrap Domain";
    protected String shrinkwrapDomainSetupFailed$str() {
        return shrinkwrapDomainSetupFailed;
    }
    @Override
    public final void deploymentModuleAdded(final DeploymentModule module) {
        super.log.logf(FQCN, org.jboss.logging.Logger.Level.DEBUG, null, deploymentModuleAdded$str(), module);
    }
    private static final String deploymentModuleAdded = "WFSWARM0015: Add deployment module: %s";
    protected String deploymentModuleAdded$str() {
        return deploymentModuleAdded;
    }
    @Override
    public final void callingPreCustomizer(final Customizer customizer) {
        super.log.logf(FQCN, org.jboss.logging.Logger.Level.DEBUG, null, callingPreCustomizer$str(), customizer);
    }
    private static final String callingPreCustomizer = "WFSWARM0016: Calling Pre Customizer: %s";
    protected String callingPreCustomizer$str() {
        return callingPreCustomizer;
    }
    @Override
    public final void callingPostCustomizer(final Customizer customizer) {
        super.log.logf(FQCN, org.jboss.logging.Logger.Level.DEBUG, null, callingPostCustomizer$str(), customizer);
    }
    private static final String callingPostCustomizer = "WFSWARM0017: Calling Post Customizer: %s";
    protected String callingPostCustomizer$str() {
        return callingPostCustomizer;
    }
    @Override
    public final void wildflyBootstrap(final String operations) {
        super.log.logf(FQCN, org.jboss.logging.Logger.Level.DEBUG, null, wildflyBootstrap$str(), operations);
    }
    private static final String wildflyBootstrap = "WFSWARM0018: WildFly Bootstrap operations: \n %s";
    protected String wildflyBootstrap$str() {
        return wildflyBootstrap;
    }
    @Override
    public final void argsInstalled(final List<String> args) {
        super.log.logf(FQCN, org.jboss.logging.Logger.Level.INFO, null, argsInstalled$str(), args);
    }
    private static final String argsInstalled = "WFSWARM0019: Install MSC service for command line args: %s";
    protected String argsInstalled$str() {
        return argsInstalled;
    }
    private static final String httpsRequiresManagementFraction = "WFSWARM0020: HTTP/S is configured correctly, but org.wildfly.swarm:management is not available";
    protected String httpsRequiresManagementFraction$str() {
        return httpsRequiresManagementFraction;
    }
    @Override
    public final RuntimeException httpsRequiresManagementFraction() {
        final RuntimeException result = new RuntimeException(String.format(httpsRequiresManagementFraction$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    @Override
    public final void ignoringSubsystem(final String nsURI, final String name) {
        super.log.logf(FQCN, org.jboss.logging.Logger.Level.WARN, null, ignoringSubsystem$str(), nsURI, name);
    }
    private static final String ignoringSubsystem = "WFSWARM0021: Ignoring subsystem %s:%s";
    protected String ignoringSubsystem$str() {
        return ignoringSubsystem;
    }
    @Override
    public final void moduleMBeanServerNotInstalled(final Throwable cause) {
        super.log.logf(FQCN, org.jboss.logging.Logger.Level.WARN, cause, moduleMBeanServerNotInstalled$str());
    }
    private static final String moduleMBeanServerNotInstalled = "WFSWARM0022: Failed to register modules mbeans";
    protected String moduleMBeanServerNotInstalled$str() {
        return moduleMBeanServerNotInstalled;
    }
    @Override
    public final void errorInstallingUserSpaceExtension(final String factoryClassName) {
        super.log.logf(FQCN, org.jboss.logging.Logger.Level.ERROR, null, errorInstallingUserSpaceExtension$str(), factoryClassName);
    }
    private static final String errorInstallingUserSpaceExtension = "WFSWARM0023: Error installing user-space CDI extension: %s";
    protected String errorInstallingUserSpaceExtension$str() {
        return errorInstallingUserSpaceExtension;
    }
    @Override
    public final void http2NotSupported() {
        super.log.logf(FQCN, org.jboss.logging.Logger.Level.WARN, null, http2NotSupported$str());
    }
    private static final String http2NotSupported = "WFSWARM0024: In order to use HTTP/2 in WildFly Swarm, you must have the OpenSSL provider with ALPN capability from JBoss Core Services installed and configured. This is due to the fact that HTTP/2 requires a TLS stack that supports ALPN, which is not provided by the default installation of Java 8. HTTP/2 will only work with browsers that also support the HTTP/2 standard. OpenSSL usage with WildFly Swarm on HP-UX is NOT supported.";
    protected String http2NotSupported$str() {
        return http2NotSupported;
    }
    private static final String generateSelfSignedCertificateNotSupported = "WFSWARM0025: This version of WildFly Swarm does not support generating self signed certificates.";
    protected String generateSelfSignedCertificateNotSupported$str() {
        return generateSelfSignedCertificateNotSupported;
    }
    @Override
    public final RuntimeException generateSelfSignedCertificateNotSupported() {
        final RuntimeException result = new RuntimeException(String.format(generateSelfSignedCertificateNotSupported$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    @Override
    public final void failToInvokeGenerateSelfSignedCertificateHost(final Throwable cause) {
        super.log.logf(FQCN, org.jboss.logging.Logger.Level.ERROR, cause, failToInvokeGenerateSelfSignedCertificateHost$str());
    }
    private static final String failToInvokeGenerateSelfSignedCertificateHost = "WFSWARM0026: Error invoking SslServerIdentity.generateSelfSignedCertificateHost(String) in HTTPSCustomizer.";
    protected String failToInvokeGenerateSelfSignedCertificateHost$str() {
        return failToInvokeGenerateSelfSignedCertificateHost;
    }
    @Override
    public final void shutdownRequested() {
        super.log.logf(FQCN, org.jboss.logging.Logger.Level.INFO, null, shutdownRequested$str());
    }
    private static final String shutdownRequested = "WFSWARM0027: Shutdown requested";
    protected String shutdownRequested$str() {
        return shutdownRequested;
    }
    @Override
    public final void errorWaitingForContainerShutdown(final Throwable cause) {
        super.log.logf(FQCN, org.jboss.logging.Logger.Level.ERROR, cause, errorWaitingForContainerShutdown$str());
    }
    private static final String errorWaitingForContainerShutdown = "WFSWARM0028: Error invoking SslServerIdentity.generateSelfSignedCertificateHost(String) in HTTPSCustomizer.";
    protected String errorWaitingForContainerShutdown$str() {
        return errorWaitingForContainerShutdown;
    }
    @Override
    public final void errorSettingUpTempFileProvider(final Throwable cause) {
        super.log.logf(FQCN, org.jboss.logging.Logger.Level.ERROR, cause, errorSettingUpTempFileProvider$str());
    }
    private static final String errorSettingUpTempFileProvider = "WFSWARM0029: Error setting up temporary file provider.";
    protected String errorSettingUpTempFileProvider$str() {
        return errorSettingUpTempFileProvider;
    }
    @Override
    public final void errorCleaningUpTempFileProvider(final Throwable cause) {
        super.log.logf(FQCN, org.jboss.logging.Logger.Level.ERROR, cause, errorCleaningUpTempFileProvider$str());
    }
    private static final String errorCleaningUpTempFileProvider = "WFSWARM0030: Error cleaning up temporary file provider.";
    protected String errorCleaningUpTempFileProvider$str() {
        return errorCleaningUpTempFileProvider;
    }
    @Override
    public final void registeredArchivePreparer(final String preparer) {
        super.log.logf(FQCN, org.jboss.logging.Logger.Level.TRACE, null, registeredArchivePreparer$str(), preparer);
    }
    private static final String registeredArchivePreparer = "WFSWARM0031: Registered archive-preparer: %s";
    protected String registeredArchivePreparer$str() {
        return registeredArchivePreparer;
    }
    @Override
    public final void wildflySwarmIsReady() {
        super.log.logf(FQCN, org.jboss.logging.Logger.Level.INFO, null, wildflySwarmIsReady$str());
    }
    private static final String wildflySwarmIsReady = "WFSWARM99999: WildFly Swarm is Ready";
    protected String wildflySwarmIsReady$str() {
        return wildflySwarmIsReady;
    }
}
